/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin.debug;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.IdUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class DebugPlayerCommand
extends BaseCommand {
    public DebugPlayerCommand(JavaPlugin plugin) {
        super(plugin, "player", (RegisteredPermission)null);
        this.usage = TAG + "/ncp debug player (playername/UUID) (yes|no|default)[:CheckType[:Check]]";
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 4) {
            String[] parts = args[3].split(":");
            if (parts.length == 1) {
                return Arrays.asList("no", "yes", "default");
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                builder.append(parts[i]);
                builder.append(":");
            }
            return CommandUtil.getCheckTypeTabMatches2(parts[parts.length - 1], builder.toString());
        }
        return null;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        String input;
        String c7;
        String c6;
        String c5;
        String c4;
        String c3;
        String c2;
        String c1;
        if (sender instanceof Player) {
            c1 = ChatColor.GRAY.toString();
            c2 = ChatColor.BOLD.toString();
            c3 = ChatColor.RED.toString();
            c4 = ChatColor.ITALIC.toString();
            c5 = ChatColor.GOLD.toString();
            c6 = ChatColor.WHITE.toString();
            c7 = ChatColor.YELLOW.toString();
        } else {
            c7 = "";
            c6 = "";
            c5 = "";
            c4 = "";
            c3 = "";
            c2 = "";
            c1 = "";
        }
        if (args.length <= 2) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Bad setup. Command usage: /ncp debug player (playername) yes/no:(checktype).");
            return true;
        }
        DebugEntry entry = new DebugEntry();
        Player player = null;
        if (args.length > 2) {
            input = args[2];
            if (IdUtil.isValidMinecraftUserName(input)) {
                player = DataManager.getPlayer(input);
            } else {
                UUID id = IdUtil.UUIDFromStringSafe(input);
                if (id == null) {
                    sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Bad name or UUID: " + c3 + input);
                    return true;
                }
                player = DataManager.getPlayer(id);
            }
            if (player == null) {
                sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Not online: " + c3 + input);
                return true;
            }
        }
        if (args.length > 3 && (entry = DebugEntry.parseEntry(input = args[3])) == null) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Bad setup: " + c3 + input);
            return true;
        }
        Collection<CheckType> checkTypes = entry.checkTypes.isEmpty() ? Arrays.asList(CheckType.ALL) : entry.checkTypes;
        IPlayerData data = DataManager.getPlayerData(player);
        for (CheckType checkType : checkTypes) {
            if (entry.active == AlmostBoolean.MAYBE) {
                data.resetDebug(checkType);
                continue;
            }
            data.overrideDebug(checkType, entry.active, OverrideType.CUSTOM, true);
        }
        sender.sendMessage(TAG + "Set debug: " + c3 + (Object)((Object)entry.active) + c1 + " for player " + c3 + player.getName() + c1 + " for checks: " + c3 + StringUtil.join(checkTypes, ","));
        return true;
    }

    static class DebugEntry {
        public AlmostBoolean active = AlmostBoolean.YES;
        public final Set<CheckType> checkTypes = new LinkedHashSet<CheckType>();

        DebugEntry() {
        }

        public static DebugEntry parseEntry(String input) {
            String[] split = input.split(":");
            DebugEntry entry = new DebugEntry();
            entry.active = AlmostBoolean.match(split[0]);
            if (entry.active == null) {
                return null;
            }
            for (int i = 1; i < split.length; ++i) {
                try {
                    CheckType checkType = CheckType.valueOf(split[i].toUpperCase().replace('.', '_'));
                    if (checkType == null) {
                        return entry;
                    }
                    entry.checkTypes.add(checkType);
                    continue;
                }
                catch (Exception e) {
                    return entry;
                }
            }
            return entry;
        }
    }
}

