/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import com.google.common.collect.Lists;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class RemovePlayerCommand
extends BaseCommand {
    public RemovePlayerCommand(JavaPlugin plugin) {
        super(plugin, "removeplayer", Permissions.COMMAND_REMOVEPLAYER, new String[]{"remove"});
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CheckType checkType;
        String c6;
        String c3;
        String c1;
        if (sender instanceof Player) {
            c1 = ChatColor.GRAY.toString();
            String c2 = ChatColor.BOLD.toString();
            c3 = ChatColor.RED.toString();
            String c5 = ChatColor.GOLD.toString();
            c6 = ChatColor.WHITE.toString();
        } else {
            c6 = "";
            String c5 = "";
            c3 = "";
            String c2 = "";
            c1 = "";
        }
        if (args.length < 2) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Please specify a player's data to remove.");
            return true;
        }
        if (args.length > 3) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Too many arguments. Command usage: /ncp removeplayer (playername) (checktype).");
            return true;
        }
        String playerName = args[1];
        if (args.length == 3) {
            try {
                checkType = CheckType.valueOf(args[2].toUpperCase().replace('-', '_').replace('.', '_'));
            }
            catch (Exception e) {
                sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Could not interpret: " + args[2]);
                sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Check type should be one of: " + StringUtil.join(Arrays.asList(CheckType.values()), c6 + ", " + c3));
                return true;
            }
        } else {
            checkType = CheckType.ALL;
        }
        if (playerName.equals("*")) {
            DataManager.clearData(checkType);
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Removed all data and history: " + c3 + (Object)((Object)checkType));
            return true;
        }
        Player player = DataManager.getPlayer(playerName);
        if (player != null) {
            playerName = player.getName();
        }
        ViolationHistory hist = ViolationHistory.getHistory(playerName, false);
        boolean somethingFound = false;
        if (hist != null) {
            somethingFound = hist.remove(checkType);
            if (checkType == CheckType.ALL) {
                somethingFound = true;
                ViolationHistory.removeHistory(playerName);
            }
        }
        if (DataManager.removeExecutionHistory(checkType, playerName)) {
            somethingFound = true;
        }
        if (DataManager.removeData(playerName, checkType)) {
            somethingFound = true;
        }
        if (somethingFound) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Issued history and data removal (" + c3 + (Object)((Object)checkType) + c1 + "): " + c3 + playerName + c1);
        } else {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Nothing found (" + c3 + (Object)((Object)checkType) + c1 + "): " + c3 + playerName + c1 + " (spelled correctly?)");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            ArrayList players = Lists.newArrayList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return players;
        }
        if (args.length == 3) {
            return CommandUtil.getCheckTypeTabMatches(args[2]);
        }
        return null;
    }

    @Override
    public boolean testPermission(CommandSender sender, Command command, String alias, String[] args) {
        return super.testPermission(sender, command, alias, args) || args.length >= 2 && args[1].trim().equalsIgnoreCase(sender.getName()) && sender.hasPermission(Permissions.COMMAND_REMOVEPLAYER_SELF.getBukkitPermission());
    }
}

