/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.command.NoCheatPlusCommand;
import fr.neatmonster.nocheatplus.command.admin.VersionCommand;
import fr.neatmonster.nocheatplus.components.registry.feature.INotifyReload;
import fr.neatmonster.nocheatplus.components.registry.order.Order;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.worlds.WorldDataManager;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ReloadCommand
extends BaseCommand {
    private final List<INotifyReload> notifyReload;

    public ReloadCommand(JavaPlugin plugin, List<INotifyReload> notifyReload) {
        super(plugin, "reload", Permissions.COMMAND_RELOAD);
        this.notifyReload = notifyReload;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 1) {
            return false;
        }
        this.handleReloadCommand(sender);
        return true;
    }

    private void handleReloadCommand(CommandSender sender) {
        LogManager logManager = NCPAPIProvider.getNoCheatPlusAPI().getLogManager();
        if (!sender.equals((Object)Bukkit.getConsoleSender())) {
            sender.sendMessage(TAG + "Reloading configuration...");
        }
        logManager.info(Streams.INIT, "Reloading configuration...");
        ConfigManager.cleanup();
        WorldDataManager worldDataManager = (WorldDataManager)NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        ConfigManager.init((Plugin)this.access, worldDataManager);
        worldDataManager.removeCachedConfigs();
        if (logManager instanceof INotifyReload) {
            ((INotifyReload)((Object)logManager)).onReload();
        }
        NCPAPIProvider.getNoCheatPlusAPI().getPlayerDataManager().removeCachedConfigs();
        DataManager.restoreDefaultDebugFlags();
        Collections.sort(this.notifyReload, Order.cmpSetupOrder);
        for (INotifyReload component : this.notifyReload) {
            component.onReload();
        }
        Bukkit.getPluginManager().callEvent((Event)new NoCheatPlusCommand.NCPReloadEvent());
        if (!sender.equals((Object)Bukkit.getConsoleSender())) {
            sender.sendMessage(TAG + "Configuration reloaded.");
        }
        logManager.info(Streams.INIT, "Configuration reloaded.");
        logManager.info(Streams.DEFAULT_FILE, StringUtil.join(VersionCommand.getVersionInfo(), "\n"));
    }
}

