/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class LagCommand
extends BaseCommand {
    public LagCommand(JavaPlugin plugin) {
        super(plugin, "lag", Permissions.COMMAND_LAG);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String bO;
        String cG;
        String cR;
        String cGO;
        if (sender instanceof Player) {
            cGO = ChatColor.GOLD.toString();
            cR = ChatColor.RED.toString();
            cG = ChatColor.GRAY.toString();
            bO = ChatColor.BOLD.toString();
        } else {
            bO = "";
            cG = "";
            cR = "";
            cGO = "";
        }
        StringBuilder builder = new StringBuilder(300);
        builder.append((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Displaying lag information...\n");
        long[] spikeDurations = TickTask.getLagSpikeDurations();
        int[] spikes = TickTask.getLagSpikes();
        builder.append(cR + "" + bO + "\u00bbLag Spikes\u00ab\n");
        if (spikes[0] == 0) {
            builder.append("No lag spike(s) greater than " + cGO + "" + spikeDurations[0] + cG + " ms within the last 40 to 60 minutes.");
        } else if (spikes[0] > 0) {
            builder.append(cG + "Total spikes: " + cGO + "" + spikes[0] + cG + "\nThere have been some spikes greater than " + cGO + "" + spikeDurations[0] + cG + " ms within the last 40 to 60 minutes.");
            builder.append("\nResult(s):");
            for (int i = 0; i < spikeDurations.length; ++i) {
                if (i < spikeDurations.length - 1 && spikes[i] == spikes[i + 1] || spikes[i] == 0) continue;
                if (i < spikeDurations.length - 1) {
                    builder.append(cG + "\n\u2022 " + cGO + "" + (spikes[i] - spikes[i + 1]) + cG + "spike(s) x " + cGO + "" + cGO + "" + spikeDurations[i] + cG + "ms -> " + cGO + "" + spikeDurations[i + 1] + cG + ". ");
                    continue;
                }
                builder.append(cG + "\n\u2022 " + cGO + "" + spikes[i] + cG + "spike(s) x " + cGO + "" + cGO + "" + spikeDurations[i] + "ms" + cG + ".");
            }
        }
        builder.append("\n");
        long max = 324000L;
        long medium = 4000L;
        long second = 1200L;
        builder.append(cR + "" + bO + "\u00bbTPS Lag\u00ab" + cG + "\n[Perc.][time tracked], 0% = 20 TPS");
        for (long ms : new long[]{second, medium, max}) {
            double lag = TickTask.getLag(ms, true);
            int p = Math.max(0, (int)((lag - 1.0) * 100.0));
            builder.append(cG + "\n\u2022 " + cG + "" + cGO + p + cG + "% tps lag in the last " + cGO + "" + StringUtil.fdec1.format((double)ms / 1200.0) + cG + " second(s). ");
        }
        sender.sendMessage(builder.toString());
        return true;
    }
}

