/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import com.google.common.collect.Lists;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeHealth;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

public class InspectCommand
extends BaseCommand {
    private static final DecimalFormat f1 = new DecimalFormat("#.#");

    public InspectCommand(JavaPlugin plugin) {
        super(plugin, "inspect", Permissions.COMMAND_INSPECT);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        String cI;
        String c3;
        String c2;
        String c1;
        if (args.length == 1) {
            if (sender instanceof Player) {
                args = new String[]{args[0], sender.getName()};
            } else {
                sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Please specify a player to inspect.");
                return true;
            }
        }
        if (sender instanceof Player) {
            c1 = ChatColor.GRAY.toString();
            c2 = ChatColor.BOLD.toString();
            c3 = ChatColor.RED.toString();
            cI = ChatColor.ITALIC.toString();
        } else {
            cI = "";
            c3 = "";
            c2 = "";
            c1 = "";
        }
        for (int i = 1; i < args.length; ++i) {
            Player player = DataManager.getPlayer(args[i].trim().toLowerCase());
            if (player == null) {
                sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Not online: " + c3 + "" + args[i]);
                continue;
            }
            sender.sendMessage(InspectCommand.getInspectMessage(player, c1, c2, c3, cI));
        }
        return true;
    }

    public static String getInspectMessage(Player player, String c1, String c2, String c3, String cI) {
        Collection effects;
        StringBuilder builder = new StringBuilder(256);
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData mData = pData.getGenericInstance(MovingData.class);
        MovingConfig mCC = pData.getGenericInstance(MovingConfig.class);
        PlayerMoveData thisMove = mData.playerMoves.getCurrentMove();
        builder.append(TAG + c1 + "Status information for player: " + c3 + player.getName());
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + cI + (pData.isBedrockPlayer() ? " Is a Bedrock player" : " Is a Java player") + c1 + ".");
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is playing with version " + pData.getClientVersion().getReleaseName() + "(" + pData.getClientVersionID() + ")");
        if (player.isOp()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + cI + " Is OP" + c1 + ".");
        }
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + (player.isOnline() ? " Is currently online." : " Is offline."));
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + (player.isValid() ? " Player is valid." : " Player is invalid."));
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Current health: " + f1.format(BridgeHealth.getHealth((LivingEntity)player)) + "/" + f1.format(BridgeHealth.getMaxHealth((LivingEntity)player)));
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Current food level: " + player.getFoodLevel());
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is in " + player.getGameMode() + " gamemode.");
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " FlySpeed: " + player.getFlySpeed());
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " WalkSpeed: " + player.getWalkSpeed());
        if (thisMove.modelFlying != null) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Movement model for this move " + thisMove.modelFlying.getId().toString());
        }
        if (player.getExp() > 0.0f) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Experience Lvl: " + f1.format(player.getExpToLevel()) + "(exp=" + f1.format(player.getExp()) + ")");
        }
        if (Bridge1_9.isGlidingWithElytra(player)) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is gliding with elytra.");
        }
        if (Bridge1_13.isRiptiding((LivingEntity)player)) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is riptiding.");
        }
        if (Bridge1_13.isSwimming((LivingEntity)player)) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is swimming (1.13).");
        }
        if (pData.isInCrouchingPose()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is sneaking.");
        }
        if (player.isBlocking()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is blocking.");
        }
        if (pData.isSprinting()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is sprinting (NCP).");
        }
        if (BridgeMisc.isUsingItem(player)) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is using " + BridgeMisc.getItemInUse(player) + ".");
        }
        if (player.isInsideVehicle()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is riding a vehicle (" + player.getVehicle().getType() + ") at " + InspectCommand.locString(player.getVehicle().getLocation()));
        }
        if (player.isDead()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is currently dead.");
        }
        if (player.isFlying()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is currently flying.");
        }
        if (player.getAllowFlight()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Is allowed to fly.");
        }
        if (!(effects = player.getActivePotionEffects()).isEmpty()) {
            builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + "Has the following effects: ");
            for (PotionEffect effect : effects) {
                builder.append(effect.getType() + " at level " + effect.getAmplifier() + ", ");
            }
        }
        Location loc = player.getLocation();
        builder.append("\n " + c1 + "" + c2 + "\u2022" + c1 + " Position: " + InspectCommand.locString(loc));
        return builder.toString();
    }

    private static final String locString(Location loc) {
        return loc.getWorld().getName() + " at " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            ArrayList players = Lists.newArrayList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return players;
        }
        return null;
    }
}

