/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin;

import com.google.common.collect.Lists;
import fr.neatmonster.nocheatplus.checks.ViolationHistory;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class InfoCommand
extends BaseCommand {
    public InfoCommand(JavaPlugin plugin) {
        super(plugin, "info", Permissions.COMMAND_INFO);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 2) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Please specify a player.");
            return true;
        }
        this.handleInfoCommand(sender, args[1]);
        return true;
    }

    private void handleInfoCommand(CommandSender sender, String playerName) {
        boolean known;
        String italicbold;
        String bold;
        String cGO;
        String cR;
        String cG;
        if (sender instanceof Player) {
            cG = ChatColor.GRAY.toString();
            cR = ChatColor.RED.toString();
            cGO = ChatColor.GOLD.toString();
            bold = ChatColor.BOLD.toString();
            italicbold = ChatColor.BOLD + "" + ChatColor.ITALIC;
        } else {
            italicbold = "";
            bold = "";
            cGO = "";
            cR = "";
            cG = "";
        }
        Player player = DataManager.getPlayer(playerName);
        if (player != null) {
            playerName = player.getName();
        }
        ViolationHistory history = ViolationHistory.getHistory(playerName, false);
        boolean bl = known = player != null || history != null;
        if (history == null) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "No entries for " + cR + playerName + cG + "'s violations " + (known ? "" : "(exact spelling ?)") + ".");
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        ViolationHistory.ViolationLevel[] violations = history.getViolationLevels();
        if (violations.length > 0) {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "Displaying " + cR + playerName + cG + "'s violations: ");
            for (ViolationHistory.ViolationLevel violationLevel : violations) {
                long time = violationLevel.time;
                String[] parts = violationLevel.check.split("\\.");
                String check = parts[parts.length - 1].toLowerCase();
                String parent = parts[parts.length - 2].toLowerCase();
                long sumVL = Math.round(violationLevel.sumVL);
                long maxVL = Math.round(violationLevel.maxVL);
                long avVl = Math.round(violationLevel.sumVL / (double)violationLevel.nVL);
                sender.sendMessage(cG + bold + "[" + cG + dateFormat.format(new Date(time)) + bold + "] " + cGO + italicbold + parent + "." + check + cG + bold + "\n\u2022 " + cG + "Sum: " + cR + sumVL + cG + " VLs." + cG + bold + "\n\u2022 " + cG + "Triggered: " + cR + violationLevel.nVL + cG + " times." + cG + bold + "\n\u2022 " + cG + "Average: " + cR + avVl + cG + " VL." + cG + bold + "\n\u2022 " + cG + "Max: " + cR + maxVL + cG + " VL.");
            }
        } else {
            sender.sendMessage((sender instanceof Player ? TAG : "[NoCheatPlus] ") + "No violations to display for player " + cR + playerName);
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            ArrayList players = Lists.newArrayList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return players;
        }
        return null;
    }
}

