/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.actions.delay;

import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class DelayableCommand
extends BaseCommand {
    protected final int delayIndex;
    protected final boolean mustHaveDelay;
    protected final int delayPreset;
    protected boolean demandConsoleCommandSender = false;

    public static long parseDelay(String[] args, int index) {
        return DelayableCommand.parseDelay(args, index, -1);
    }

    public static long parseDelay(String[] args, int index, int preset) {
        if (args.length <= index) {
            return preset;
        }
        String arg = args[index].trim().toLowerCase();
        if (!arg.startsWith("delay=")) {
            return preset;
        }
        if (arg.length() < 7) {
            return -1L;
        }
        try {
            long res = Long.parseLong(arg.substring(6));
            if (res < 0L) {
                return -1L;
            }
            return res;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public DelayableCommand(JavaPlugin plugin, String label, RegisteredPermission permission) {
        this(plugin, label, permission, 1);
    }

    public DelayableCommand(JavaPlugin plugin, String label, RegisteredPermission permission, int delayIndex) {
        this(plugin, label, permission, delayIndex, -1, false);
    }

    public DelayableCommand(JavaPlugin plugin, String label, RegisteredPermission permission, int delayIndex, int delayPreset, boolean mustHaveDelay) {
        this(plugin, label, permission, null, delayIndex, delayPreset, mustHaveDelay);
    }

    public DelayableCommand(JavaPlugin plugin, String label, RegisteredPermission permission, String[] aliases, int delayIndex, int delayPreset, boolean mustHaveDelay) {
        super(plugin, label, permission, aliases);
        this.delayIndex = delayIndex;
        this.mustHaveDelay = mustHaveDelay;
        this.delayPreset = delayPreset;
    }

    public abstract boolean execute(CommandSender var1, Command var2, String var3, String[] var4, long var5);

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (this.demandConsoleCommandSender && !DelayableCommand.demandConsoleCommandSender(sender)) {
            return true;
        }
        long delay = DelayableCommand.parseDelay(args, this.delayIndex, this.delayPreset);
        if (args.length <= this.delayIndex) {
            if (this.mustHaveDelay) {
                StaticLog.logInfo("Bad setup. Command usage /ncp delay delay=(ticks) (command to delay).");
            }
            String[] alteredArgs = args;
            return true;
        }
        boolean hasDef = args[this.delayIndex].startsWith("delay=") && delay != -1L;
        String[] alteredArgs = new String[args.length + (hasDef ? -1 : 0)];
        if (alteredArgs.length > 0) {
            int increment = 0;
            for (int i = 0; i < args.length; ++i) {
                if (i == this.delayIndex && hasDef) {
                    increment = -1;
                    continue;
                }
                alteredArgs[i + increment] = args[i];
            }
        }
        return this.execute(sender, command, label, alteredArgs, delay);
    }

    protected void schedule(Runnable runnable, long delay) {
        if (delay < 0L) {
            runnable.run();
        } else if (delay == 0L) {
            SchedulerHelper.runSyncTask((Plugin)this.access, arg -> runnable.run());
        } else {
            SchedulerHelper.runSyncDelayedTask((Plugin)this.access, arg -> runnable.run(), delay);
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }
}

