/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.actions;

import com.google.common.collect.Lists;
import fr.neatmonster.nocheatplus.command.AbstractCommand;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TellCommand
extends BaseCommand {
    public TellCommand(JavaPlugin plugin) {
        super(plugin, "tell", Permissions.COMMAND_TELL);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!TellCommand.demandConsoleCommandSender(sender)) {
            return true;
        }
        if (args.length < 3) {
            StaticLog.logInfo("Bad setup. Command usage: /ncp tell (playername) (message to send).");
            return true;
        }
        String name = args[1].trim();
        String message = AbstractCommand.join(args, 2);
        this.tell(name, message);
        return true;
    }

    private void tell(String name, String message) {
        Player player = DataManager.getPlayer(name);
        if (player != null) {
            player.sendMessage(ColorUtil.replaceColors(message));
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            ArrayList players = Lists.newArrayList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return players;
        }
        return null;
    }
}

