/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.actions;

import com.google.common.collect.Lists;
import fr.neatmonster.nocheatplus.command.AbstractCommand;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class KickCommand
extends BaseCommand {
    private final JavaPlugin plugin;

    public KickCommand(JavaPlugin plugin) {
        super(plugin, "kick", Permissions.COMMAND_KICK);
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!KickCommand.demandConsoleCommandSender(sender)) {
            return true;
        }
        if (args.length < 2) {
            StaticLog.logInfo("Please specify a player to kick (Reason is optional). ");
            return true;
        }
        String name = args[1];
        String reason = args.length > 2 ? AbstractCommand.join(args, 2) : "";
        this.kick(sender, name, reason);
        return true;
    }

    void kick(CommandSender sender, String name, String reason) {
        Player player = DataManager.getPlayer(name);
        if (player == null) {
            return;
        }
        SchedulerHelper.runSyncTask((Plugin)this.plugin, arg -> {
            player.kickPlayer(reason);
            StaticLog.logInfo("(" + sender.getName() + ") Kicked " + player.getName() + " : " + reason);
        });
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            ArrayList players = Lists.newArrayList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return players;
        }
        return null;
    }
}

