/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.actions;

import com.google.common.collect.Lists;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.command.AbstractCommand;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class DenyLoginCommand
extends BaseCommand {
    public DenyLoginCommand(JavaPlugin plugin) {
        super(plugin, "denylogin", Permissions.COMMAND_DENYLOGIN, new String[]{"tempkick", "tkick", "tempban", "tban"});
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            sender.sendMessage(TAG + "This command can only be run from the console.");
            return true;
        }
        if (args.length == 1) {
            StaticLog.logInfo("Please specify a player to temporarily deny log-in.");
            return true;
        }
        if (args.length == 2) {
            StaticLog.logInfo("Please specify the log-in denial duration (minutes).");
            return true;
        }
        long base = 60000L;
        String name = args[1];
        long duration = -1L;
        try {
            duration = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (duration <= 0L) {
            return false;
        }
        long finalDuration = duration * base;
        String reason = args.length > 3 ? AbstractCommand.join(args, 3) : "";
        this.denyLogin(sender, name, finalDuration, reason);
        return true;
    }

    protected void denyLogin(CommandSender sender, String name, long duration, String reason) {
        Player player = DataManager.getPlayer(name);
        NCPAPIProvider.getNoCheatPlusAPI().denyLogin(name, duration);
        if (player == null) {
            return;
        }
        player.kickPlayer(reason);
        StaticLog.logInfo("(" + sender.getName() + ") Kicked " + player.getName() + " for " + duration / 60000L + " minutes: " + reason);
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            ArrayList players = Lists.newArrayList();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
            }
            return players;
        }
        return null;
    }
}

