/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.velocity.VelocityFlags;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import java.util.Arrays;
import java.util.LinkedList;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VelocityAdapter
extends BaseAdapter {
    private static PacketType[] initPacketTypes() {
        LinkedList<PacketType> types = new LinkedList<PacketType>(Arrays.asList(PacketType.Play.Server.EXPLOSION));
        return types.toArray(new PacketType[types.size()]);
    }

    public VelocityAdapter(Plugin plugin) {
        super(plugin, ListenerPriority.MONITOR, VelocityAdapter.initPacketTypes());
    }

    public void onPacketSending(PacketEvent event) {
        this.handleVelocityPacket(event);
    }

    private void handleVelocityPacket(PacketEvent event) {
        block8: {
            try {
                if (event.isPlayerTemporary()) {
                    return;
                }
            }
            catch (NoSuchMethodError e) {
                if (event.getPlayer() == null) {
                    this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
                    return;
                }
                if (DataManager.getPlayerDataSafe(event.getPlayer()) != null) break block8;
                return;
            }
        }
        if (event.getPacketType() != PacketType.Play.Server.EXPLOSION) {
            return;
        }
        Player player = event.getPlayer();
        PacketContainer packet = event.getPacket();
        StructureModifier floats = packet.getFloat();
        if (floats.size() != 4) {
            return;
        }
        Float velX = (Float)floats.read(1);
        Float velY = (Float)floats.read(2);
        Float velZ = (Float)floats.read(3);
        if ((double)Math.abs(velX.floatValue()) == 0.0 && (double)Math.abs(velZ.floatValue()) == 0.0 && (double)Math.abs(velY.floatValue()) == 0.0) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        if (!pData.isCheckActive(CheckType.MOVING, player)) {
            return;
        }
        MovingData data = pData.getGenericInstance(MovingData.class);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        data.addVelocity(player, cc, velX.floatValue(), velY.floatValue(), velZ.floatValue(), VelocityFlags.ORIGIN_EXPLOSION | VelocityFlags.ADDITIVE);
    }
}

