/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.entity.InventoryUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import java.util.Arrays;
import java.util.LinkedList;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.plugin.Plugin;

public class UseItemAdapter
extends BaseAdapter {
    private static final String dftag = "system.nocheatplus.useitemadapter";
    private static final MiniListener<?>[] miniListeners = new MiniListener[]{new MiniListener<PlayerItemConsumeEvent>(){

        @Override
        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.useitemadapter")
        public void onEvent(PlayerItemConsumeEvent event) {
            UseItemAdapter.onItemConsume(event);
        }
    }, new MiniListener<PlayerInteractEvent>(){

        @Override
        @EventHandler(priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.useitemadapter")
        public void onEvent(PlayerInteractEvent event) {
            UseItemAdapter.onItemInteract(event);
        }
    }, new MiniListener<InventoryOpenEvent>(){

        @Override
        @EventHandler(priority=EventPriority.LOWEST)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.useitemadapter")
        public void onEvent(InventoryOpenEvent event) {
            UseItemAdapter.onInventoryOpen(event);
        }
    }, new MiniListener<PlayerDeathEvent>(){

        @Override
        @EventHandler(priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.useitemadapter")
        public void onEvent(PlayerDeathEvent event) {
            UseItemAdapter.onDeath(event);
        }
    }, new MiniListener<PlayerItemHeldEvent>(){

        @Override
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.useitemadapter")
        public void onEvent(PlayerItemHeldEvent event) {
            UseItemAdapter.onChangeSlot(event);
        }
    }};
    private static int timeBetweenRL = 70;

    private static PacketType[] initPacketTypes() {
        LinkedList<PacketType> types = new LinkedList<PacketType>(Arrays.asList(PacketType.Play.Client.BLOCK_DIG, PacketType.Play.Client.BLOCK_PLACE));
        return types.toArray(new PacketType[types.size()]);
    }

    public UseItemAdapter(Plugin plugin) {
        super(plugin, ListenerPriority.MONITOR, UseItemAdapter.initPacketTypes());
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        if (!BridgeMisc.hasGetItemInUseMethod()) {
            if (Bridge1_13.hasPlayerRiptideEvent()) {
                MiniListener<PlayerRiptideEvent> miniListener = new MiniListener<PlayerRiptideEvent>(){

                    @Override
                    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                    @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.useitemadapter")
                    public void onEvent(PlayerRiptideEvent event) {
                        UseItemAdapter.onTridentRelease(event);
                    }
                };
                api.addComponent(miniListener, false);
            }
            for (MiniListener<?> listener : miniListeners) {
                api.addComponent(listener, false);
            }
        }
        MiniListener<PlayerRespawnEvent> miniListener = new MiniListener<PlayerRespawnEvent>(){

            @Override
            @EventHandler(priority=EventPriority.MONITOR)
            @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.useitemadapter")
            public void onEvent(PlayerRespawnEvent event) {
                UseItemAdapter.onRespawning(event);
            }
        };
        api.addComponent(miniListener, false);
    }

    public void onPacketReceiving(PacketEvent event) {
        block8: {
            try {
                if (event.isPlayerTemporary()) {
                    return;
                }
            }
            catch (NoSuchMethodError e) {
                if (event.getPlayer() == null) {
                    this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
                    return;
                }
                if (DataManager.getPlayerDataSafe(event.getPlayer()) != null) break block8;
                StaticLog.logWarning("Failed to fetch player data with " + event.getPacketType() + " for: " + event.getPlayer().toString());
                return;
            }
        }
        if (BridgeMisc.hasGetItemInUseMethod()) {
            if (event.getPacketType().equals((Object)PacketType.Play.Client.BLOCK_DIG)) {
                this.handleDiggingPacket(event);
            }
            return;
        }
        if (event.getPacketType().equals((Object)PacketType.Play.Client.BLOCK_DIG)) {
            this.handleDiggingPacket(event);
        } else {
            this.handleBlockPlacePacket(event);
        }
    }

    private static void onRespawning(PlayerRespawnEvent e) {
        IPlayerData pData = DataManager.getPlayerData(e.getPlayer());
        if (Bridge1_9.hasGetItemInOffHand() && e.getPlayer().isBlocking()) {
            pData.requestItemUseResync();
        }
    }

    private static void onTridentRelease(PlayerRiptideEvent e) {
        IPlayerData pData = DataManager.getPlayerData(e.getPlayer());
        pData.setItemInUse(null);
    }

    private static void onItemConsume(PlayerItemConsumeEvent e) {
        Player p = e.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(p);
        pData.setItemInUse(null);
    }

    private static void onInventoryOpen(InventoryOpenEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = (Player)e.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(p);
        pData.setItemInUse(null);
    }

    private static void onDeath(PlayerDeathEvent e) {
        IPlayerData pData = DataManager.getPlayerData(e.getEntity());
        pData.setItemInUse(null);
    }

    private static void onItemInteract(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player p = e.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(p);
        MovingConfig mCC = pData.getGenericInstance(MovingConfig.class);
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        data.offHandUse = false;
        if (!data.mightUseItem) {
            return;
        }
        data.mightUseItem = false;
        if (e.useItemInHand().equals((Object)Event.Result.DENY)) {
            return;
        }
        if (p.getGameMode() == GameMode.CREATIVE) {
            pData.setItemInUse(null);
            return;
        }
        if (e.hasItem()) {
            ItemStack item = e.getItem();
            Material m = item.getType();
            if (Bridge1_9.hasElytra() && p.hasCooldown(m)) {
                return;
            }
            if (InventoryUtil.isConsumable(item)) {
                if (!Bridge1_9.hasElytra() && item.getDurability() > 16384) {
                    return;
                }
                if (m == Material.POTION || m == Material.MILK_BUCKET || m.toString().endsWith("_APPLE") || m.name().startsWith("HONEY_BOTTLE")) {
                    pData.setItemInUse(m);
                    data.offHandUse = Bridge1_9.hasGetItemInOffHand() && e.getHand() == EquipmentSlot.OFF_HAND;
                    return;
                }
                if (item.getType().isEdible() && p.getFoodLevel() < 20) {
                    pData.setItemInUse(m);
                    data.offHandUse = Bridge1_9.hasGetItemInOffHand() && e.getHand() == EquipmentSlot.OFF_HAND;
                    return;
                }
            }
            if (m == Material.BOW && InventoryUtil.hasArrow(p.getInventory(), false)) {
                pData.setItemInUse(m);
                data.offHandUse = Bridge1_9.hasGetItemInOffHand() && e.getHand() == EquipmentSlot.OFF_HAND;
                return;
            }
            if (ServerVersion.isAtLeast("1.9") && pData.getClientVersion().isAtLeast(ClientVersion.V_1_9)) {
                if (m == Material.SHIELD) {
                    pData.setItemInUse(m);
                    data.offHandUse = e.getHand() == EquipmentSlot.OFF_HAND;
                    return;
                }
            } else if (MaterialUtil.isSword(m) && (ServerVersion.isLowerThan("1.9") || pData.getClientVersion().isAtMost(ClientVersion.V_1_8))) {
                pData.setItemInUse(m);
                return;
            }
            if (m.toString().equals("CROSSBOW") && !((CrossbowMeta)item.getItemMeta()).hasChargedProjectiles() && InventoryUtil.hasArrow(p.getInventory(), true)) {
                pData.setItemInUse(m);
                boolean bl = data.offHandUse = e.getHand() == EquipmentSlot.OFF_HAND;
            }
            if (m == BridgeMaterial.TRIDENT && item.getDurability() < m.getMaxDurability() - 1 && pData.getClientVersion().isAtLeast(ClientVersion.V_1_13) && ((double)BridgeEnchant.getRiptideLevel(p) > 0.0 && (BlockProperties.isInWater(p, p.getLocation(), mCC.yOnGround) || p.getLocation().getWorld().hasStorm() && BlockProperties.canSeeSky(p, p.getLocation(), mCC.yOnGround)) || (double)BridgeEnchant.getRiptideLevel(p) <= 0.0)) {
                pData.setItemInUse(m);
                data.offHandUse = e.getHand() == EquipmentSlot.OFF_HAND;
                return;
            }
            if (BridgeMisc.hasIsFrozen() && m == Material.SPYGLASS) {
                pData.setItemInUse(m);
                data.offHandUse = e.getHand() == EquipmentSlot.OFF_HAND;
                return;
            }
            if (m.toString().equals("GOAT_HORN")) {
                pData.setItemInUse(m);
                data.offHandUse = e.getHand() == EquipmentSlot.OFF_HAND;
                return;
            }
        } else {
            pData.setItemInUse(null);
        }
    }

    private static void onChangeSlot(PlayerItemHeldEvent e) {
        Player p = e.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(p);
        MovingData mData = pData.getGenericInstance(MovingData.class);
        CombinedData cData = pData.getGenericInstance(CombinedData.class);
        if (e.getPreviousSlot() != e.getNewSlot()) {
            pData.requestItemUseResync();
        }
    }

    private void handleBlockPlacePacket(PacketEvent event) {
        int faceIndex;
        Player p = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(p);
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        PacketContainer packet = event.getPacket();
        StructureModifier ints = packet.getIntegers();
        if (ints.size() > 0 && !ServerVersion.isAtLeast("1.9") && (faceIndex = ((Integer)ints.read(0)).intValue()) <= 5) {
            data.mightUseItem = false;
            return;
        }
        if (!event.isCancelled()) {
            data.mightUseItem = true;
        }
    }

    private void handleDiggingPacket(PacketEvent event) {
        Player p = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerDataSafe(p);
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        EnumWrappers.PlayerDigType digtype = (EnumWrappers.PlayerDigType)event.getPacket().getPlayerDigTypes().read(0);
        if (!(BridgeMisc.hasGetItemInUseMethod() || digtype != EnumWrappers.PlayerDigType.DROP_ALL_ITEMS && digtype != EnumWrappers.PlayerDigType.DROP_ITEM)) {
            pData.setItemInUse(null);
        }
        if (digtype == EnumWrappers.PlayerDigType.RELEASE_USE_ITEM) {
            pData.setItemInUse(null);
            long now = System.currentTimeMillis();
            if (data.releaseItemTime != 0L) {
                if (now < data.releaseItemTime) {
                    data.releaseItemTime = now;
                    return;
                }
                if (data.releaseItemTime + (long)timeBetweenRL > now) {
                    data.isHackingRI = true;
                }
            }
            data.releaseItemTime = now;
        }
    }

    public static void setuseRLThreshold(int time) {
        timeBetweenRL = time;
    }
}

