/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedEnumEntityUseAction;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.AttackFrequency;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UseEntityAdapter
extends BaseAdapter {
    private static final int INTERPRETED = 1;
    private static final int ATTACK = 2;
    private final AttackFrequency attackFrequency;
    private final LegacyReflectionSet legacySet;

    public UseEntityAdapter(Plugin plugin) {
        super(plugin, PacketType.Play.Client.USE_ENTITY);
        this.checkType = CheckType.NET_ATTACKFREQUENCY;
        if (NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().isActiveAnywhere(CheckType.NET_ATTACKFREQUENCY)) {
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(AttackFrequency.class.getSimpleName()));
        }
        this.attackFrequency = new AttackFrequency();
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.attackFrequency);
        this.legacySet = this.getLegacyReflectionSet();
    }

    private LegacyReflectionSet getLegacyReflectionSet() {
        for (String versionDetail : new String[]{"v1_7_R4", "v1_7_R1"}) {
            try {
                return new LegacyReflectionSet(versionDetail);
            }
            catch (RuntimeException runtimeException) {
            }
        }
        return null;
    }

    public void onPacketReceiving(PacketEvent event) {
        int flags;
        try {
            if (event.isPlayerTemporary()) {
                return;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerDataSafe(player);
        if (pData == null) {
            return;
        }
        NetData data = pData.getGenericInstance(NetData.class);
        data.lastKeepAliveTime = time;
        if (!pData.isCheckActive(CheckType.NET_ATTACKFREQUENCY, player)) {
            return;
        }
        PacketContainer packet = event.getPacket();
        boolean isAttack = false;
        boolean packetInterpreted = false;
        if (this.legacySet != null && ((flags = this.getAction_legacy(packet)) & 1) != 0) {
            packetInterpreted = true;
            if ((flags & 2) != 0) {
                isAttack = true;
            }
        }
        if (!packetInterpreted) {
            try {
                StructureModifier actions = packet.getEntityUseActions();
                StructureModifier enumActions = packet.getEnumEntityUseActions();
                if (actions.size() == 1 && actions.read(0) == EnumWrappers.EntityUseAction.ATTACK || enumActions.size() == 1 && ((WrappedEnumEntityUseAction)enumActions.read(0)).equals((Object)WrappedEnumEntityUseAction.attack())) {
                    packetInterpreted = true;
                    isAttack = true;
                }
            }
            catch (NullPointerException actions) {
                // empty catch block
            }
        }
        if (!packetInterpreted) {
            return;
        }
        boolean cancel = false;
        if (isAttack) {
            NetConfig cc = pData.getGenericInstance(NetConfig.class);
            if (this.attackFrequency.isEnabled(player, pData) && this.attackFrequency.check(player, time, data, cc, pData)) {
                cancel = true;
            }
        }
        if (cancel) {
            event.setCancelled(true);
        }
    }

    private int getAction_legacy(PacketContainer packetContainer) {
        String actionName = this.legacySet.getActionFromNMSPacket(packetContainer.getHandle());
        return actionName == null ? 0 : 1 | ("ATTACK".equals(actionName) ? 2 : 0);
    }

    private static class LegacyReflectionSet {
        final Class<?> packetClass_legacy;
        final Class<?> enumClassAction_legacy;
        final Method methodGetAction_legacy;
        final Method methodName_legacy;

        private LegacyReflectionSet(String versionDetail) {
            Method methodGetAction;
            Class<?> packetClass = ReflectionUtil.getClass("net.minecraft.server." + versionDetail + ".PacketPlayInUseEntity");
            Class<?> actionClass = ReflectionUtil.getClass("net.minecraft.server." + versionDetail + ".EnumEntityUseAction");
            Method method = methodGetAction = packetClass == null || actionClass == null ? null : ReflectionUtil.getMethodNoArgs(packetClass, "c", actionClass);
            if (packetClass == null || actionClass == null || methodGetAction == null) {
                this.packetClass_legacy = null;
                this.enumClassAction_legacy = null;
                this.methodGetAction_legacy = null;
                this.methodName_legacy = null;
            } else {
                this.packetClass_legacy = packetClass;
                this.enumClassAction_legacy = actionClass;
                this.methodGetAction_legacy = methodGetAction;
                this.methodName_legacy = ReflectionUtil.getMethodNoArgs(this.enumClassAction_legacy, "name", String.class);
            }
            if (this.methodName_legacy == null) {
                throw new RuntimeException("Not supported.");
            }
        }

        String getActionFromNMSPacket(Object handle) {
            Class<?> clazz = handle.getClass();
            if (clazz != this.packetClass_legacy) {
                return null;
            }
            Object action = ReflectionUtil.invokeMethodNoArgs(this.methodGetAction_legacy, handle);
            if (action == null) {
                return null;
            }
            Object actionName = ReflectionUtil.invokeMethodNoArgs(this.methodName_legacy, action);
            if (actionName instanceof String) {
                return (String)actionName;
            }
            return null;
        }
    }
}

