/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketListener;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.registry.feature.IDisableListener;
import fr.neatmonster.nocheatplus.components.registry.feature.INotifyReload;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.worlds.IWorldDataManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ProtocolLibComponent
implements IDisableListener,
INotifyReload,
JoinLeaveListener,
Listener {
    public static final int idNullPlayer = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class).registerKey("packet.nullplayer");
    public static final int idInconsistentIsAsync = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class).registerKey("packet.inconsistent.isasync");
    private static final List<PacketAdapter> registeredPacketAdapters = new LinkedList<PacketAdapter>();

    public static PacketType findPacketTypeByName(PacketType.Protocol protocol, PacketType.Sender sender, String name) {
        try {
            return PacketType.findCurrent((PacketType.Protocol)protocol, (PacketType.Sender)sender, (String)name);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ProtocolLibComponent(Plugin plugin) {
        this.register(plugin);
    }

    private void register(Plugin plugin) {
        IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        if (!worldMan.isActiveAnywhere(CheckType.NET)) {
            StaticLog.logInfo("No packet level checks activated.");
            return;
        }
        StaticLog.logInfo("Adding packet level hooks for ProtocolLib (MC " + ProtocolLibrary.getProtocolManager().getMinecraftVersion().getVersion() + ")...");
        if (ConfigManager.isTrueForAnyConfig("checks.net.debug") || ConfigManager.isTrueForAnyConfig("checks.debug")) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.DebugAdapter", plugin);
        }
        if (ServerVersion.compareMinecraftVersion("1.6.4") <= 0) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Disable EntityUseAdapter due to incompatibilities. Click speed won't be monitored.");
        } else if (worldMan.isActiveAnywhere(CheckType.NET_ATTACKFREQUENCY)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.UseEntityAdapter", plugin);
        }
        if (worldMan.isActiveAnywhere(CheckType.NET_FLYINGFREQUENCY) || worldMan.isActiveAnywhere(CheckType.NET_MOVING) || worldMan.isActiveAnywhere(CheckType.NET_WRONGTURN)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.MovingFlying", plugin);
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.OutgoingPosition", plugin);
        }
        if (worldMan.isActiveAnywhere(CheckType.NET_KEEPALIVEFREQUENCY) || worldMan.isActiveAnywhere(CheckType.FIGHT_GODMODE)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.KeepAliveAdapter", plugin);
        }
        if (worldMan.isActiveAnywhere(CheckType.NET_SOUNDDISTANCE)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.SoundDistance", plugin);
        }
        if (ServerVersion.compareMinecraftVersion("1.9") < 0 && worldMan.isActiveAnywhere(CheckType.NET_PACKETFREQUENCY)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.CatchAllAdapter", plugin);
        }
        if (ServerVersion.isAtLeast("1.8")) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.UseItemAdapter", plugin);
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.VelocityAdapter", plugin);
        } else {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Disable UseItemAdapter due to incompatibilities. Using-item status won't be monitored.");
        }
        if (worldMan.isActiveAnywhere(CheckType.NET_TOGGLEFREQUENCY)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.EntityActionAdapter", plugin);
        }
        if (BridgeMisc.hasPlayerInputEvent()) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.InputsAdapter", plugin);
        }
        if (!registeredPacketAdapters.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>(registeredPacketAdapters.size());
            for (PacketAdapter adapter : registeredPacketAdapters) {
                names.add(adapter.getClass().getSimpleName());
            }
            StaticLog.logInfo("Available (and activated) packet level hooks: " + StringUtil.join(names, " | "));
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("packet-listeners", names);
        } else {
            StaticLog.logInfo("No packet level hooks activated.");
        }
    }

    private void register(String name, Plugin plugin) {
        Exception t = null;
        try {
            Class<?> clazz = Class.forName(name);
            this.register(clazz, plugin);
            return;
        }
        catch (ClassNotFoundException e) {
            t = e;
        }
        catch (ClassCastException e) {
            t = e;
        }
        StaticLog.logWarning("Could not register packet level hook: " + name);
        StaticLog.logWarning(t);
    }

    private void register(Class<? extends PacketAdapter> clazz, Plugin plugin) {
        block2: {
            try {
                PacketAdapter adapter = clazz.getDeclaredConstructor(Plugin.class).newInstance(plugin);
                ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)adapter);
                registeredPacketAdapters.add(adapter);
            }
            catch (Throwable t) {
                StaticLog.logWarning("Could not register packet level hook: " + clazz.getSimpleName());
                StaticLog.logWarning(t);
                if (t.getCause() == null) break block2;
                StaticLog.logWarning(t.getCause());
            }
        }
    }

    @Override
    public void onDisable() {
        this.unregister();
    }

    @Override
    public void onReload() {
        this.unregister();
        NCPAPIProvider.getNoCheatPlusAPI().getPlayerDataManager().removeGenericInstance(NetData.class);
        this.register(Bukkit.getPluginManager().getPlugin("NoCheatPlus"));
    }

    private void unregister() {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        for (PacketAdapter adapter : registeredPacketAdapters) {
            try {
                protocolManager.removePacketListener((PacketListener)adapter);
                api.removeComponent(adapter);
            }
            catch (Throwable t) {
                StaticLog.logWarning("Failed to unregister packet level hook: " + adapter.getClass().getName());
            }
        }
        registeredPacketAdapters.clear();
    }

    protected static void unregister(PacketAdapter adapter) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        try {
            protocolManager.removePacketListener((PacketListener)adapter);
            api.removeComponent(adapter);
            registeredPacketAdapters.remove(adapter);
            ArrayList<String> names = new ArrayList<String>(registeredPacketAdapters.size());
            for (PacketAdapter adaptern : registeredPacketAdapters) {
                names.add(adaptern.getClass().getSimpleName());
            }
            api.setFeatureTags("packet-listeners", names);
            StaticLog.logInfo("Unregistered packet level hook:" + adapter.getClass().getName());
        }
        catch (Throwable t) {
            StaticLog.logWarning("Failed to unregister packet level hook: " + adapter.getClass().getName());
        }
    }

    @Override
    public void playerJoins(Player player) {
        if (!registeredPacketAdapters.isEmpty()) {
            DataManager.getGenericInstance(player, NetData.class).onJoin(player);
        }
        SchedulerHelper.runSyncDelayedTask(Bukkit.getPluginManager().getPlugin("NoCheatPlus"), arg -> {
            if (Bukkit.getPluginManager().getPlugin("ViaVersion") == null && Bukkit.getPluginManager().getPlugin("ProtocolSupport") == null) {
                DataManager.getPlayerData(player).setClientVersionID(ProtocolLibrary.getProtocolManager().getProtocolVersion(player));
            }
        }, 5L);
    }

    @Override
    public void playerLeaves(Player player) {
        if (!registeredPacketAdapters.isEmpty()) {
            DataManager.getGenericInstance(player, NetData.class).onLeave(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!registeredPacketAdapters.isEmpty()) {
            Player player = event.getPlayer();
            NetData data = DataManager.getGenericInstance(player, NetData.class);
            data.onJoin(player);
            Location loc = event.getRespawnLocation();
            data.teleportQueue.onTeleportEvent(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (!registeredPacketAdapters.isEmpty()) {
            Location to = event.getTo();
            if (to == null) {
                return;
            }
            Player player = event.getPlayer();
            IPlayerData pData = DataManager.getPlayerData(player);
            NetData data = pData.getGenericInstance(NetData.class);
            data.teleportQueue.onTeleportEvent(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
            data.clearFlyingQueue();
        }
    }
}

