/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.FlyingFrequency;
import fr.neatmonster.nocheatplus.checks.net.Moving;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.WrongTurn;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.checks.net.model.TeleportQueue;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.time.monotonic.Monotonic;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MovingFlying
extends BaseAdapter {
    private static final boolean isServerAtLeast1_21_3 = ServerVersion.compareMinecraftVersion("1.21.3") >= 0;
    public static final int indexOnGround = 0;
    public static final int indexhorizontalCollision = isServerAtLeast1_21_3 ? 1 : 0;
    public static final int indexhasPos = 1 + indexhorizontalCollision;
    public static final int indexhasLook = 2 + indexhorizontalCollision;
    public static final int indexX = 0;
    public static final int indexY = 1;
    public static final int indexZ = 2;
    public static final int indexStance = 3;
    public static final int indexYaw = 0;
    public static final int indexPitch = 1;
    private static PacketType confirmTeleportType;
    private static boolean acceptConfirmTeleportPackets;
    private final Plugin plugin = Bukkit.getPluginManager().getPlugin("NoCheatPlus");
    private final FlyingFrequency flyingFrequency = new FlyingFrequency();
    private final Moving moving = new Moving();
    private final WrongTurn wrongTurn = new WrongTurn();
    private final int idFlying = this.counters.registerKey("packet.flying");
    private final int idAsyncFlying = this.counters.registerKey("packet.flying.asynchronous");
    private long packetMismatch = Long.MIN_VALUE;
    private long packetMismatchLogFrequency = 60000L;
    private final HashSet<DataPacketFlying.PACKET_CONTENT> validContent = new LinkedHashSet<DataPacketFlying.PACKET_CONTENT>();

    private static PacketType[] initPacketTypes() {
        LinkedList<PacketType> types = new LinkedList<PacketType>(Arrays.asList(PacketType.Play.Client.LOOK, PacketType.Play.Client.POSITION, PacketType.Play.Client.POSITION_LOOK));
        if (ServerVersion.isLowerThan("1.17")) {
            types.add(PacketType.Play.Client.FLYING);
            StaticLog.logInfo("Add listener for legacy PlayInFlying packet.");
        } else {
            types.add(PacketType.Play.Client.GROUND);
        }
        confirmTeleportType = ProtocolLibComponent.findPacketTypeByName(PacketType.Protocol.PLAY, PacketType.Sender.CLIENT, "AcceptTeleportation");
        if (confirmTeleportType == null) {
            confirmTeleportType = ProtocolLibComponent.findPacketTypeByName(PacketType.Protocol.PLAY, PacketType.Sender.CLIENT, "TeleportAccept");
        }
        if (confirmTeleportType != null && ServerVersion.isAtLeast("1.9")) {
            StaticLog.logInfo("Confirm teleport packet available (via name): " + confirmTeleportType);
            types.add(confirmTeleportType);
            acceptConfirmTeleportPackets = true;
        } else {
            acceptConfirmTeleportPackets = false;
        }
        return types.toArray(new PacketType[types.size()]);
    }

    public MovingFlying(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, MovingFlying.initPacketTypes());
        if (NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().isActiveAnywhere(CheckType.NET_FLYINGFREQUENCY)) {
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("checks", Arrays.asList(FlyingFrequency.class.getSimpleName()));
        }
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.flyingFrequency);
    }

    public void onPacketReceiving(PacketEvent event) {
        block7: {
            try {
                if (event.isPlayerTemporary()) {
                    return;
                }
            }
            catch (NoSuchMethodError e) {
                if (event.getPlayer() == null) {
                    return;
                }
                if (DataManager.getPlayerDataSafe(event.getPlayer()) != null) break block7;
                return;
            }
        }
        if (event.getPacketType().equals((Object)confirmTeleportType)) {
            if (acceptConfirmTeleportPackets) {
                this.onConfirmTeleportPacket(event);
            }
        } else {
            this.onFlyingPacket(event);
        }
    }

    private void onConfirmTeleportPacket(PacketEvent event) {
        try {
            this.processConfirmTeleport(event);
        }
        catch (Throwable t) {
            this.noConfirmTeleportPacket();
        }
    }

    private void processConfirmTeleport(PacketEvent event) {
        PacketContainer packet = event.getPacket();
        StructureModifier integers = packet.getIntegers();
        if (integers.size() != 1) {
            this.noConfirmTeleportPacket();
            return;
        }
        Integer teleportId = (Integer)integers.read(0);
        if (teleportId == null) {
            return;
        }
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerDataSafe(player);
        NetData data = pData.getGenericInstance(NetData.class);
        AlmostBoolean matched = data.teleportQueue.processAck(teleportId);
        if (matched.decideOptimistically()) {
            ActionFrequency.subtract(System.currentTimeMillis(), 1.0f, data.flyingFrequencyAll);
        }
        if (pData.isDebugActive(this.checkType)) {
            this.debug(player, "Confirm teleport packet" + (matched.decideOptimistically() ? " (matched=" + (Object)((Object)matched) + ")" : "") + ": " + teleportId);
        }
    }

    private void noConfirmTeleportPacket() {
        acceptConfirmTeleportPackets = false;
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Confirm teleport packet not available.");
    }

    private void onFlyingPacket(PacketEvent event) {
        boolean primaryThread = Bukkit.isPrimaryThread();
        this.counters.add(this.idFlying, 1, primaryThread);
        if (event.isAsync() == primaryThread) {
            this.counters.add(ProtocolLibComponent.idInconsistentIsAsync, 1, primaryThread);
        }
        if (!primaryThread) {
            this.counters.addSynchronized(this.idAsyncFlying, 1);
        }
        long time = System.currentTimeMillis();
        Player player = event.getPlayer();
        if (player == null) {
            this.counters.add(ProtocolLibComponent.idNullPlayer, 1, primaryThread);
            event.setCancelled(true);
            return;
        }
        IPlayerData pData = DataManager.getPlayerDataSafe(player);
        NetData data = pData.getGenericInstance(NetData.class);
        data.lastKeepAliveTime = time;
        NetConfig cc = pData.getGenericInstance(NetConfig.class);
        boolean cancel = false;
        DataPacketFlying packetData = this.interpretPacket(event, time);
        boolean skipFlyingFrequency = false;
        if (packetData != null) {
            if (this.isInvalidContent(packetData)) {
                event.setCancelled(true);
                if (pData.isDebugActive(this.checkType)) {
                    this.debug(player, "Incoming packet, cancel due to malicious content: " + packetData.toString());
                }
                return;
            }
            switch (data.teleportQueue.processAck(packetData)) {
                case WAITING: {
                    if (pData.isDebugActive(this.checkType)) {
                        this.debug(player, "Incoming packet, still waiting for ACK on outgoing position.");
                    }
                    if (confirmTeleportType == null || !cc.supersededFlyingCancelWaiting) break;
                    TeleportQueue.AckReference ackReference = data.teleportQueue.getLastAckReference();
                    if (ackReference.lastOutgoingId == Integer.MIN_VALUE || ackReference.lastOutgoingId == ackReference.maxConfirmedId) break;
                    cancel = true;
                    break;
                }
                case ACK: {
                    skipFlyingFrequency = true;
                    if (pData.isDebugActive(this.checkType)) {
                        this.debug(player, "Incoming packet, interpret as ACK for outgoing position.");
                    }
                }
                default: {
                    data.addFlyingQueue(packetData);
                }
            }
            this.validContent.add(packetData.getSimplifiedContentType());
        }
        if (!cancel && !skipFlyingFrequency && this.flyingFrequency.check(player, packetData, time, data, cc, pData) && !pData.hasBypass(CheckType.NET_FLYINGFREQUENCY, player)) {
            cancel = true;
            data.requestSetBack(player, this, this.plugin, CheckType.NET_FLYINGFREQUENCY);
        }
        if (!cancel && !skipFlyingFrequency && pData.isCheckActive(CheckType.NET_MOVING, player) && this.moving.check(player, packetData, data, cc, pData, this.plugin) && !pData.hasBypass(CheckType.NET_MOVING, player)) {
            cancel = true;
            data.requestSetBack(player, this, this.plugin, CheckType.NET_MOVING);
        }
        if (!cancel && pData.isCheckActive(CheckType.NET_WRONGTURN, player) && this.wrongTurn.check(player, packetData.getPitch(), data, cc) && !pData.hasBypass(CheckType.NET_WRONGTURN, player)) {
            cancel = true;
        }
        if (cancel) {
            event.setCancelled(true);
        }
        if (pData.isDebugActive(this.checkType)) {
            this.debug(player, (packetData == null ? "(Incompatible data)" : packetData.toString()) + (event.isCancelled() ? " CANCEL" : ""));
        }
    }

    private boolean isInvalidContent(DataPacketFlying packetData) {
        if (packetData.hasPos && LocUtil.isBadCoordinate(packetData.getX(), packetData.getY(), packetData.getZ())) {
            return true;
        }
        return packetData.hasLook && LocUtil.isBadCoordinate(packetData.getYaw(), packetData.getPitch());
    }

    private DataPacketFlying interpretPacket(PacketEvent event, long time) {
        List floats;
        List doubles;
        PacketContainer packet = event.getPacket();
        List booleans = packet.getBooleans().getValues();
        if (booleans.size() != (isServerAtLeast1_21_3 ? 4 : 3)) {
            this.packetMismatch(event);
            return null;
        }
        boolean onGround = (Boolean)booleans.get(0);
        boolean horizontalCollision = isServerAtLeast1_21_3 && (Boolean)booleans.get(indexhorizontalCollision) != false;
        boolean hasPos = (Boolean)booleans.get(indexhasPos);
        boolean hasLook = (Boolean)booleans.get(indexhasLook);
        if (!hasPos && !hasLook) {
            return new DataPacketFlying(onGround, horizontalCollision, time);
        }
        if (hasPos) {
            doubles = packet.getDoubles().getValues();
            if (doubles.size() != 3 && doubles.size() != 4) {
                this.packetMismatch(event);
                return null;
            }
        } else {
            doubles = null;
        }
        if (hasLook) {
            floats = packet.getFloat().getValues();
            if (floats.size() != 2) {
                this.packetMismatch(event);
                return null;
            }
        } else {
            floats = null;
        }
        if (hasPos && hasLook) {
            return new DataPacketFlying(onGround, horizontalCollision, (Double)doubles.get(0), (Double)doubles.get(1), (Double)doubles.get(2), ((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), time);
        }
        if (hasLook) {
            return new DataPacketFlying(onGround, horizontalCollision, ((Float)floats.get(0)).floatValue(), ((Float)floats.get(1)).floatValue(), time);
        }
        if (hasPos) {
            return new DataPacketFlying(onGround, horizontalCollision, (Double)doubles.get(0), (Double)doubles.get(1), (Double)doubles.get(2), time);
        }
        throw new IllegalStateException("Can't be, it can't be!");
    }

    private void packetMismatch(PacketEvent packetEvent) {
        long time = Monotonic.synchMillis();
        if (time - this.packetMismatchLogFrequency > this.packetMismatch) {
            this.packetMismatch = time;
            StringBuilder builder = new StringBuilder(512);
            builder.append(CheckUtils.getLogMessagePrefix(packetEvent.getPlayer(), this.checkType));
            builder.append("Incoming packet could not be interpreted. Are server and plugins up to date (NCP/ProtocolLib...)? This message is logged every ");
            builder.append(Long.toString(this.packetMismatchLogFrequency / 1000L));
            builder.append(" seconds, disregarding for which player this happens.");
            if (!this.validContent.isEmpty()) {
                builder.append(" On other occasion, valid content was received for: ");
                StringUtil.join(this.validContent, ", ", builder);
            }
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, builder.toString());
        }
    }
}

