/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.AutoWrapper;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.InputDirection;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import java.util.Arrays;
import java.util.LinkedList;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InputsAdapter
extends BaseAdapter {
    private static AutoWrapper<Input7Bools> INPUT_WRAPPER;

    private static PacketType[] initPacketTypes() {
        LinkedList<PacketType> types = new LinkedList<PacketType>(Arrays.asList(PacketType.Play.Client.STEER_VEHICLE));
        return types.toArray(new PacketType[types.size()]);
    }

    public InputsAdapter(Plugin plugin) {
        super(plugin, ListenerPriority.MONITOR, InputsAdapter.initPacketTypes());
    }

    public void onPacketReceiving(PacketEvent event) {
        this.handleInputPacket(event);
    }

    private void handleInputPacket(PacketEvent event) {
        block6: {
            try {
                if (event.isPlayerTemporary()) {
                    return;
                }
            }
            catch (NoSuchMethodError e) {
                if (event.getPlayer() == null) {
                    this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
                    return;
                }
                if (DataManager.getPlayerDataSafe(event.getPlayer()) != null) break block6;
                return;
            }
        }
        Player player = event.getPlayer();
        PacketContainer packet = event.getPacket();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        StructureModifier objs = packet.getModifier().withType(Object.class);
        Object raw = objs.read(0);
        if (INPUT_WRAPPER == null) {
            INPUT_WRAPPER = AutoWrapper.wrap(Input7Bools.class, raw.getClass());
        }
        Input7Bools in = (Input7Bools)INPUT_WRAPPER.wrap(raw);
        boolean forward = in.forward;
        boolean backward = in.backward;
        boolean left = in.left;
        boolean right = in.right;
        boolean jump = in.jump;
        boolean shift = in.shift;
        boolean sprint = in.sprint;
        thisMove.input = new InputDirection(Boolean.compare(left, right), Boolean.compare(forward, backward));
        if (pData.isDebugActive(CheckType.MOVING)) {
            player.sendMessage("Strafe: " + (Object)((Object)thisMove.input.getStrafeDir()) + " Frwd: " + (Object)((Object)thisMove.input.getForwardDir()));
        }
    }

    public static class Input7Bools {
        public boolean forward;
        public boolean backward;
        public boolean left;
        public boolean right;
        public boolean jump;
        public boolean shift;
        public boolean sprint;
    }
}

