/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.ToggleFrequency;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import java.util.Arrays;
import java.util.LinkedList;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EntityActionAdapter
extends BaseAdapter {
    private final ToggleFrequency toggleFrequency = new ToggleFrequency();

    private static PacketType[] initPacketTypes() {
        LinkedList<PacketType> types = new LinkedList<PacketType>(Arrays.asList(PacketType.Play.Client.ENTITY_ACTION));
        return types.toArray(new PacketType[types.size()]);
    }

    public EntityActionAdapter(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, EntityActionAdapter.initPacketTypes());
    }

    public void onPacketReceiving(PacketEvent event) {
        try {
            if (event.isPlayerTemporary()) {
                return;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (event.getPacketType() != PacketType.Play.Client.ENTITY_ACTION) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
            return;
        }
        IPlayerData pData = DataManager.getPlayerDataSafe(player);
        if (pData == null) {
            StaticLog.logWarning("Failed to fetch player data with " + event.getPacketType() + " for: " + player.toString());
            return;
        }
        StructureModifier actions = event.getPacket().getPlayerActions();
        NetData data = pData.getGenericInstance(NetData.class);
        data.playerActionFreq.add(System.currentTimeMillis(), 1.0f);
        data.lastKeepAliveTime = System.currentTimeMillis();
        boolean cancel = false;
        if (!cancel && pData.isCheckActive(CheckType.NET_TOGGLEFREQUENCY, player) && this.toggleFrequency.check(player, data, pData.getGenericInstance(NetConfig.class), pData) && !pData.hasBypass(CheckType.NET_TOGGLEFREQUENCY, player)) {
            cancel = true;
        }
        if (cancel) {
            data.requestSetBack(player, this, this.plugin, this.checkType);
        }
    }
}

