/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.PacketFrequency;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.checks.net.protocollib.ProtocolLibComponent;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import java.util.LinkedHashSet;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CatchAllAdapter
extends BaseAdapter {
    private final PacketFrequency packetFrequency = new PacketFrequency();

    private static Iterable<? extends PacketType> getPacketTypes() {
        LinkedHashSet<PacketType> types = new LinkedHashSet<PacketType>();
        for (PacketType type : PacketType.Play.Client.getInstance().values()) {
            if (!type.isSupported()) continue;
            types.add(type);
        }
        return types;
    }

    public CatchAllAdapter(Plugin plugin) {
        super(plugin, ListenerPriority.LOWEST, CatchAllAdapter.getPacketTypes());
        NCPAPIProvider.getNoCheatPlusAPI().addComponent(this.packetFrequency);
    }

    public void onPacketReceiving(PacketEvent event) {
        try {
            if (event.isPlayerTemporary()) {
                return;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        Player player = event.getPlayer();
        if (player == null) {
            this.counters.add(ProtocolLibComponent.idNullPlayer, 1);
            return;
        }
        IPlayerData pData = DataManager.getPlayerDataSafe(player);
        if (pData == null) {
            StaticLog.logWarning("Failed to fetch player data with " + event.getPacketType() + " for: " + player.toString());
            return;
        }
        if (this.packetFrequency.isEnabled(player, pData)) {
            NetConfig cc = pData.getGenericInstance(NetConfig.class);
            NetData data = pData.getGenericInstance(NetData.class);
            if (this.packetFrequency.check(player, data, cc)) {
                event.setCancelled(true);
            }
        }
    }
}

