/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.checks.net.model.TeleportQueue;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.components.debug.IDebugPlayer;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NetData
extends ACheckData {
    private final Lock lock = new ReentrantLock();
    public ActionFrequency attackFrequencySeconds = new ActionFrequency(16, 500L);
    public final ActionFrequency flyingFrequencyAll;
    public boolean flyingFrequencyOnGround = false;
    public long flyingFrequencyTimeOnGround = 0L;
    public long flyingFrequencyTimeNotOnGround = 0L;
    public double movingVL = 0.0;
    public ActionFrequency keepAliveFreq = new ActionFrequency(20, 1000L);
    public double wrongTurnVL = 0.0;
    public double toggleFrequencyVL = 0.0;
    public ActionFrequency playerActionFreq;
    public long lastKeepAliveTime = 0L;
    public final TeleportQueue teleportQueue = new TeleportQueue();
    private final LinkedList<DataPacketFlying> flyingQueue = new LinkedList();
    private final int flyingQueueMaxSize = 20;
    private long maxSequence = 0L;
    public final ActionFrequency packetFrequency;

    public NetData(NetConfig config) {
        this.flyingFrequencyAll = new ActionFrequency(config.flyingFrequencySeconds, 1000L);
        this.packetFrequency = config.packetFrequencySeconds <= 2 ? new ActionFrequency(config.packetFrequencySeconds * 3, 333L) : new ActionFrequency(config.packetFrequencySeconds * 2, 500L);
        this.playerActionFreq = new ActionFrequency(Math.max(1, config.toggleActionSeconds), 1000L);
    }

    public void onJoin(Player player) {
        this.teleportQueue.clear();
        this.clearFlyingQueue();
    }

    public void onLeave(Player player) {
        this.teleportQueue.clear();
        this.clearFlyingQueue();
    }

    public void requestSetBack(Player player, IDebugPlayer idp, Plugin plugin, CheckType checkType) {
        IPlayerData pData = DataManager.getPlayerData(player);
        Location knownLocation = player.getLocation();
        MovingData mData = pData.getGenericInstance(MovingData.class);
        Object task = null;
        task = SchedulerHelper.runSyncTaskForEntity((Entity)player, plugin, arg -> {
            Location newTo;
            Location location = mData.hasSetBack() ? mData.getSetBack(knownLocation) : (newTo = mData.hasMorePacketsSetBack() ? mData.getMorePacketsSetBack() : knownLocation);
            if (newTo == null) {
                StaticLog.logSevere("Could not retrieve a safe (set back) location for " + player.getName() + " on packet-level, kicking them due to crash potential.");
                CheckUtils.kickIllegalMove(player, pData.getGenericInstance(MovingConfig.class));
            } else {
                mData.prepareSetBack(newTo);
                SchedulerHelper.teleportEntity((Entity)player, LocUtil.clone(newTo), BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
                if (pData.isDebugActive(checkType)) {
                    idp.debug(player, "Packet set back tasked for player: " + player.getName() + " at :" + LocUtil.simpleFormat(newTo));
                }
            }
        }, null);
        if (!SchedulerHelper.isTaskScheduled(task)) {
            StaticLog.logWarning("Failed to schedule packet set back task for player: " + player.getName());
        }
        mData.resetTeleported();
    }

    public boolean addFlyingQueue(DataPacketFlying packetData) {
        boolean res = false;
        this.lock.lock();
        packetData.setSequence(++this.maxSequence);
        this.flyingQueue.addFirst(packetData);
        if (this.flyingQueue.size() > 20) {
            this.flyingQueue.removeLast();
            res = true;
        }
        this.lock.unlock();
        return res;
    }

    public void clearFlyingQueue() {
        this.lock.lock();
        this.flyingQueue.clear();
        this.lock.unlock();
    }

    public DataPacketFlying[] copyFlyingQueue() {
        this.lock.lock();
        DataPacketFlying[] out = this.flyingQueue.toArray(new DataPacketFlying[this.flyingQueue.size()]);
        this.lock.unlock();
        return out;
    }

    public DataPacketFlying getCurrentFlyingPacket() {
        this.lock.lock();
        DataPacketFlying latest = this.flyingQueue.isEmpty() ? null : this.flyingQueue.getFirst();
        this.lock.unlock();
        return latest;
    }

    public DataPacketFlying getPastFlyingPacketInQueue(int index) {
        this.lock.lock();
        DataPacketFlying packet = this.flyingQueue.isEmpty() ? null : this.flyingQueue.get(index);
        this.lock.unlock();
        return packet;
    }

    public void handleSystemTimeRanBackwards() {
        long now = System.currentTimeMillis();
        this.teleportQueue.clear();
        this.lastKeepAliveTime = Math.min(this.lastKeepAliveTime, now);
        this.flyingFrequencyTimeNotOnGround = Math.min(this.flyingFrequencyTimeNotOnGround, now);
        this.flyingFrequencyTimeOnGround = Math.min(this.flyingFrequencyTimeOnGround, now);
    }
}

