/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.worlds.IWorldData;

public class NetConfig
extends ACheckConfig {
    private static RegisteredPermission[] preferKeepUpdatedPermissions = new RegisteredPermission[]{Permissions.NET_ATTACKFREQUENCY, Permissions.NET_FLYINGFREQUENCY, Permissions.NET_KEEPALIVEFREQUENCY, Permissions.NET_MOVING, Permissions.NET_PACKETFREQUENCY, Permissions.NET_TOGGLEFREQUENCY, Permissions.NET_WRONGTURN};
    public final float attackFrequencyLimitSecondsHalf;
    public final float attackFrequencyLimitSecondsOne;
    public final float attackFrequencyLimitSecondsTwo;
    public final float attackFrequencyLimitSecondsFour;
    public final float attackFrequencyLimitSecondsEight;
    public final float attackFrequencyImprobableWeight;
    public final ActionList attackFrequencyActions;
    public final int flyingFrequencySeconds;
    public final double flyingFrequencyPPS;
    public final ActionList flyingFrequencyActions;
    public final ActionList keepAliveFrequencyActions;
    public final int keepAliveFrequencyStartupDelay;
    public final ActionList movingActions;
    public final float packetFrequencyPacketsPerSecond;
    public final int packetFrequencySeconds;
    public final ActionList packetFrequencyActions;
    public final ActionList wrongTurnActions;
    public final double soundDistanceSq;
    public final boolean supersededFlyingCancelWaiting;
    public final int toggleActionLimit;
    public final int toggleActionSeconds;
    public final ActionList toggleFrequencyActions;

    public static RegisteredPermission[] getPreferKeepUpdatedPermissions() {
        return preferKeepUpdatedPermissions;
    }

    public NetConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        ConfigFile globalConfig = ConfigManager.getConfigFile();
        this.attackFrequencyLimitSecondsHalf = config.getInt("checks.net.attackfrequency.limitforseconds.half");
        this.attackFrequencyLimitSecondsOne = config.getInt("checks.net.attackfrequency.limitforseconds.one");
        this.attackFrequencyLimitSecondsTwo = config.getInt("checks.net.attackfrequency.limitforseconds.two");
        this.attackFrequencyLimitSecondsFour = config.getInt("checks.net.attackfrequency.limitforseconds.four");
        this.attackFrequencyLimitSecondsEight = config.getInt("checks.net.attackfrequency.limitforseconds.eight");
        this.attackFrequencyImprobableWeight = (float)config.getDouble("checks.net.attackfrequency.improbable.weight");
        this.attackFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.attackfrequency.actions", Permissions.NET_ATTACKFREQUENCY);
        this.flyingFrequencySeconds = Math.max(1, globalConfig.getInt("checks.net.flyingfrequency.seconds"));
        this.flyingFrequencyPPS = Math.max(1.0, globalConfig.getDouble("checks.net.flyingfrequency.packets-per-second"));
        this.flyingFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.flyingfrequency.actions", Permissions.NET_FLYINGFREQUENCY);
        this.keepAliveFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.keepalivefrequency.actions", Permissions.NET_KEEPALIVEFREQUENCY);
        this.keepAliveFrequencyStartupDelay = config.getInt("checks.net.keepalivefrequency.seconds") * 1000;
        if (ServerVersion.compareMinecraftVersion("1.9") >= 0) {
            NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().overrideCheckActivation(CheckType.NET_PACKETFREQUENCY, AlmostBoolean.NO, OverrideType.PERMANENT, true);
        }
        this.movingActions = (ActionList)config.getOptimizedActionList("checks.net.moving.actions", Permissions.NET_MOVING);
        this.packetFrequencyPacketsPerSecond = config.getInt("checks.net.packetfrequency.limit-per-second");
        this.packetFrequencySeconds = config.getInt("checks.net.packetfrequency.seconds");
        this.packetFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.packetfrequency.actions", Permissions.NET_PACKETFREQUENCY);
        this.wrongTurnActions = (ActionList)config.getOptimizedActionList("checks.net.wrongturn.actions", Permissions.NET_WRONGTURN);
        this.toggleActionLimit = config.getInt("checks.net.togglefrequency.limit");
        this.toggleActionSeconds = config.getInt("checks.net.togglefrequency.seconds");
        this.toggleFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.togglefrequency.actions", Permissions.NET_TOGGLEFREQUENCY);
        double dist = config.getDouble("checks.net.sounddistance.max-distance");
        this.soundDistanceSq = dist * dist;
        this.supersededFlyingCancelWaiting = config.getBoolean("checks.net.superseded.flying.cancel-waiting");
    }
}

