/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Moving
extends Check {
    final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    final List<String> tags = new ArrayList<String>();

    public Moving() {
        super(CheckType.NET_MOVING);
    }

    public boolean check(Player player, DataPacketFlying packetData, NetData data, NetConfig cc, IPlayerData pData, Plugin plugin) {
        boolean cancel = false;
        long now = System.currentTimeMillis();
        boolean debug = pData.isDebugActive(CheckType.NET_MOVING);
        this.tags.clear();
        if (now > pData.getLastJoinTime() && pData.getLastJoinTime() + 10000L > now) {
            this.tags.add("login_grace");
            return false;
        }
        if (packetData != null && packetData.hasPos) {
            MovingData mData = pData.getGenericInstance(MovingData.class);
            Location knownLocation = player.getLocation(this.useLoc);
            Location packetLocation = new Location(null, packetData.getX(), packetData.getY(), packetData.getZ());
            double yDistance = Math.abs(knownLocation.getY() - packetLocation.getY());
            double hDistance = TrigUtil.xzDistance(knownLocation, packetLocation);
            double distance = TrigUtil.distance(knownLocation, packetLocation);
            if (yDistance > 100.0 || distance > 100.0) {
                data.movingVL += 1.0;
                this.tags.add("invalid_pos");
                ViolationData vd = new ViolationData(this, player, data.movingVL, 1.0, cc.movingActions);
                if (vd.needsParameters()) {
                    vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
                }
                cancel = this.executeActions(vd).willCancel();
            } else {
                data.movingVL *= 0.98;
            }
        }
        if (debug) {
            Location packetLocation = new Location(null, packetData.getX(), packetData.getY(), packetData.getZ());
            StringBuilder builder = new StringBuilder(500);
            if (packetData.hasPos) {
                builder.append(CheckUtils.getLogMessagePrefix(player, this.type));
                builder.append("\nPacket location: " + LocUtil.simpleFormat(packetLocation));
                builder.append("\nServer location: " + LocUtil.simpleFormat(player.getLocation(this.useLoc)));
                builder.append("\nDeltas: h= " + TrigUtil.distance(player.getLocation(this.useLoc), packetLocation) + ", y= " + Math.abs(player.getLocation(this.useLoc).getY() - packetLocation.getY()));
            } else {
                builder.append("Empty packet (no position)");
            }
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
        }
        this.useLoc.setWorld(null);
        return cancel;
    }
}

