/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;

public abstract class FlyingQueueLookBlockChecker {
    protected boolean invalidateFailed = true;
    protected boolean checkOldLook = true;

    protected abstract boolean check(double var1, double var3, double var5, float var7, float var8, int var9, int var10, int var11);

    public FlyingQueueLookBlockChecker setInvalidateFailed(boolean invalidatedFailed) {
        this.invalidateFailed = invalidatedFailed;
        return this;
    }

    public FlyingQueueLookBlockChecker setCheckOldLook(boolean checkOldLook) {
        this.checkOldLook = checkOldLook;
        return this;
    }

    public boolean checkFlyingQueue(double x, double y, double z, float oldYaw, float oldPitch, int blockX, int blockY, int blockZ, FlyingQueueHandle flyingHandle) {
        DataPacketFlying[] queue;
        if (this.checkOldLook && flyingHandle.isCurrentLocationValid()) {
            if (this.check(x, y, z, oldYaw, oldPitch, blockX, blockY, blockZ)) {
                return true;
            }
            flyingHandle.setCurrentLocationValid(false);
        }
        if ((queue = flyingHandle.getHandle()).length == 0) {
            return false;
        }
        for (int i = 0; i < queue.length; ++i) {
            DataPacketFlying packetData = queue[i];
            if (packetData == null) continue;
            if (!packetData.hasLook) {
                if (!this.invalidateFailed) continue;
                queue[i] = null;
                continue;
            }
            float yaw = packetData.getYaw();
            float pitch = packetData.getPitch();
            if (yaw == oldYaw && pitch == oldPitch) {
                if (!this.invalidateFailed) continue;
                queue[i] = null;
                continue;
            }
            if (this.check(x, y, z, yaw, pitch, blockX, blockY, blockZ)) {
                return true;
            }
            if (!this.invalidateFailed) continue;
            queue[i] = null;
        }
        return false;
    }
}

