/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.players.IPlayerData;

public class FlyingQueueHandle
implements IHandle<DataPacketFlying[]> {
    private final IPlayerData pData;
    private DataPacketFlying[] queue;
    private boolean currentLocationValid = true;

    public FlyingQueueHandle(IPlayerData pData) {
        this.pData = pData;
    }

    @Override
    public DataPacketFlying[] getHandle() {
        if (this.queue == null) {
            this.queue = this.pData.getGenericInstance(NetData.class).copyFlyingQueue();
        }
        return this.queue;
    }

    public boolean isFlyingQueueFetched() {
        return this.queue != null;
    }

    public int getFirstIndexWithContentIfFetched() {
        if (this.queue == null) {
            return -1;
        }
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] == null) continue;
            return i;
        }
        return -1;
    }

    public DataPacketFlying getIfFetched(int index) {
        return this.queue == null ? null : this.queue[index];
    }

    public int sizeIfFetched() {
        return this.queue == null ? -1 : this.queue.length;
    }

    public boolean isCurrentLocationValid() {
        return this.currentLocationValid;
    }

    public void setCurrentLocationValid(boolean currentLocationValid) {
        this.currentLocationValid = currentLocationValid;
    }
}

