/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.entity.Player;

public class AttackFrequency
extends Check {
    public AttackFrequency() {
        super(CheckType.NET_ATTACKFREQUENCY);
    }

    public boolean check(Player player, long time, NetData data, NetConfig cc, IPlayerData pData) {
        data.attackFrequencySeconds.add(time, 1.0f);
        double maxVL = 0.0;
        float maxLimit = 0.0f;
        String tags = null;
        float sum = data.attackFrequencySeconds.bucketScore(0);
        float limit = cc.attackFrequencyLimitSecondsHalf;
        if ((double)(sum - limit) > maxVL) {
            maxVL = sum - limit;
            maxLimit = limit;
            tags = "sec_half";
        }
        if ((double)((sum += data.attackFrequencySeconds.bucketScore(1)) - (limit = cc.attackFrequencyLimitSecondsOne)) > maxVL) {
            maxVL = sum - limit;
            maxLimit = limit;
            tags = "sec_one";
        }
        if ((double)((sum += data.attackFrequencySeconds.sliceScore(2, 4, 1.0f)) - (limit = cc.attackFrequencyLimitSecondsTwo)) > maxVL) {
            maxVL = sum - limit;
            maxLimit = limit;
            tags = "sec_two";
        }
        if ((double)((sum += data.attackFrequencySeconds.sliceScore(4, 8, 1.0f)) - (limit = cc.attackFrequencyLimitSecondsFour)) > maxVL) {
            maxVL = sum - limit;
            maxLimit = limit;
            tags = "sec_four";
        }
        if ((double)((sum += data.attackFrequencySeconds.sliceScore(8, 16, 1.0f)) - (limit = cc.attackFrequencyLimitSecondsEight)) > maxVL) {
            maxVL = sum - limit;
            maxLimit = limit;
            tags = "sec_eight";
        }
        if (pData.isDebugActive(CheckType.NET_ATTACKFREQUENCY)) {
            player.sendMessage("AttackFrequency: " + data.attackFrequencySeconds.toLine());
        }
        boolean cancel = false;
        if (maxVL > 0.0) {
            ViolationData vd = new ViolationData(this, player, maxVL, 1.0, cc.attackFrequencyActions);
            if (pData.isDebugActive(this.type) || vd.needsParameters()) {
                vd.setParameter(ParameterName.PACKETS, Integer.toString((int)sum));
                vd.setParameter(ParameterName.LIMIT, Integer.toString((int)maxLimit));
                vd.setParameter(ParameterName.TAGS, tags);
            }
            cancel = this.executeActions(vd).willCancel();
            if (cc.attackFrequencyImprobableWeight > 0.0f) {
                TickTask.requestImprobableUpdate(player.getUniqueId(), cc.attackFrequencyImprobableWeight);
            }
        }
        return cancel;
    }
}

