/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.velocity;

import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.UnusedTracker;
import fr.neatmonster.nocheatplus.checks.moving.velocity.VelocityFlags;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SimpleAxisVelocity {
    private static final long FILTER_SPLIT;
    private static final long FILTER_POST_USE;
    private static final double marginAcceptZero = 0.005;
    private static final double thresholdCleanup = 40.0;
    private final LinkedList<SimpleEntry> queued = new LinkedList();
    private boolean unusedActive = true;
    private double unusedSensitivity = 0.1;
    public final UnusedTracker unusedTrackerPos = new UnusedTracker();
    public final UnusedTracker unusedTrackerNeg = new UnusedTracker();

    public void addToFront(SimpleEntry entry) {
        this.queued.addFirst(entry);
    }

    public void add(SimpleEntry entry) {
        this.queued.add(entry);
        if ((double)this.queued.size() > 40.0) {
            this.removeInvalid(TickTask.getTick());
        }
    }

    public boolean hasQueued() {
        return !this.queued.isEmpty();
    }

    public List<SimpleEntry> use(double amount, double tolerance) {
        Iterator it = this.queued.iterator();
        SimpleEntry entry = null;
        LinkedList<SimpleEntry> result = new LinkedList<SimpleEntry>();
        double totalAmount = 0.0;
        int lastTick = 0;
        boolean hasVel = false;
        while (it.hasNext()) {
            entry = (SimpleEntry)it.next();
            it.remove();
            if ((entry.flags & VelocityFlags.ADDITIVE) != 0L && lastTick == entry.tick) {
                totalAmount += entry.value;
                result.add(entry);
                hasVel = true;
            } else {
                if (hasVel && Math.abs(totalAmount - amount) < tolerance) break;
                if (this.unusedActive) {
                    for (SimpleEntry unused : result) {
                        this.addUnused(unused);
                    }
                }
                result.clear();
                totalAmount = entry.value;
                lastTick = entry.tick;
                result.add(entry);
                hasVel = true;
            }
            if (hasVel || !(Math.abs(totalAmount - amount) >= tolerance)) continue;
            result.clear();
        }
        return result;
    }

    public List<SimpleEntry> use(int tick) {
        Iterator it = this.queued.iterator();
        SimpleEntry entry = null;
        LinkedList<SimpleEntry> result = new LinkedList<SimpleEntry>();
        int lastTick = 0;
        boolean hasVel = false;
        while (it.hasNext()) {
            entry = (SimpleEntry)it.next();
            it.remove();
            if ((entry.flags & VelocityFlags.ADDITIVE) != 0L && lastTick == entry.tick) {
                result.add(entry);
                hasVel = true;
                continue;
            }
            if (hasVel && tick == ((SimpleEntry)result.get((int)0)).tick) break;
            if (this.unusedActive) {
                for (SimpleEntry unused : result) {
                    this.addUnused(unused);
                }
            }
            result.clear();
            lastTick = entry.tick;
            result.add(entry);
            hasVel = true;
        }
        return result;
    }

    private SimpleEntry processFlagsPostUse(SimpleEntry entry, double amount) {
        if (this.allowsSplit(entry, amount)) {
            this.addToFront(new SimpleEntry(entry.tick, entry.value - amount, entry.flags, (entry.flags & VelocityFlags.SPLIT_RETAIN_ACTCOUNT) == 0L ? entry.actCount : Math.max(entry.actCount, 2)));
        }
        return entry;
    }

    private final boolean allowsSplit(SimpleEntry entry, double amount) {
        if ((entry.flags & FILTER_SPLIT) == 0L) {
            return false;
        }
        double remain = entry.value - amount;
        return (entry.flags & VelocityFlags.SPLIT_ABOVE_THIRD) != 0L && remain > entry.value / 3.0 || (entry.flags & VelocityFlags.SPLIT_ABOVE_0_42) != 0L && remain > 0.42;
    }

    public List<SimpleEntry> peek(double amount, int minActCount, int maxActCount, double tolerance) {
        LinkedList<SimpleEntry> result = new LinkedList<SimpleEntry>();
        double totalAmount = 0.0;
        int lastTick = 0;
        boolean hasVel = false;
        for (SimpleEntry entry : this.queued) {
            if (entry.actCount < minActCount || entry.actCount > maxActCount) continue;
            if ((entry.flags & VelocityFlags.ADDITIVE) != 0L && lastTick == entry.tick) {
                totalAmount += entry.value;
                result.add(entry);
                hasVel = true;
                continue;
            }
            if (hasVel && Math.abs(totalAmount - amount) < tolerance) {
                return result;
            }
            result.clear();
            totalAmount = entry.value;
            lastTick = entry.tick;
            result.add(entry);
            hasVel = true;
        }
        if (Math.abs(totalAmount - amount) >= tolerance) {
            result.clear();
        }
        return result;
    }

    public List<SimpleEntry> peek(int tick, int minActCount, int maxActCount, double tolerance) {
        LinkedList<SimpleEntry> result = new LinkedList<SimpleEntry>();
        int lastTick = 0;
        boolean hasVel = false;
        for (SimpleEntry entry : this.queued) {
            if (entry.actCount < minActCount || entry.actCount > maxActCount) continue;
            if ((entry.flags & VelocityFlags.ADDITIVE) != 0L && lastTick == entry.tick) {
                result.add(entry);
                hasVel = true;
                continue;
            }
            if (hasVel && tick == ((SimpleEntry)result.get((int)0)).tick) {
                return result;
            }
            result.clear();
            lastTick = entry.tick;
            result.add(entry);
            hasVel = true;
        }
        return result;
    }

    public boolean matchesEntry(SimpleEntry entry, double amount, double tolerance) {
        return Math.abs(amount) <= Math.abs(entry.value) + tolerance && (amount > 0.0 && entry.value > 0.0 && amount <= entry.value + tolerance || amount < 0.0 && entry.value < 0.0 && entry.value - tolerance <= amount || amount == 0.0 && Math.abs(entry.value) <= 0.005);
    }

    public void removeInvalid(int invalidateBeforeTick) {
        Iterator it = this.queued.iterator();
        while (it.hasNext()) {
            SimpleEntry entry = (SimpleEntry)it.next();
            --entry.actCount;
            if (entry.actCount > 0 && entry.tick >= invalidateBeforeTick) continue;
            it.remove();
            if (!this.unusedActive) continue;
            this.addUnused(entry);
        }
    }

    public void clear() {
        if (this.unusedActive && !this.queued.isEmpty()) {
            this.removeInvalid(TickTask.getTick());
        }
        this.queued.clear();
    }

    public void addQueued(StringBuilder builder) {
        for (SimpleEntry vel : this.queued) {
            builder.append(" ");
            builder.append(vel);
        }
    }

    public void updateBlockedState(int tick, boolean posBlocked, boolean negBlocked) {
        this.unusedTrackerPos.updateState(tick, posBlocked);
        this.unusedTrackerNeg.updateState(tick, negBlocked);
    }

    private void addUnused(SimpleEntry entry) {
        if (Math.abs(entry.value) < this.unusedSensitivity || entry.initialActCount < 5) {
            return;
        }
        if (entry.value < 0.0) {
            this.unusedTrackerNeg.addValue(entry.tick, -entry.value);
        } else {
            this.unusedTrackerPos.addValue(entry.tick, entry.value);
        }
    }

    public boolean isUnusedActive() {
        return this.unusedActive;
    }

    public void setUnusedActive(boolean unusedActive) {
        this.unusedActive = unusedActive;
    }

    public void removeLeadingQueuedVerticalVelocityByFlag(long flag) {
        SimpleEntry entry;
        if (this.queued.isEmpty()) {
            return;
        }
        Iterator it = this.queued.iterator();
        while (it.hasNext() && (entry = (SimpleEntry)it.next()).hasFlag(flag)) {
            it.remove();
        }
    }

    static {
        FILTER_POST_USE = FILTER_SPLIT = VelocityFlags.SPLIT_ABOVE_THIRD | VelocityFlags.SPLIT_ABOVE_0_42;
    }
}

