/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.velocity;

import fr.neatmonster.nocheatplus.checks.moving.velocity.PairEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.VelocityFlags;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PairAxisVelocity {
    private static final double thresholdCleanup = 40.0;
    private final LinkedList<PairEntry> queued = new LinkedList();
    private boolean unusedActive = true;
    private double unusedSensitivity = 0.1;

    public void addToFront(PairEntry entry) {
        this.queued.addFirst(entry);
    }

    public void add(PairEntry entry) {
        this.queued.add(entry);
        if ((double)this.queued.size() > 40.0) {
            this.removeInvalid(TickTask.getTick());
        }
    }

    public boolean hasQueued() {
        return !this.queued.isEmpty();
    }

    public List<PairEntry> use(double x, double z, double tolerance) {
        Iterator it = this.queued.iterator();
        PairEntry entry = null;
        LinkedList<PairEntry> result = new LinkedList<PairEntry>();
        double totalAmountX = 0.0;
        double totalAmountZ = 0.0;
        int lastTick = 0;
        boolean hasVel = false;
        while (it.hasNext()) {
            entry = (PairEntry)it.next();
            it.remove();
            if ((entry.flags & VelocityFlags.ADDITIVE) != 0L && lastTick == entry.tick) {
                totalAmountX += entry.x;
                totalAmountZ += entry.z;
                result.add(entry);
                hasVel = true;
            } else {
                if (hasVel && Math.abs(totalAmountX - x) < tolerance && Math.abs(totalAmountZ - z) < tolerance) break;
                if (this.unusedActive) {
                    // empty if block
                }
                result.clear();
                totalAmountX = entry.x;
                totalAmountZ = entry.z;
                lastTick = entry.tick;
                result.add(entry);
                hasVel = true;
            }
            if (hasVel || !(Math.abs(totalAmountX - x) >= tolerance) || !(Math.abs(totalAmountZ - z) >= tolerance)) continue;
            result.clear();
        }
        return result;
    }

    public List<PairEntry> use(int tick) {
        Iterator it = this.queued.iterator();
        PairEntry entry = null;
        LinkedList<PairEntry> result = new LinkedList<PairEntry>();
        int lastTick = 0;
        boolean hasVel = false;
        while (it.hasNext()) {
            entry = (PairEntry)it.next();
            it.remove();
            if ((entry.flags & VelocityFlags.ADDITIVE) != 0L && lastTick == entry.tick) {
                result.add(entry);
                hasVel = true;
                continue;
            }
            if (hasVel && tick == ((PairEntry)result.get((int)0)).tick) break;
            if (this.unusedActive) {
                // empty if block
            }
            result.clear();
            lastTick = entry.tick;
            result.add(entry);
            hasVel = true;
        }
        return result;
    }

    public List<PairEntry> peek(double x, double z, int minActCount, int maxActCount, double tolerance) {
        LinkedList<PairEntry> result = new LinkedList<PairEntry>();
        double totalAmountX = 0.0;
        double totalAmountZ = 0.0;
        int lastTick = 0;
        boolean hasVel = false;
        for (PairEntry entry : this.queued) {
            if (entry.actCount < minActCount || entry.actCount > maxActCount) continue;
            if ((entry.flags & VelocityFlags.ADDITIVE) != 0L && lastTick == entry.tick) {
                totalAmountX += entry.x;
                totalAmountZ += entry.z;
                result.add(entry);
                hasVel = true;
                continue;
            }
            if (hasVel && Math.abs(totalAmountX - x) < tolerance && Math.abs(totalAmountZ - z) < tolerance) {
                return result;
            }
            result.clear();
            totalAmountX = entry.x;
            totalAmountZ = entry.z;
            lastTick = entry.tick;
            result.add(entry);
            hasVel = true;
        }
        if (Math.abs(totalAmountX - x) >= tolerance || Math.abs(totalAmountZ - z) >= tolerance) {
            result.clear();
        }
        return result;
    }

    public List<PairEntry> peek(int tick, int minActCount, int maxActCount, double tolerance) {
        LinkedList<PairEntry> result = new LinkedList<PairEntry>();
        int lastTick = 0;
        boolean hasVel = false;
        for (PairEntry entry : this.queued) {
            if (entry.actCount < minActCount || entry.actCount > maxActCount) continue;
            if ((entry.flags & VelocityFlags.ADDITIVE) != 0L && lastTick == entry.tick) {
                result.add(entry);
                hasVel = true;
                continue;
            }
            if (hasVel && tick == ((PairEntry)result.get((int)0)).tick) {
                return result;
            }
            result.clear();
            lastTick = entry.tick;
            result.add(entry);
            hasVel = true;
        }
        return result;
    }

    public boolean matchesEntry(PairEntry entry, double x, double z, double tolerance) {
        return Math.abs(z) <= Math.abs(entry.z) + tolerance && Math.abs(x) <= Math.abs(entry.x) + tolerance;
    }

    public void removeInvalid(int invalidateBeforeTick) {
        Iterator it = this.queued.iterator();
        while (it.hasNext()) {
            PairEntry entry = (PairEntry)it.next();
            --entry.actCount;
            if (entry.actCount > 0 && entry.tick >= invalidateBeforeTick) continue;
            it.remove();
        }
    }

    public void clear() {
        if (this.unusedActive && !this.queued.isEmpty()) {
            this.removeInvalid(TickTask.getTick());
        }
        this.queued.clear();
    }

    public void addQueued(StringBuilder builder) {
        for (PairEntry vel : this.queued) {
            builder.append(" ");
            builder.append(vel);
        }
    }

    public boolean isUnusedActive() {
        return this.unusedActive;
    }

    public void setUnusedActive(boolean unusedActive) {
        this.unusedActive = unusedActive;
    }

    public void removeLeadingQueuedVerticalVelocityByFlag(long flag) {
        PairEntry entry;
        if (this.queued.isEmpty()) {
            return;
        }
        Iterator it = this.queued.iterator();
        while (it.hasNext() && (entry = (PairEntry)it.next()).hasFlag(flag)) {
            it.remove();
        }
    }
}

