/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.vehicle;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.envelope.workaround.LostGroundVehicle;
import fr.neatmonster.nocheatplus.checks.moving.envelope.workaround.VehicleWorkarounds;
import fr.neatmonster.nocheatplus.checks.moving.location.setback.SetBackEntry;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveInfo;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.entity.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.location.RichEntityLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class VehicleEnvelope
extends Check {
    private final List<String> tags = new LinkedList<String>();
    private final List<String> debugDetails = new LinkedList<String>();
    private final CheckDetails checkDetails = new CheckDetails();
    private final Class<?> bestHorse;
    private final Class<?> strider;
    private final Class<?> camel;

    public VehicleEnvelope() {
        super(CheckType.MOVING_VEHICLE_ENVELOPE);
        Class<?> clazz = ReflectionUtil.getClass("org.bukkit.entity.AbstractHorse");
        this.bestHorse = clazz == null ? ReflectionUtil.getClass("org.bukkit.entity.Horse") : clazz;
        this.strider = ReflectionUtil.getClass("org.bukkit.entity.Strider");
        this.camel = ReflectionUtil.getClass("org.bukkit.entity.Camel");
    }

    public SetBackEntry check(Player player, Entity vehicle, VehicleMoveData thisMove, boolean isFake, MovingData data, MovingConfig cc, IPlayerData pData, VehicleMoveInfo moveInfo) {
        boolean debug = pData.isDebugActive(this.type);
        this.tags.clear();
        this.tags.add("entity." + vehicle.getType());
        if (debug) {
            this.debugDetails.clear();
            data.ws.setJustUsedIds(this.debugDetails);
        }
        LostGroundVehicle.lostGround(vehicle, moveInfo.from, moveInfo.to, thisMove.hDistance, thisMove.yDistance, false, data.vehicleMoves.getFirstPastMove(), data, cc, null, this.tags);
        boolean violation = this.checkEntity(player, vehicle, thisMove, isFake, data, cc, debug, moveInfo);
        if (debug && !this.debugDetails.isEmpty()) {
            this.debugDetails(player);
            this.debugDetails.clear();
        }
        if (violation) {
            data.vehicleEnvelopeVL += 1.0;
            ViolationData vd = new ViolationData(this, player, data.vehicleEnvelopeVL, 1.0, cc.vehicleEnvelopeActions);
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            if (this.executeActions(vd).willCancel()) {
                return data.vehicleSetBacks.getValidSafeMediumEntry();
            }
        } else {
            data.vehicleEnvelopeVL *= 0.99;
        }
        return null;
    }

    private void debugDetails(Player player) {
        if (!this.tags.isEmpty()) {
            this.debugDetails.add("tags:");
            this.debugDetails.add(StringUtil.join(this.tags, "+"));
        }
        StringBuilder builder = new StringBuilder(500);
        builder.append("Details:\n");
        for (String detail : this.debugDetails) {
            builder.append(" , ");
            builder.append(detail);
        }
        this.debug(player, builder.toString());
        this.debugDetails.clear();
    }

    private double getHDistCap(EntityType type, MovingConfig cc, VehicleMoveData thisMove, MovingData data) {
        Double cap = cc.vehicleEnvelopeHorizontalSpeedCap.get(type);
        Double globalcap = cc.vehicleEnvelopeHorizontalSpeedCap.get(null);
        if (cap == null) {
            if (MaterialUtil.isBoat(type)) {
                return this.getHDistCapBoats(thisMove, data, 1.0, globalcap);
            }
            return globalcap;
        }
        if (MaterialUtil.isBoat(type)) {
            return this.getHDistCapBoats(thisMove, data, cap, globalcap);
        }
        return cap;
    }

    private double getHDistCapBoats(VehicleMoveData thisMove, MovingData data, double multiplier, double globalcap) {
        VehicleMoveData lastMove = data.vehicleMoves.getFirstPastMove();
        if (lastMove.from.onBlueIce && !thisMove.from.onBlueIce) {
            data.boatIceVelocityTicks = 20;
        } else if (lastMove.from.onIce && !thisMove.from.onIce) {
            data.boatIceVelocityTicks = 10;
        }
        if (thisMove.from.onBlueIce || thisMove.to.onBlueIce) {
            return multiplier * 4.1;
        }
        if (thisMove.from.onIce || thisMove.to.onIce) {
            return multiplier * 2.3;
        }
        if (data.boatIceVelocityTicks-- > 0) {
            if (data.boatIceVelocityTicks > 10) {
                return multiplier * 4.1;
            }
            return multiplier * 2.3;
        }
        if (thisMove.from.onGround && !thisMove.from.inWater || thisMove.to.onGround && !thisMove.to.inWater) {
            return multiplier * 0.4;
        }
        if (thisMove.from.inWater || thisMove.to.inWater) {
            return multiplier * 0.5;
        }
        return multiplier == 1.0 ? globalcap : multiplier;
    }

    private boolean checkEntity(Player player, Entity vehicle, VehicleMoveData thisMove, boolean isFake, MovingData data, MovingConfig cc, boolean debug, VehicleMoveInfo moveInfo) {
        Double levitation;
        boolean violation = false;
        long now = System.currentTimeMillis();
        if (debug) {
            this.debugDetails.add("inair: " + data.sfJumpPhase);
        }
        if ((moveInfo.from.getBlockFlags() & BlockFlags.F_BUBBLE_COLUMN) != 0L) {
            data.timeVehicletoss = System.currentTimeMillis();
        }
        if (vehicle instanceof LivingEntity) {
            Double speed = PotionUtil.getPotionEffectAmplifier((LivingEntity)vehicle, PotionEffectType.SPEED);
            if (this.camel != null && this.camel.isAssignableFrom(vehicle.getClass())) {
                VehicleMoveData firstPastMove = data.vehicleMoves.getFirstPastMove();
                double cap = this.getHDistCap(this.checkDetails.simplifiedType, cc, thisMove, data);
                if (!Double.isInfinite(speed)) {
                    cap *= 1.0 + 0.2 * (speed + 1.0);
                }
                if (thisMove.hDistance > cap) {
                    long current = System.currentTimeMillis();
                    if (data.timeCamelDash + 2000L < current) {
                        data.timeCamelDash = current;
                        return this.maxDistHorizontal(thisMove, cap * 2.7);
                    }
                    return this.maxDistHorizontal(thisMove, firstPastMove.toIsValid ? firstPastMove.hDistance * 0.98 : cap);
                }
            }
            if (!Double.isInfinite(speed) ? this.maxDistHorizontal(thisMove, this.getHDistCap(this.checkDetails.simplifiedType, cc, thisMove, data) * (1.0 + 0.2 * (speed + 1.0))) : this.maxDistHorizontal(thisMove, this.getHDistCap(this.checkDetails.simplifiedType, cc, thisMove, data) + (this.checkDetails.canJump ? 0.18 : 0.0))) {
                return true;
            }
        } else if (this.maxDistHorizontal(thisMove, this.getHDistCap(this.checkDetails.simplifiedType, cc, thisMove, data))) {
            return true;
        }
        if (thisMove.from.inWeb) {
            if (debug) {
                this.debugDetails.add("");
            }
        } else if (this.checkDetails.canClimb && thisMove.from.onClimbable) {
            this.checkDetails.checkDescendMuch = false;
            this.checkDetails.checkAscendMuch = false;
            if (Math.abs(thisMove.yDistance) > 0.1625) {
                violation = true;
                this.tags.add("climbspeed");
            }
        } else if (this.checkDetails.canRails && thisMove.fromOnRails) {
            if (Math.abs(thisMove.yDistance) < 0.5) {
                this.checkDetails.checkDescendMuch = false;
                this.checkDetails.checkAscendMuch = false;
            }
        } else if (thisMove.from.inWater && thisMove.to.inWater) {
            if (debug) {
                this.debugDetails.add("water-water");
            }
            if (VehicleWorkarounds.oddInWater(thisMove, this.checkDetails, data)) {
                this.checkDetails.checkAscendMuch = false;
                this.checkDetails.checkDescendMuch = false;
                violation = false;
            }
        } else if (thisMove.from.onGround && thisMove.to.onGround) {
            if (this.checkDetails.canStepUpBlock && thisMove.yDistance > 0.0 && thisMove.yDistance <= 1.0) {
                this.checkDetails.checkAscendMuch = false;
                this.tags.add("step_up");
            }
            if (thisMove.from.onBlueIce && thisMove.to.onBlueIce) {
                if (debug) {
                    this.debugDetails.add("blueIce-blueIce");
                }
            } else if (thisMove.from.onIce && thisMove.to.onIce) {
                if (debug) {
                    this.debugDetails.add("ice-ice");
                }
            } else if (debug) {
                this.debugDetails.add("ground-ground");
            }
        } else if (this.checkDetails.inAir) {
            if (this.checkInAir(thisMove, data, debug, vehicle, moveInfo)) {
                violation = true;
            }
        } else {
            if (debug) {
                this.debugDetails.add("?-?");
            }
            if (!this.checkDetails.toIsSafeMedium) {
                // empty if block
            }
        }
        if (vehicle instanceof LivingEntity && !Double.isInfinite(levitation = Double.valueOf(Bridge1_9.getLevitationAmplifier((LivingEntity)vehicle)))) {
            this.checkDetails.maxAscend += 0.046 * (levitation + 1.0);
            violation = false;
        }
        if (this.checkDetails.checkAscendMuch && thisMove.yDistance > this.checkDetails.maxAscend) {
            this.tags.add("ascend_much");
            violation = true;
        }
        if (data.timeVehicletoss + 2000L > now && thisMove.yDistance < 4.0) {
            violation = false;
        }
        if (this.checkDetails.checkDescendMuch && thisMove.yDistance < -5.0) {
            this.tags.add("descend_much");
            violation = true;
        }
        if (vehicle instanceof LivingEntity) {
            VehicleMoveData firstPastMove = data.vehicleMoves.getFirstPastMove();
            if (!(!(thisMove.hDistance > 0.1) || thisMove.yDistance != 0.0 || thisMove.to.onGround || thisMove.from.onGround || !firstPastMove.valid || firstPastMove.yDistance != 0.0 || !thisMove.to.inLiquid || !thisMove.from.inLiquid || thisMove.headObstructed || this.strider != null && this.strider.isAssignableFrom(vehicle.getClass()) && thisMove.to.inLava && thisMove.from.inLava)) {
                violation = true;
                this.tags.add("liquidwalk");
            }
            Material blockUnder = vehicle.getLocation().subtract(0.0, 0.3, 0.0).getBlock().getType();
            Material blockAbove = vehicle.getLocation().add(0.0, 0.1, 0.0).getBlock().getType();
            if (!(blockUnder == null || blockAbove == null || !BlockProperties.isAir(blockAbove) || !BlockProperties.isLiquid(blockUnder) || this.strider != null && this.strider.isAssignableFrom(vehicle.getClass()) || !(thisMove.hDistance > 0.11 && thisMove.yDistance <= 0.1 && !thisMove.to.onGround && !thisMove.from.onGround && firstPastMove.valid && firstPastMove.yDistance == thisMove.yDistance) && (firstPastMove.yDistance != thisMove.yDistance * -1.0 || firstPastMove.yDistance == 0.0 || thisMove.headObstructed) || thisMove.yDistance < 0.0 && thisMove.yDistance != 0.0 && firstPastMove.yDistance < 0.0 && firstPastMove.yDistance != 0.0)) {
                violation = true;
                this.tags.add("liquidmove");
            }
        }
        if (!violation) {
            if (this.checkDetails.inAir) {
                ++data.sfJumpPhase;
            } else {
                if (this.checkDetails.toIsSafeMedium) {
                    data.vehicleSetBacks.setSafeMediumEntry(thisMove.to);
                    data.sfJumpPhase = 0;
                } else if (this.checkDetails.fromIsSafeMedium) {
                    data.vehicleSetBacks.setSafeMediumEntry(thisMove.from);
                    data.sfJumpPhase = 0;
                }
                data.ws.resetConditions("reset.notinair");
            }
            data.vehicleSetBacks.setLastMoveEntry(thisMove.to);
        }
        return violation;
    }

    private boolean isBouncingBlock(RichEntityLocation from) {
        return (from.getBlockFlags() & BlockFlags.F_BOUNCE25) != 0L;
    }

    protected void prepareCheckDetails(Entity vehicle, VehicleMoveInfo moveInfo, VehicleMoveData thisMove) {
        this.checkDetails.reset();
        this.checkDetails.fromIsSafeMedium = thisMove.from.inWater || thisMove.from.onGround || thisMove.from.inWeb;
        this.checkDetails.toIsSafeMedium = thisMove.to.inWater || thisMove.to.onGround || thisMove.to.inWeb;
        boolean bl = this.checkDetails.inAir = !this.checkDetails.fromIsSafeMedium && !this.checkDetails.toIsSafeMedium;
        if (vehicle != null && MaterialUtil.isBoat(vehicle.getType())) {
            this.checkDetails.simplifiedType = vehicle.getType();
            this.checkDetails.maxAscend = 0.27;
        } else if (vehicle instanceof Minecart) {
            this.checkDetails.simplifiedType = EntityType.MINECART;
            this.checkDetails.canRails = true;
            thisMove.setExtraMinecartProperties(moveInfo);
            if (thisMove.fromOnRails) {
                this.checkDetails.fromIsSafeMedium = true;
                this.checkDetails.inAir = false;
            }
            if (thisMove.toOnRails) {
                this.checkDetails.toIsSafeMedium = true;
                this.checkDetails.inAir = false;
            }
            this.checkDetails.gravityTargetSpeed = 0.79;
        } else if (this.bestHorse != null && this.bestHorse.isAssignableFrom(vehicle.getClass())) {
            this.checkDetails.simplifiedType = EntityType.HORSE;
            this.checkDetails.canStepUpBlock = true;
            this.checkDetails.canJump = true;
        } else if (this.strider != null && this.strider.isAssignableFrom(vehicle.getClass())) {
            this.checkDetails.canJump = false;
            this.checkDetails.canStepUpBlock = true;
            this.checkDetails.canClimb = true;
            this.checkDetails.maxAscend = 1.1;
            if (thisMove.from.inLava || thisMove.to.inLava) {
                this.checkDetails.inAir = false;
            }
            if (!thisMove.from.onGround && thisMove.to.onGround) {
                this.checkDetails.gravityTargetSpeed = 0.07;
            }
        } else if (this.camel != null && this.camel.isAssignableFrom(vehicle.getClass())) {
            this.checkDetails.canStepUpBlock = true;
            this.checkDetails.canClimb = false;
            this.checkDetails.canJump = false;
        } else if (vehicle instanceof Pig) {
            this.checkDetails.simplifiedType = EntityType.PIG;
            this.checkDetails.canJump = false;
            this.checkDetails.canStepUpBlock = true;
            this.checkDetails.canClimb = true;
        } else {
            this.checkDetails.simplifiedType = thisMove.vehicleType;
        }
        if (this.checkDetails.canJump) {
            this.checkDetails.maxAscend = 1.2;
        }
        if (this.checkDetails.canClimb) {
            if (thisMove.from.onClimbable) {
                this.checkDetails.fromIsSafeMedium = true;
                this.checkDetails.inAir = false;
            }
            if (thisMove.to.onClimbable) {
                this.checkDetails.toIsSafeMedium = true;
                this.checkDetails.inAir = false;
            }
        }
    }

    private boolean checkInAir(VehicleMoveData thisMove, MovingData data, boolean debug, Entity vehicle, VehicleMoveInfo moveInfo) {
        RichEntityLocation from = moveInfo.from;
        RichEntityLocation to = moveInfo.to;
        if (debug) {
            this.debugDetails.add("air-air");
        }
        if (!this.checkDetails.canJump && thisMove.yDistance > 0.0) {
            this.tags.add("ascend_at_all");
            return true;
        }
        boolean violation = false;
        double minDescend = -(thisMove.yDistance < -0.5 ? 0.0052 : 0.0208) * (double)(this.checkDetails.canJump ? Math.max(data.sfJumpPhase - 8, 0) : data.sfJumpPhase);
        double maxDescend = this.getInAirMaxDescend(thisMove, data);
        if (data.sfJumpPhase > (this.checkDetails.canJump ? 8 : 1) && thisMove.yDistance > Math.max(minDescend, -this.checkDetails.gravityTargetSpeed)) {
            boolean noViolation;
            boolean bl = noViolation = this.collidesWithHoneyBlock(from) || vehicle instanceof LivingEntity && !Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)vehicle)) || !vehicle.hasGravity();
            if (this.collidesWithHoneyBlock(from)) {
                data.sfJumpPhase = 5;
            }
            if (!noViolation) {
                this.tags.add("slow_fall_vdist");
                violation = true;
            }
        } else if (data.sfJumpPhase > 1 && thisMove.yDistance < maxDescend) {
            this.tags.add("fast_fall_vdist");
            violation = true;
        }
        if (violation) {
            if (VehicleWorkarounds.oddInAir(thisMove, minDescend, maxDescend, this.checkDetails, data)) {
                violation = false;
                this.checkDetails.checkAscendMuch = false;
                this.checkDetails.checkDescendMuch = false;
            }
            if (debug) {
                this.debugDetails.add("maxDescend: " + maxDescend);
            }
        }
        return violation;
    }

    private double getInAirMaxDescend(PlayerMoveData thisMove, MovingData data) {
        double maxDescend = -0.07289999999999999 * (double)data.sfJumpPhase - 0.5;
        VehicleMoveData firstPastMove = data.vehicleMoves.getFirstPastMove();
        if (thisMove.yDistance < maxDescend && firstPastMove.toIsValid) {
            if (firstPastMove.yDistance < maxDescend && firstPastMove.yDistance > maxDescend * 2.5) {
                maxDescend = Math.min(maxDescend, firstPastMove.yDistance - 0.046849999999999996);
                this.debugDetails.add("desc_frict");
            } else if (firstPastMove.specialCondition && thisMove.yDistance > -1.5) {
                maxDescend = Math.min(maxDescend, -1.5);
                this.debugDetails.add("desc_special");
            }
        }
        return maxDescend;
    }

    private boolean maxDistHorizontal(VehicleMoveData thisMove, double maxDistanceHorizontal) {
        if (thisMove.hDistance > maxDistanceHorizontal) {
            this.tags.add("hdist");
            return true;
        }
        return false;
    }

    private boolean collidesWithHoneyBlock(RichEntityLocation from) {
        return (from.getBlockFlags() & BlockFlags.F_STICKY) != 0L;
    }

    public class CheckDetails {
        public boolean canClimb;
        public boolean canRails;
        public boolean canJump;
        public boolean canStepUpBlock;
        public double maxAscend;
        public double gravityTargetSpeed;
        public EntityType simplifiedType;
        public boolean checkAscendMuch;
        public boolean checkDescendMuch;
        public boolean fromIsSafeMedium;
        public boolean toIsSafeMedium;
        public boolean inAir;

        public void reset() {
            this.canStepUpBlock = false;
            this.canJump = false;
            this.canRails = false;
            this.canClimb = false;
            this.maxAscend = 0.0;
            this.checkDescendMuch = true;
            this.checkAscendMuch = true;
            this.inAir = false;
            this.toIsSafeMedium = false;
            this.fromIsSafeMedium = false;
            this.simplifiedType = null;
            this.gravityTargetSpeed = 3.7;
        }
    }
}

