/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.vehicle;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.location.setback.SetBackEntry;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveConsistency;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.vehicle.VehicleEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.vehicle.VehicleMorePackets;
import fr.neatmonster.nocheatplus.checks.moving.vehicle.VehicleSetBackTask;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.location.IGetLocationWithLook;
import fr.neatmonster.nocheatplus.components.location.SimplePositionWithLook;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.entity.PassengerUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.moving.AuxMoving;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import fr.neatmonster.nocheatplus.worlds.IWorldDataManager;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.plugin.Plugin;

public class VehicleChecks
extends CheckListener {
    private final Plugin plugin = Bukkit.getPluginManager().getPlugin("NoCheatPlus");
    private final IWorldDataManager worldDataManager = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
    private final Set<EntityType> normalVehicles = new HashSet<EntityType>();
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLocEnter = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLocLeave = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLocVehicleEnter = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLocVehicleLeave = new Location(null, 0.0, 0.0, 0.0);
    private final SimplePositionWithLook usePos1 = new SimplePositionWithLook();
    private final SimplePositionWithLook usePos2 = new SimplePositionWithLook();
    private final AuxMoving aux = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);
    private final PassengerUtil passengerUtil = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(PassengerUtil.class);
    private final boolean specialMinecart = ServerVersion.compareMinecraftVersion("1.19.4") >= 0;
    private final VehicleMorePackets vehicleMorePackets = this.addCheck(new VehicleMorePackets());
    private final VehicleEnvelope vehicleEnvelope = new VehicleEnvelope();

    public VehicleChecks() {
        super(CheckType.MOVING_VEHICLE);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (vehicle == null) {
            return;
        }
        if (vehicle.getVehicle() != null) {
            return;
        }
        Player player = this.passengerUtil.getFirstPlayerPassenger((Entity)vehicle);
        if (player == null) {
            return;
        }
        if (vehicle.isDead() || !vehicle.isValid()) {
            this.onPlayerVehicleLeave(player, (Entity)vehicle);
            return;
        }
        EntityType vehicleType = vehicle.getType();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        Location from = event.getFrom();
        Location to = event.getTo();
        if (pData.isDebugActive(this.checkType)) {
            this.outputDebugVehicleMoveEvent(player, from, to);
        }
        if (from == null) {
            return;
        }
        if (!from.equals((Object)to) && !from.getWorld().equals((Object)to.getWorld())) {
            return;
        }
        if (this.normalVehicles.contains(vehicleType)) {
            return;
        }
        boolean debug = pData.isDebugActive(this.checkType);
        if (debug) {
            this.debug(player, "VehicleMoveEvent: legacy handling, potential issue.");
        }
        this.checkVehicleMove((Entity)vehicle, vehicleType, from, to, player, false, data, pData, debug);
    }

    private void outputDebugVehicleMoveEvent(Player player, Location from, Location to) {
        if (from != null && from.equals((Object)to)) {
            this.debug(player, "VehicleMoveEvent: from=to: " + from);
        } else {
            this.debug(player, "VehicleMoveEvent: from: " + from + " , to: " + to);
        }
    }

    public Location onPlayerMoveVehicle(Player player, Location from, Location to, MovingData data, IPlayerData pData) {
        Entity vehicle = this.passengerUtil.getLastNonPlayerVehicle((Entity)player);
        if (pData.isDebugActive(this.checkType)) {
            this.debug(player, "onPlayerMoveVehicle: vehicle: " + vehicle);
        }
        data.wasInVehicle = true;
        data.sfHoverTicks = -1;
        data.removeAllVelocity();
        if (vehicle == null || vehicle.isDead() || !vehicle.isValid()) {
            this.onPlayerVehicleLeave(player, vehicle);
            return null;
        }
        EntityType vehicleType = vehicle.getType();
        this.onVehicleUpdate(vehicle, vehicleType, player, true, data, pData, pData.isDebugActive(this.checkType));
        Location vLoc = vehicle.getLocation();
        data.vehicleConsistency = MoveConsistency.getConsistency(from, to, vLoc);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        if (data.vehicleConsistency == MoveConsistency.INCONSISTENT) {
            if (cc.vehicleEnforceLocation) {
                return vLoc;
            }
            return null;
        }
        this.aux.resetPositionsAndMediumProperties(player, vLoc, data, cc);
        return null;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onVehicleUpdate(VehicleUpdateEvent event) {
        Vehicle vehicle = event.getVehicle();
        EntityType vehicleType = vehicle.getType();
        if (!(this.normalVehicles.contains(vehicleType) || vehicleType == EntityType.MINECART && this.specialMinecart)) {
            this.normalVehicles.add(vehicleType);
            if (this.worldDataManager.getWorldData(vehicle.getWorld()).isDebugActive(this.checkType)) {
                this.debug(null, "VehicleUpdateEvent fired for: " + vehicleType);
            }
        }
        if (vehicle.getVehicle() != null) {
            return;
        }
        Player player = this.passengerUtil.getFirstPlayerPassenger((Entity)vehicle);
        if (player == null || player.isDead()) {
            return;
        }
        if (vehicle.isDead() || !vehicle.isValid()) {
            this.onPlayerVehicleLeave(player, (Entity)vehicle);
            return;
        }
    }

    private void onVehicleUpdate(Entity vehicle, EntityType vehicleType, Player player, boolean fake, MovingData data, IPlayerData pData, boolean debug) {
        this.checkVehicleMove(vehicle, vehicleType, null, null, player, true, data, pData, debug);
    }

    private void checkVehicleMove(Entity vehicle, EntityType vehicleType, Location from, Location to, Player player, boolean fake, MovingData data, IPlayerData pData, boolean debug) {
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        if (cc.ignoredVehicles.contains(vehicleType)) {
            data.clearVehicleData();
            return;
        }
        World world = vehicle.getWorld();
        VehicleMoveInfo moveInfo = this.aux.useVehicleMoveInfo();
        Location vehicleLocation = vehicle.getLocation(moveInfo.useLoc);
        VehicleMoveData firstPastMove = data.vehicleMoves.getFirstPastMove();
        if (!firstPastMove.valid) {
            Location refLoc = from == null ? vehicleLocation : from;
            MovingUtil.ensureChunksLoaded(player, refLoc, "vehicle move (no past move)", data, cc, pData);
            this.aux.resetVehiclePositions(vehicle, refLoc, data, cc);
            if (pData.isDebugActive(this.checkType)) {
                this.debug(player, "Missing past move data, set to: " + firstPastMove.from);
            }
        }
        Location useFrom = LocUtil.set(this.useLoc, world, firstPastMove.toIsValid ? firstPastMove.to : firstPastMove.from);
        Location useTo = vehicleLocation;
        if (vehicleType == EntityType.PIG) {
            moveInfo.setExtendFullWidth(0.52);
        }
        moveInfo.set(vehicle, useFrom, useTo, vehicleType == EntityType.PIG ? Math.max(0.13, cc.yOnGround) : cc.yOnGround);
        moveInfo.setExtendFullWidth(0.0);
        if (this.checkIllegal(moveInfo.from, moveInfo.to)) {
            SetBackEntry newTo = data.vehicleSetBacks.getValidSafeMediumEntry();
            if (newTo == null) {
                this.recoverVehicleSetBack(player, vehicle, vehicleLocation, moveInfo, data, cc);
            }
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING_VEHICLE) + "Illegal coordinates on checkVehicleMove: from: " + from + " , to: " + to);
            this.setBack(player, vehicle, newTo, data, cc, pData);
            this.aux.returnVehicleMoveInfo(moveInfo);
            return;
        }
        MovingUtil.ensureChunksLoaded(player, useFrom, useTo, firstPastMove, "vehicle move", cc, pData);
        VehicleMoveData thisMove = data.vehicleMoves.getCurrentMove();
        thisMove.set(moveInfo.from, moveInfo.to);
        MovingUtil.prepareFullCheck(moveInfo.from, moveInfo.to, thisMove, cc.yOnGround);
        thisMove.setExtraVehicleProperties(vehicle);
        this.checkVehicleMove(vehicle, vehicleType, vehicleLocation, world, moveInfo, thisMove, firstPastMove, player, fake, data, cc, pData);
        this.aux.returnVehicleMoveInfo(moveInfo);
    }

    private void recoverVehicleSetBack(Player player, Entity vehicle, Location vehicleLocation, VehicleMoveInfo moveInfo, MovingData data, MovingConfig cc) {
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, this.checkType) + "Illegal coordinates on vehicle moving: world: " + moveInfo.from.getWorldName() + " , from: " + LocUtil.simpleFormat(moveInfo.from) + " , to: " + LocUtil.simpleFormat(moveInfo.to));
        if (moveInfo.from.hasIllegalCoords()) {
            if (LocUtil.isBadCoordinate(vehicleLocation.getX(), vehicleLocation.getY(), vehicleLocation.getZ())) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, this.checkType) + "Could not recover vehicle coordinates. Player will be kicked.");
                player.kickPlayer(cc.msgKickIllegalVehicleMove);
            } else {
                data.vehicleSetBacks.setDefaultEntry(vehicleLocation);
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, this.checkType) + "Using the current vehicle location for set back, due to not having a past location to rely on. This could be a bug.");
            }
        } else {
            data.vehicleSetBacks.setDefaultEntry(moveInfo.from);
        }
    }

    private boolean checkIllegal(RichBoundsLocation from, RichBoundsLocation to) {
        return from.hasIllegalCoords() || to.hasIllegalCoords();
    }

    private void checkVehicleMove(Entity vehicle, EntityType vehicleType, Location vehicleLocation, World world, VehicleMoveInfo moveInfo, VehicleMoveData thisMove, VehicleMoveData firstPastMove, Player player, boolean fake, MovingData data, MovingConfig cc, IPlayerData pData) {
        SetBackEntry tempNewTo;
        boolean debug = pData.isDebugActive(this.checkType);
        data.joinOrRespawn = false;
        data.vehicleConsistency = MoveConsistency.getConsistency(thisMove, player.getLocation(this.useLoc));
        switch (data.vehicleConsistency) {
            case FROM: 
            case TO: {
                this.aux.resetPositionsAndMediumProperties(player, player.getLocation(this.useLoc), data, cc);
                break;
            }
        }
        SetBackEntry newTo = null;
        if (cc.noFallVehicleReset) {
            data.noFallSkipAirCheck = true;
            data.clearNoFallData();
        }
        if (debug) {
            this.outputDebugVehicleMove(player, vehicle, thisMove, fake);
        }
        if (!data.vehicleSetBacks.isDefaultEntryValid()) {
            this.ensureSetBack(player, thisMove, data, pData);
        }
        if ((newTo == null || data.vehicleSetBacks.getSafeMediumEntry().isValidAndOlderThan(newTo)) && pData.isCheckActive(CheckType.MOVING_VEHICLE_ENVELOPE, player)) {
            if (data.timeSinceSetBack == 0 || thisMove.to.hashCode() == data.lastSetBackHash) {
                thisMove.specialCondition = true;
                if (debug) {
                    this.debug(player, "Skip envelope check on first move after set back acknowledging the set back with an odd starting point (from).");
                }
            } else {
                this.vehicleEnvelope.prepareCheckDetails(vehicle, moveInfo, thisMove);
                tempNewTo = this.vehicleEnvelope.check(player, vehicle, thisMove, fake, data, cc, pData, moveInfo);
                if (tempNewTo != null) {
                    newTo = tempNewTo;
                }
            }
        }
        if (newTo == null || data.vehicleSetBacks.getMidTermEntry().isValidAndOlderThan(newTo)) {
            if (pData.isCheckActive(CheckType.MOVING_VEHICLE_MOREPACKETS, player)) {
                tempNewTo = this.vehicleMorePackets.check(player, thisMove, newTo, data, cc, pData);
                if (tempNewTo != null) {
                    newTo = tempNewTo;
                }
            } else {
                data.clearVehicleMorePacketsData();
            }
        }
        if (newTo == null) {
            List<Entity> passengers = this.passengerUtil.handleVehicle.getHandle().getEntityPassengers(vehicle);
            if (passengers.size() > 1) {
                this.updateVehicleData(player, data, vehicle, moveInfo, passengers);
            }
            ++data.timeSinceSetBack;
            data.vehicleMoves.finishCurrentMove();
        } else {
            this.setBack(player, vehicle, newTo, data, cc, pData);
        }
        this.useLoc.setWorld(null);
    }

    private void updateVehicleData(Player player, MovingData data, Entity vehicle, VehicleMoveInfo moveInfo, List<Entity> passengers) {
        for (Entity passenger : passengers) {
            if (!(passenger instanceof Player) || player.equals((Object)passenger)) continue;
            Player otherPlayer = (Player)passenger;
            MovingData otherData = DataManager.getGenericInstance(otherPlayer, MovingData.class);
            otherData.resetVehiclePositions(moveInfo.to);
            otherData.vehicleSetBacks.resetAllLazily(data.vehicleSetBacks.getOldestValidEntry());
            otherData.wasInVehicle = true;
            otherData.vehicleMoves.invalidate();
        }
    }

    private void ensureSetBack(Player player, VehicleMoveData thisMove, MovingData data, IPlayerData pData) {
        IGetLocationWithLook ensureLoc = !data.vehicleSetBacks.isAnyEntryValid() ? thisMove.from : data.vehicleSetBacks.getOldestValidEntry();
        data.vehicleSetBacks.setDefaultEntry(ensureLoc);
        if (pData.isDebugActive(this.checkType)) {
            this.debug(player, "Ensure vehicle set back: " + ensureLoc);
        }
    }

    private void setBack(Player player, Entity vehicle, SetBackEntry newTo, MovingData data, MovingConfig cc, IPlayerData pData) {
        boolean debug = pData.isDebugActive(this.checkType);
        if (!SchedulerHelper.isTaskScheduled(data.vehicleSetBackTaskId)) {
            boolean scheduleSetBack;
            if (debug) {
                this.debug(player, "Will set back to: " + newTo);
            }
            if (scheduleSetBack = cc.scheduleVehicleSetBacks) {
                this.aux.resetVehiclePositions(vehicle, LocUtil.set(this.useLoc, vehicle.getWorld(), newTo), data, cc);
                data.vehicleSetBackTaskId = SchedulerHelper.runSyncTaskForEntity(vehicle, this.plugin, arg -> new VehicleSetBackTask(vehicle, player, newTo.getLocation(vehicle.getWorld()), debug, new Entity[0]).run(), null);
                if (!SchedulerHelper.isTaskScheduled(data.vehicleSetBackTaskId)) {
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "Failed to schedule vehicle set back task. Player: " + player.getName() + " , set back: " + newTo);
                    scheduleSetBack = false;
                } else if (debug) {
                    this.debug(player, "Vehicle set back task id: " + data.vehicleSetBackTaskId);
                }
            }
            if (!scheduleSetBack) {
                if (debug) {
                    this.debug(player, "Attempt to set the player back directly.");
                }
                this.passengerUtil.teleportWithPassengers(vehicle, player, newTo.getLocation(vehicle.getWorld()), debug, pData);
            }
        } else if (debug) {
            data.vehicleMoves.invalidate();
            this.debug(player, "Vehicle set back task already scheduled, skip this time.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerVehicleEnter(VehicleEnterEvent event) {
        Entity entity = event.getEntered();
        if (entity instanceof Player && this.onPlayerVehicleEnter((Player)entity, (Entity)event.getVehicle())) {
            event.setCancelled(true);
        }
    }

    public boolean onPlayerVehicleEnter(Player player, Entity vehicle) {
        Entity lastVehicle;
        IPlayerData pData = DataManager.getPlayerData(player);
        boolean debug = pData.isDebugActive(this.checkType);
        MovingData data = pData.getGenericInstance(MovingData.class);
        if (!data.isVehicleSetBack && MovingUtil.hasScheduledPlayerSetBack(player.getUniqueId(), data)) {
            if (debug) {
                this.debug(player, "Vehicle enter: prevent, due to a scheduled set back.");
            }
            return true;
        }
        if (debug) {
            this.debug(player, "Vehicle enter: first vehicle: " + vehicle.getClass().getName());
        }
        if ((lastVehicle = this.passengerUtil.getLastNonPlayerVehicle(vehicle, true)) == null) {
            data.clearVehicleData();
            if (debug) {
                this.debugNestedVehicleEnter(player);
            }
            return false;
        }
        if (!lastVehicle.equals((Object)vehicle)) {
            if (debug) {
                this.debug(player, "Vehicle enter: last of nested vehicles: " + lastVehicle.getClass().getName());
            }
            this.dataOnVehicleEnter(player, lastVehicle, data, pData);
        } else {
            this.dataOnVehicleEnter(player, vehicle, data, pData);
        }
        return false;
    }

    private void debugNestedVehicleEnter(Player player) {
        this.debug(player, "Vehicle enter: Skip on nested vehicles, possibly with multiple players involved, who would do that?");
        LinkedList<String> vehicles = new LinkedList<String>();
        for (Entity tempVehicle = player.getVehicle(); tempVehicle != null; tempVehicle = tempVehicle.getVehicle()) {
            vehicles.add(tempVehicle.getType().toString());
        }
        if (!vehicles.isEmpty()) {
            this.debug(player, "Vehicle enter: Nested vehicles: " + StringUtil.join(vehicles, ", "));
        }
    }

    private void dataOnVehicleEnter(Player player, Entity vehicle, MovingData data, IPlayerData pData) {
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        data.joinOrRespawn = false;
        data.vehicleLeave = false;
        data.removeAllVelocity();
        Location vLoc = vehicle.getLocation(this.useLocVehicleEnter);
        data.vehicleConsistency = MoveConsistency.getConsistency(vLoc, null, player.getLocation(this.useLocEnter));
        if (!data.isVehicleSetBack) {
            data.vehicleSetBacks.resetAll(vLoc);
        }
        this.aux.resetVehiclePositions(vehicle, vLoc, data, cc);
        if (pData.isDebugActive(this.checkType)) {
            this.debug(player, "Vehicle enter: " + vehicle.getType() + " , player: " + this.useLocEnter + " c=" + (Object)((Object)data.vehicleConsistency));
        }
        this.useLocVehicleEnter.setWorld(null);
        this.useLocEnter.setWorld(null);
    }

    public void onVehicleLeaveMiss(Player player, MovingData data, MovingConfig cc, IPlayerData pData) {
        if (pData.isDebugActive(this.checkType)) {
            StaticLog.logWarning("VehicleExitEvent missing for: " + player.getName());
        }
        this.onPlayerVehicleLeave(player, null);
        data.noFallSkipAirCheck = true;
        data.clearNoFallData();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleExit(VehicleExitEvent event) {
        LivingEntity entity = event.getExited();
        if (!(entity instanceof Player)) {
            return;
        }
        this.onPlayerVehicleLeave((Player)entity, (Entity)event.getVehicle());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVehicleDestroyLowest(VehicleDestroyEvent event) {
        Entity attacker = event.getAttacker();
        if (attacker instanceof Player && this.passengerUtil.isPassenger(attacker, (Entity)event.getVehicle())) {
            Player player = (Player)attacker;
            IPlayerData pData = DataManager.getPlayerData(player);
            MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
            if (cc.vehiclePreventDestroyOwn) {
                if (pData.isCheckActive(CheckType.MOVING_SURVIVALFLY, player) || pData.isCheckActive(CheckType.MOVING_CREATIVEFLY, player)) {
                    // empty if block
                }
                event.setCancelled(true);
                player.sendMessage(ChatColor.DARK_RED + "Destroying your own vehicle is disabled.");
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        for (Entity entity : this.passengerUtil.handleVehicle.getHandle().getEntityPassengers((Entity)event.getVehicle())) {
            if (!(entity instanceof Player)) continue;
            this.onPlayerVehicleLeave((Player)entity, (Entity)event.getVehicle());
        }
    }

    private void onPlayerVehicleLeave(Player player, Entity vehicle) {
        Location pLoc;
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        boolean debug = pData.isDebugActive(this.checkType);
        data.wasInVehicle = false;
        data.joinOrRespawn = false;
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        Location loc = pLoc = player.getLocation(this.useLocLeave);
        if (vehicle != null) {
            Location vLoc = vehicle.getLocation(this.useLocVehicleLeave);
            if (!this.normalVehicles.contains(vehicle.getType()) || cc.noFallVehicleReset) {
                data.noFallSkipAirCheck = true;
                data.clearNoFallData();
            }
            if (MoveConsistency.getConsistency(vLoc, null, pLoc) == MoveConsistency.INCONSISTENT) {
                loc = vLoc;
                if (data.vehicleConsistency != MoveConsistency.INCONSISTENT) {
                    Location oldLoc;
                    PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
                    if (lastMove.toIsValid && MoveConsistency.getConsistency(oldLoc = new Location(pLoc.getWorld(), lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ()), null, pLoc) != MoveConsistency.INCONSISTENT) {
                        loc = oldLoc;
                    }
                }
            }
            if (debug) {
                String pWorld = player.getWorld().getName();
                String vWorld = vehicle.getWorld() != null ? vehicle.getWorld().getName() : "";
                this.debug(player, "Vehicle leave: " + vehicle.getType() + "@" + (pWorld.equals(vWorld) ? Double.valueOf(pLoc.distance(vLoc)) : "Player/Vehicle world mismatch"));
            }
        }
        if (BlockProperties.isLiquid(loc.getBlock().getType())) {
            loc.setY((double)Location.locToBlock((double)loc.getY()) + 1.25);
        }
        if (debug) {
            this.debug(player, "Vehicle leave: " + pLoc.toString() + (pLoc.equals((Object)loc) ? "" : " / player at: " + pLoc.toString()));
        }
        data.lastVehicleType = vehicle != null ? vehicle.getType() : null;
        this.aux.resetPositionsAndMediumProperties(player, loc, data, cc);
        data.setSetBack(loc);
        data.removeAllVelocity();
        data.vehicleLeave = true;
        this.useLocLeave.setWorld(null);
        this.useLocVehicleLeave.setWorld(null);
    }

    private void outputDebugVehicleMove(Player player, Entity vehicle, VehicleMoveData thisMove, boolean fake) {
        StringBuilder builder = new StringBuilder(250);
        Location vLoc = vehicle.getLocation();
        Location loc = player.getLocation();
        Entity actualVehicle = player.getVehicle();
        boolean wrongVehicle = actualVehicle == null || actualVehicle.getEntityId() != vehicle.getEntityId();
        builder.append(CheckUtils.getLogMessagePrefix(player, this.checkType));
        builder.append("VEHICLE MOVE " + (fake ? "(fake)" : "") + " in world " + thisMove.from.getWorldName() + ":");
        builder.append("\nFrom: ");
        builder.append(LocUtil.simpleFormat(thisMove.from));
        builder.append("\nTo: ");
        builder.append(LocUtil.simpleFormat(thisMove.to));
        builder.append("\n" + (thisMove.from.resetCond ? "resetcond" : (thisMove.from.onGround ? "ground" : "---")) + " -> " + (thisMove.to.resetCond ? "resetcond" : (thisMove.to.onGround ? "ground" : "---")));
        builder.append("\n Vehicle: ");
        builder.append(LocUtil.simpleFormat(vLoc));
        builder.append("\n Player: ");
        builder.append(LocUtil.simpleFormat(loc));
        builder.append("\n Vehicle type: " + vehicle.getType() + (wrongVehicle ? (actualVehicle == null ? " (exited?)" : " actual: " + actualVehicle.getType()) : ""));
        builder.append("\n hdist: " + thisMove.hDistance);
        builder.append(" vdist: " + thisMove.yDistance);
        builder.append(" fake: " + fake);
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
    }
}

