/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.SfLegacy;
import fr.neatmonster.nocheatplus.checks.moving.envelope.PhysicsEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.envelope.workaround.LostGround;
import fr.neatmonster.nocheatplus.checks.moving.envelope.workaround.MagicWorkarounds;
import fr.neatmonster.nocheatplus.checks.moving.model.InputDirection;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.player.UnusedVelocity;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.components.location.IGetPositionWithLook;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.collision.supportingblock.SupportingBlockUtils;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SurvivalFly
extends Check {
    private final ArrayList<String> tags = new ArrayList(15);
    private final ArrayList<String> justUsedWorkarounds = new ArrayList();
    private final BlockChangeTracker blockChangeTracker;
    private final IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);

    public SurvivalFly() {
        super(CheckType.MOVING_SURVIVALFLY);
        this.blockChangeTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, int multiMoveCount, MovingData data, MovingConfig cc, IPlayerData pData, int tick, long now, boolean useBlockChangeTracker, boolean isNormalOrPacketSplitMove) {
        int tagsLength;
        double yDistanceAboveLimit;
        double yAllowedDistance;
        double[] res;
        double hFreedom;
        this.tags.clear();
        this.justUsedWorkarounds.clear();
        boolean debug = pData.isDebugActive(this.type);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        boolean fromOnGround = from.isOnGround() || useBlockChangeTracker && from.isOnGroundOpportune(cc.yOnGround, 0L, this.blockChangeTracker, data.blockChangeRef, tick);
        boolean toOnGround = to.isOnGround() || useBlockChangeTracker && to.isOnGroundOpportune(cc.yOnGround, 0L, this.blockChangeTracker, data.blockChangeRef, tick);
        boolean resetTo = toOnGround || to.isResetCond();
        boolean resetFrom = fromOnGround || from.isResetCond();
        LostGround.runLostGroundChecks(player, from, to, thisMove.hDistance, thisMove.yDistance, pData.isSprinting(), lastMove, data, cc, useBlockChangeTracker ? this.blockChangeTracker : null, this.tags);
        data.ws.setJustUsedIds(this.justUsedWorkarounds);
        if (data.liftOffEnvelope == LiftOffEnvelope.UNKNOWN) {
            data.adjustLiftOffEnvelope(from);
        }
        data.adjustMediumProperties(player.getLocation(), cc, player, thisMove);
        if (thisMove.touchedGround && multiMoveCount == 0 && thisMove.from.onGround && PhysicsEnvelope.inAir(lastMove) && TrigUtil.isSamePosAndLook((IGetPositionWithLook)thisMove.from, lastMove.to)) {
            data.setSetBack(from);
            if (debug) {
                this.debug(player, "Ground appeared due to a block-place: adjust set-back location.");
            }
        }
        if (data.jumpDelay > 0) {
            --data.jumpDelay;
        }
        double[] resGlide = this.processGliding(from, to, pData, data, player, isNormalOrPacketSplitMove, fromOnGround, toOnGround, debug);
        double[] hRes = Bridge1_9.isGliding((LivingEntity)player) ? resGlide : this.prepareSpeedEstimation(from, to, pData, player, data, thisMove, lastMove, fromOnGround, toOnGround, debug, isNormalOrPacketSplitMove, false, false);
        double hAllowedDistance = hRes[0];
        double hDistanceAboveLimit = hRes[1];
        if (hDistanceAboveLimit > 0.0) {
            double[] res2 = this.hDistAfterFailure(player, from, to, hAllowedDistance, hDistanceAboveLimit, thisMove, lastMove, debug, data, cc, pData, tick, useBlockChangeTracker, fromOnGround, toOnGround, isNormalOrPacketSplitMove);
            hAllowedDistance = res2[0];
            hDistanceAboveLimit = res2[1];
            hFreedom = res2[2];
        } else {
            hFreedom = 0.0;
        }
        if (from.isOnClimbable()) {
            res = this.vDistClimbable(player, from, to, pData, thisMove, lastMove, thisMove.yDistance, data, cc);
            yAllowedDistance = res[0];
            yDistanceAboveLimit = res[1];
        } else if (Bridge1_9.isGliding((LivingEntity)player)) {
            yAllowedDistance = resGlide[2];
            yDistanceAboveLimit = resGlide[3];
            if (yDistanceAboveLimit > 0.0) {
                res = this.vDistAfterFailure(player, pData, data, fromOnGround, toOnGround, from, to, isNormalOrPacketSplitMove, resetFrom, resetTo, thisMove, lastMove, yDistanceAboveLimit, yAllowedDistance, useBlockChangeTracker, debug);
                yAllowedDistance = res[0];
                yDistanceAboveLimit = res[1];
            }
        } else {
            res = this.vDistRel(now, player, from, fromOnGround, resetFrom, to, toOnGround, resetTo, thisMove.yDistance, isNormalOrPacketSplitMove, lastMove, data, cc, pData, false, debug);
            yAllowedDistance = res[0];
            yDistanceAboveLimit = res[1];
            if (yDistanceAboveLimit > 0.0) {
                double[] vRes = this.vDistAfterFailure(player, pData, data, fromOnGround, toOnGround, from, to, isNormalOrPacketSplitMove, resetFrom, resetTo, thisMove, lastMove, yDistanceAboveLimit, yAllowedDistance, useBlockChangeTracker, debug);
                yAllowedDistance = vRes[0];
                yDistanceAboveLimit = vRes[1];
            }
        }
        if (debug) {
            this.outputDebug(player, to, from, data, thisMove.hDistance, hAllowedDistance, hFreedom, thisMove.yDistance, yAllowedDistance, fromOnGround, resetFrom, toOnGround, resetTo, thisMove);
            tagsLength = this.tags.size();
            data.ws.setJustUsedIds(null);
        } else {
            tagsLength = 0;
        }
        boolean inAir = PhysicsEnvelope.inAir(thisMove);
        double result = (Math.max(hDistanceAboveLimit, 0.0) + Math.max(yDistanceAboveLimit, 0.0)) * 100.0;
        if (result > 0.0) {
            Location vLoc = this.handleViolation(result, player, from, to, data, cc);
            if (inAir) {
                data.sfVLInAir = true;
            }
            if (vLoc != null) {
                return vLoc;
            }
        } else if (this.canRelaxVL(data, cc, inAir, lastMove, thisMove)) {
            data.survivalFlyVL *= 0.95;
        }
        if (thisMove.to.inPowderSnow) {
            data.liftOffEnvelope = LiftOffEnvelope.LIMIT_POWDER_SNOW;
        } else if (thisMove.to.inWeb) {
            data.liftOffEnvelope = LiftOffEnvelope.LIMIT_WEBS;
        } else if (thisMove.to.inBerryBush) {
            data.liftOffEnvelope = LiftOffEnvelope.LIMIT_SWEET_BERRY;
        } else if (thisMove.to.onHoneyBlock) {
            data.liftOffEnvelope = LiftOffEnvelope.LIMIT_HONEY_BLOCK;
        } else if (resetTo) {
            data.liftOffEnvelope = LiftOffEnvelope.NORMAL;
        } else if (thisMove.from.inPowderSnow) {
            data.liftOffEnvelope = LiftOffEnvelope.LIMIT_POWDER_SNOW;
        } else if (thisMove.from.inWeb) {
            data.liftOffEnvelope = LiftOffEnvelope.LIMIT_WEBS;
        } else if (thisMove.from.inBerryBush) {
            data.liftOffEnvelope = LiftOffEnvelope.LIMIT_SWEET_BERRY;
        } else if (thisMove.from.onHoneyBlock) {
            data.liftOffEnvelope = LiftOffEnvelope.LIMIT_HONEY_BLOCK;
        } else if (resetFrom || thisMove.touchedGround) {
            data.liftOffEnvelope = LiftOffEnvelope.NORMAL;
        }
        if (resetTo) {
            data.setSetBack(to);
            data.sfJumpPhase = 0;
        } else if (resetFrom) {
            data.setSetBack(from);
            data.sfJumpPhase = 1;
        } else {
            ++data.sfJumpPhase;
            if (to.getY() < 0.0 && cc.sfSetBackPolicyVoid || thisMove.hasLevitation || Bridge1_13.isRiptiding((LivingEntity)player) || Bridge1_9.isGliding((LivingEntity)player)) {
                data.setSetBack(to);
            }
        }
        if (!inAir) {
            data.ws.resetConditions("reset.notinair");
            data.sfVLInAir = false;
        }
        if (debug) {
            data.getVerticalVelocityTracker().updateBlockedState(tick, thisMove.headObstructed || thisMove.from.resetCond, thisMove.touchedGround || thisMove.to.resetCond);
            UnusedVelocity.checkUnusedVelocity(player, this.type, data, cc);
        }
        data.lastFrictionVertical = data.nextFrictionVertical;
        data.lastFrictionHorizontal = data.nextFrictionHorizontal;
        data.lastStuckInBlockVertical = data.nextStuckInBlockVertical;
        data.lastStuckInBlockHorizontal = data.nextStuckInBlockHorizontal;
        data.lastBlockSpeedMultiplier = data.nextBlockSpeedMultiplier;
        data.lastInertia = data.nextInertia;
        data.lastLevitationLevel = thisMove.hasLevitation ? Bridge1_9.getLevitationAmplifier(player) + 1.0 : 0.0;
        data.lastGravity = data.nextGravity;
        data.lastCollidingEntitiesLocations = CollisionUtil.getCollidingEntitiesLocations((Entity)player);
        if (debug && this.tags.size() > tagsLength) {
            this.logPostViolationTags(player);
        }
        return null;
    }

    private boolean canRelaxVL(MovingData data, MovingConfig cc, boolean inAir, PlayerMoveData lastMove, PlayerMoveData thisMove) {
        return (long)(data.getPlayerMoveCount() - data.sfVLMoveCount) > cc.survivalFlyVLFreezeCount && (!cc.survivalFlyVLFreezeInAir || !inAir || !data.sfVLInAir && data.liftOffEnvelope == LiftOffEnvelope.NORMAL && lastMove.toIsValid && lastMove.yDistance < -0.0624 && thisMove.yDistance - lastMove.yDistance < -0.0624);
    }

    public boolean checkBed(Player player, MovingConfig cc, MovingData data) {
        boolean cancel = false;
        if (!data.wasInBed) {
            this.tags.add("bedfly");
            data.survivalFlyVL += 100.0;
            Improbable.check(player, 5.0f, System.currentTimeMillis(), "moving.survivalfly.bedfly", DataManager.getPlayerData(player));
            ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, 100.0, cc.survivalFlyActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            cancel = this.executeActions(vd).willCancel();
        } else {
            data.wasInBed = false;
        }
        return cancel;
    }

    private double[] getVerticalBlockMoveResult(double yDistance, PlayerLocation from, PlayerLocation to, MovingData data) {
        if (yDistance > 0.0) {
            if (yDistance <= 1.015 && from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, BlockChangeTracker.Direction.Y_POS, Math.min(yDistance, 1.0))) {
                if (yDistance > 1.0 && to.getY() - (double)to.getBlockY() >= 0.015) {
                    return null;
                }
                this.tags.add("blkmv_y_pos");
                double maxDistYPos = yDistance;
                return new double[]{maxDistYPos, 0.0};
            }
        } else if (yDistance < 0.0 && yDistance >= -1.0 && from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, BlockChangeTracker.Direction.Y_NEG, -yDistance)) {
            this.tags.add("blkmv_y_neg");
            double maxDistYNeg = yDistance;
            return new double[]{maxDistYNeg, 0.0};
        }
        return null;
    }

    private double[] processGliding(PlayerLocation from, PlayerLocation to, IPlayerData pData, MovingData data, Player player, boolean isNormalOrPacketSplitMove, boolean fromOnGround, boolean toOnGround, boolean debug) {
        double offsetV;
        double baseSpeed;
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        double yDistanceAboveLimit = 0.0;
        double hDistanceAboveLimit = 0.0;
        if (!Bridge1_9.isGliding((LivingEntity)player)) {
            return new double[]{thisMove.hDistance, 0.0, thisMove.yDistance, 0.0};
        }
        thisMove.hasImpulse = AlmostBoolean.NO;
        thisMove.forwardImpulse = InputDirection.ForwardDirection.NONE;
        thisMove.strafeImpulse = InputDirection.StrafeDirection.NONE;
        thisMove.xAllowedDistance = lastMove.toIsValid ? lastMove.xDistance : 0.0;
        thisMove.yAllowedDistance = lastMove.toIsValid ? lastMove.yDistance : 0.0;
        thisMove.zAllowedDistance = lastMove.toIsValid ? lastMove.zDistance : 0.0;
        this.doWallCollision(lastMove, thisMove);
        if (TrigUtil.lengthSquared(data.lastStuckInBlockHorizontal, data.lastStuckInBlockVertical, data.lastStuckInBlockHorizontal) > 1.0E-7) {
            if (data.lastStuckInBlockVertical != 1.0) {
                thisMove.yAllowedDistance = 0.0;
            }
            if (data.lastStuckInBlockHorizontal != 1.0) {
                thisMove.zAllowedDistance = 0.0;
                thisMove.xAllowedDistance = 0.0;
            }
        }
        this.checkNegligibleMomentum(pData, thisMove);
        this.checkNegligibleMomentumVertical(pData, thisMove);
        Vector viewVector = TrigUtil.getLookingDirection(to, player);
        float radianPitch = to.getPitch() * ((float)Math.PI / 180);
        double viewVecHorizontalLength = MathUtil.dist(viewVector.getX(), viewVector.getZ());
        double thisMoveHDistance = MathUtil.dist(thisMove.xAllowedDistance, thisMove.zAllowedDistance);
        double viewVectorLength = viewVector.length();
        double cosPitch = pData.getClientVersion().isAtMost(ClientVersion.V_1_18_2) ? TrigUtil.cos((double)radianPitch) : Math.cos(radianPitch);
        cosPitch = cosPitch * cosPitch * Math.min(1.0, viewVectorLength / 0.4);
        thisMove.yAllowedDistance = thisMove.yAllowedDistance + (lastMove.hasSlowfall && lastMove.yDistance <= 0.0 ? 0.01 : 0.08) * (-1.0 + cosPitch * 0.75);
        if (thisMove.yAllowedDistance < 0.0 && viewVecHorizontalLength > 0.0) {
            baseSpeed = thisMove.yAllowedDistance * -0.1 * cosPitch;
            thisMove.xAllowedDistance += viewVector.getX() * baseSpeed / viewVecHorizontalLength;
            thisMove.yAllowedDistance += baseSpeed;
            thisMove.zAllowedDistance += viewVector.getZ() * baseSpeed / viewVecHorizontalLength;
        }
        if ((double)radianPitch < 0.0 && viewVecHorizontalLength > 0.0) {
            baseSpeed = thisMoveHDistance * (double)(-TrigUtil.sin(radianPitch)) * 0.04;
            thisMove.xAllowedDistance += -viewVector.getX() * baseSpeed / viewVecHorizontalLength;
            thisMove.yAllowedDistance += baseSpeed * 3.2;
            thisMove.zAllowedDistance += -viewVector.getZ() * baseSpeed / viewVecHorizontalLength;
        }
        if (viewVecHorizontalLength > 0.0) {
            thisMove.xAllowedDistance += (viewVector.getX() / viewVecHorizontalLength * thisMoveHDistance - thisMove.xAllowedDistance) * 0.1;
            thisMove.zAllowedDistance += (viewVector.getZ() / viewVecHorizontalLength * thisMoveHDistance - thisMove.zAllowedDistance) * 0.1;
        }
        if (data.fireworksBoostDuration > 0) {
            thisMove.xAllowedDistance += viewVector.getX() * 0.1 + (viewVector.getX() * 1.5 - thisMove.xAllowedDistance) * 0.5;
            thisMove.yAllowedDistance += viewVector.getY() * 0.1 + (viewVector.getY() * 1.5 - thisMove.yAllowedDistance) * 0.5;
            thisMove.zAllowedDistance += viewVector.getZ() * 0.1 + (viewVector.getZ() * 1.5 - thisMove.zAllowedDistance) * 0.5;
        }
        thisMove.xAllowedDistance *= 0.99;
        thisMove.yAllowedDistance *= data.lastFrictionVertical;
        thisMove.zAllowedDistance *= 0.99;
        if (TrigUtil.lengthSquared(data.nextStuckInBlockHorizontal, data.nextStuckInBlockVertical, data.nextStuckInBlockHorizontal) > 1.0E-7) {
            thisMove.xAllowedDistance *= data.nextStuckInBlockHorizontal;
            thisMove.yAllowedDistance *= data.nextStuckInBlockVertical;
            thisMove.zAllowedDistance *= data.nextStuckInBlockHorizontal;
        }
        if (lastMove.slowedByUsingAnItem && !thisMove.slowedByUsingAnItem && thisMove.isRiptiding) {
            Vector propellingForce = to.getTridentPropellingForce(false);
            thisMove.xAllowedDistance += propellingForce.getX();
            thisMove.yAllowedDistance += propellingForce.getY();
            thisMove.zAllowedDistance += propellingForce.getZ();
        }
        Vector collisionVector = from.collide(new Vector(thisMove.xAllowedDistance, thisMove.yAllowedDistance, thisMove.zAllowedDistance), fromOnGround || thisMove.touchedGroundWorkaround, from.getBoundingBox());
        thisMove.collideX = collisionVector.getX() != thisMove.xAllowedDistance;
        thisMove.collideY = collisionVector.getY() != thisMove.yAllowedDistance;
        thisMove.collideZ = collisionVector.getZ() != thisMove.zAllowedDistance;
        thisMove.collidesHorizontally = thisMove.collideX || thisMove.collideZ;
        thisMove.xAllowedDistance = collisionVector.getX();
        thisMove.yAllowedDistance = collisionVector.getY();
        thisMove.zAllowedDistance = collisionVector.getZ();
        if (MagicWorkarounds.checkPostPredictWorkaround(data, fromOnGround, toOnGround, from, to, thisMove.yAllowedDistance, player, isNormalOrPacketSplitMove)) {
            thisMove.yAllowedDistance = thisMove.yDistance;
        }
        if (!(Math.abs(offsetV = thisMove.yDistance - thisMove.yAllowedDistance) < 1.0E-4) && data.getOrUseVerticalVelocity(thisMove.yDistance).isEmpty()) {
            yDistanceAboveLimit = Math.max(yDistanceAboveLimit, Math.abs(offsetV));
            this.tags.add("vdistrel");
        }
        thisMove.hAllowedDistance = MathUtil.dist(thisMove.xAllowedDistance, thisMove.zAllowedDistance);
        double offsetH = thisMove.hDistance - thisMove.hAllowedDistance;
        if (!(offsetH < 1.0E-4)) {
            hDistanceAboveLimit = Math.max(hDistanceAboveLimit, offsetH);
            this.tags.add("hdistrel");
        }
        if (debug) {
            player.sendMessage("hDistance/Predicted " + StringUtil.fdec6.format(thisMove.hDistance) + " / " + StringUtil.fdec6.format(thisMove.hAllowedDistance));
            player.sendMessage("vDistance/Predicted " + StringUtil.fdec6.format(thisMove.yDistance) + " / " + StringUtil.fdec6.format(thisMove.yAllowedDistance));
        }
        return new double[]{thisMove.hAllowedDistance, hDistanceAboveLimit, thisMove.yAllowedDistance, yDistanceAboveLimit};
    }

    private void doWallCollision(PlayerMoveData lastMove, PlayerMoveData thisMove) {
        if (lastMove.collideX) {
            thisMove.xAllowedDistance = 0.0;
        }
        if (lastMove.collideZ) {
            thisMove.zAllowedDistance = 0.0;
        }
    }

    private void checkNegligibleMomentum(IPlayerData pData, PlayerMoveData thisMove) {
        if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_9)) {
            if (Math.abs(thisMove.xAllowedDistance) < 0.003) {
                thisMove.xAllowedDistance = 0.0;
            }
            if (Math.abs(thisMove.zAllowedDistance) < 0.003) {
                thisMove.zAllowedDistance = 0.0;
            }
        } else {
            if (Math.abs(thisMove.xAllowedDistance) < 0.005) {
                thisMove.xAllowedDistance = 0.0;
            }
            if (Math.abs(thisMove.zAllowedDistance) < 0.005) {
                thisMove.zAllowedDistance = 0.0;
            }
        }
    }

    private void checkNegligibleMomentumVertical(IPlayerData pData, PlayerMoveData thisMove) {
        double d = Math.abs(thisMove.yAllowedDistance);
        double d2 = pData.getClientVersion().isAtLeast(ClientVersion.V_1_9) ? 0.003 : 0.005;
        if (d < d2) {
            thisMove.yAllowedDistance = 0.0;
        }
    }

    private double[] prepareSpeedEstimation(PlayerLocation from, PlayerLocation to, IPlayerData pData, Player player, MovingData data, PlayerMoveData thisMove, PlayerMoveData lastMove, boolean fromOnGround, boolean toOnGround, boolean debug, boolean isNormalOrPacketSplitMove, boolean forceSetOnGround, boolean forceSetOffGround) {
        boolean isPredictable;
        boolean onGround;
        if (!isNormalOrPacketSplitMove) {
            thisMove.xAllowedDistance = thisMove.xDistance;
            thisMove.zAllowedDistance = thisMove.zDistance;
            thisMove.hAllowedDistance = thisMove.hDistance;
            double hDistanceAboveLimit = 0.0;
            return new double[]{thisMove.hAllowedDistance, hDistanceAboveLimit};
        }
        boolean bl = onGround = !forceSetOffGround && (from.isOnGround() || lastMove.toIsValid && lastMove.yDistance <= 0.0 && lastMove.from.onGround || forceSetOnGround);
        if (from.isInWater()) {
            data.nextInertia = Bridge1_13.isSwimming((LivingEntity)player) ? 0.9f : 0.8f;
            float acceleration = 0.02f;
            float StriderLevel = this.attributeAccess.getHandle().getWaterMovementEfficiency(player);
            if (!onGround) {
                StriderLevel *= 0.5f;
            }
            if ((double)StriderLevel > 0.0) {
                data.nextInertia = data.nextInertia + (0.54600006f - data.nextInertia) * StriderLevel / (pData.getClientVersion().isAtMost(ClientVersion.V_1_20_6) ? 3.0f : 1.0f);
                acceleration += (data.walkSpeed - acceleration) * StriderLevel / (pData.getClientVersion().isAtMost(ClientVersion.V_1_20_6) ? 3.0f : 1.0f);
            }
            if (!Double.isInfinite(Bridge1_13.getDolphinGraceAmplifier((LivingEntity)player))) {
                data.nextInertia = 0.96f;
            }
            isPredictable = this.estimateNextSpeed(player, acceleration, pData, this.tags, to, from, debug, fromOnGround, toOnGround, onGround, forceSetOffGround);
        } else if (from.isInLava()) {
            data.nextInertia = 0.5f;
            isPredictable = this.estimateNextSpeed(player, 0.02f, pData, this.tags, to, from, debug, fromOnGround, toOnGround, onGround, forceSetOffGround);
        } else {
            float acceleration;
            float frictionMediumFactor;
            data.nextInertia = onGround ? data.nextFrictionHorizontal * 0.91f : 0.91f;
            float f = frictionMediumFactor = pData.getClientVersion().isAtLeast(ClientVersion.V_1_13) ? data.nextFrictionHorizontal : data.nextFrictionHorizontal * 0.91f;
            float f2 = onGround ? data.walkSpeed * ((pData.getClientVersion().isAtLeast(ClientVersion.V_1_13) ? 0.21600002f : 0.16277136f) / (frictionMediumFactor * frictionMediumFactor * frictionMediumFactor)) : (acceleration = 0.02f);
            if (pData.isSprinting()) {
                acceleration += acceleration * 0.3f;
            }
            isPredictable = this.estimateNextSpeed(player, acceleration, pData, this.tags, to, from, debug, fromOnGround, toOnGround, onGround, forceSetOffGround);
        }
        thisMove.hAllowedDistance = MathUtil.dist(thisMove.xAllowedDistance, thisMove.zAllowedDistance);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        double hDistanceAboveLimit = !isPredictable ? this.handleUnpredictableMove(thisMove, cc.survivalFlyStrictHorizontal) : this.handlePredictableMove(thisMove, cc.survivalFlyStrictHorizontal);
        if (hDistanceAboveLimit > 0.0) {
            this.tags.add("hdistrel");
        }
        if (debug) {
            player.sendMessage("c/e: " + StringUtil.fdec6.format(thisMove.hDistance) + " / " + StringUtil.fdec6.format(thisMove.hAllowedDistance));
        }
        return new double[]{thisMove.hAllowedDistance, hDistanceAboveLimit};
    }

    private boolean estimateNextSpeed(Player player, float movementSpeed, IPlayerData pData, Collection<String> tags, PlayerLocation to, PlayerLocation from, boolean debug, boolean fromOnGround, boolean toOnGround, boolean onGround, boolean forceSetOffGround) {
        MovingData data = pData.getGenericInstance(MovingData.class);
        CombinedData cData = pData.getGenericInstance(CombinedData.class);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (cData.isHackingRI) {
            tags.add("noslowpacket");
            cData.isHackingRI = false;
            Improbable.check(player, (float)thisMove.hDistance, System.currentTimeMillis(), "moving.survivalfly.noslow", pData);
            data.resetHorizontalData();
            return true;
        }
        if (cData.invalidItemUse) {
            tags.add("invaliditemuse");
            cData.invalidItemUse = false;
            Improbable.check(player, (float)thisMove.hDistance, System.currentTimeMillis(), "moving.survivalfly.invalid_use", pData);
            data.resetHorizontalData();
            return true;
        }
        if (BridgeMisc.isWASDImpulseKnown(player) && pData.isSprinting() && ((player.getCurrentInput().isLeft() || player.getCurrentInput().isRight() || player.getCurrentInput().isBackward()) && !player.getCurrentInput().isForward() || player.getFoodLevel() <= 5)) {
            tags.add("illegalsprint");
            pData.setSprintingState(false);
            Improbable.check(player, (float)thisMove.hDistance, System.currentTimeMillis(), "moving.survivalfly.illegalsprint", pData);
            data.resetHorizontalData();
            return true;
        }
        InputDirection input = null;
        InputDirection[] theorInputs = null;
        int i = 0;
        if (BridgeMisc.isWASDImpulseKnown(player)) {
            input = new InputDirection(player);
            input.operationToInt(0.98f, 0.98f, 1);
            if (pData.isInCrouchingPose()) {
                input.operationToInt(this.attributeAccess.getHandle().getPlayerSneakingFactor(player), this.attributeAccess.getHandle().getPlayerSneakingFactor(player), 1);
                tags.add("crouching");
            }
            if (BridgeMisc.isUsingItem(player)) {
                input.operationToInt(0.2f, 0.2f, 1);
                tags.add("usingitem");
            }
        } else {
            theorInputs = new InputDirection[9];
            for (int strafe = -1; strafe <= 1; ++strafe) {
                for (int forward = -1; forward <= 1; ++forward) {
                    theorInputs[i] = new InputDirection((float)strafe * 0.98f, (float)forward * 0.98f);
                    ++i;
                }
            }
            if (pData.isInCrouchingPose()) {
                tags.add("crouching");
                for (i = 0; i < 9; ++i) {
                    theorInputs[i].operationToInt(this.attributeAccess.getHandle().getPlayerSneakingFactor(player), this.attributeAccess.getHandle().getPlayerSneakingFactor(player), 1);
                }
            }
            if (BridgeMisc.isUsingItem(player)) {
                tags.add("usingitem");
                for (i = 0; i < 9; ++i) {
                    theorInputs[i].operationToInt(0.2f, 0.2f, 1);
                }
            }
        }
        boolean isPredictable = true;
        thisMove.xAllowedDistance = lastMove.toIsValid ? lastMove.xDistance : 0.0;
        thisMove.zAllowedDistance = lastMove.toIsValid ? lastMove.zDistance : 0.0;
        this.doWallCollision(lastMove, thisMove);
        if (from.isInWater() && !lastMove.from.inWater) {
            Vector liquidFlowVector = from.getLiquidPushingVector(thisMove.xAllowedDistance, thisMove.zAllowedDistance, BlockFlags.F_WATER);
            thisMove.xAllowedDistance += liquidFlowVector.getX();
            thisMove.zAllowedDistance += liquidFlowVector.getZ();
        }
        if (from.isOnSlimeBlock() && onGround && Math.abs(lastMove.yDistance) < 0.1 && !pData.isShiftKeyPressed()) {
            if (thisMove.yDistance == 0.0) {
                isPredictable = false;
                thisMove.xAllowedDistance *= 0.67;
                thisMove.zAllowedDistance *= 0.67;
            } else {
                thisMove.xAllowedDistance *= 0.4 + Math.abs(lastMove.yDistance) * 0.2;
                thisMove.zAllowedDistance *= 0.4 + Math.abs(lastMove.yDistance) * 0.2;
            }
        }
        if (from.isSlidingDown() && lastMove.yDistance < -0.13) {
            thisMove.xAllowedDistance *= (double)-0.05f / lastMove.yDistance;
            thisMove.zAllowedDistance *= (double)-0.05f / lastMove.yDistance;
        }
        if (data.lastStuckInBlockHorizontal != 1.0 && TrigUtil.lengthSquared(data.lastStuckInBlockHorizontal, data.lastStuckInBlockVertical, data.lastStuckInBlockHorizontal) > 1.0E-7) {
            thisMove.zAllowedDistance = 0.0;
            thisMove.xAllowedDistance = 0.0;
        }
        thisMove.xAllowedDistance *= (double)data.nextBlockSpeedMultiplier;
        thisMove.zAllowedDistance *= (double)data.nextBlockSpeedMultiplier;
        thisMove.xAllowedDistance *= (double)data.lastInertia;
        thisMove.zAllowedDistance *= (double)data.lastInertia;
        if (player.getGameMode() != BridgeMisc.GAME_MODE_SPECTATOR) {
            Vector push = from.doPush(new Vector(thisMove.xAllowedDistance, 0.0, thisMove.zAllowedDistance));
            thisMove.xAllowedDistance = push.getX();
            thisMove.zAllowedDistance = push.getZ();
            if (data.lastCollidingEntitiesLocations != null && !data.lastCollidingEntitiesLocations.isEmpty()) {
                isPredictable = false;
            }
        }
        if (thisMove.hasAttackSlowDown) {
            thisMove.zAllowedDistance *= 0.6;
            thisMove.xAllowedDistance *= 0.6;
        }
        if (from.isInLiquid()) {
            Vector liquidFlowVector = from.getLiquidPushingVector(thisMove.xAllowedDistance, thisMove.zAllowedDistance, from.isInWater() ? BlockFlags.F_WATER : BlockFlags.F_LAVA);
            thisMove.xAllowedDistance += liquidFlowVector.getX();
            thisMove.zAllowedDistance += liquidFlowVector.getZ();
        }
        this.checkNegligibleMomentum(pData, thisMove);
        if (PhysicsEnvelope.isBunnyhop(from, to, pData, fromOnGround, toOnGround, player, forceSetOffGround)) {
            thisMove.xAllowedDistance += (double)(-TrigUtil.sin(to.getYaw() * ((float)Math.PI / 180)) * 0.2f);
            thisMove.zAllowedDistance += (double)(TrigUtil.cos(to.getYaw() * ((float)Math.PI / 180)) * 0.2f);
            thisMove.bunnyHop = true;
            if (!BridgeMisc.isWASDImpulseKnown(player) && PhysicsEnvelope.isVerticallyConstricted(from, to, pData)) {
                isPredictable = false;
            }
            tags.add("bunnyhop");
        }
        if (BridgeMisc.isWASDImpulseKnown(player)) {
            Vector collisionVector;
            double inputSq = MathUtil.square(input.getStrafe()) + MathUtil.square(input.getForward());
            if (inputSq >= 1.0E-7) {
                if (inputSq > 1.0) {
                    double inputForce = Math.sqrt(inputSq);
                    if (inputForce < 1.0E-4) {
                        input.operationToInt(0.0, 0.0, 0);
                    } else {
                        input.operationToInt(inputForce, inputForce, 2);
                    }
                }
                input.operationToInt(movementSpeed, movementSpeed, 1);
                thisMove.xAllowedDistance += (double)input.getStrafe() * (double)TrigUtil.cos(to.getYaw() * ((float)Math.PI / 180)) - (double)input.getForward() * (double)TrigUtil.sin(to.getYaw() * ((float)Math.PI / 180));
                thisMove.zAllowedDistance += (double)input.getForward() * (double)TrigUtil.cos(to.getYaw() * ((float)Math.PI / 180)) + (double)input.getStrafe() * (double)TrigUtil.sin(to.getYaw() * ((float)Math.PI / 180));
            }
            if (from.isOnClimbable() && !from.isInLiquid()) {
                thisMove.xAllowedDistance = MathUtil.clamp(thisMove.xAllowedDistance, (double)-0.15f, (double)0.15f);
                thisMove.zAllowedDistance = MathUtil.clamp(thisMove.zAllowedDistance, (double)-0.15f, (double)0.15f);
            }
            if (TrigUtil.lengthSquared(data.nextStuckInBlockHorizontal, data.nextStuckInBlockVertical, data.nextStuckInBlockHorizontal) > 1.0E-7) {
                thisMove.xAllowedDistance *= data.nextStuckInBlockHorizontal;
                thisMove.zAllowedDistance *= data.nextStuckInBlockHorizontal;
            }
            if (lastMove.slowedByUsingAnItem && !thisMove.slowedByUsingAnItem && thisMove.isRiptiding) {
                Vector propellingForce = to.getTridentPropellingForce(lastMove.touchedGround);
                thisMove.xAllowedDistance += propellingForce.getX();
                thisMove.zAllowedDistance += propellingForce.getZ();
            }
            if (!player.isFlying() && pData.isShiftKeyPressed() && from.isAboveGround() && thisMove.yDistance <= 0.0) {
                Vector backOff = from.maybeBackOffFromEdge(new Vector(thisMove.xAllowedDistance, thisMove.yDistance, thisMove.zAllowedDistance));
                thisMove.xAllowedDistance = backOff.getX();
                thisMove.zAllowedDistance = backOff.getZ();
            }
            thisMove.collideX = thisMove.xAllowedDistance != (collisionVector = from.collide(new Vector(thisMove.xAllowedDistance, thisMove.yDistance, thisMove.zAllowedDistance), onGround, from.getBoundingBox())).getX();
            thisMove.collideZ = thisMove.zAllowedDistance != collisionVector.getZ();
            thisMove.collidesHorizontally = thisMove.collideX || thisMove.collideZ;
            thisMove.xAllowedDistance = collisionVector.getX();
            thisMove.zAllowedDistance = collisionVector.getZ();
            boolean bl = thisMove.negligibleHorizontalCollision = thisMove.collidesHorizontally && CollisionUtil.isHorizontalCollisionNegligible(new Vector(thisMove.xAllowedDistance, thisMove.yDistance, thisMove.zAllowedDistance), to, input.getStrafe(), input.getForward());
            if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_20)) {
                pData.setSupportingBlockData(SupportingBlockUtils.checkSupportingBlock(from.getBlockCache(), player, pData.getSupportingBlockData(), new Vector(thisMove.xAllowedDistance, thisMove.yAllowedDistance, thisMove.zAllowedDistance), from.getBoundingBox(), onGround));
            }
            MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
            if (cc.trackBlockMove) {
                if (from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, thisMove.xAllowedDistance < 0.0 ? BlockChangeTracker.Direction.X_NEG : BlockChangeTracker.Direction.X_POS, 0.05)) {
                    thisMove.xAllowedDistance = thisMove.xDistance;
                }
                if (from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, thisMove.zAllowedDistance < 0.0 ? BlockChangeTracker.Direction.Z_NEG : BlockChangeTracker.Direction.Z_POS, 0.05)) {
                    thisMove.zAllowedDistance = thisMove.zDistance;
                }
            }
            thisMove.hasImpulse = AlmostBoolean.match(input.getForwardDir() != InputDirection.ForwardDirection.NONE || input.getStrafeDir() != InputDirection.StrafeDirection.NONE);
            thisMove.strafeImpulse = input.getStrafeDir();
            thisMove.forwardImpulse = input.getForwardDir();
            if (debug) {
                player.sendMessage("[SurvivalFly] (postPredict) Direction: " + (Object)((Object)input.getForwardDir()) + " | " + (Object)((Object)input.getStrafeDir()));
            }
            return isPredictable;
        }
        float sinYaw = TrigUtil.sin(to.getYaw() * ((float)Math.PI / 180));
        float cosYaw = TrigUtil.cos(to.getYaw() * ((float)Math.PI / 180));
        double[] xTheoreticalDistance = new double[9];
        boolean[] collideX = new boolean[9];
        double[] zTheoreticalDistance = new double[9];
        boolean[] collideZ = new boolean[9];
        for (i = 0; i < 9; ++i) {
            xTheoreticalDistance[i] = thisMove.xAllowedDistance;
            zTheoreticalDistance[i] = thisMove.zAllowedDistance;
            double inputSq = MathUtil.square(theorInputs[i].getStrafe()) + MathUtil.square(theorInputs[i].getForward());
            if (!(inputSq >= 1.0E-7)) continue;
            if (inputSq > 1.0) {
                double inputForce = Math.sqrt(inputSq);
                if (inputForce < 1.0E-4) {
                    theorInputs[i].operationToInt(0.0, 0.0, 0);
                } else {
                    theorInputs[i].operationToInt(inputForce, inputForce, 2);
                }
            }
            theorInputs[i].operationToInt(movementSpeed, movementSpeed, 1);
            int n = i;
            xTheoreticalDistance[n] = xTheoreticalDistance[n] + ((double)theorInputs[i].getStrafe() * (double)cosYaw - (double)theorInputs[i].getForward() * (double)sinYaw);
            int n2 = i;
            zTheoreticalDistance[n2] = zTheoreticalDistance[n2] + ((double)theorInputs[i].getForward() * (double)cosYaw + (double)theorInputs[i].getStrafe() * (double)sinYaw);
        }
        if (from.isOnClimbable() && !from.isInLiquid()) {
            for (i = 0; i < 9; ++i) {
                xTheoreticalDistance[i] = MathUtil.clamp(xTheoreticalDistance[i], (double)-0.15f, (double)0.15f);
                zTheoreticalDistance[i] = MathUtil.clamp(zTheoreticalDistance[i], (double)-0.15f, (double)0.15f);
            }
        }
        if (TrigUtil.lengthSquared(data.nextStuckInBlockHorizontal, data.nextStuckInBlockVertical, data.nextStuckInBlockHorizontal) > 1.0E-7) {
            i = 0;
            while (i < 9) {
                int n = i;
                xTheoreticalDistance[n] = xTheoreticalDistance[n] * data.nextStuckInBlockHorizontal;
                int n3 = i++;
                zTheoreticalDistance[n3] = zTheoreticalDistance[n3] * data.nextStuckInBlockHorizontal;
            }
        }
        if (lastMove.slowedByUsingAnItem && !thisMove.slowedByUsingAnItem && thisMove.isRiptiding) {
            Vector propellingForce = to.getTridentPropellingForce(lastMove.touchedGround);
            i = 0;
            while (i < 9) {
                int n = i;
                xTheoreticalDistance[n] = xTheoreticalDistance[n] + propellingForce.getX();
                int n4 = i++;
                zTheoreticalDistance[n4] = zTheoreticalDistance[n4] + propellingForce.getZ();
            }
        }
        if (!player.isFlying() && pData.isShiftKeyPressed() && from.isAboveGround() && thisMove.yDistance <= 0.0) {
            for (i = 0; i < 9; ++i) {
                Vector backOff = from.maybeBackOffFromEdge(new Vector(xTheoreticalDistance[i], thisMove.yDistance, zTheoreticalDistance[i]));
                xTheoreticalDistance[i] = backOff.getX();
                zTheoreticalDistance[i] = backOff.getZ();
            }
        }
        for (i = 0; i < 9; ++i) {
            Vector collisionVector = from.collide(new Vector(xTheoreticalDistance[i], thisMove.yDistance, zTheoreticalDistance[i]), onGround, from.getBoundingBox());
            if (xTheoreticalDistance[i] != collisionVector.getX()) {
                collideX[i] = true;
            }
            if (zTheoreticalDistance[i] != collisionVector.getZ()) {
                collideZ[i] = true;
            }
            xTheoreticalDistance[i] = collisionVector.getX();
            zTheoreticalDistance[i] = collisionVector.getZ();
        }
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        if (cc.trackBlockMove) {
            for (i = 0; i < 9; ++i) {
                if (!from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, xTheoreticalDistance[i] < 0.0 ? BlockChangeTracker.Direction.X_NEG : BlockChangeTracker.Direction.X_POS, 0.05)) continue;
                xTheoreticalDistance[i] = thisMove.xDistance;
            }
            for (i = 0; i < 9; ++i) {
                if (!from.matchBlockChange(this.blockChangeTracker, data.blockChangeRef, zTheoreticalDistance[i] < 0.0 ? BlockChangeTracker.Direction.Z_NEG : BlockChangeTracker.Direction.Z_POS, 0.05)) continue;
                zTheoreticalDistance[i] = thisMove.zDistance;
            }
        }
        boolean found = false;
        boolean strict = cc.survivalFlyStrictHorizontal;
        for (i = 0; i < 9; ++i) {
            if (strict) {
                if (MathUtil.almostEqual(thisMove.xDistance, xTheoreticalDistance[i], 1.0E-4) && MathUtil.almostEqual(thisMove.zDistance, zTheoreticalDistance[i], 1.0E-4)) {
                    found = true;
                }
            } else {
                double theoreticalHDistance = MathUtil.dist(xTheoreticalDistance[i], zTheoreticalDistance[i]);
                if (MathUtil.almostEqual(theoreticalHDistance, thisMove.hDistance, 1.0E-4)) {
                    found = true;
                }
            }
            boolean forceViolation = false;
            if (!found) continue;
            if (pData.isSprinting() && ((theorInputs[i].getForwardDir().equals((Object)InputDirection.ForwardDirection.BACKWARD) || theorInputs[i].getStrafeDir().equals((Object)InputDirection.StrafeDirection.RIGHT) || theorInputs[i].getStrafeDir().equals((Object)InputDirection.StrafeDirection.LEFT)) && !theorInputs[i].getForwardDir().equals((Object)InputDirection.ForwardDirection.FORWARD) || player.getFoodLevel() <= 5)) {
                tags.add("illegalsprint");
                pData.setSprintingState(false);
                Improbable.check(player, (float)thisMove.hDistance, System.currentTimeMillis(), "moving.survivalfly.illegalsprint", pData);
                forceViolation = true;
            }
            if (forceViolation) continue;
            thisMove.collideX = collideX[i];
            thisMove.collideZ = collideZ[i];
            thisMove.collidesHorizontally = thisMove.collideX || thisMove.collideZ;
            boolean bl = thisMove.negligibleHorizontalCollision = thisMove.collidesHorizontally && CollisionUtil.isHorizontalCollisionNegligible(new Vector(xTheoreticalDistance[i], thisMove.yDistance, zTheoreticalDistance[i]), to, theorInputs[i].getStrafe(), theorInputs[i].getForward());
            if (!pData.getClientVersion().isAtLeast(ClientVersion.V_1_20)) break;
            pData.setSupportingBlockData(SupportingBlockUtils.checkSupportingBlock(from.getBlockCache(), player, pData.getSupportingBlockData(), new Vector(xTheoreticalDistance[i], thisMove.yAllowedDistance, zTheoreticalDistance[i]), from.getBoundingBox(), onGround));
            break;
        }
        int indexPair = i;
        int xIdx = -1;
        int zIdx = -1;
        if (indexPair >= 9) {
            indexPair = 4;
        }
        if (!isPredictable) {
            xIdx = MathUtil.findClosestIndex(xTheoreticalDistance, thisMove.xDistance);
            zIdx = MathUtil.findClosestIndex(zTheoreticalDistance, thisMove.zDistance);
        }
        thisMove.xAllowedDistance = xTheoreticalDistance[!isPredictable ? xIdx : indexPair];
        thisMove.zAllowedDistance = zTheoreticalDistance[!isPredictable ? zIdx : indexPair];
        thisMove.hasImpulse = !isPredictable ? AlmostBoolean.MAYBE : AlmostBoolean.match(theorInputs[indexPair].getForwardDir() != InputDirection.ForwardDirection.NONE || theorInputs[indexPair].getStrafeDir() != InputDirection.StrafeDirection.NONE);
        thisMove.strafeImpulse = theorInputs[isPredictable ? indexPair : xIdx].getStrafeDir();
        thisMove.forwardImpulse = theorInputs[isPredictable ? indexPair : zIdx].getForwardDir();
        if (debug) {
            player.sendMessage("[SurvivalFly] (postPredict) " + (!isPredictable ? "Uncertain" : "Predicted") + " direction: " + (Object)((Object)theorInputs[isPredictable ? indexPair : xIdx].getForwardDir()) + " | " + (Object)((Object)theorInputs[isPredictable ? indexPair : xIdx].getStrafeDir()));
        }
        return isPredictable;
    }

    private double handleUnpredictableMove(PlayerMoveData thisMove, boolean strict) {
        double hDistanceAboveLimit = 0.0;
        double offset = thisMove.hDistance - thisMove.hAllowedDistance;
        if (strict) {
            if (MathUtil.exceedsAllowedDistance(thisMove.xDistance, thisMove.xAllowedDistance) || MathUtil.exceedsAllowedDistance(thisMove.zDistance, thisMove.zAllowedDistance)) {
                hDistanceAboveLimit = Math.max(hDistanceAboveLimit, offset);
            }
        } else if (thisMove.hDistance > thisMove.hAllowedDistance) {
            hDistanceAboveLimit = Math.max(hDistanceAboveLimit, offset);
        }
        return hDistanceAboveLimit;
    }

    private double handlePredictableMove(PlayerMoveData thisMove, boolean strict) {
        double hDistanceAboveLimit = 0.0;
        double offset = thisMove.hDistance - thisMove.hAllowedDistance;
        if (strict) {
            if (!MathUtil.isOffsetWithinPredictionEpsilon(thisMove.xDistance, thisMove.xAllowedDistance) || !MathUtil.isOffsetWithinPredictionEpsilon(thisMove.zDistance, thisMove.zAllowedDistance)) {
                hDistanceAboveLimit = Math.max(hDistanceAboveLimit, offset);
            }
        } else if (!MathUtil.isOffsetWithinPredictionEpsilon(thisMove.hDistance, thisMove.hAllowedDistance)) {
            hDistanceAboveLimit = Math.max(hDistanceAboveLimit, offset);
        }
        return hDistanceAboveLimit;
    }

    private double[] vDistRel(long now, Player player, PlayerLocation from, boolean fromOnGround, boolean resetFrom, PlayerLocation to, boolean toOnGround, boolean resetTo, double yDistance, boolean isNormalOrPacketSplitMove, PlayerMoveData lastMove, MovingData data, MovingConfig cc, IPlayerData pData, boolean forceResetMomentum, boolean debug) {
        double offset;
        Vector fluidFallingAdjustMovement;
        boolean fullyInAir;
        double yDistanceAboveLimit = 0.0;
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        boolean yDirectionSwitch = lastMove.toIsValid && lastMove.yDistance != yDistance && (yDistance <= 0.0 && lastMove.yDistance >= 0.0 || yDistance >= 0.0 && lastMove.yDistance <= 0.0);
        boolean bl = fullyInAir = !thisMove.touchedGroundWorkaround && !resetFrom && !resetTo;
        if (SfLegacy.checkOnChangeOfYDirection(this.tags, now, player, yDistance, lastMove, data, pData, fullyInAir, yDirectionSwitch, thisMove)) {
            Improbable.check(player, 1.0f, System.currentTimeMillis(), "moving.survivalfly.airjump", pData);
            yDistanceAboveLimit = Math.max(1.0, thisMove.yDistance);
            thisMove.yAllowedDistance = 0.0;
            return new double[]{thisMove.yAllowedDistance, yDistanceAboveLimit};
        }
        if (thisMove.yDistance == 0.0 && fromOnGround) {
            thisMove.yAllowedDistance = 0.0;
            yDistanceAboveLimit = 0.0;
            this.tags.add("onground_env");
            return new double[]{thisMove.yAllowedDistance, yDistanceAboveLimit};
        }
        if (PhysicsEnvelope.isStepUpByNCPDefinition(pData, fromOnGround, toOnGround, player)) {
            thisMove.yAllowedDistance = thisMove.yDistance;
            yDistanceAboveLimit = 0.0;
            thisMove.isStepUp = true;
            this.tags.add("step_env");
            return new double[]{thisMove.yAllowedDistance, yDistanceAboveLimit};
        }
        if (PhysicsEnvelope.isJumpMotion(from, to, player, fromOnGround, toOnGround)) {
            thisMove.yAllowedDistance = thisMove.yDistance;
            yDistanceAboveLimit = 0.0;
            thisMove.isJump = true;
            thisMove.isSpaceBarImpulse = true;
            data.jumpDelay = 10;
            this.tags.add("jump_env");
            return new double[]{thisMove.yAllowedDistance, yDistanceAboveLimit};
        }
        double[] yTheoreticalDistance = null;
        boolean[] collideLiquidY = null;
        double d = thisMove.yAllowedDistance = forceResetMomentum || lastMove.yDistance < 0.0 && fromOnGround || !lastMove.toIsValid ? 0.0 : lastMove.yDistance;
        if (!pData.isShiftKeyPressed() && lastMove.collideY && lastMove.yAllowedDistance < 0.0 && lastMove.to.onBouncyBlock) {
            thisMove.yAllowedDistance = lastMove.to.onSlimeBlock ? -thisMove.yAllowedDistance : -thisMove.yAllowedDistance * 0.66;
            this.tags.add("bounceup");
        }
        Vector bubbleVector = from.tryApplyBubbleColumnMotion(new Vector(0.0, thisMove.yAllowedDistance, 0.0));
        thisMove.yAllowedDistance = bubbleVector.getY();
        if (from.isSlidingDown()) {
            thisMove.yAllowedDistance = -0.05f;
        }
        if (TrigUtil.lengthSquared(data.lastStuckInBlockHorizontal, data.lastStuckInBlockVertical, data.lastStuckInBlockHorizontal) > 1.0E-7 && data.lastStuckInBlockVertical != 1.0) {
            thisMove.yAllowedDistance = 0.0;
        }
        data.nextGravity = this.attributeAccess.getHandle().getGravity(player);
        if (lastMove.from.inWater) {
            if (lastMove.collidesHorizontally && lastMove.from.onClimbable && pData.getClientVersion().isAtLeast(ClientVersion.V_1_14)) {
                thisMove.yAllowedDistance = 0.2;
            }
            thisMove.yAllowedDistance *= data.lastFrictionVertical;
            this.tags.add("v_water");
        } else if (lastMove.from.inLava) {
            if (data.lastFrictionVertical != 0.5) {
                thisMove.yAllowedDistance *= data.lastFrictionVertical;
                fluidFallingAdjustMovement = from.getFluidFallingAdjustedMovement(data.lastGravity, thisMove.yAllowedDistance <= 0.0, new Vector(0.0, thisMove.yAllowedDistance, 0.0), lastMove.isSprinting);
                thisMove.yAllowedDistance = fluidFallingAdjustMovement.getY();
            } else {
                thisMove.yAllowedDistance *= data.lastFrictionVertical;
            }
            if (data.lastGravity != 0.0) {
                thisMove.yAllowedDistance += -data.lastGravity / 4.0;
            }
            this.tags.add("v_lava");
        } else {
            PlayerMoveData secondLastMove = data.playerMoves.getSecondPastMove();
            if ((lastMove.collidesHorizontally || lastMove.isSpaceBarImpulse && BridgeMisc.isSpaceBarImpulseKnown(player) || lastMove.yDistance > 0.0 && secondLastMove.yDistance >= 0.0 && !BridgeMisc.isSpaceBarImpulseKnown(player)) && (lastMove.from.onClimbable || BlockProperties.isPowderSnow(from.getBlockType()) && BridgeMisc.canStandOnPowderSnow(player))) {
                thisMove.yAllowedDistance = 0.2;
            }
            thisMove.yAllowedDistance = lastMove.hasLevitation ? (thisMove.yAllowedDistance += (0.05 * data.lastLevitationLevel - lastMove.yAllowedDistance) * 0.2) : (thisMove.yAllowedDistance -= data.lastGravity);
            thisMove.yAllowedDistance *= data.lastFrictionVertical;
            this.tags.add("v_air");
        }
        if (lastMove.from.inWater) {
            fluidFallingAdjustMovement = from.getFluidFallingAdjustedMovement(data.lastGravity, lastMove.yAllowedDistance <= 0.0, new Vector(0.0, thisMove.yAllowedDistance, 0.0), lastMove.isSprinting);
            thisMove.yAllowedDistance = fluidFallingAdjustMovement.getY();
        }
        if (lastMove.from.inLiquid && lastMove.collidesHorizontally && from.isUnobstructed()) {
            thisMove.yAllowedDistance = 0.3;
            this.tags.add("v_exiting_liquid");
        }
        this.checkNegligibleMomentumVertical(pData, thisMove);
        if (!from.isInLiquid() && from.isOnClimbable()) {
            thisMove.yAllowedDistance = Math.max(thisMove.yAllowedDistance, (double)-0.15f);
            if (thisMove.yAllowedDistance < 0.0 && pData.isShiftKeyPressed() && from.getEntity() instanceof Player && (!BlockProperties.isScaffolding(from.getBlockType()) || !pData.getClientVersion().isAtLeast(ClientVersion.V_1_14))) {
                thisMove.yAllowedDistance = 0.0;
            }
            this.tags.add("v_climbable");
        }
        if (from.isInLiquid()) {
            double fluidJumpThreshold;
            if (pData.isShiftKeyPressed() && from.isInWater()) {
                thisMove.yAllowedDistance -= 0.04;
            }
            if (BridgeMisc.isSpaceBarImpulseKnown(player)) {
                if (player.getCurrentInput().isJump()) {
                    boolean isSubmergedInWater = from.isInWater() && thisMove.submergedWaterHeight > 0.0;
                    double d2 = fluidJumpThreshold = from.getEyeHeight() < 0.4 ? 0.0 : 0.4;
                    if (isSubmergedInWater && (!from.isOnGround() || thisMove.submergedWaterHeight > fluidJumpThreshold)) {
                        thisMove.yAllowedDistance += 0.04;
                    } else if (from.isInLava() && (!from.isOnGround() || thisMove.submergedLavaHeight > fluidJumpThreshold)) {
                        thisMove.yAllowedDistance += 0.04;
                    } else if ((from.isOnGround() || isSubmergedInWater && thisMove.submergedWaterHeight <= fluidJumpThreshold) && data.jumpDelay == 0) {
                        thisMove.yAllowedDistance = data.liftOffEnvelope.getJumpGain(data.jumpAmplifier) * this.attributeAccess.getHandle().getJumpGainMultiplier(player);
                        data.jumpDelay = 10;
                        thisMove.hasImpulse = AlmostBoolean.YES;
                        thisMove.isJump = true;
                    }
                } else {
                    data.jumpDelay = 0;
                }
                if (thisMove.hasGravity && pData.getClientVersion().isLowerThan(ClientVersion.V_1_13)) {
                    thisMove.yAllowedDistance -= 0.02;
                }
                if (thisMove.isSwimming && from.getEntity() instanceof Player) {
                    double swimmingScalar;
                    Vector lookVector = TrigUtil.getLookingDirection(to, player);
                    double d3 = swimmingScalar = lookVector.getY() < -0.2 ? 0.085 : 0.06;
                    if (lookVector.getY() <= 0.0 || player.getCurrentInput().isJump() || BlockProperties.getLiquidHeightAt(from.getBlockCache(), Location.locToBlock((double)from.getX()), Location.locToBlock((double)(from.getY() + 1.0 - 0.1)), Location.locToBlock((double)from.getZ()), BlockFlags.F_WATER, true) != 0.0) {
                        thisMove.yAllowedDistance += (lookVector.getY() - thisMove.yAllowedDistance) * swimmingScalar;
                    }
                }
            } else {
                yTheoreticalDistance = new double[3];
                collideLiquidY = new boolean[3];
                yTheoreticalDistance[0] = thisMove.yAllowedDistance;
                yTheoreticalDistance[1] = thisMove.yAllowedDistance;
                yTheoreticalDistance[2] = thisMove.yAllowedDistance;
                boolean isSubmergedInWater = from.isInWater() && thisMove.submergedWaterHeight > 0.0;
                double d4 = fluidJumpThreshold = from.getEyeHeight() < 0.4 ? 0.0 : 0.4;
                if (isSubmergedInWater && (!from.isOnGround() || thisMove.submergedWaterHeight > fluidJumpThreshold)) {
                    yTheoreticalDistance[0] = yTheoreticalDistance[0] + 0.04;
                } else if (from.isInLava() && (!from.isOnGround() || thisMove.submergedLavaHeight > fluidJumpThreshold)) {
                    yTheoreticalDistance[0] = yTheoreticalDistance[0] + 0.04;
                } else if ((from.isOnGround() || isSubmergedInWater && thisMove.submergedWaterHeight <= fluidJumpThreshold) && data.jumpDelay == 0) {
                    yTheoreticalDistance[0] = data.liftOffEnvelope.getJumpGain(data.jumpAmplifier) * this.attributeAccess.getHandle().getJumpGainMultiplier(player);
                    data.jumpDelay = 10;
                    thisMove.hasImpulse = AlmostBoolean.YES;
                }
                if (BridgeMisc.hasGravity((LivingEntity)player) && pData.getClientVersion().isLowerThan(ClientVersion.V_1_13)) {
                    yTheoreticalDistance[0] = yTheoreticalDistance[0] - 0.02;
                    yTheoreticalDistance[1] = yTheoreticalDistance[1] - 0.02;
                }
                if (thisMove.isSwimming && !player.isInsideVehicle()) {
                    Vector lookVector = TrigUtil.getLookingDirection(to, player);
                    double swimmingScalar = lookVector.getY() < -0.2 ? 0.085 : 0.06;
                    yTheoreticalDistance[0] = yTheoreticalDistance[0] + (lookVector.getY() - yTheoreticalDistance[0]) * swimmingScalar;
                    yTheoreticalDistance[1] = yTheoreticalDistance[1] + (lookVector.getY() - yTheoreticalDistance[1]) * swimmingScalar;
                }
            }
        }
        if (TrigUtil.lengthSquared(data.nextStuckInBlockHorizontal, data.nextStuckInBlockVertical, data.nextStuckInBlockHorizontal) > 1.0E-7) {
            if (yTheoreticalDistance != null) {
                int i = 0;
                while (i < yTheoreticalDistance.length) {
                    int n = i++;
                    yTheoreticalDistance[n] = yTheoreticalDistance[n] * data.nextStuckInBlockVertical;
                }
            } else {
                thisMove.yAllowedDistance *= data.nextStuckInBlockVertical;
            }
        }
        if (lastMove.slowedByUsingAnItem && !thisMove.slowedByUsingAnItem && thisMove.isRiptiding) {
            Vector riptideForce = to.getTridentPropellingForce(from.isOnGround());
            if (yTheoreticalDistance != null) {
                int i = 0;
                while (i < yTheoreticalDistance.length) {
                    int n = i++;
                    yTheoreticalDistance[n] = yTheoreticalDistance[n] + riptideForce.getY();
                }
            } else {
                thisMove.yAllowedDistance += riptideForce.getY();
            }
            if (debug) {
                player.sendMessage("Trident propel(v): " + StringUtil.fdec6.format(thisMove.yDistance) + " / " + StringUtil.fdec6.format(thisMove.yAllowedDistance));
            }
        }
        if (yTheoreticalDistance == null) {
            Vector collisionVector = from.collide(new Vector(thisMove.xAllowedDistance, thisMove.yAllowedDistance, thisMove.zAllowedDistance), fromOnGround || thisMove.touchedGroundWorkaround, from.getBoundingBox());
            thisMove.headObstructed = thisMove.yAllowedDistance != collisionVector.getY() && thisMove.yDistance >= 0.0 && from.seekCollisionAbove() && !fromOnGround;
            boolean bl2 = thisMove.collideY = collisionVector.getY() != thisMove.yAllowedDistance;
            if (lastMove.headObstructed && !thisMove.headObstructed && yDirectionSwitch && thisMove.yDistance <= 0.0 && fullyInAir) {
                thisMove.yAllowedDistance = 0.0;
                if (BridgeMisc.hasGravity((LivingEntity)player)) {
                    thisMove.yAllowedDistance -= data.nextGravity;
                }
                thisMove.yAllowedDistance *= data.nextFrictionVertical;
                this.tags.add("gravity_reiterate");
            } else {
                thisMove.yAllowedDistance = collisionVector.getY();
            }
        } else {
            for (int i = 0; i < yTheoreticalDistance.length; ++i) {
                Vector collisionVector = from.collide(new Vector(thisMove.xAllowedDistance, yTheoreticalDistance[i], thisMove.zAllowedDistance), fromOnGround || thisMove.touchedGroundWorkaround, from.getBoundingBox());
                if (yTheoreticalDistance[i] != collisionVector.getY()) {
                    collideLiquidY[i] = true;
                }
                yTheoreticalDistance[i] = collisionVector.getY();
                thisMove.headObstructed = yTheoreticalDistance[i] != collisionVector.getY() && thisMove.yDistance >= 0.0 && from.seekCollisionAbove() && !fromOnGround;
            }
        }
        if (yTheoreticalDistance != null) {
            for (int i = 0; i < yTheoreticalDistance.length; ++i) {
                if (!MathUtil.isOffsetWithinPredictionEpsilon(thisMove.yDistance, yTheoreticalDistance[i])) continue;
                thisMove.yAllowedDistance = yTheoreticalDistance[i];
                thisMove.collideY = collideLiquidY[i];
                thisMove.isSpaceBarImpulse = yTheoreticalDistance[0] == thisMove.yAllowedDistance;
                break;
            }
        }
        if (!(Math.abs(offset = thisMove.yDistance - thisMove.yAllowedDistance) < 1.0E-4)) {
            if (MagicWorkarounds.checkPostPredictWorkaround(data, fromOnGround, toOnGround, from, to, thisMove.yAllowedDistance, player, isNormalOrPacketSplitMove)) {
                thisMove.yAllowedDistance = thisMove.yDistance;
                if (debug) {
                    player.sendMessage("Workaround ID: " + (!this.justUsedWorkarounds.isEmpty() ? StringUtil.join(this.justUsedWorkarounds, " , ") : ""));
                }
            } else if (data.getOrUseVerticalVelocity(yDistance).isEmpty()) {
                yDistanceAboveLimit = Math.max(yDistanceAboveLimit, Math.abs(offset));
                this.tags.add("vdistrel");
            }
        }
        if (debug) {
            player.sendMessage("y actual/predict: " + StringUtil.fdec6.format(thisMove.yDistance) + " / " + StringUtil.fdec6.format(thisMove.yAllowedDistance));
        }
        return new double[]{thisMove.yAllowedDistance, yDistanceAboveLimit};
    }

    @Deprecated
    private double[] vDistClimbable(Player player, PlayerLocation from, PlayerLocation to, IPlayerData pData, PlayerMoveData thisMove, PlayerMoveData lastMove, double yDistance, MovingData data, MovingConfig cc) {
        boolean scaffolding;
        double yDistanceAboveLimit = 0.0;
        double yDistAbs = Math.abs(yDistance);
        double maxJumpGain = data.liftOffEnvelope.getJumpGain(data.jumpAmplifier) + 1.0E-4;
        boolean waterStep = lastMove.from.inLiquid && yDistAbs < PhysicsEnvelope.swimBaseSpeedV(Bridge1_13.hasIsSwimming());
        boolean bl = scaffolding = from.isOnGround() && from.getBlockY() == Location.locToBlock((double)from.getY()) && yDistance > 0.0 && yDistance < maxJumpGain;
        double yAllowedDistance = waterStep || scaffolding ? yDistAbs : (yDistance < 0.0 ? 0.151 : 0.119);
        double maxJumpHeight = LiftOffEnvelope.NORMAL.getMaxJumpHeight(0.0) + (data.jumpAmplifier > 0.0 ? 0.6 + data.jumpAmplifier - 1.0 : 0.0);
        if (yDistAbs > yAllowedDistance) {
            if (from.isOnGround(BlockFlags.F_CLIMBABLE) && to.isOnGround(BlockFlags.F_CLIMBABLE)) {
                yDistanceAboveLimit = Math.max(yDistanceAboveLimit, yDistAbs - cc.sfStepHeight);
                this.tags.add("climbstep");
            } else if (from.isOnGround(maxJumpHeight, 0.0, 0.0, BlockFlags.F_CLIMBABLE)) {
                if (yDistance > maxJumpGain) {
                    yDistanceAboveLimit = Math.max(yDistanceAboveLimit, yDistAbs - yAllowedDistance);
                    Improbable.check(player, (float)yDistAbs, System.currentTimeMillis(), "moving.survivalfly.instantclimb", pData);
                    this.tags.add("instantclimb");
                } else {
                    this.tags.add("climbheight(" + StringUtil.fdec3.format(maxJumpHeight) + ")");
                }
            } else {
                yDistanceAboveLimit = Math.max(yDistanceAboveLimit, yDistAbs - yAllowedDistance);
                this.tags.add("climbspeed");
            }
        }
        if (yDistance > 0.0 && !thisMove.touchedGround && !from.canClimbUp(maxJumpHeight)) {
            yDistanceAboveLimit = Math.max(yDistanceAboveLimit, yDistance);
            yAllowedDistance = 0.0;
            this.tags.add("climbdetached");
        }
        if (yDistanceAboveLimit > 0.0 && thisMove.yDistance > 0.0 && lastMove.yDistance - 0.07289999999999999 > thisMove.yDistance) {
            yDistanceAboveLimit = 0.0;
            yAllowedDistance = yDistance;
            this.tags.add("vfrict_climb");
        }
        if (yDistanceAboveLimit > 0.0 && !data.getOrUseVerticalVelocity(yDistance).isEmpty()) {
            yDistanceAboveLimit = 0.0;
        }
        return new double[]{yAllowedDistance, yDistanceAboveLimit};
    }

    private double[] vDistAfterFailure(Player player, IPlayerData pData, MovingData data, boolean fromOnGround, boolean toOnGround, PlayerLocation from, PlayerLocation to, boolean isNormalOrPacketSplitMove, boolean resetFrom, boolean resetTo, PlayerMoveData thisMove, PlayerMoveData lastMove, double yDistanceAboveLimit, double yAllowedDistance, boolean useBlockChangeTracker, boolean debug) {
        double[] res;
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        if (useBlockChangeTracker && (res = this.getVerticalBlockMoveResult(thisMove.yDistance, from, to, data)) != null) {
            yAllowedDistance = res[0];
            yDistanceAboveLimit = res[1];
            return new double[]{yAllowedDistance, yDistanceAboveLimit};
        }
        if (Bridge1_9.isGliding((LivingEntity)player) || Bridge1_13.isRiptiding((LivingEntity)player) || from.isInLiquid() || from.isOnClimbable()) {
            return new double[]{yAllowedDistance, yDistanceAboveLimit};
        }
        if (!thisMove.couldStepUp && thisMove.yDistance < 0.0 && yDistanceAboveLimit > 0.0 && (lastMove.toLostGround || lastMove.to.onGround) && !thisMove.from.onGround) {
            res = this.vDistRel(System.currentTimeMillis(), player, from, fromOnGround, resetFrom, to, toOnGround, resetTo, thisMove.yDistance, isNormalOrPacketSplitMove, lastMove, data, cc, pData, true, debug);
            yAllowedDistance = res[0];
            yDistanceAboveLimit = res[1];
        }
        return new double[]{yAllowedDistance, yDistanceAboveLimit};
    }

    private double[] hDistAfterFailure(Player player, PlayerLocation from, PlayerLocation to, double hAllowedDistance, double hDistanceAboveLimit, PlayerMoveData thisMove, PlayerMoveData lastMove, boolean debug, MovingData data, MovingConfig cc, IPlayerData pData, int tick, boolean useBlockChangeTracker, boolean fromOnGround, boolean toOnGround, boolean isNormalOrPacketSplitMove) {
        double[] res;
        if (cc.survivalFlyResetItem && BridgeMisc.isUsingItem(player) && !Bridge1_9.isGliding((LivingEntity)player)) {
            pData.requestItemUseResync();
            this.tags.add("itemresync");
            if (!BridgeMisc.isUsingItem(player) && hDistanceAboveLimit > 0.0) {
                res = this.prepareSpeedEstimation(from, to, pData, player, data, thisMove, lastMove, fromOnGround, toOnGround, debug, isNormalOrPacketSplitMove, false, false);
                hAllowedDistance = res[0];
                hDistanceAboveLimit = res[1];
            }
        }
        if ((thisMove.touchedGroundWorkaround || lastMove.toIsValid && lastMove.yDistance <= 0.0 && lastMove.touchedGroundWorkaround) && hDistanceAboveLimit > 0.0) {
            res = this.prepareSpeedEstimation(from, to, pData, player, data, thisMove, lastMove, fromOnGround, toOnGround, debug, isNormalOrPacketSplitMove, true, false);
            hAllowedDistance = res[0];
            hDistanceAboveLimit = res[1];
        }
        if (PhysicsEnvelope.isVerticallyConstricted(from, to, pData) && hDistanceAboveLimit > 0.0) {
            res = this.prepareSpeedEstimation(from, to, pData, player, data, thisMove, lastMove, fromOnGround, toOnGround, debug, isNormalOrPacketSplitMove, false, true);
            hAllowedDistance = res[0];
            hDistanceAboveLimit = res[1];
        }
        if (useBlockChangeTracker && hDistanceAboveLimit > 0.0 && !thisMove.touchedGroundWorkaround && !from.isOnGround() && from.isOnGroundOpportune(cc.yOnGround, 0L, this.blockChangeTracker, data.blockChangeRef, tick)) {
            this.tags.add("blockchange_h");
            res = this.prepareSpeedEstimation(from, to, pData, player, data, thisMove, lastMove, fromOnGround, toOnGround, debug, isNormalOrPacketSplitMove, true, false);
            hAllowedDistance = res[0];
            hDistanceAboveLimit = res[1];
        }
        return new double[]{hAllowedDistance, hDistanceAboveLimit, 0.0};
    }

    private Location handleViolation(double result, Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        data.survivalFlyVL += result;
        data.sfVLMoveCount = data.getPlayerMoveCount();
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, result, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
            vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance(from, to)));
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
        }
        if (this.executeActions(vd).willCancel()) {
            return MovingUtil.getApplicableSetBackLocation(player, to.getYaw(), to.getPitch(), to, data, cc);
        }
        data.sfJumpPhase = 0;
        return null;
    }

    public final void handleHoverViolation(Player player, PlayerLocation loc, MovingConfig cc, MovingData data) {
        data.survivalFlyVL += cc.sfHoverViolation;
        data.sfVLMoveCount = data.getPlayerMoveCount();
        data.sfVLInAir = true;
        ViolationData vd = new ViolationData(this, player, data.survivalFlyVL, cc.sfHoverViolation, cc.survivalFlyActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", loc.getX(), loc.getY(), loc.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, "(HOVER)");
            vd.setParameter(ParameterName.DISTANCE, "0.0(HOVER)");
            vd.setParameter(ParameterName.TAGS, "hover");
        }
        if (this.executeActions(vd).willCancel()) {
            Location newTo = MovingUtil.getApplicableSetBackLocation(player, loc.getYaw(), loc.getPitch(), loc, data, cc);
            if (newTo != null) {
                data.prepareSetBack(newTo);
                SchedulerHelper.teleportEntity((Entity)player, newTo, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
            } else {
                player.kickPlayer("Hovering?");
            }
        }
    }

    private void outputDebug(Player player, PlayerLocation to, PlayerLocation from, MovingData data, double hDistance, double hAllowedDistance, double hFreedom, double yDistance, double yAllowedDistance, boolean fromOnGround, boolean resetFrom, boolean toOnGround, boolean resetTo, PlayerMoveData thisMove) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        double yDistDiffEx = yDistance - yAllowedDistance;
        double hDistDiffEx = thisMove.hDistance - thisMove.hAllowedDistance;
        StringBuilder builder = new StringBuilder(500);
        builder.append(CheckUtils.getLogMessagePrefix(player, this.type));
        String hVelUsed = hFreedom > 0.0 ? " / hVelUsed: " + StringUtil.fdec3.format(hFreedom) : "";
        builder.append("\nOnGround: " + (thisMove.headObstructed ? "(head obstr.) " : (from.isSlidingDown() ? "(sliding down) " : "")) + (thisMove.touchedGroundWorkaround ? "(lost ground) " : "") + (fromOnGround ? "onground -> " : (resetFrom ? "resetcond -> " : "--- -> ")) + (toOnGround ? "onground" : (resetTo ? "resetcond" : "---")) + ", jumpPhase: " + data.sfJumpPhase + ", LiftOff: " + data.liftOffEnvelope.name());
        String dHDist = lastMove.toIsValid ? "(" + StringUtil.formatDiff(hDistance, lastMove.hDistance) + ")" : "";
        String dYDist = lastMove.toIsValid ? "(" + StringUtil.formatDiff(yDistance, lastMove.yDistance) + ")" : "";
        builder.append("\n hDist: " + StringUtil.fdec6.format(hDistance) + dHDist + " / offset: " + hDistDiffEx + " / predicted: " + StringUtil.fdec6.format(hAllowedDistance) + hVelUsed + "\n vDist: " + StringUtil.fdec6.format(yDistance) + dYDist + " / offset: " + yDistDiffEx + " / predicted: " + StringUtil.fdec6.format(yAllowedDistance) + " , setBackY: " + (data.hasSetBack() ? data.getSetBackY() + " (jump height: " + StringUtil.fdec3.format(to.getY() - data.getSetBackY()) + " / max jump height: " + data.liftOffEnvelope.getMaxJumpHeight(data.jumpAmplifier) + ")" : "?"));
        if (lastMove.toIsValid) {
            builder.append("\n fdsq: " + StringUtil.fdec3.format(thisMove.distanceSquared / lastMove.distanceSquared));
        }
        if (!lastMove.toIsValid) {
            builder.append("\n Invalid last move (data reset)");
        }
        if (!lastMove.valid) {
            builder.append("\n Invalid last move (missing data)");
        }
        if (!thisMove.verVelUsed.isEmpty()) {
            builder.append(" , vVelUsed: " + thisMove.verVelUsed + " ");
        }
        data.addVerticalVelocity(builder);
        data.addHorizontalVelocity(builder);
        if (player.isSleeping()) {
            this.tags.add("sleeping");
        }
        if (Bridge1_9.isWearingElytra(player)) {
            this.tags.add("elytra_off");
        }
        if (!this.tags.isEmpty()) {
            builder.append("\n Tags: " + StringUtil.join(this.tags, "+"));
        }
        if (!this.justUsedWorkarounds.isEmpty()) {
            builder.append("\n Workaround ID: " + StringUtil.join(this.justUsedWorkarounds, " , "));
        }
        builder.append("\n");
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
    }

    private void logPostViolationTags(Player player) {
        this.debug(player, "SurvivalFly Post violation handling tag update:\n" + StringUtil.join(this.tags, "+"));
    }
}

