/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.LocationData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeMaterial;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.feature.TickListener;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.block.data.type.TurtleEgg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class NoFall
extends Check {
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Location useLoc2 = new Location(null, 0.0, 0.0, 0.0);
    private static final IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);

    public NoFall() {
        super(CheckType.MOVING_NOFALL);
    }

    public static double getDamage(float fallDistance, Player player) {
        return (double)fallDistance - attributeAccess.getHandle().getSafeFallDistance(player);
    }

    private void handleOnGround(Player player, double y, double previousSetBackY, boolean reallyOnGround, MovingData data, MovingConfig cc, IPlayerData pData) {
        float fallDist = this.getAndRunFallDistanceDependentTasks(player, y, previousSetBackY, data);
        double maxDamage = NoFall.getDamage(fallDist, player);
        if ((maxDamage = NoFall.applyFeatherFalling(player, NoFall.applyBlockDamageModifier(player, data, maxDamage), ((MCAccess)this.mcAccess.getHandle()).dealFallDamageFiresAnEvent().decide()) * attributeAccess.getHandle().getFallDamageMultiplier(player)) >= 0.5) {
            if (cc.noFallSkipAllowFlight && player.getAllowFlight()) {
                data.clearNoFallData();
                data.noFallSkipAirCheck = true;
            } else {
                if (pData.isDebugActive(this.type)) {
                    this.debug(player, "NoFall deal damage" + (reallyOnGround ? "" : "violation") + ": " + maxDamage);
                }
                data.noFallSkipAirCheck = true;
                this.dealFallDamage(player, maxDamage);
            }
        } else {
            data.clearNoFallData();
            player.setFallDistance(0.0f);
        }
    }

    private float getAndRunFallDistanceDependentTasks(Player player, double y, double previousSetBackY, MovingData data) {
        Block fallenOnBlock;
        float fallDist = (float)NoFall.getApplicableFallHeight(player, y, previousSetBackY, data);
        Block block = player.getLocation(this.useLoc2).subtract(0.0, 1.0, 0.0).getBlock();
        IPlayerData pData = DataManager.getPlayerData(player);
        if (block.getType() == BridgeMaterial.FARMLAND && (double)fallDist > 0.5 && (double)ThreadLocalRandom.current().nextFloat() < (double)fallDist - 0.5) {
            BlockState newState = block.getState();
            newState.setType(Material.DIRT);
            if (this.canChangeBlock(player, block, newState, true, true, true)) {
                player.setVelocity(new Vector(player.getVelocity().getX() * -1.0, 0.062501, player.getVelocity().getZ() * -1.0));
                block.setType(Material.DIRT);
                if (pData.isDebugActive(this.type)) {
                    this.debug(player, "Apply block-state change workaround for FARMLAND.");
                }
            }
            this.useLoc2.setWorld(null);
            return fallDist;
        }
        if (Bridge1_13.hasIsSwimming() && block.getType() == Material.TURTLE_EGG && ThreadLocalRandom.current().nextInt(3) == 0) {
            TurtleEgg egg = (TurtleEgg)block.getBlockData();
            BlockState newState = block.getState();
            if (this.canChangeBlock(player, block, newState, true, false, false)) {
                if (egg.getEggs() - 1 > 0) {
                    egg.setEggs(egg.getEggs() - 1);
                } else {
                    block.setType(Material.AIR);
                }
                if (pData.isDebugActive(this.type)) {
                    this.debug(player, "Apply block-state change workaround for TURTLE_EGG.");
                }
            }
            this.useLoc2.setWorld(null);
            return fallDist;
        }
        PlayerMoveData validMove = data.playerMoves.getLatestValidMove();
        if (BridgeMisc.hasIsFrozen() && validMove != null && validMove.toIsValid && (double)fallDist > 0.0 && (fallenOnBlock = player.getWorld().getBlockAt(Location.locToBlock((double)validMove.to.getX()), Location.locToBlock((double)validMove.to.getY()), Location.locToBlock((double)validMove.to.getZ()))).getBlockData() instanceof PointedDripstone) {
            boolean isStalagmite;
            PointedDripstone dripstone = (PointedDripstone)fallenOnBlock.getBlockData();
            boolean bl = isStalagmite = dripstone.getThickness().equals((Object)PointedDripstone.Thickness.TIP) && dripstone.getVerticalDirection().equals((Object)BlockFace.UP);
            if (isStalagmite) {
                fallDist = (fallDist + 0.5f) * 2.0f;
                this.useLoc2.setWorld(null);
                if (pData.isDebugActive(this.type)) {
                    this.debug(player, "Player fell on a stalagmite: multiply the final fall distance by x2.");
                }
                return fallDist;
            }
        }
        if ((double)fallDist - attributeAccess.getHandle().getSafeFallDistance(player) > 0.0 && data.noFallCurrentLocOnWindChargeHit != null) {
            double lastImpulseY = data.noFallCurrentLocOnWindChargeHit.getY();
            data.clearWindChargeImpulse();
            fallDist = (float)(lastImpulseY < y ? 0.0 : lastImpulseY - y);
        }
        this.useLoc2.setWorld(null);
        return fallDist;
    }

    private boolean canChangeBlock(Player player, Block block, BlockState newState, boolean interact, boolean entityChangeBlock, boolean fade) {
        if (interact) {
            PlayerInteractEvent interactEvent = new PlayerInteractEvent(player, Action.PHYSICAL, null, block, BlockFace.SELF);
            Bukkit.getPluginManager().callEvent((Event)interactEvent);
            if (interactEvent.isCancelled()) {
                return false;
            }
        }
        if (entityChangeBlock) {
            if (!Bridge1_13.hasIsSwimming()) {
                Object o = ReflectionUtil.newInstance(ReflectionUtil.getConstructor(EntityChangeBlockEvent.class, Entity.class, Block.class, Material.class, Byte.TYPE), player, block, Material.DIRT, (byte)0);
                if (o instanceof EntityChangeBlockEvent) {
                    EntityChangeBlockEvent event = (EntityChangeBlockEvent)o;
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return false;
                    }
                }
            } else {
                EntityChangeBlockEvent blockEvent = new EntityChangeBlockEvent((Entity)player, block, newState.getBlockData());
                Bukkit.getPluginManager().callEvent((Event)blockEvent);
                if (blockEvent.isCancelled()) {
                    return false;
                }
            }
        }
        if (fade && Bridge1_9.hasGetItemInOffHand()) {
            BlockState newFadeState = block.getState();
            newFadeState.setType(Material.DIRT);
            BlockFadeEvent fadeEvent = new BlockFadeEvent(block, newFadeState);
            Bukkit.getPluginManager().callEvent((Event)fadeEvent);
            if (fadeEvent.isCancelled()) {
                return false;
            }
        }
        return true;
    }

    public static double applyFeatherFalling(Player player, double damage, boolean dealFallDamageFiresAnEvent) {
        int level;
        if (dealFallDamageFiresAnEvent) {
            return damage;
        }
        if (BridgeEnchant.hasFeatherFalling() && damage > 0.0 && (level = BridgeEnchant.getFeatherFallingLevel(player)) > 0) {
            int tmp = level * 3;
            if (tmp > 20) {
                tmp = 20;
            }
            return damage * (1.0 - (double)tmp / 25.0);
        }
        return damage;
    }

    public static double applyBlockDamageModifier(Player player, MovingData data, double damage) {
        PlayerMoveData validMove = data.playerMoves.getLatestValidMove();
        if (validMove != null && validMove.toIsValid) {
            Material mat = player.getWorld().getBlockAt(Location.locToBlock((double)validMove.to.getX()), Location.locToBlock((double)validMove.to.getY()), Location.locToBlock((double)validMove.to.getZ())).getType();
            if ((BlockFlags.getBlockFlags(mat) & BlockFlags.F_STICKY) != 0L) {
                return damage / 5.0;
            }
            IPlayerData pData = DataManager.getPlayerData(player);
            if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_12) && MaterialUtil.BEDS.contains(mat)) {
                return damage / 2.0;
            }
            if (pData.getClientVersion().isAtLeast(ClientVersion.V_1_9) && mat == Material.HAY_BLOCK) {
                return damage / 5.0;
            }
        }
        return damage;
    }

    private static double getApplicableFallHeight(Player player, double y, double previousSetBackY, MovingData data) {
        double correction;
        double yDistance = Math.max(data.noFallMaxY - y, (double)data.noFallFallDistance);
        if (yDistance > 0.0 && data.jumpAmplifier > 0.0 && previousSetBackY != Double.NEGATIVE_INFINITY && (correction = data.noFallMaxY - previousSetBackY) > 0.0) {
            return (float)Math.max(0.0, yDistance - correction);
        }
        return yDistance;
    }

    public static double getApplicableFallHeight(Player player, double y, MovingData data) {
        return NoFall.getApplicableFallHeight(player, y, data.hasSetBack() ? data.getSetBackY() : Double.NEGATIVE_INFINITY, data);
    }

    public boolean willDealFallDamage(Player player, double y, double previousSetBackY, MovingData data) {
        return NoFall.getDamage((float)NoFall.getApplicableFallHeight(player, y, previousSetBackY, data), player) - attributeAccess.getHandle().getSafeFallDistance(player) >= 0.5;
    }

    private void adjustFallDistance(Player player, double minY, boolean reallyOnGround, MovingData data) {
        float fallDistance;
        float noFallFallDistance = Math.max(data.noFallFallDistance, (float)(data.noFallMaxY - minY));
        if ((double)noFallFallDistance >= attributeAccess.getHandle().getSafeFallDistance(player) && (noFallFallDistance - (fallDistance = player.getFallDistance()) >= 0.5f || (double)noFallFallDistance >= attributeAccess.getHandle().getSafeFallDistance(player) && (double)fallDistance < attributeAccess.getHandle().getSafeFallDistance(player))) {
            player.setFallDistance(noFallFallDistance);
        }
        data.clearNoFallData();
        data.noFallSkipAirCheck = true;
    }

    private void dealFallDamage(final Player player, double damage) {
        if (((MCAccess)this.mcAccess.getHandle()).dealFallDamageFiresAnEvent().decide()) {
            ((MCAccess)this.mcAccess.getHandle()).dealFallDamage(player, damage);
        } else {
            final EntityDamageEvent event = BridgeHealth.getEntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.FALL, damage);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (player.getNoDamageTicks() > 0) {
                    TickListener damagePlayer = new TickListener(){

                        @Override
                        public void onTick(int tick, long timeLast) {
                            if (player.getNoDamageTicks() > 0) {
                                return;
                            }
                            player.setLastDamageCause(event);
                            ((MCAccess)NoFall.this.mcAccess.getHandle()).dealFallDamage(player, BridgeHealth.getRawDamage(event));
                            TickTask.removeTickListener(this);
                        }
                    };
                    TickTask.addTickListener(damagePlayer);
                } else {
                    player.setLastDamageCause(event);
                    ((MCAccess)this.mcAccess.getHandle()).dealFallDamage(player, BridgeHealth.getRawDamage(event));
                }
            }
        }
        player.setFallDistance(0.0f);
    }

    public void check(Player player, PlayerLocation pFrom, PlayerLocation pTo, double previousSetBackY, MovingData data, MovingConfig cc, IPlayerData pData) {
        double max;
        boolean toOnGround;
        boolean fromOnGround;
        boolean debug = pData.isDebugActive(this.type);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        LocationData from = thisMove.from;
        LocationData to = thisMove.to;
        double fromY = from.getY();
        double toY = to.getY();
        double yDiff = toY - fromY;
        double oldNFDist = data.noFallFallDistance;
        boolean fromReset = from.resetCond;
        boolean toReset = to.resetCond;
        if (yDiff < 0.0 && cc.yOnGround < cc.noFallyOnGround) {
            this.adjustYonGround(pFrom, pTo, cc.noFallyOnGround);
            fromOnGround = pFrom.isOnGround();
            toOnGround = pTo.isOnGround();
        } else {
            fromOnGround = from.onGround;
            toOnGround = to.onGround;
        }
        double minY = Math.min(fromY, toY);
        if (fromReset) {
            data.clearNoFallData();
            if (toY - fromY <= -attributeAccess.getHandle().getSafeFallDistance(player)) {
                data.noFallSkipAirCheck = true;
            }
        } else if (fromOnGround || !toOnGround && thisMove.touchedGround) {
            this.touchDown(player, minY, previousSetBackY, data, cc, pData);
            if (toY - fromY <= -attributeAccess.getHandle().getSafeFallDistance(player)) {
                data.noFallSkipAirCheck = true;
            }
        } else if (toReset) {
            data.clearNoFallData();
        } else if (toOnGround) {
            if (yDiff < 0.0) {
                data.noFallFallDistance = (float)((double)data.noFallFallDistance - yDiff);
            }
            this.touchDown(player, minY, previousSetBackY, data, cc, pData);
        }
        data.noFallMaxY = Math.max(Math.max(fromY, toY), data.noFallMaxY);
        float mcFallDistance = player.getFallDistance();
        if (!toReset && !toOnGround && yDiff < 0.0) {
            data.noFallFallDistance = (float)((double)data.noFallFallDistance - yDiff);
        } else if (cc.noFallAntiCriticals && (toReset || toOnGround || (fromReset || fromOnGround || thisMove.touchedGround) && yDiff >= 0.0) && (max = (double)Math.max(data.noFallFallDistance, mcFallDistance)) > 0.0 && max < 0.75) {
            if (debug) {
                this.debug(player, "NoFall: Reset fall distance (anticriticals): mc=" + mcFallDistance + " / nf=" + data.noFallFallDistance);
            }
            if (data.noFallFallDistance > 0.0f) {
                data.noFallFallDistance = 0.0f;
            }
            if (mcFallDistance > 0.0f) {
                player.setFallDistance(0.0f);
            }
        }
        if (debug) {
            this.debug(player, "NoFall: mc=" + mcFallDistance + " / nf=" + data.noFallFallDistance + (oldNFDist < (double)data.noFallFallDistance ? " (+" + ((double)data.noFallFallDistance - oldNFDist) + ")" : "") + " | ymax=" + data.noFallMaxY);
        }
    }

    private void touchDown(Player player, double minY, double previousSetBackY, MovingData data, MovingConfig cc, IPlayerData pData) {
        if (cc.noFallDealDamage) {
            this.handleOnGround(player, minY, previousSetBackY, true, data, cc, pData);
        } else {
            this.adjustFallDistance(player, minY, true, data);
        }
    }

    private void adjustYonGround(PlayerLocation from, PlayerLocation to, double yOnGround) {
        if (!from.isOnGround()) {
            from.setyOnGround(yOnGround);
        }
        if (!to.isOnGround()) {
            to.setyOnGround(yOnGround);
        }
    }

    public void onLeave(Player player, MovingData data, IPlayerData pData) {
        float fallDistance = player.getFallDistance();
        if (data.noFallFallDistance > fallDistance) {
            double playerY = player.getLocation(this.useLoc).getY();
            this.useLoc.setWorld(null);
            if (player.isFlying() || player.getGameMode() == GameMode.CREATIVE || player.getAllowFlight() && pData.getGenericInstance(MovingConfig.class).noFallSkipAllowFlight) {
                player.setFallDistance(0.0f);
                data.noFallFallDistance = 0.0f;
                data.noFallMaxY = playerY;
            } else {
                float yDiff = (float)(data.noFallMaxY - playerY);
                float maxDist = Math.max(yDiff, data.noFallFallDistance);
                player.setFallDistance(maxDist);
            }
        }
    }

    public void checkDamage(Player player, double y, MovingData data, IPlayerData pData) {
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        this.handleOnGround(player, y, data.hasSetBack() ? data.getSetBackY() : Double.NEGATIVE_INFINITY, false, data, cc, pData);
    }
}

