/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.net.NetStatic;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class MorePackets
extends Check {
    private final List<String> tags = new ArrayList<String>();

    public MorePackets() {
        super(CheckType.MOVING_MOREPACKETS);
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, boolean allowSetSetBack, MovingData data, MovingConfig cc, IPlayerData pData) {
        long time = System.currentTimeMillis();
        boolean debug = pData.isDebugActive(this.type);
        if (allowSetSetBack && !data.hasMorePacketsSetBack()) {
            if (data.hasSetBack()) {
                data.setMorePacketsSetBackFromSurvivalfly();
            } else {
                data.setMorePacketsSetBack(from);
            }
        }
        this.tags.clear();
        double violation = NetStatic.morePacketsCheck(data.morePacketsFreq, time, 1.0f, cc.morePacketsEPSMax, cc.morePacketsEPSIdeal, data.morePacketsBurstFreq, cc.morePacketsBurstPackets, cc.morePacketsBurstDirect, cc.morePacketsBurstEPM, this.tags);
        if (violation > 0.0) {
            data.morePacketsVL = violation;
            ViolationData vd = new ViolationData(this, player, data.morePacketsVL, violation, cc.morePacketsActions);
            if (debug || vd.needsParameters()) {
                vd.setParameter(ParameterName.PACKETS, Integer.toString(new Double(violation).intValue()));
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            if (this.executeActions(vd).willCancel()) {
                return data.hasMorePacketsSetBack() ? data.getMorePacketsSetBack() : data.getSetBack(to);
            }
        } else if (allowSetSetBack && data.getMorePacketsSetBackAge() > cc.morePacketsSetBackAge) {
            data.setMorePacketsSetBack(from);
            if (debug) {
                this.debug(player, "Update set back (morepackets) to from.");
            }
        }
        return null;
    }
}

