/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.envelope.workaround.LostGround;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.ModelFlying;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class CreativeFly
extends Check {
    private final List<String> tags = new LinkedList<String>();
    private final BlockChangeTracker blockChangeTracker;
    private IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);

    public CreativeFly() {
        super(CheckType.MOVING_CREATIVEFLY);
        this.blockChangeTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, IPlayerData pData, long time, int tick, boolean useBlockChangeTracker) {
        double[] res;
        this.tags.clear();
        boolean debug = pData.isDebugActive(this.type);
        GameMode gameMode = player.getGameMode();
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        ModelFlying model = thisMove.modelFlying;
        double yDistance = thisMove.yDistance;
        double hDistance = thisMove.hDistance;
        boolean flying = gameMode == BridgeMisc.GAME_MODE_SPECTATOR || player.isFlying();
        boolean sprinting = player.isSprinting();
        if (model.getGround()) {
            MovingUtil.prepareFullCheck(from, to, thisMove, Math.max(cc.yOnGround, cc.noFallyOnGround));
            LostGround.runLostGroundChecks(player, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, useBlockChangeTracker ? this.blockChangeTracker : null, this.tags);
        }
        double[] resH = this.hDist(player, from, to, hDistance, yDistance, sprinting, flying, thisMove, lastMove, time, model, data, cc);
        double limitH = resH[0];
        double resultH = resH[1];
        if ((resultH *= 100.0) > 0.0) {
            this.tags.add("hdist");
        }
        double limitV = 0.0;
        double resultV = 0.0;
        if (yDistance > 0.0) {
            res = this.vDistAscend(from, to, yDistance, flying, thisMove, lastMove, model, data, cc, debug);
            resultV = Math.max(resultV, res[1]);
            limitV = res[0];
        } else if (yDistance < 0.0) {
            res = this.vDistDescend(from, to, yDistance, flying, thisMove, lastMove, model, data, cc);
            resultV = Math.max(resultV, res[1]);
            limitV = res[0];
        } else {
            res = this.vDistZero(from, to, yDistance, flying, thisMove, lastMove, model, data, cc);
            resultV = Math.max(resultV, res[1]);
            limitV = res[0];
        }
        if (!(!(resultV > 0.0) || thisMove.verVelUsed.isEmpty() && data.getOrUseVerticalVelocity(yDistance).isEmpty())) {
            resultV = 0.0;
            this.tags.add("vvel");
        }
        double maximumHeight = model.getMaxHeight() + (double)player.getWorld().getMaxHeight();
        if (to.getY() > maximumHeight) {
            this.tags.add("maxheight");
        }
        if ((resultV *= 100.0) > 0.0) {
            this.tags.add("vdist");
        }
        double result = Math.max(0.0, resultH) + Math.max(0.0, resultV);
        if (debug) {
            this.outpuDebugMove(player, hDistance, limitH, yDistance, limitV, model, this.tags, data);
        }
        Location setBack = null;
        if (result > 0.0) {
            data.creativeFlyVL += result;
            ViolationData vd = new ViolationData(this, player, data.creativeFlyVL, result, cc.creativeFlyActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
                vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
                vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance(from, to)));
                if (model != null) {
                    vd.setParameter(ParameterName.MODEL, model.getId().toString());
                }
                if (!this.tags.isEmpty()) {
                    vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
                }
            }
            if (this.executeActions(vd).willCancel()) {
                setBack = data.getSetBack(to);
            }
        } else {
            if (to.getY() > maximumHeight) {
                setBack = data.getSetBack(to);
                if (debug) {
                    this.debug(player, "Maximum height exceeded, silent set-back.");
                }
            }
            if (setBack == null) {
                data.creativeFlyVL *= 0.97;
            }
        }
        if (setBack != null) {
            if (setBack.getY() > maximumHeight) {
                setBack.setY(this.getCorrectedHeight(maximumHeight, setBack.getWorld()));
                if (debug) {
                    this.debug(player, "Maximum height exceeded by set back, correct to: " + setBack.getY());
                }
            }
            data.sfJumpPhase = 0;
            return setBack;
        }
        data.setSetBack(to);
        data.sfJumpPhase = !thisMove.from.onGroundOrResetCond && !thisMove.to.onGroundOrResetCond ? ++data.sfJumpPhase : (thisMove.touchedGround && !thisMove.to.onGroundOrResetCond ? 1 : 0);
        return null;
    }

    private double[] hDist(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, boolean flying, PlayerMoveData thisMove, PlayerMoveData lastMove, long time, ModelFlying model, MovingData data, MovingConfig cc) {
        double fSpeed;
        if (model.getApplyModifiers()) {
            double speedModifier = ((MCAccess)this.mcAccess.getHandle()).getFasterMovementAmplifier(player);
            fSpeed = Double.isInfinite(speedModifier) ? 1.0 : 1.0 + 0.2 * (speedModifier + 1.0);
            if (flying) {
                fSpeed *= (double)data.flySpeed / 0.1;
                if (sprinting) {
                    fSpeed *= model.getHorizontalModSprint();
                    this.tags.add("sprint");
                }
                this.tags.add("flying");
            }
        } else {
            fSpeed = 1.0;
        }
        double limitH = model.getHorizontalModSpeed() / 100.0 * 0.6 * fSpeed;
        if (lastMove.toIsValid) {
            double frictionDist = lastMove.hDistance * 0.98;
            limitH = Math.max(frictionDist, limitH);
            this.tags.add("hfrict");
        }
        double resultH = Math.max(0.0, hDistance - limitH);
        if (model.getApplyModifiers()) {
            --data.jumpDelay;
            if (!flying && resultH > 0.0 && resultH < 0.3) {
                if (yDistance >= 0.0 && (yDistance > 0.0 && yDistance > LiftOffEnvelope.NORMAL.getJumpGain(data.jumpAmplifier) - 0.021000000000000005 || thisMove.headObstructed || lastMove.toIsValid && lastMove.headObstructed && lastMove.yDistance <= 0.0) && data.sfJumpPhase <= 1 && (thisMove.touchedGroundWorkaround || lastMove.touchedGround && !lastMove.bunnyHop) && !from.isResetCond() && !to.isResetCond()) {
                    this.tags.add("bunnyhop");
                    data.jumpDelay = 9;
                    thisMove.bunnyHop = true;
                    resultH = 0.0;
                } else if (data.jumpDelay <= 0) {
                    resultH = 0.0;
                    this.tags.add("bunnyhop");
                }
            }
        }
        return new double[]{limitH, resultH};
    }

    private double[] vDistAscend(PlayerLocation from, PlayerLocation to, double yDistance, boolean flying, PlayerMoveData thisMove, PlayerMoveData lastMove, ModelFlying model, MovingData data, MovingConfig cc, boolean debug) {
        double maxGain;
        double limitV = model.getVerticalAscendModSpeed() / 100.0 * 1.0;
        double resultV = 0.0;
        if (model.getApplyModifiers() && flying && yDistance > 0.0) {
            limitV *= (double)data.flySpeed / 0.1;
        }
        if (model.getGravity() && yDistance > limitV && lastMove.toIsValid) {
            double frictionDist = lastMove.yDistance * 0.98;
            if (!flying) {
                frictionDist -= 0.019;
            }
            if (frictionDist > limitV) {
                limitV = frictionDist;
                this.tags.add("vfrict_g");
            }
        }
        if (model.getGround() && yDistance > limitV && !thisMove.to.onGroundOrResetCond && !thisMove.from.onGroundOrResetCond && (lastMove.toIsValid && lastMove.touchedGround && (lastMove.yDistance <= 0.0 || lastMove.to.extraPropertiesValid && lastMove.to.onGround) || thisMove.touchedGroundWorkaround) && (maxGain = LiftOffEnvelope.NORMAL.getJumpGain(data.jumpAmplifier)) > limitV) {
            limitV = maxGain;
            this.tags.add("jump_gain");
        }
        if (yDistance > limitV && yDistance <= cc.sfStepHeight && (lastMove.toIsValid && lastMove.yDistance < 0.0 || from.isOnGroundOrResetCond() || thisMove.touchedGroundWorkaround) && to.isOnGround()) {
            limitV = cc.sfStepHeight;
            this.tags.add("step_up");
        }
        resultV = Math.max(0.0, yDistance - limitV);
        return new double[]{limitV, resultV};
    }

    private double[] vDistDescend(PlayerLocation from, PlayerLocation to, double yDistance, boolean flying, PlayerMoveData thisMove, PlayerMoveData lastMove, ModelFlying model, MovingData data, MovingConfig cc) {
        double limitV = 0.0;
        double resultV = 0.0;
        return new double[]{limitV, resultV};
    }

    private double[] vDistZero(PlayerLocation from, PlayerLocation to, double yDistance, boolean flying, PlayerMoveData thisMove, PlayerMoveData lastMove, ModelFlying model, MovingData data, MovingConfig cc) {
        double limitV = 0.0;
        double resultV = 0.0;
        return new double[]{limitV, resultV};
    }

    private double getCorrectedHeight(double maximumHeight, World world) {
        return Math.max(maximumHeight - 10.0, (double)world.getMaxHeight());
    }

    private void outpuDebugMove(Player player, double hDistance, double limitH, double yDistance, double limitV, ModelFlying model, List<String> tags, MovingData data) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        StringBuilder builder = new StringBuilder(350);
        String dHDist = lastMove.toIsValid ? " (" + StringUtil.formatDiff(hDistance, lastMove.hDistance) + ")" : "";
        String dYDist = lastMove.toIsValid ? " (" + StringUtil.formatDiff(yDistance, lastMove.yDistance) + ")" : "";
        builder.append("hDist: " + hDistance + dHDist + " / " + limitH + " , vDist: " + yDistance + dYDist + " / " + limitV);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        if (lastMove.toIsValid) {
            builder.append(" , fdsq: " + StringUtil.fdec3.format(thisMove.distanceSquared / lastMove.distanceSquared));
        }
        if (thisMove.verVelUsed != null) {
            builder.append(" , vVelUsed: " + thisMove.verVelUsed);
        }
        builder.append(" , model: " + model.getId());
        if (!tags.isEmpty()) {
            builder.append(" , tags: ");
            builder.append(StringUtil.join(tags, "+"));
        }
        builder.append(" , jumpphase: " + data.sfJumpPhase);
        thisMove.addExtraProperties(builder, " , ");
        this.debug(player, builder.toString());
    }
}

