/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.model.InputDirection;
import fr.neatmonster.nocheatplus.checks.moving.model.LocationData;
import fr.neatmonster.nocheatplus.checks.moving.model.ModelFlying;
import fr.neatmonster.nocheatplus.components.location.IGetLocationWithLook;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;

public class MoveData {
    public boolean valid = false;
    public final LocationData from = new LocationData();
    public boolean toIsValid = false;
    public InputDirection input = new InputDirection();
    public final LocationData to = new LocationData();
    public double xDistance;
    public double yDistance;
    public double zDistance;
    public double hDistance;
    public double distanceSquared;
    public boolean headObstructed;
    public boolean touchedGround;
    public boolean touchedGroundWorkaround;
    public boolean fromLostGround;
    public boolean toLostGround;
    public CheckType flyCheck;
    public ModelFlying modelFlying;

    private void setPositions(IGetLocationWithLook from, IGetLocationWithLook to) {
        this.from.setLocation(from);
        this.to.setLocation(to);
        this.xDistance = this.to.getX() - this.from.getX();
        this.yDistance = this.to.getY() - this.from.getY();
        this.zDistance = this.to.getZ() - this.from.getZ();
        this.hDistance = TrigUtil.xzDistance(from, (IGetPosition)to);
        this.distanceSquared = this.yDistance * this.yDistance + this.hDistance * this.hDistance;
        this.toIsValid = true;
        this.flyCheck = null;
        this.modelFlying = null;
    }

    private void setPositions(String worldName, double x, double y, double z, float yaw, float pitch) {
        this.from.setLocation(worldName, x, y, z, yaw, pitch);
        this.toIsValid = false;
    }

    protected void resetBase() {
        this.from.extraPropertiesValid = false;
        this.to.extraPropertiesValid = false;
        this.headObstructed = false;
        this.touchedGround = false;
        this.touchedGroundWorkaround = false;
        this.fromLostGround = false;
        this.toLostGround = false;
        this.valid = true;
    }

    public void set(IGetLocationWithLook from, IGetLocationWithLook to) {
        this.setPositions(from, to);
        this.resetBase();
    }

    public void set(IGetLocationWithLook loc) {
        this.setPositions(loc.getWorldName(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        this.resetBase();
    }

    public void setWithExtraProperties(RichBoundsLocation loc) {
        this.set(loc);
        this.from.setExtraProperties(loc);
        if (this.from.onGround) {
            this.touchedGround = true;
        }
    }

    public void setExtraProperties(RichBoundsLocation from, RichBoundsLocation to) {
        this.from.setExtraProperties(from);
        this.to.setExtraProperties(to);
        if (this.from.onGround || this.to.onGround) {
            this.touchedGround = true;
        }
    }

    public void invalidate() {
        this.valid = false;
        this.toIsValid = false;
        this.from.extraPropertiesValid = false;
        this.to.extraPropertiesValid = false;
    }

    public void addExtraProperties(StringBuilder builder, String prefix) {
        if (this.from.extraPropertiesValid && this.from.onGroundOrResetCond) {
            if (prefix != null && !prefix.isEmpty()) {
                builder.append(prefix);
            }
            builder.append("from/x: ");
            this.from.addExtraProperties(builder);
        }
        if (this.to.extraPropertiesValid && this.to.onGroundOrResetCond) {
            if (prefix != null && !prefix.isEmpty()) {
                builder.append(prefix);
            }
            builder.append(" to/x: ");
            this.to.addExtraProperties(builder);
        }
    }
}

