/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

import fr.neatmonster.nocheatplus.components.location.IGetLocationWithLook;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;

public class LocationData
implements IGetLocationWithLook {
    private String worldName;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    public boolean extraPropertiesValid = false;
    public boolean onClimbable;
    public boolean inWeb;
    public boolean inPowderSnow;
    public boolean inSoulSand;
    public boolean inLava;
    public boolean inWater;
    public boolean inLiquid;
    public boolean onGround;
    public boolean onIce;
    public boolean onBlueIce;
    public boolean onSoulSand;
    public boolean onSlimeBlock;
    public boolean inBerryBush;
    public boolean onHoneyBlock;
    public boolean onBouncyBlock;
    public boolean inBubbleStream;
    public boolean resetCond;
    public boolean onGroundOrResetCond;

    public void set(LocationData other) {
        this.setLocation(other.worldName, other.x, other.y, other.z, other.yaw, other.pitch);
        this.setExtraProperties(other);
    }

    public void set(RichBoundsLocation loc) {
        this.setLocation(loc);
        this.setExtraProperties(loc);
    }

    public void setLocation(IGetLocationWithLook loc) {
        this.setLocation(loc.getWorldName(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public void setLocation(String worldName, double x, double y, double z, float yaw, float pitch) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void setExtraProperties(RichBoundsLocation loc) {
        loc.collectBlockFlags();
        this.onClimbable = loc.isOnClimbable();
        this.inWeb = loc.isInWeb();
        this.onSoulSand = loc.isInSoulSand();
        this.inLiquid = loc.isInLiquid();
        this.inBerryBush = loc.isInBerryBush();
        this.onSlimeBlock = loc.isOnSlimeBlock();
        this.onHoneyBlock = loc.isOnHoneyBlock();
        this.inPowderSnow = loc.isInPowderSnow();
        if (this.inLiquid) {
            this.inLava = loc.isInLava();
            this.inWater = loc.isInWater();
        } else {
            this.inWater = false;
            this.inLava = false;
        }
        this.onGround = loc.isOnGround();
        this.onIce = loc.isOnIce();
        this.onBlueIce = loc.isOnBlueIce();
        this.resetCond = loc.isResetCond();
        this.onBouncyBlock = loc.isOnBouncyBlock();
        this.onGroundOrResetCond = loc.isOnGroundOrResetCond();
        this.inBubbleStream = loc.isInBubbleStream();
        this.extraPropertiesValid = true;
    }

    public void setExtraProperties(LocationData other) {
        if (other.extraPropertiesValid) {
            this.onClimbable = other.onClimbable;
            this.inWeb = other.inWeb;
            this.inLiquid = other.inLiquid;
            this.inLava = other.inLava;
            this.inWater = other.inWater;
            this.onGround = other.onGround;
            this.onIce = other.onIce;
            this.onBlueIce = other.onBlueIce;
            this.inSoulSand = other.inSoulSand;
            this.inBerryBush = other.inBerryBush;
            this.onSlimeBlock = other.onSlimeBlock;
            this.onHoneyBlock = other.onHoneyBlock;
            this.inPowderSnow = other.inPowderSnow;
            this.resetCond = other.resetCond;
            this.onBouncyBlock = other.onBouncyBlock;
            this.inBubbleStream = other.inBubbleStream;
            this.onGroundOrResetCond = other.onGroundOrResetCond;
        }
        this.extraPropertiesValid = other.extraPropertiesValid;
    }

    public void resetExtraProperties() {
        this.extraPropertiesValid = false;
        this.onClimbable = false;
        this.inWeb = false;
        this.inLiquid = false;
        this.inLava = false;
        this.inWater = false;
        this.onGround = false;
        this.onSoulSand = false;
        this.onSlimeBlock = false;
        this.onHoneyBlock = false;
        this.inBerryBush = false;
        this.inPowderSnow = false;
        this.onIce = false;
        this.onBlueIce = false;
        this.resetCond = false;
        this.onBouncyBlock = false;
        this.inBubbleStream = false;
        this.onGroundOrResetCond = false;
    }

    public void addExtraProperties(StringBuilder builder) {
        if (!this.extraPropertiesValid) {
            return;
        }
        if (this.onGround) {
            builder.append(" ground");
        }
        if (this.resetCond) {
            builder.append(" resetcond");
        }
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    public int hashCode() {
        return LocUtil.hashCode(this);
    }

    public String toString() {
        return "LocationData(" + this.worldName + "/" + LocUtil.simpleFormat(this) + ")";
    }
}

