/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

public enum LiftOffEnvelope {
    NORMAL(0.42, 1.29, 6, true),
    LIMIT_WEBS(0.021, 0.021, 0, true),
    LIMIT_SWEET_BERRY(0.315, 0.315, 0, true),
    LIMIT_POWDER_SNOW(0.63, 0.63, 0, true),
    LIMIT_HONEY_BLOCK(0.21, 0.4, 4, true),
    UNKNOWN(0.0, 0.0, 0, false);

    private double jumpGain;
    private double maxJumpHeight;
    private int maxJumpPhase;
    private boolean jumpEffectApplies;

    private LiftOffEnvelope(double jumpGain, double maxJumpHeight, int maxJumpPhase, boolean jumpEffectApplies) {
        this.jumpGain = jumpGain;
        this.maxJumpHeight = maxJumpHeight;
        this.maxJumpPhase = maxJumpPhase;
        this.jumpEffectApplies = jumpEffectApplies;
    }

    public double getJumpGain(double jumpAmplifier) {
        if (this.jumpEffectApplies && jumpAmplifier != 0.0) {
            return Math.max(0.0, this.jumpGain + 0.1 * jumpAmplifier);
        }
        return this.jumpGain;
    }

    public double getJumpGain(double jumpAmplifier, double factor) {
        if (this.jumpEffectApplies && jumpAmplifier != 0.0) {
            return Math.max(0.0, this.jumpGain + 0.1 * jumpAmplifier * factor);
        }
        return this.jumpGain;
    }

    public double getMaxJumpHeight(double jumpAmplifier) {
        if (this.jumpEffectApplies && jumpAmplifier > 0.0) {
            if (jumpAmplifier < 10.0) {
                return this.maxJumpHeight + 0.6 + jumpAmplifier - 1.0;
            }
            if (jumpAmplifier < 19.0) {
                return 0.6 + (jumpAmplifier + 3.2) * (jumpAmplifier + 3.2) / 16.0;
            }
            return 0.6 + (jumpAmplifier + 3.2) * (jumpAmplifier + 3.2) / 16.0 - jumpAmplifier * (jumpAmplifier - 1.0) / 2.0 * 0.03125;
        }
        return this.maxJumpHeight;
    }

    public int getMaxJumpPhase(double jumpAmplifier) {
        if (this.jumpEffectApplies && jumpAmplifier > 0.0) {
            return (int)Math.round((0.5 + jumpAmplifier) * (double)this.maxJumpPhase);
        }
        return this.maxJumpPhase;
    }

    public boolean jumpEffectApplies() {
        return this.jumpEffectApplies;
    }
}

