/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.model;

import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import org.bukkit.Input;
import org.bukkit.entity.Player;

public class InputDirection {
    private float strafe;
    private float forward;
    private ForwardDirection fdir;
    private StrafeDirection sdir;

    public InputDirection() {
    }

    public InputDirection(float strafe, float forward) {
        this.forward = forward;
        this.strafe = strafe;
        ForwardDirection forwardDirection = (double)forward >= 0.0 ? ((double)forward == 0.0 ? ForwardDirection.NONE : ForwardDirection.FORWARD) : (this.fdir = ForwardDirection.BACKWARD);
        this.sdir = (double)strafe >= 0.0 ? ((double)strafe == 0.0 ? StrafeDirection.NONE : StrafeDirection.LEFT) : StrafeDirection.RIGHT;
    }

    public InputDirection(Player player) {
        if (!BridgeMisc.hasInputGetterMethod()) {
            throw new UnsupportedOperationException("getCurrentInput is not available.");
        }
        Input input = player.getCurrentInput();
        float f = input.isLeft() ? 1.0f : (this.strafe = input.isRight() ? -1.0f : 0.0f);
        float f2 = input.isForward() ? 1.0f : (this.forward = input.isBackward() ? -1.0f : 0.0f);
        ForwardDirection forwardDirection = this.forward == 0.0f ? ForwardDirection.NONE : (this.fdir = (double)this.forward > 0.0 ? ForwardDirection.FORWARD : ForwardDirection.BACKWARD);
        this.sdir = this.strafe == 0.0f ? StrafeDirection.NONE : ((double)this.strafe > 0.0 ? StrafeDirection.LEFT : StrafeDirection.RIGHT);
    }

    public InputDirection(Input input) {
        if (!BridgeMisc.hasPlayerInputEvent()) {
            throw new UnsupportedOperationException("PlayerInputEvent is not available.");
        }
        float f = input.isLeft() ? 1.0f : (this.strafe = input.isRight() ? -1.0f : 0.0f);
        float f2 = input.isForward() ? 1.0f : (this.forward = input.isBackward() ? -1.0f : 0.0f);
        ForwardDirection forwardDirection = this.forward == 0.0f ? ForwardDirection.NONE : (this.fdir = (double)this.forward > 0.0 ? ForwardDirection.FORWARD : ForwardDirection.BACKWARD);
        this.sdir = this.strafe == 0.0f ? StrafeDirection.NONE : ((double)this.strafe > 0.0 ? StrafeDirection.LEFT : StrafeDirection.RIGHT);
    }

    public float getStrafe() {
        return this.strafe;
    }

    public float getForward() {
        return this.forward;
    }

    public double getInputSquared() {
        return MathUtil.square(this.strafe) + MathUtil.square(this.forward);
    }

    public void operationToInt(double strafeFactor, double forwardFactor, int operation) {
        switch (operation) {
            case 0: {
                this.strafe = 0.0f;
                this.forward = 0.0f;
                this.fdir = ForwardDirection.NONE;
                this.sdir = StrafeDirection.NONE;
                break;
            }
            case 1: {
                this.strafe = (float)((double)this.strafe * strafeFactor);
                this.forward = (float)((double)this.forward * forwardFactor);
                break;
            }
            case 2: {
                this.strafe = (float)((double)this.strafe / strafeFactor);
                this.forward = (float)((double)this.forward / forwardFactor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation: " + operation + ". Expected 0, 1, or 2.");
            }
        }
    }

    public StrafeDirection getStrafeDir() {
        return this.sdir;
    }

    public ForwardDirection getForwardDir() {
        return this.fdir;
    }

    public static enum ForwardDirection {
        NONE,
        FORWARD,
        BACKWARD;

    }

    public static enum StrafeDirection {
        NONE,
        LEFT,
        RIGHT;

    }
}

