/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.location.setback;

import fr.neatmonster.nocheatplus.checks.moving.location.setback.SetBackEntry;
import fr.neatmonster.nocheatplus.components.location.IGetLocationWithLook;
import fr.neatmonster.nocheatplus.components.location.IGetPositionWithLook;
import fr.neatmonster.nocheatplus.time.monotonic.Monotonic;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import org.bukkit.Location;
import org.bukkit.World;

public class SetBackStorage {
    final SetBackEntry[] entries;
    final int defaultIndex;
    int time;

    public SetBackStorage(int size, int defaultIndex) {
        this.entries = new SetBackEntry[size];
        for (int i = 0; i < size; ++i) {
            this.entries[i] = new SetBackEntry();
        }
        this.defaultIndex = defaultIndex;
    }

    public int size() {
        return this.entries.length;
    }

    public SetBackEntry getOldestValidEntry() {
        int oldestTime = Integer.MAX_VALUE;
        SetBackEntry oldestEntry = null;
        for (int i = 0; i < this.entries.length; ++i) {
            SetBackEntry entry = this.entries[i];
            if (!entry.isValid() || entry.getTime() >= oldestTime) continue;
            oldestTime = entry.getTime();
            oldestEntry = entry;
        }
        return oldestEntry;
    }

    public SetBackEntry getLatestValidEntry() {
        int latestTime = 0;
        SetBackEntry latestEntry = null;
        for (int i = 0; i < this.entries.length; ++i) {
            SetBackEntry entry = this.entries[i];
            if (!entry.isValid() || entry.getTime() <= latestTime) continue;
            latestTime = entry.getTime();
            latestEntry = entry;
        }
        return latestEntry;
    }

    public SetBackEntry getValidEntry(int index, boolean fallBack) {
        if (this.entries[index].isValid()) {
            return this.entries[index];
        }
        if (fallBack && this.defaultIndex >= 0 && this.entries[this.defaultIndex].isValid()) {
            return this.entries[this.defaultIndex];
        }
        return null;
    }

    public SetBackEntry getFirstValidEntry(Location location) {
        for (int i = 0; i < this.entries.length; ++i) {
            SetBackEntry entry = this.entries[i];
            if (!entry.isValid() || !TrigUtil.isSamePosAndLook((IGetPositionWithLook)entry, location)) continue;
            return entry;
        }
        return null;
    }

    public void invalidateAll() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i].setValid(false);
        }
    }

    public void resetAll(Location loc) {
        ++this.time;
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i].set(loc, this.time, Monotonic.millis());
        }
    }

    public void resetAll(IGetLocationWithLook loc) {
        ++this.time;
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i].set(loc, this.time, Monotonic.millis());
        }
    }

    public void resetAllLazily(Location loc) {
        if (this.defaultIndex < 0) {
            this.resetAll(loc);
        } else {
            this.invalidateAll();
            this.entries[this.defaultIndex].set(loc, ++this.time, Monotonic.millis());
        }
    }

    public void resetAllLazily(IGetLocationWithLook loc) {
        if (this.defaultIndex < 0) {
            this.resetAll(loc);
        } else {
            this.invalidateAll();
            this.entries[this.defaultIndex].set(loc, ++this.time, Monotonic.millis());
        }
    }

    public void resetByWorldName(String worldName) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!worldName.equals(this.entries[i].getWorldName())) continue;
            this.entries[i].setValid(false);
        }
    }

    public boolean isAnyEntryValid() {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].isValid()) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryValid(int index) {
        return this.entries[index].isValid();
    }

    public boolean isDefaultEntryValid() {
        return this.defaultIndex >= 0 && this.entries[this.defaultIndex].isValid();
    }

    public SetBackEntry getDefaultEntry() {
        return this.defaultIndex < 0 ? null : this.entries[this.defaultIndex];
    }

    public void setDefaultEntry(Location loc) {
        this.getDefaultEntry().set(loc, ++this.time, Monotonic.millis());
    }

    public void setDefaultEntry(IGetLocationWithLook loc) {
        this.getDefaultEntry().set(loc, ++this.time, Monotonic.millis());
    }

    public Location getValidDefaultLocation(World world) {
        SetBackEntry entry = this.getDefaultEntry();
        return entry.isValid() ? entry.getLocation(world) : null;
    }
}

