/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.envelope.workaround;

import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.checks.moving.player.Passable;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.utilities.location.RichEntityLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class LostGroundVehicle {
    public static boolean lostGround(Entity vehicle, RichEntityLocation from, RichEntityLocation to, double hDistance, double yDistance, boolean sprinting, VehicleMoveData lastMove, MovingData data, MovingConfig cc, BlockChangeTracker blockChangeTracker, Collection<String> tags) {
        if (yDistance >= -0.7 && yDistance <= 0.0) {
            if (yDistance >= 0.0 && lastMove.toIsValid && LostGroundVehicle.lostGroundAscend(vehicle, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, tags)) {
                return true;
            }
            if (yDistance <= 0.0 && LostGroundVehicle.lostGroundDescend(vehicle, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, tags)) {
                return true;
            }
        } else if (yDistance < -0.7 && lastMove.toIsValid && hDistance <= 0.5 && LostGroundVehicle.lostGroundFastDescend(vehicle, from, to, hDistance, yDistance, sprinting, lastMove, data, cc, tags)) {
            return true;
        }
        return false;
    }

    private static boolean lostGroundAscend(Entity vehicle, RichEntityLocation from, RichEntityLocation to, double hDistance, double yDistance, boolean sprinting, PlayerMoveData lastMove, MovingData data, MovingConfig cc, Collection<String> tags) {
        VehicleMoveData thisMove = data.vehicleMoves.getCurrentMove();
        if (lastMove.yDistance < 0.0 && !to.isOnGround()) {
            if (LostGroundVehicle.lostGroundEdgeAsc(vehicle, from.getBlockCache(), from.getWorld(), from.getX(), from.getY(), from.getZ(), from.getBoxMarginHorizontal(), from.getyOnGround(), lastMove, data, "asc1", tags, from.getMCAccess())) {
                return true;
            }
            if (yDistance == 0.0 && lastMove.yDistance <= -0.1515 && hDistance <= lastMove.hDistance * 1.1) {
                double xzMargin;
                double d = xzMargin = lastMove.yDistance <= -0.23 ? 0.3 : 0.15;
                if (LostGroundVehicle.lostGroundEdgeAsc(vehicle, from.getBlockCache(), to.getWorld(), to.getX(), to.getY(), to.getZ(), from.getX(), from.getY(), from.getZ(), hDistance, to.getBoxMarginHorizontal(), xzMargin, data, "asc5", tags, from.getMCAccess())) {
                    return true;
                }
            } else if (from.isOnGround(from.getyOnGround(), 0.0625, 0.0)) {
                return LostGroundVehicle.applyLostGround(vehicle, from, false, thisMove, data, "edgeasc2", tags);
            }
        }
        return false;
    }

    private static boolean lostGroundEdgeAsc(Entity vehicle, BlockCache blockCache, World world, double x1, double y1, double z1, double boxMarginHorizontal, double yOnGround, PlayerMoveData lastMove, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        return LostGroundVehicle.lostGroundEdgeAsc(vehicle, blockCache, world, x1, y1, z1, lastMove.from.getX(), lastMove.from.getY(), lastMove.from.getZ(), lastMove.hDistance, boxMarginHorizontal, yOnGround, data, tag, tags, mcAccess);
    }

    private static boolean lostGroundEdgeAsc(Entity vehicle, BlockCache blockCache, World world, double x1, double y1, double z1, double x2, double y2, double z2, double hDistance2, double boxMarginHorizontal, double yOnGround, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        x2 -= x1;
        z2 -= z1;
        double fMin = 1.0;
        if (Math.abs(x2) > hDistance2) {
            fMin = Math.min(fMin, hDistance2 / Math.abs(x2));
        }
        if (Math.abs(z2) > hDistance2) {
            fMin = Math.min(fMin, hDistance2 / Math.abs(z2));
        }
        if (BlockProperties.isOnGroundShuffled(world, blockCache, x1, y1, z1, x2 = fMin * x2 + x1, y1, z2 = fMin * z2 + z1, boxMarginHorizontal, yOnGround, 0.0)) {
            return LostGroundVehicle.applyLostGround(vehicle, new Location(world, x2, y2, z2), true, data.vehicleMoves.getCurrentMove(), data, "edge" + tag, tags, mcAccess);
        }
        return false;
    }

    private static boolean lostGroundDescend(Entity vehicle, RichEntityLocation from, RichEntityLocation to, double hDistance, double yDistance, boolean sprinting, VehicleMoveData lastMove, MovingData data, MovingConfig cc, Collection<String> tags) {
        VehicleMoveData thisMove = data.vehicleMoves.getCurrentMove();
        double setBackYDistance = to.getY() - data.getSetBackY();
        if (yDistance < 0.0 && !to.isOnGround() && from.isOnGround(from.getY() - to.getY() + 0.001)) {
            Location ref = from.getLocation();
            ref.setY(to.getY());
            if (Passable.isPassable(from.getLocation(), ref)) {
                return LostGroundVehicle.applyLostGround(vehicle, from, false, thisMove, data, "vcollide", tags);
            }
        }
        if (!lastMove.toIsValid) {
            return false;
        }
        if (data.sfJumpPhase <= 7) {
            if (lastMove.yDistance <= yDistance && setBackYDistance < 0.0 && !to.isOnGround() && from.isOnGround(0.6, 0.4, 0.0, 0L)) {
                return LostGroundVehicle.applyLostGround(vehicle, from, true, thisMove, data, "pyramid", tags);
            }
            if (yDistance == 0.0 && lastMove.yDistance > 0.0 && lastMove.yDistance < 0.25 && (double)data.sfJumpPhase <= Math.max(0.0, 6.0 + data.jumpAmplifier * 3.0) && setBackYDistance > 1.0 && setBackYDistance < Math.max(0.0, 1.5 + 0.2 * data.jumpAmplifier) && !to.isOnGround() && from.isOnGround(0.25, 0.4, 0.0, 0L)) {
                return LostGroundVehicle.applyLostGround(vehicle, from, true, thisMove, data, "ministep", tags);
            }
        }
        if (yDistance < 0.0 && hDistance <= 1.5 && lastMove.yDistance < 0.0 && yDistance > lastMove.yDistance && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.2, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return LostGroundVehicle.applyLostGround(vehicle, from, true, thisMove, data, "edgedesc", tags);
        }
        return false;
    }

    private static boolean lostGroundFastDescend(Entity vehicle, RichEntityLocation from, RichEntityLocation to, double hDistance, double yDistance, boolean sprinting, VehicleMoveData lastMove, MovingData data, MovingConfig cc, Collection<String> tags) {
        if (yDistance > lastMove.yDistance && !to.isOnGround() && (from.isOnGround(0.5, 0.2, 0.0) || to.isOnGround(0.5, Math.min(0.3, 0.01 + hDistance), Math.min(0.1, 0.01 + -yDistance)))) {
            return LostGroundVehicle.applyLostGround(vehicle, from, true, data.vehicleMoves.getCurrentMove(), data, "fastedge", tags);
        }
        return false;
    }

    private static boolean applyLostGround(Entity vehicle, Location refLoc, boolean setBackSafe, VehicleMoveData thisMove, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        return LostGroundVehicle.applyLostGround(vehicle, thisMove, data, tag, tags, mcAccess);
    }

    private static boolean applyLostGround(Entity vehicle, RichEntityLocation refLoc, boolean setBackSafe, VehicleMoveData thisMove, MovingData data, String tag, Collection<String> tags) {
        return LostGroundVehicle.applyLostGround(vehicle, thisMove, data, tag, tags, refLoc.getMCAccess());
    }

    private static boolean applyLostGround(Entity vehicle, VehicleMoveData thisMove, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        data.sfJumpPhase = 0;
        thisMove.touchedGround = true;
        thisMove.touchedGroundWorkaround = true;
        tags.add("lostground_" + tag);
        return true;
    }
}

