/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.envelope.workaround;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.envelope.PhysicsEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class LostGround {
    public static boolean runLostGroundChecks(Player player, PlayerLocation from, PlayerLocation to, double hDistance, double yDistance, boolean sprinting, PlayerMoveData lastMove, MovingData data, MovingConfig cc, BlockChangeTracker blockChangeTracker, Collection<String> tags) {
        if (Bridge1_9.isGliding((LivingEntity)player) || Bridge1_13.isRiptiding((LivingEntity)player) || from.isResetCond() || from.isSlidingDown() || from.isOnGround() || player.isFlying() || hDistance < 0.001) {
            return false;
        }
        if (!Double.isInfinite(Bridge1_9.getLevitationAmplifier(player))) {
            return false;
        }
        if (PhysicsEnvelope.isVerticallyConstricted(from, to, DataManager.getPlayerData(player))) {
            return false;
        }
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        if (hDistance <= 0.03 && from.isOnGround(0.03) && (MaterialUtil.LANTERNS.contains(from.getBlockType(from.getBlockX(), Location.locToBlock((double)(from.getY() + 2.0)), from.getBlockZ())) || data.joinOrRespawn)) {
            return LostGround.applyLostGround(player, from, true, thisMove, data, "0.03", tags);
        }
        if (!MathUtil.inRange(0.1, hDistance, 1.5)) {
            return false;
        }
        double horizontalMargin = to.getBoxMarginHorizontal() + 0.1;
        double from_Y = from.getY() + cc.sfStepHeight;
        if (MathUtil.inRange(0.0, yDistance, cc.sfStepHeight) && lastMove.yDistance < 0.0 && from.isOnGround(1.0) && BlockProperties.isOnGroundShuffled(to.getWorld(), to.getBlockCache(), from.getX(), from_Y, from.getZ(), to.getX(), to.getY(), to.getZ(), horizontalMargin, to.getyOnGround(), 0.0)) {
            thisMove.couldStepUp = true;
            return LostGround.applyLostGround(player, from, false, thisMove, data, "couldstep", tags);
        }
        if (!lastMove.toIsValid) {
            return false;
        }
        if (thisMove.yDistance > lastMove.yDistance && lastMove.yDistance < 0.0) {
            if (to.isOnGround()) {
                return false;
            }
            if (LostGround.interpolateGround(player, from.getBlockCache(), from.getWorld(), from.getMCAccess(), "_from", tags, data, from.getX(), from.getY(), from.getZ(), lastMove, from.getBoxMarginHorizontal(), from.getyOnGround())) {
                thisMove.fromLostGround = true;
                return true;
            }
            if (LostGround.interpolateGround(player, to.getBlockCache(), to.getWorld(), to.getMCAccess(), tags, "_to", data, to.getX(), to.getY(), to.getZ(), from.getX(), from.getY(), from.getZ(), thisMove.hDistance, to.getBoxMarginHorizontal(), to.getyOnGround())) {
                thisMove.toLostGround = true;
                return true;
            }
        }
        return blockChangeTracker != null && LostGround.lostGroundPastState(player, from, to, data, cc, blockChangeTracker, tags);
    }

    private static boolean lostGroundPastState(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, BlockChangeTracker blockChangeTracker, Collection<String> tags) {
        int tick = TickTask.getTick();
        if (from.isOnGroundOpportune(cc.yOnGround, 0L, blockChangeTracker, data.blockChangeRef, tick)) {
            return LostGround.applyLostGround(player, from, false, data.playerMoves.getCurrentMove(), data, "past", tags);
        }
        return false;
    }

    private static boolean interpolateGround(Player player, BlockCache blockCache, World world, MCAccess mcAccess, Collection<String> tags, String tag, MovingData data, double thisX, double thisY, double thisZ, double lastX, double lastY, double lastZ, double lastHDistance, double boxMarginHorizontal, double yOnGround) {
        lastX -= thisX;
        lastZ -= thisZ;
        double minFactor = 1.0;
        if (Math.abs(lastX) > lastHDistance) {
            minFactor = Math.min(minFactor, lastHDistance / Math.abs(lastX));
        }
        if (Math.abs(lastZ) > lastHDistance) {
            minFactor = Math.min(minFactor, lastHDistance / Math.abs(lastZ));
        }
        if (BlockProperties.isOnGroundShuffled(world, blockCache, thisX, thisY, thisZ, lastX = minFactor * lastX + thisX, thisY, lastZ = minFactor * lastZ + thisZ, boxMarginHorizontal, yOnGround, 0.0)) {
            return LostGround.applyLostGround(player, new Location(world, lastX, lastY, lastZ), true, data.playerMoves.getCurrentMove(), data, "interpolate" + tag, tags, mcAccess);
        }
        return false;
    }

    private static boolean interpolateGround(Player player, BlockCache blockCache, World world, MCAccess mcAccess, String tag, Collection<String> tags, MovingData data, double thisX, double thisY, double thisZ, PlayerMoveData lastMove, double boxMarginHorizontal, double yOnGround) {
        return LostGround.interpolateGround(player, blockCache, world, mcAccess, tags, tag, data, thisX, thisY, thisZ, lastMove.from.getX(), lastMove.from.getY(), lastMove.from.getZ(), lastMove.hDistance, boxMarginHorizontal, yOnGround);
    }

    private static boolean applyLostGround(Player player, PlayerMoveData thisMove, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        data.sfJumpPhase = 0;
        data.jumpAmplifier = MovingUtil.getJumpAmplifier(player, mcAccess);
        data.adjustMediumProperties(player.getLocation(), DataManager.getPlayerData(player).getGenericInstance(MovingConfig.class), player, data.playerMoves.getCurrentMove());
        thisMove.touchedGround = true;
        thisMove.touchedGroundWorkaround = true;
        tags.add("lostground_" + tag);
        IPlayerData pData = DataManager.getPlayerData(player);
        if (pData.isDebugActive(CheckType.MOVING_SURVIVALFLY) || pData.isDebugActive(CheckType.MOVING_CREATIVEFLY)) {
            player.sendMessage("lostground_" + tag);
        }
        return true;
    }

    private static boolean applyLostGround(Player player, Location refLoc, boolean setBackSafe, PlayerMoveData thisMove, MovingData data, String tag, Collection<String> tags, MCAccess mcAccess) {
        if (setBackSafe) {
            data.setSetBack(refLoc);
        }
        return LostGround.applyLostGround(player, thisMove, data, tag, tags, mcAccess);
    }

    private static boolean applyLostGround(Player player, PlayerLocation refLoc, boolean setBackSafe, PlayerMoveData thisMove, MovingData data, String tag, Collection<String> tags) {
        if (setBackSafe) {
            data.setSetBack(refLoc);
        }
        return LostGround.applyLostGround(player, thisMove, data, tag, tags, refLoc.getMCAccess());
    }
}

