/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.envelope;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.moving.Magic;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PhysicsEnvelope {
    private static final IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);

    public static boolean glideVerticalGainEnvelope(double yDistance, double previousYDistance) {
        return yDistance < -0.1044 && previousYDistance < -0.1044 && yDistance - previousYDistance > -0.0834 && yDistance - previousYDistance < 0.025641025641025644;
    }

    public static boolean enoughFrictionEnvelope(PlayerMoveData thisMove, PlayerMoveData lastMove, double friction, double minGravity, double maxOff, double decreaseByOff) {
        double frictDist = lastMove.yDistance * friction - minGravity;
        double off = Math.abs(thisMove.yDistance - frictDist);
        return off <= maxOff && Math.abs(thisMove.yDistance - lastMove.yDistance) <= off * decreaseByOff;
    }

    public static boolean isFrictionFalling(double yDistance, double lastYDist, double lastFrictionVertical, double extraGravity) {
        if (yDistance >= lastYDist) {
            return false;
        }
        double frictDist = lastYDist * lastFrictionVertical - 0.0624;
        return yDistance <= frictDist + extraGravity && yDistance > frictDist - 0.021000000000000005 - extraGravity;
    }

    public static boolean isVerticallyConstricted(PlayerLocation from, PlayerLocation to, IPlayerData pData) {
        if (pData.getClientVersion().isLowerThan(ClientVersion.V_1_14)) {
            return false;
        }
        if (!pData.isInCrouchingPose()) {
            return false;
        }
        return from.seekCollisionAbove(0.0899, false) && from.isOnGround() && to.isOnGround() && pData.getGenericInstance(MovingData.class).playerMoves.getCurrentMove().yDistance == 0.0;
    }

    public static boolean isBunnyhop(PlayerLocation from, PlayerLocation to, IPlayerData pData, boolean fromOnGround, boolean toOnGround, Player player, boolean forceSetOffGround) {
        return pData.isSprinting() && (PhysicsEnvelope.isJumpMotion(from, to, player, fromOnGround, toOnGround) || PhysicsEnvelope.isVerticallyConstricted(from, to, pData) && (!forceSetOffGround && pData.getClientVersion().isLowerThan(ClientVersion.V_1_21_2) || BridgeMisc.isSpaceBarImpulseKnown(player) && player.getCurrentInput().isJump()));
    }

    public static boolean isJumpMotion(PlayerLocation from, PlayerLocation to, Player player, boolean fromOnGround, boolean toOnGround) {
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (thisMove.hasLevitation || thisMove.isRiptiding || thisMove.isGliding || from.isInLiquid()) {
            return false;
        }
        double jumpGain = data.liftOffEnvelope.getJumpGain(data.jumpAmplifier) * attributeAccess.getHandle().getJumpGainMultiplier(player);
        Vector collisionVector = from.collide(new Vector(0.0, jumpGain, 0.0), fromOnGround || thisMove.touchedGroundWorkaround, from.getBoundingBox());
        thisMove.headObstructed = jumpGain != collisionVector.getY() && thisMove.yDistance >= 0.0 && !toOnGround;
        jumpGain = collisionVector.getY();
        if (!MathUtil.almostEqual(thisMove.yDistance, jumpGain, 1.0E-4)) {
            return false;
        }
        return fromOnGround && !toOnGround || lastMove.toIsValid && lastMove.yDistance <= 0.0 && !from.seekCollisionAbove() && (lastMove.from.onGround && !lastMove.to.onGround && !thisMove.touchedGroundWorkaround || thisMove.touchedGroundWorkaround && (!lastMove.touchedGroundWorkaround || !thisMove.to.onGround));
    }

    public static boolean isStepUpByNCPDefinition(IPlayerData pData, boolean fromOnGround, boolean toOnGround, Player player) {
        MovingData data = pData.getGenericInstance(MovingData.class);
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        if (thisMove.isRiptiding) {
            return false;
        }
        if (thisMove.isGliding) {
            return false;
        }
        return fromOnGround && toOnGround && MathUtil.almostEqual(thisMove.yDistance, attributeAccess.getHandle().getMaxStepUp(player), 1.0E-4) || thisMove.couldStepUp;
    }

    public static boolean couldBeSetBackLoop(MovingData data) {
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (!data.hasSetBack()) {
            return false;
        }
        double setBackYDistance = thisMove.to.getY() - data.getSetBackY();
        return !lastMove.toIsValid && data.sfJumpPhase == 0 && thisMove.multiMoveCount > 0 && setBackYDistance > 0.0 && setBackYDistance < 0.01 && thisMove.yDistance > 0.0 && thisMove.yDistance < 0.01 && PhysicsEnvelope.inAir(thisMove);
    }

    public static boolean canBounce(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, IPlayerData pData) {
        if (pData.isShiftKeyPressed()) {
            return false;
        }
        double blockY = (to.getY() + 0.4375) % 1.0 == 0.0 ? to.getY() : (double)to.getBlockY();
        return MovingUtil.getRealisticFallDistance(player, from.getY(), to.getY(), data, pData) > 1.0 && (to.getY() - blockY <= Math.max(cc.yOnGround, cc.noFallyOnGround) || BlockProperties.isCarpet(to.getBlockType()) && to.getY() - (double)to.getBlockY() <= 0.9) || to.getY() - blockY < 0.286 && to.getY() - from.getY() > -0.9 && to.getY() - from.getY() < -0.0624 && !to.isOnGround() || Bridge1_13.isRiptiding((LivingEntity)player) || to.isOnGround() && !from.isOnGround() && to.getY() - from.getY() < 0.0 && MovingUtil.getRealisticFallDistance(player, from.getY(), to.getY(), data, pData) <= 0.5 && to.isOnBouncyBlock() && !to.isOnSlimeBlock();
    }

    public static boolean touchedIce(PlayerMoveData thisMove) {
        return thisMove.from.onIce || thisMove.from.onBlueIce || thisMove.to.onIce || thisMove.to.onBlueIce;
    }

    public static double swimBaseSpeedV(boolean isSwimming) {
        return isSwimming ? 0.221 * Magic.modSwim[2] + 0.1 : 0.221 * Magic.modSwim[0] + 0.07;
    }

    static boolean splashMove(PlayerMoveData thisMove, PlayerMoveData lastMove) {
        return !thisMove.touchedGround && thisMove.from.inWater && !thisMove.to.resetCond && !lastMove.touchedGround && !lastMove.from.resetCond && lastMove.to.inWater && PhysicsEnvelope.excludeStaticSpeed(thisMove) && PhysicsEnvelope.excludeStaticSpeed(lastMove);
    }

    static boolean splashMoveNonStrict(PlayerMoveData thisMove, PlayerMoveData lastMove) {
        return !thisMove.touchedGround && thisMove.from.inWater && !thisMove.to.resetCond && !lastMove.from.resetCond && lastMove.to.inWater && PhysicsEnvelope.excludeStaticSpeed(thisMove) && PhysicsEnvelope.excludeStaticSpeed(lastMove);
    }

    public static boolean inAir(PlayerMoveData thisMove) {
        return !thisMove.touchedGround && !thisMove.from.resetCond && !thisMove.to.resetCond;
    }

    public static boolean liftingOffOrLandingOnGround(PlayerMoveData move) {
        return move.from.onGround ^ move.to.onGround;
    }

    public static boolean inLiquid(PlayerMoveData thisMove) {
        return thisMove.from.inLiquid && thisMove.to.inLiquid && PhysicsEnvelope.excludeStaticSpeed(thisMove);
    }

    public static boolean inWater(PlayerMoveData thisMove) {
        return thisMove.from.inWater && thisMove.to.inWater && PhysicsEnvelope.excludeStaticSpeed(thisMove);
    }

    public static boolean resetCond(PlayerMoveData thisMove) {
        return thisMove.from.resetCond || thisMove.to.resetCond;
    }

    public static boolean leavingLiquid(PlayerMoveData thisMove) {
        return thisMove.from.inLiquid && !thisMove.to.inLiquid && PhysicsEnvelope.excludeStaticSpeed(thisMove);
    }

    public static boolean leavingWater(PlayerMoveData thisMove) {
        return thisMove.from.inWater && !thisMove.to.inWater && PhysicsEnvelope.excludeStaticSpeed(thisMove);
    }

    public static boolean intoWater(PlayerMoveData thisMove) {
        return !thisMove.from.inWater && thisMove.to.inWater && PhysicsEnvelope.excludeStaticSpeed(thisMove);
    }

    public static boolean intoLiquid(PlayerMoveData thisMove) {
        return !thisMove.from.inLiquid && thisMove.to.inLiquid && PhysicsEnvelope.excludeStaticSpeed(thisMove);
    }

    public static boolean excludeStaticSpeed(PlayerMoveData thisMove) {
        return !thisMove.from.inWeb && !thisMove.to.inWeb && !thisMove.from.onClimbable && !thisMove.to.onClimbable && !thisMove.from.inBerryBush && !thisMove.to.inBerryBush && !thisMove.from.inPowderSnow && !thisMove.to.inPowderSnow;
    }
}

