/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.envelope;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.BounceType;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.VelocityFlags;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.debug.IDebugPlayer;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class BounceHandler {
    private static final long FLAGS_VELOCITY_BOUNCE_BLOCK = VelocityFlags.ORIGIN_BLOCK_BOUNCE;
    private static final long FLAGS_VELOCITY_BOUNCE_BLOCK_MOVE_ASCEND = FLAGS_VELOCITY_BOUNCE_BLOCK | VelocityFlags.SPLIT_ABOVE_0_42 | VelocityFlags.SPLIT_RETAIN_ACTCOUNT | VelocityFlags.ORIGIN_BLOCK_MOVE;

    public static void processBounce(Player player, double fromY, double toY, BounceType bounceType, int tick, IDebugPlayer idp, MovingData data, MovingConfig cc, IPlayerData pData) {
        double lastMinGain;
        double fallDistance = MovingUtil.getRealisticFallDistance(player, fromY, toY, data, pData);
        double baseEffect = BounceHandler.getBaseBounceSpeed(player, fallDistance);
        double finalEffect = Math.min(BounceHandler.getMaximumBounceGain(player), baseEffect + Math.min(baseEffect / 10.0, 0.0834));
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (finalEffect > 0.415 && lastMove.toIsValid && !Bridge1_13.isRiptiding((LivingEntity)player) && (lastMinGain = Math.abs(lastMove.yDistance < 0.0 ? Math.min(lastMove.yDistance, toY - fromY) : toY - fromY) - 0.021000000000000005) < finalEffect) {
            finalEffect = lastMinGain;
            if (pData.isDebugActive(CheckType.MOVING)) {
                idp.debug(player, "Cap this bounce effect by recent y-distances.");
            }
        }
        if (bounceType == BounceType.STATIC_PAST_AND_PUSH) {
            // empty if block
        }
        if (pData.isDebugActive(CheckType.MOVING)) {
            idp.debug(player, "Set bounce effect (dY=" + fallDistance + " / " + (Object)((Object)bounceType) + "): " + finalEffect);
        }
        data.noFallSkipAirCheck = true;
        data.verticalBounce = new SimpleEntry(tick, finalEffect, FLAGS_VELOCITY_BOUNCE_BLOCK, 1);
    }

    public static double getBaseBounceSpeed(Player player, double fallDistance) {
        if (BridgeMisc.isRipgliding(player)) {
            return Math.sqrt(fallDistance);
        }
        if (Bridge1_13.isRiptiding((LivingEntity)player)) {
            return Math.sqrt(fallDistance) / 1.5;
        }
        return Math.sqrt(fallDistance) / 3.3;
    }

    public static double getMaximumBounceGain(Player player) {
        if (BridgeMisc.isRipgliding(player)) {
            return 12.25;
        }
        if (Bridge1_13.isRiptiding((LivingEntity)player)) {
            return 7.0;
        }
        return 3.5;
    }

    public static boolean onPreparedBounceSupport(Player player, Location from, Location to, PlayerMoveData thisMove, PlayerMoveData lastMove, int tick, MovingData data) {
        if (to.getY() > from.getY() || to.getY() == from.getY() && data.verticalBounce.value < 0.13) {
            if (to.getY() == from.getY()) {
                if (lastMove.toIsValid && lastMove.yDistance < 0.0) {
                    data.verticalBounce = new SimpleEntry(tick, data.verticalBounce.value, 1);
                }
            } else {
                data.useVerticalBounce(player);
            }
            return true;
        }
        data.verticalBounce = null;
        return false;
    }

    public static BounceType checkPastStateBounceDescend(Player player, PlayerLocation from, PlayerLocation to, PlayerMoveData thisMove, PlayerMoveData lastMove, int tick, MovingData data, MovingConfig cc, BlockChangeTracker blockChangeTracker) {
        UUID worldId = from.getWorld().getUID();
        BlockChangeTracker.BlockChangeEntry entryBelowAny = blockChangeTracker.getBlockChangeEntryMatchFlags(data.blockChangeRef, tick, worldId, to.getBlockX(), to.getBlockY() - 1, to.getBlockZ(), null, BlockFlags.F_BOUNCE25);
        if (entryBelowAny != null) {
            BlockChangeTracker.BlockChangeEntry entryBelowY_POS;
            BlockChangeTracker.BlockChangeEntry blockChangeEntry = entryBelowY_POS = entryBelowAny.direction == BlockChangeTracker.Direction.Y_POS ? entryBelowAny : blockChangeTracker.getBlockChangeEntryMatchFlags(data.blockChangeRef, tick, worldId, to.getBlockX(), to.getBlockY() - 1, to.getBlockZ(), BlockChangeTracker.Direction.Y_POS, BlockFlags.F_BOUNCE25);
            if (entryBelowY_POS != null) {
                return BounceType.STATIC_PAST_AND_PUSH;
            }
            return BounceType.STATIC_PAST;
        }
        return BounceType.NO_BOUNCE;
    }

    public static BounceType checkPastStateBounceAscend(Player player, PlayerLocation from, PlayerLocation to, PlayerMoveData thisMove, PlayerMoveData lastMove, int tick, IPlayerData pData, IDebugPlayer idp, MovingData data, MovingConfig cc, BlockChangeTracker blockChangeTracker) {
        BlockChangeTracker.BlockChangeEntry entry2BelowY_POS;
        UUID worldId = from.getWorld().getUID();
        boolean debug = pData.isDebugActive(CheckType.MOVING);
        double amount = -1.0;
        BlockChangeTracker.BlockChangeEntry entryBelowY_POS = blockChangeTracker.getBlockChangeEntryMatchFlags(data.blockChangeRef, tick, worldId, from.getBlockX(), from.getBlockY() - 1, from.getBlockZ(), BlockChangeTracker.Direction.Y_POS, BlockFlags.F_BOUNCE25);
        if (entryBelowY_POS != null || thisMove.yDistance < 1.515 && from.matchBlockChangeMatchResultingFlags(blockChangeTracker, data.blockChangeRef, BlockChangeTracker.Direction.Y_POS, Math.min(0.415, thisMove.yDistance), BlockFlags.F_BOUNCE25)) {
            amount = Math.min(Math.max(0.505, 1.0 + (double)from.getBlockY() - from.getY() + 1.515), 1.915);
            if (debug) {
                idp.debug(player, "Direct block push with bounce (" + (entryBelowY_POS == null ? "off_center)." : "center)."));
            }
            if (entryBelowY_POS != null) {
                data.blockChangeRef.updateSpan(entryBelowY_POS);
            }
        }
        if (amount < 0.0 && lastMove.toIsValid && lastMove.yDistance >= 0.0 && lastMove.yDistance <= 0.505 && Math.abs(from.getY() - (double)from.getBlockY() - lastMove.yDistance) < 0.205 && (entry2BelowY_POS = blockChangeTracker.getBlockChangeEntryMatchFlags(data.blockChangeRef, tick, worldId, from.getBlockX(), from.getBlockY() - 2, from.getBlockZ(), BlockChangeTracker.Direction.Y_POS, BlockFlags.F_BOUNCE25)) != null) {
            amount = Math.min(Math.max(0.505, 1.0 + (double)from.getBlockY() - from.getY() + 1.515), 1.915 - lastMove.yDistance);
            if (debug) {
                idp.debug(player, "Foot position block push with bounce (" + (entry2BelowY_POS == null ? "off_center)." : "center)."));
            }
            if (entryBelowY_POS != null) {
                data.blockChangeRef.updateSpan(entry2BelowY_POS);
            }
        }
        if (amount >= 0.0) {
            SimpleEntry vel;
            data.removeLeadingQueuedVerticalVelocityByFlag(VelocityFlags.ORIGIN_BLOCK_BOUNCE);
            data.verticalBounce = vel = new SimpleEntry(tick, amount, FLAGS_VELOCITY_BOUNCE_BLOCK_MOVE_ASCEND, 4);
            data.useVerticalBounce(player);
            data.useVerticalVelocity(thisMove.yDistance);
            if (debug) {
                idp.debug(player, "checkPastStateBounceAscend: set velocity: " + vel);
            }
            return BounceType.STATIC_PAST_AND_PUSH;
        }
        return BounceType.NO_BOUNCE;
    }
}

