/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.inventory.Open;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.envelope.BounceHandler;
import fr.neatmonster.nocheatplus.checks.moving.envelope.PhysicsEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.BounceType;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveInfo;
import fr.neatmonster.nocheatplus.checks.moving.player.CreativeFly;
import fr.neatmonster.nocheatplus.checks.moving.player.MorePackets;
import fr.neatmonster.nocheatplus.checks.moving.player.NoFall;
import fr.neatmonster.nocheatplus.checks.moving.player.Passable;
import fr.neatmonster.nocheatplus.checks.moving.player.PlayerSetBackMethod;
import fr.neatmonster.nocheatplus.checks.moving.player.SurvivalFly;
import fr.neatmonster.nocheatplus.checks.moving.vehicle.VehicleChecks;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.VelocityFlags;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.SchedulerHelper;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEnchant;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeEntityType;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeHealth;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgePotionEffect;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessDimensions;
import fr.neatmonster.nocheatplus.components.location.IGetPositionWithLook;
import fr.neatmonster.nocheatplus.components.location.SimplePositionWithLook;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.feature.IHaveCheckType;
import fr.neatmonster.nocheatplus.components.registry.feature.INeedConfig;
import fr.neatmonster.nocheatplus.components.registry.feature.IRemoveData;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.registry.feature.TickListener;
import fr.neatmonster.nocheatplus.components.registry.setup.config.RegisterConfigWorld;
import fr.neatmonster.nocheatplus.components.registry.setup.data.RegisterDataPlayer;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.logging.debug.DebugUtil;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.PlayerFactoryArgument;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.build.BuildParameters;
import fr.neatmonster.nocheatplus.utilities.entity.PotionUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.moving.AuxMoving;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import fr.neatmonster.nocheatplus.worlds.WorldFactoryArgument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;

public class MovingListener
extends CheckListener
implements TickListener,
IRemoveData,
IHaveCheckType,
INeedConfig,
JoinLeaveListener {
    public final NoFall noFall = this.addCheck(new NoFall());
    private final CreativeFly creativeFly = this.addCheck(new CreativeFly());
    private final MorePackets morePackets = this.addCheck(new MorePackets());
    private final VehicleChecks vehicleChecks = new VehicleChecks();
    private final SurvivalFly survivalFly = this.addCheck(new SurvivalFly());
    private final Passable passable = this.addCheck(new Passable());
    private final Map<String, PlayerMoveEvent> processingEvents = new HashMap<String, PlayerMoveEvent>();
    private final Set<String> hoverTicks = ConcurrentHashMap.newKeySet(30);
    private final Set<String> playersEnforce = ConcurrentHashMap.newKeySet(30);
    private int hoverTicksStep = 5;
    final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    final Location useBedLeaveLoc = new Location(null, 0.0, 0.0, 0.0);
    final Location useChangeWorldLoc = new Location(null, 0.0, 0.0, 0.0);
    final Location useDeathLoc = new Location(null, 0.0, 0.0, 0.0);
    final Location useFallLoc = new Location(null, 0.0, 0.0, 0.0);
    final Location useJoinLoc = new Location(null, 0.0, 0.0, 0.0);
    final Location useLeaveLoc = new Location(null, 0.0, 0.0, 0.0);
    final Location useToggleFlightLoc = new Location(null, 0.0, 0.0, 0.0);
    final Location useTickLoc = new Location(null, 0.0, 0.0, 0.0);
    private final AuxMoving aux = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(AuxMoving.class);
    private final BlockChangeTracker blockChangeTracker;
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);
    private final int idMoveEvent = this.counters.registerKey("event.player.move");
    private final boolean ServerIsAtLeast1_19_4 = ServerVersion.isAtLeast("1.19.4");

    public MovingListener() {
        super(CheckType.MOVING);
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        api.addComponent(this.vehicleChecks);
        this.blockChangeTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();
        api.register(((RegisterDataPlayer)((RegisterDataPlayer)((RegisterConfigWorld)api.newRegistrationContext().registerConfigWorld(MovingConfig.class).factory((IFactoryOne)new IFactoryOne<WorldFactoryArgument, MovingConfig>(){

            @Override
            public MovingConfig getNewInstance(WorldFactoryArgument arg) {
                return new MovingConfig(arg.worldData);
            }
        })).registerConfigTypesPlayer(CheckType.MOVING, true).context().registerDataPlayer(MovingData.class).factory((IFactoryOne)new IFactoryOne<PlayerFactoryArgument, MovingData>(){

            @Override
            public MovingData getNewInstance(PlayerFactoryArgument arg) {
                return new MovingData(arg.worldData.getGenericInstance(MovingConfig.class), arg.playerData);
            }
        })).addToGroups(CheckType.MOVING, false, new Class[]{IData.class, ICheckData.class})).removeSubCheckData(CheckType.MOVING, true).context());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerSleep(PlayerBedEnterEvent event) {
        DataManager.getGenericInstance((Player)event.getPlayer(), MovingData.class).wasInBed = true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerWake(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        if (pData.isCheckActive(CheckType.MOVING_SURVIVALFLY, player) && this.survivalFly.checkBed(player, cc, data)) {
            Location newTo = null;
            Location loc = player.getLocation(this.useBedLeaveLoc);
            PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
            moveInfo.set(player, loc, null, cc.yOnGround);
            boolean sfCheck = MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, (PlayerLocation)moveInfo.to, data, cc, pData);
            this.aux.returnPlayerMoveInfo(moveInfo);
            if (sfCheck) {
                newTo = MovingUtil.getApplicableSetBackLocation(player, loc.getYaw(), loc.getPitch(), (PlayerLocation)moveInfo.from, data, cc);
            }
            if (newTo == null) {
                newTo = LocUtil.clone(loc);
            }
            if (sfCheck && cc.sfSetBackPolicyFallDamage && this.noFall.isEnabled(player, pData)) {
                double y = loc.getY();
                if (data.hasSetBack()) {
                    y = Math.min(y, data.getSetBackY());
                }
                this.noFall.checkDamage(player, y, data, pData);
            }
            this.useBedLeaveLoc.setWorld(null);
            data.prepareSetBack(newTo);
            SchedulerHelper.teleportEntity((Entity)player, newTo, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
        } else {
            data.wasInBed = false;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onUnknowBoatTeleport(PlayerTeleportEvent event) {
        if (!Bridge1_13.hasIsSwimming() || this.ServerIsAtLeast1_19_4) {
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.UNKNOWN) {
            Player player = event.getPlayer();
            IPlayerData pData = DataManager.getPlayerData(player);
            MovingData data = pData.getGenericInstance(MovingData.class);
            if (data.lastVehicleType != null && this.standsOnEntity((Entity)player, player.getLocation().getY())) {
                event.setCancelled(true);
                player.setSwimming(false);
            }
        }
    }

    private boolean standsOnEntity(Entity entity, double minY) {
        for (Entity other : entity.getNearbyEntities(1.5, 1.5, 1.5)) {
            EntityType type = other.getType();
            if (!MaterialUtil.isBoat(type)) continue;
            Material m = other.getLocation().getBlock().getType();
            double locY = other.getLocation().getY();
            return Math.abs(locY - minY) < 0.7 && BlockProperties.isLiquid(m);
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        data.clearMostMovingCheckData();
        Location loc = player.getLocation(this.useChangeWorldLoc);
        data.setSetBack(loc);
        if (cc.loadChunksOnWorldChange) {
            MovingUtil.ensureChunksLoaded(player, loc, "world change", data, cc, pData);
        }
        this.aux.resetPositionsAndMediumProperties(player, loc, data, cc);
        data.resetTrace(player, loc, TickTask.getTick(), (IEntityAccessDimensions)this.mcAccess.getHandle(), cc);
        if (cc.enforceLocation) {
            this.playersEnforce.add(player.getName());
        }
        this.useChangeWorldLoc.setWorld(null);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWindChargeExplode(EntityExplodeEvent e) {
        if (e.getEntity().getType() == BridgeEntityType.WIND_CHARGE) {
            Location loc = e.getLocation();
            for (Entity affectedPlayer : loc.getWorld().getNearbyEntities(loc, 1.2, 1.2, 1.2, entity -> entity.getType() == EntityType.PLAYER)) {
                Player player = (Player)affectedPlayer;
                IPlayerData pData = DataManager.getPlayerData(player);
                MovingData data = pData.getGenericInstance(MovingData.class);
                if (!pData.isCheckActive(CheckType.MOVING, player)) continue;
                data.noFallCurrentLocOnWindChargeHit = player.getLocation().clone();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (player.isFlying() || event.isFlying() && !event.isCancelled()) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        if (!pData.isCheckActive(CheckType.MOVING, player)) {
            return;
        }
        MovingData data = pData.getGenericInstance(MovingData.class);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        Location loc = player.getLocation(this.useToggleFlightLoc);
        moveInfo.set(player, loc, null, cc.yOnGround);
        if (!MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, (PlayerLocation)moveInfo.to, data, cc, pData) || BlockProperties.isOnGroundOrResetCond(player, loc, cc.yOnGround)) {
            this.useToggleFlightLoc.setWorld(null);
            this.aux.returnPlayerMoveInfo(moveInfo);
            return;
        }
        this.aux.returnPlayerMoveInfo(moveInfo);
        this.useToggleFlightLoc.setWorld(null);
        data.addVelocity(player, cc, 0.0, 0.3, 0.0, VelocityFlags.FAKED);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || event.getNewGameMode() == GameMode.CREATIVE) {
            MovingData data = DataManager.getGenericInstance(player, MovingData.class);
            data.clearFlyData();
            data.clearPlayerMorePacketsData();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerPortalLowest(PlayerPortalEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (MovingUtil.hasScheduledPlayerSetBack(player)) {
            if (pData.isDebugActive(this.checkType)) {
                this.debug(player, "[PORTAL] Prevent use, due to a scheduled set back.");
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerPortal(PlayerPortalEvent event) {
        Location to = event.getTo();
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        MovingData data = pData.getGenericInstance(MovingData.class);
        if (pData.isDebugActive(this.checkType)) {
            this.debug(event.getPlayer(), "[PORTAL] to=" + to);
        }
        if (to != null) {
            data.clearMostMovingCheckData();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        data.clearMostMovingCheckData();
        data.setSetBack(player.getLocation(this.useDeathLoc));
        if (pData.isDebugActive(this.checkType)) {
            this.debug(player, "Death: " + player.getLocation(this.useDeathLoc));
        }
        this.useDeathLoc.setWorld(null);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerTeleportLowest(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        this.processingEvents.remove(player.getName());
        PlayerTeleportEvent.TeleportCause cause = event.getCause();
        switch (cause) {
            case COMMAND: 
            case ENDER_PEARL: {
                break;
            }
            default: {
                return;
            }
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        boolean debug = pData.isDebugActive(this.checkType);
        MovingData data = pData.getGenericInstance(MovingData.class);
        Location to = event.getTo();
        if (to == null) {
            if (!event.isCancelled()) {
                if (debug) {
                    this.debugTeleportMessage(player, event, "Cancel event, that has no target location (to) set.");
                }
                event.setCancelled(true);
            }
            return;
        }
        if (data.hasTeleported()) {
            if (data.isTeleportedPosition(to)) {
                return;
            }
            if (debug) {
                this.debugTeleportMessage(player, event, "Prevent teleport, due to a scheduled set back: ", to);
            }
            event.setCancelled(true);
            return;
        }
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        boolean cancel = false;
        if (cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            if (pData.getGenericInstance(CombinedConfig.class).enderPearlCheck && !BlockProperties.isPassable(to)) {
                cancel = true;
            }
        } else if (cc.passableUntrackedTeleportCheck) {
            Location newTo;
            if (cc.loadChunksOnTeleport) {
                MovingUtil.ensureChunksLoaded(player, to, "teleport", data, cc, pData);
            }
            if (MovingUtil.shouldCheckUntrackedLocation(player, to, pData) && (newTo = MovingUtil.checkUntrackedLocation(to)) != null) {
                event.setTo(newTo);
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, player.getName() + " correct untracked teleport destination (" + to + " corrected to " + newTo + ").");
            }
        }
        if (cancel) {
            event.setCancelled(true);
            if (debug) {
                this.debug(player, "TP " + cause + " (cancel): " + to);
            }
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (!event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        if (data.hasTeleported()) {
            event.setCancelled(false);
            if (!data.isTeleported(event.getTo())) {
                Location teleported = data.getTeleported();
                event.setTo(teleported);
                event.setFrom(teleported);
            }
            if (pData.isDebugActive(this.checkType)) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, player.getName() + " TP " + event.getCause() + " (revert cancel on set back): " + event.getTo());
            }
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
    public void onPlayerTeleportMonitor(PlayerTeleportEvent event) {
        Location from;
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        data.joinOrRespawn = false;
        Location to = event.getTo();
        if (event.isCancelled()) {
            this.onPlayerTeleportMonitorCancelled(player, event, to, data, pData);
            return;
        }
        if (to == null) {
            this.onPlayerTeleportMonitorNullTarget(player, event, to, data, pData);
            return;
        }
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        if (data.hasTeleported() && this.onPlayerTeleportMonitorHasTeleported(player, event, to, data, cc, pData)) {
            data.clearWindChargeImpulse();
            return;
        }
        boolean skipExtras = false;
        if (data.isVehicleSetBack) {
            if (event.getCause() != BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION) {
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING_VEHICLE) + "Unexpected teleport cause on vehicle set back: " + event.getCause());
            }
            skipExtras = true;
        }
        double fallDistance = data.noFallFallDistance;
        data.clearFlyData();
        data.clearPlayerMorePacketsData();
        data.setSetBack(to);
        data.sfHoverTicks = -1;
        if (cc.loadChunksOnTeleport) {
            MovingUtil.ensureChunksLoaded(player, to, "teleport", data, cc, pData);
        }
        this.aux.resetPositionsAndMediumProperties(player, to, data, cc);
        Combined.resetYawRate(player, to.getYaw(), System.currentTimeMillis(), true, pData);
        data.resetTeleported();
        if (!skipExtras) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.UNKNOWN || event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) {
                player.setFallDistance((float)fallDistance);
                data.noFallFallDistance = (float)fallDistance;
            } else if (fallDistance > 1.0 && fallDistance - (double)player.getFallDistance() > 0.0) {
                if (!cc.noFallTpReset) {
                    player.setFallDistance((float)fallDistance);
                    data.noFallFallDistance = (float)fallDistance;
                } else if (fallDistance >= this.attributeAccess.getHandle().getSafeFallDistance(player)) {
                    data.noFallSkipAirCheck = true;
                }
            }
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                data.noFallSkipAirCheck = true;
            }
        }
        if ((from = event.getFrom()) != null && event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL && !from.getWorld().getName().equals(to.getWorld().getName())) {
            data.crossWorldFrom = new SimplePositionWithLook(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            Open.checkClose(player);
        } else {
            data.crossWorldFrom = null;
        }
        if (pData.isDebugActive(this.checkType)) {
            this.debugTeleportMessage(player, event, "(normal)", to);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        if (player.isInsideVehicle()) {
            data.removeAllVelocity();
            return;
        }
        Vector velocity = event.getVelocity();
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        data.addVelocity(player, cc, velocity.getX(), velocity.getY(), velocity.getZ());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        this.checkFallDamageEvent((Player)entity, event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        data.clearMostMovingCheckData();
        data.resetSetBack();
        this.dataOnJoin(player, event.getRespawnLocation(), true, data, pData.getGenericInstance(MovingConfig.class), pData.isDebugActive(this.checkType));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerMoveMonitor(PlayerMoveEvent event) {
        long now = System.currentTimeMillis();
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (this.processingEvents.remove(player.getName()) == null) {
            return;
        }
        if (player.isDead() || player.isSleeping()) {
            return;
        }
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        data.lastMoveTime = now;
        Location from = event.getFrom();
        MovingData mData = pData.getGenericInstance(MovingData.class);
        int tick = TickTask.getTick();
        MovingConfig mCc = pData.getGenericInstance(MovingConfig.class);
        if (!event.isCancelled()) {
            Location pLoc = player.getLocation(this.useLoc);
            this.onMoveMonitorNotCancelled(player, TrigUtil.isSamePosAndLook(pLoc, from) ? from : pLoc, event.getTo(), now, tick, data, mData, mCc, pData);
            this.useLoc.setWorld(null);
        } else {
            this.onCancelledMove(player, from, tick, now, mData, mCc, data, pData);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        String token;
        boolean earlyReturn;
        this.counters.add(this.idMoveEvent, 1);
        Player player = event.getPlayer();
        this.processingEvents.put(player.getName(), event);
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        MovingData data = pData.getGenericInstance(MovingData.class);
        boolean debug = pData.isDebugActive(this.checkType);
        Location from = event.getFrom().clone();
        Location to = event.getTo().clone();
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        Location newTo = null;
        data.increasePlayerMoveCount();
        if (player.isInsideVehicle()) {
            newTo = this.vehicleChecks.onPlayerMoveVehicle(player, from, to, data, pData);
            earlyReturn = true;
            token = "vehicle";
        } else if (data.lastVehicleType == EntityType.MINECART && this.ServerIsAtLeast1_19_4 && to.distance(data.getSetBack(from)) < 3.0) {
            earlyReturn = true;
            token = "minecart-total";
            data.lastVehicleType = null;
        } else if (data.vehicleLeave && to.distance(from) > 3.0) {
            earlyReturn = true;
            token = "vehicle-leave-sb";
            newTo = data.getSetBack(from);
            data.vehicleLeave = false;
        } else if (player.isDead()) {
            data.sfHoverTicks = -1;
            earlyReturn = true;
            token = "dead";
        } else if (player.isSleeping()) {
            data.sfHoverTicks = -1;
            earlyReturn = true;
            token = "sleeping";
        } else if (!from.getWorld().equals((Object)to.getWorld())) {
            earlyReturn = true;
            token = "worldchange";
        } else if (data.hasTeleported()) {
            earlyReturn = this.handleTeleportedOnMove(player, event, data, cc, pData);
            token = "awaitsetback";
        } else if (TrigUtil.isSamePos(from, to) && !data.lastMoveNoMove && pData.getClientVersion().isAtLeast(ClientVersion.V_1_17) && pData.getClientVersion().isAtMost(ClientVersion.V_1_20_6)) {
            thisMove.hasNoMovementDueToDuplicatePacket = true;
            data.lastMoveNoMove = true;
            earlyReturn = true;
            token = "duplicate1.17";
        } else {
            earlyReturn = false;
            token = null;
        }
        if (!TrigUtil.isSamePos(from, to)) {
            thisMove.hasNoMovementDueToDuplicatePacket = false;
            data.lastMoveNoMove = false;
        }
        if (earlyReturn) {
            if (debug) {
                this.debug(player, "Early return" + (token == null ? "" : " (" + token + ")") + " on PlayerMoveEvent: from: " + from + " , to: " + to);
            }
            if (newTo != null) {
                if (LocUtil.needsYawCorrection(newTo.getYaw())) {
                    newTo.setYaw(LocUtil.correctYaw(newTo.getYaw()));
                }
                if (LocUtil.needsPitchCorrection(newTo.getPitch())) {
                    newTo.setPitch(LocUtil.correctPitch(newTo.getPitch()));
                }
                this.prepareSetBack(player, event, newTo, data, cc, pData);
            }
            data.joinOrRespawn = false;
            return;
        }
        data.hasLeatherBoots = BridgeMisc.canStandOnPowderSnow(player);
        data.lastY = from.getY();
        if (SchedulerHelper.isFoliaServer()) {
            if (data.fromMissedWorldChange != null && !data.fromMissedWorldChange.equals((Object)from.getWorld())) {
                PlayerChangedWorldEvent e = new PlayerChangedWorldEvent(player, data.fromMissedWorldChange);
                Bukkit.getPluginManager().callEvent((Event)e);
            }
            data.fromMissedWorldChange = from.getWorld();
        }
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        Location loc = player.getLocation(moveInfo.useLoc);
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (cc.loadChunksOnMove) {
            MovingUtil.ensureChunksLoaded(player, from, to, lastMove, "move", cc, pData);
        }
        if (TrigUtil.isSamePos(from, loc) || lastMove.valid && TrigUtil.isSamePos(loc, lastMove.from.getX(), lastMove.from.getY(), lastMove.from.getZ())) {
            FlyingQueueHandle flyingHandle = new FlyingQueueHandle(pData);
            DataPacketFlying[] queue = flyingHandle.getHandle();
            float currentYaw = from.getYaw();
            float currentPitch = from.getPitch();
            int count = 0;
            boolean breakOnFound = false;
            if (queue.length != 0) {
                for (int queueIndex = queue.length - 1; queueIndex >= 0; --queueIndex) {
                    DataPacketFlying packetData = queue[queueIndex];
                    if (packetData == null || !packetData.hasPos && !packetData.hasLook) continue;
                    if (breakOnFound && packetData.hasPos) break;
                    if (packetData.hasLook) {
                        currentYaw = packetData.getYaw();
                        currentPitch = packetData.getPitch();
                        if (!packetData.hasPos) continue;
                    }
                    if (count < 1 && TrigUtil.isSamePos(from.getX(), from.getY(), from.getZ(), packetData.getX(), packetData.getY(), packetData.getZ())) {
                        from.setYaw(currentYaw);
                        from.setPitch(currentPitch);
                        ++count;
                        continue;
                    }
                    if (!TrigUtil.isSamePos(to.getX(), to.getY(), to.getZ(), packetData.getX(), packetData.getY(), packetData.getZ())) continue;
                    breakOnFound = true;
                }
                to.setYaw(currentYaw);
                to.setPitch(currentPitch);
            }
            moveInfo.set(player, from, to, cc.yOnGround);
            this.checkPlayerMove(player, from, to, 0, moveInfo, debug, data, cc, pData, event, true);
        } else {
            FlyingQueueHandle flyingHandle = new FlyingQueueHandle(pData);
            DataPacketFlying[] queue = flyingHandle.getHandle();
            if (queue.length != 0) {
                int fromIndex = -1;
                int toIndex = -1;
                for (int queueIndex = 0; queueIndex < queue.length; ++queueIndex) {
                    DataPacketFlying packetData = queue[queueIndex];
                    if (packetData == null || !packetData.hasPos) continue;
                    if (toIndex == -1 && TrigUtil.isSamePos(to.getX(), to.getY(), to.getZ(), packetData.getX(), packetData.getY(), packetData.getZ())) {
                        toIndex = queueIndex;
                    } else if (fromIndex == -1 && TrigUtil.isSamePos(from.getX(), from.getY(), from.getZ(), packetData.getX(), packetData.getY(), packetData.getZ())) {
                        fromIndex = queueIndex;
                    }
                    if (fromIndex > 0 && toIndex >= 0) break;
                }
                if (fromIndex < 0 || toIndex < 0 || fromIndex - toIndex + 1 < 1) {
                    this.bukkitSplitMove(player, moveInfo, from, loc, to, debug, data, cc, pData, event);
                    data.joinOrRespawn = false;
                    this.aux.returnPlayerMoveInfo(moveInfo);
                    if (debug) {
                        this.debug(player, "Fallback to Bukkit-based split moves. (Flying queue indices - from: " + fromIndex + ", to: " + toIndex + ")");
                    }
                    return;
                }
                DataPacketFlying[] queuePos = new DataPacketFlying[fromIndex - toIndex + 1];
                int j = 0;
                for (int i = fromIndex; i >= toIndex; --i) {
                    if (queue[i] == null || !queue[i].hasPos && !queue[i].hasLook) continue;
                    queuePos[j] = queue[i];
                    ++j;
                }
                int count = 1;
                int maxSplit = 14;
                float currentYaw = from.getYaw();
                float currentPitch = from.getPitch();
                Location packet = null;
                for (int i = 0; i < j; ++i) {
                    if (queuePos[i].hasLook) {
                        currentYaw = queuePos[i].getYaw();
                        currentPitch = queuePos[i].getPitch();
                    }
                    if (!queuePos[i].hasPos) continue;
                    if (packet != null) {
                        Location packetTo = count >= maxSplit ? to : new Location(from.getWorld(), queuePos[i].getX(), queuePos[i].getY(), queuePos[i].getZ(), currentYaw, currentPitch);
                        moveInfo.set(player, packet, packetTo, cc.yOnGround);
                        if (debug) {
                            String s1 = count == 1 ? "from" : "loc";
                            String s2 = i == j - 1 || count >= maxSplit ? "to" : "loc";
                            this.debug(player, "Split move (packet): " + count + " (" + s1 + " -> " + s2 + ")");
                        }
                        if (this.checkPlayerMove(player, packet, packetTo, count++, moveInfo, debug, data, cc, pData, event, true) || !this.processingEvents.containsKey(player.getName())) break;
                        this.onMoveMonitorNotCancelled(player, packet, packetTo, System.currentTimeMillis(), TickTask.getTick(), pData.getGenericInstance(CombinedData.class), data, cc, pData);
                        data.joinOrRespawn = false;
                        if (count > maxSplit) break;
                    }
                    packet = new Location(from.getWorld(), queuePos[i].getX(), queuePos[i].getY(), queuePos[i].getZ(), currentYaw, currentPitch);
                }
            } else {
                this.bukkitSplitMove(player, moveInfo, from, loc, to, debug, data, cc, pData, event);
                if (debug) {
                    this.debug(player, "Flying queue is empty. Fallback to Bukkit-based split moves.");
                }
            }
        }
        data.joinOrRespawn = false;
        this.aux.returnPlayerMoveInfo(moveInfo);
    }

    private void bukkitSplitMove(Player player, PlayerMoveInfo moveInfo, Location from, Location loc, Location to, boolean debug, MovingData data, MovingConfig cc, IPlayerData pData, PlayerMoveEvent event) {
        moveInfo.set(player, from, loc, cc.yOnGround);
        if (debug) {
            this.debug(player, "Split move (bukkit): 1 (from -> loc)");
        }
        if (!this.checkPlayerMove(player, from, loc, 1, moveInfo, debug, data, cc, pData, event, false) && this.processingEvents.containsKey(player.getName())) {
            this.onMoveMonitorNotCancelled(player, from, loc, System.currentTimeMillis(), TickTask.getTick(), pData.getGenericInstance(CombinedData.class), data, cc, pData);
            data.joinOrRespawn = false;
            moveInfo.set(player, loc, to, cc.yOnGround);
            this.checkPlayerMove(player, loc, to, 2, moveInfo, debug, data, cc, pData, event, false);
            if (debug) {
                this.debug(player, "Split move (bukkit): 2 (loc -> to)");
            }
        }
    }

    private boolean handleTeleportedOnMove(Player player, PlayerMoveEvent event, MovingData data, MovingConfig cc, IPlayerData pData) {
        boolean debug = pData.isDebugActive(this.checkType);
        if (data.isTeleportedPosition(event.getFrom())) {
            this.confirmSetBack(player, false, data, cc, pData, event.getFrom());
            if (debug) {
                this.debug(player, "Implicitly confirm set back with the start point of a move.");
            }
            return false;
        }
        if (DataManager.getPlayerData(player).isPlayerSetBackScheduled()) {
            event.setCancelled(true);
            if (debug) {
                this.debug(player, "Cancel move, due to a scheduled teleport (set back).");
            }
            return true;
        }
        if (debug) {
            this.debug(player, "Invalidate left-over teleported (set back) location: " + data.getTeleported());
        }
        data.resetTeleported();
        return false;
    }

    private boolean checkPlayerMove(Player player, Location from, Location to, int multiMoveCount, PlayerMoveInfo moveInfo, boolean debug, MovingData data, MovingConfig cc, IPlayerData pData, PlayerMoveEvent event, boolean isNormalOrPacketSplitMove) {
        boolean useBlockChangeTracker;
        double previousSetBackY;
        boolean checkSf;
        boolean checkCf;
        double jumpAmplifier;
        Location newTo = null;
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        String playerName = player.getName();
        long time = System.currentTimeMillis();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        data.resetTeleported();
        if (debug) {
            this.outputMoveDebug(player, (PlayerLocation)moveInfo.from, (PlayerLocation)moveInfo.to, Math.max(cc.noFallyOnGround, cc.yOnGround), (MCAccess)this.mcAccess.getHandle());
        }
        if (((PlayerLocation)moveInfo.from).hasIllegalCoords() || ((PlayerLocation)moveInfo.to).hasIllegalCoords() || !cc.ignoreStance && (((PlayerLocation)moveInfo.from).hasIllegalStance() || ((PlayerLocation)moveInfo.to).hasIllegalStance())) {
            MovingUtil.handleIllegalMove(event, player, data, cc);
            return true;
        }
        if (cc.enforceLocation && this.playersEnforce.contains(playerName)) {
            newTo = this.enforceLocation(player, from, data);
            this.playersEnforce.remove(playerName);
        }
        PlayerLocation pFrom = (PlayerLocation)moveInfo.from;
        PlayerLocation pTo = (PlayerLocation)moveInfo.to;
        if (data.timeRiptiding + 1500L > System.currentTimeMillis() || pFrom.isInLiquid() || pFrom.isOnClimbable() || Bridge1_9.isGlidingWithElytra(player)) {
            data.clearWindChargeImpulse();
        }
        if (data.wasInVehicle) {
            this.vehicleChecks.onVehicleLeaveMiss(player, data, cc, pData);
        }
        thisMove.set(pFrom, pTo);
        thisMove.multiMoveCount = multiMoveCount;
        thisMove.setBackYDistance = pTo.getY() - data.getSetBackY();
        thisMove.hasLevitation = !Double.isInfinite(Bridge1_9.getLevitationAmplifier(player));
        thisMove.hasSlowfall = !Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player));
        thisMove.hasGravity = BridgeMisc.hasGravity((LivingEntity)player);
        thisMove.isGliding = Bridge1_9.isGliding((LivingEntity)player);
        thisMove.isRiptiding = Bridge1_13.isRiptiding((LivingEntity)player);
        thisMove.isSprinting = pData.isSprinting();
        thisMove.isCrouching = pData.isInCrouchingPose();
        thisMove.isSwimming = Bridge1_13.isSwimming((LivingEntity)player);
        thisMove.slowedByUsingAnItem = BridgeMisc.isUsingItem(player);
        if (BridgeMisc.isSpaceBarImpulseKnown(player)) {
            thisMove.isSpaceBarImpulse = player.getCurrentInput().isJump();
        }
        if ((jumpAmplifier = this.aux.getJumpAmplifier(player)) > data.jumpAmplifier) {
            data.jumpAmplifier = jumpAmplifier;
        }
        int tick = TickTask.getTick();
        data.velocityTick(tick - cc.velocityActivationTicks);
        float walkSpeed = this.attributeAccess.getHandle().getMovementSpeed(player);
        if (walkSpeed == Float.MAX_VALUE) {
            if (debug) {
                this.debug(player, "The player's movement speed attribute couldn't be retrieved. Fallback to manual calculation.");
            }
            walkSpeed = player.getWalkSpeed() / 2.0f;
            if (!Double.isInfinite(((MCAccess)this.mcAccess.getHandle()).getFasterMovementAmplifier(player))) {
                walkSpeed += (float)(((MCAccess)this.mcAccess.getHandle()).getFasterMovementAmplifier(player) + 1.0) * 0.2f * walkSpeed;
            }
            if (!Double.isInfinite(PotionUtil.getPotionEffectAmplifier(player, BridgePotionEffect.SLOWNESS))) {
                walkSpeed += (float)(PotionUtil.getPotionEffectAmplifier(player, BridgePotionEffect.SLOWNESS) + 1.0) * -0.15f * walkSpeed;
            }
        }
        if (MovingUtil.shouldCheckSurvivalFly(player, pFrom, pTo, data, cc, pData)) {
            checkCf = false;
            checkSf = true;
            thisMove.flyCheck = CheckType.MOVING_SURVIVALFLY;
            data.adjustWalkSpeed(walkSpeed, tick, cc.speedGrace);
        } else if (pData.isCheckActive(CheckType.MOVING_CREATIVEFLY, player)) {
            checkCf = true;
            checkSf = false;
            thisMove.flyCheck = CheckType.MOVING_CREATIVEFLY;
            this.prepareCreativeFlyCheck(player, from, to, moveInfo, thisMove, multiMoveCount, tick, data, cc, walkSpeed);
        } else {
            checkSf = false;
            checkCf = false;
        }
        boolean checkNf = true;
        BounceType verticalBounce = BounceType.NO_BOUNCE;
        boolean checkPassable = pData.isCheckActive(CheckType.MOVING_PASSABLE, player);
        if (data.fireworksBoostDuration > 0) {
            data.fireworksBoostDuration = !lastMove.valid || data.fireworksBoostTickExpire < tick ? 0 : --data.fireworksBoostDuration;
        }
        if (Bridge1_13.isRiptiding((LivingEntity)player)) {
            data.timeRiptiding = System.currentTimeMillis();
        }
        if (data.lastVehicleType != null && thisMove.distanceSquared < 5.0) {
            data.setSetBack(from);
            data.addVerticalVelocity(new SimpleEntry(thisMove.yDistance, 1));
            data.lastVehicleType = null;
        }
        if (checkSf || checkCf) {
            previousSetBackY = data.hasSetBack() ? data.getSetBackY() : Double.NEGATIVE_INFINITY;
            MovingUtil.checkSetBack(player, pFrom, data, pData, this);
            if (data.crossWorldFrom != null) {
                if (!TrigUtil.isSamePosAndLook((IGetPositionWithLook)pFrom, pTo) && TrigUtil.isSamePosAndLook((IGetPositionWithLook)pTo, data.crossWorldFrom)) {
                    newTo = data.getSetBack(from);
                    checkNf = false;
                    Open.checkClose(player);
                    NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING) + " Player move end point seems to be set wrongly.");
                }
                data.crossWorldFrom = null;
            }
            if (lastMove.to.getWorldName() != null && !lastMove.to.getWorldName().equals(thisMove.from.getWorldName()) && TrigUtil.distance(pFrom, pTo) > 5.5) {
                newTo = data.getSetBack(from);
                checkNf = false;
                Open.checkClose(player);
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING) + " Player move end point seems to be set wrongly.");
            }
            if (newTo == null && (Math.abs(thisMove.yDistance) > 7.0 || thisMove.hDistance > 15.0)) {
                newTo = this.checkExtremeMove(player, pFrom, pTo, data, cc);
            }
            boolean bl = useBlockChangeTracker = newTo == null && cc.trackBlockMove && this.blockChangeTracker.hasActivityShuffled(from.getWorld().getUID(), pFrom, pTo, 1.5625);
            if (newTo == null) {
                if (thisMove.yDistance < 0.0) {
                    pTo.collectBlockFlags();
                    if (PhysicsEnvelope.canBounce(player, pFrom, pTo, data, cc, pData)) {
                        if ((pTo.getBlockFlags() & BlockFlags.F_BOUNCE25) != 0L) {
                            verticalBounce = BounceType.STATIC;
                            checkNf = false;
                        }
                        if (verticalBounce == BounceType.NO_BOUNCE && useBlockChangeTracker && BounceHandler.checkPastStateBounceDescend(player, pFrom, pTo, thisMove, lastMove, tick, data, cc, this.blockChangeTracker) != BounceType.NO_BOUNCE) {
                            checkNf = false;
                        }
                    }
                } else if ((data.verticalBounce != null && BounceHandler.onPreparedBounceSupport(player, from, to, thisMove, lastMove, tick, data) || useBlockChangeTracker && thisMove.yDistance <= 1.515) && (verticalBounce = BounceHandler.checkPastStateBounceAscend(player, pFrom, pTo, thisMove, lastMove, tick, pData, this, data, cc, this.blockChangeTracker)) != BounceType.NO_BOUNCE) {
                    checkNf = false;
                }
                if (useBlockChangeTracker && checkNf && !this.checkPastStateVerticalPush(player, pFrom, pTo, thisMove, lastMove, tick, debug, data, cc)) {
                    this.checkPastStateHorizontalPush(player, pFrom, pTo, thisMove, lastMove, tick, debug, data, cc);
                }
                if (!Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player))) {
                    checkNf = false;
                } else if (!Double.isInfinite(Bridge1_9.getLevitationAmplifier(player))) {
                    checkNf = false;
                }
            }
        } else {
            useBlockChangeTracker = false;
            previousSetBackY = Double.NEGATIVE_INFINITY;
        }
        boolean mightSkipNoFall = false;
        if (newTo == null && checkPassable && player.getGameMode() != BridgeMisc.GAME_MODE_SPECTATOR && (newTo = this.passable.check(player, pFrom, pTo, data, cc, pData, tick, useBlockChangeTracker)) != null) {
            mightSkipNoFall = true;
        }
        if (checkSf) {
            MovingUtil.prepareFullCheck(pFrom, pTo, thisMove, Math.max(cc.noFallyOnGround, cc.yOnGround));
            if (newTo == null) {
                newTo = this.survivalFly.check(player, pFrom, pTo, multiMoveCount, data, cc, pData, tick, time, useBlockChangeTracker, isNormalOrPacketSplitMove);
            }
            if (checkNf) {
                checkNf = this.noFall.isEnabled(player, pData);
            }
            if (newTo == null) {
                if (!(!cc.sfHoverCheck || lastMove.toIsValid && lastMove.to.extraPropertiesValid && lastMove.to.onGroundOrResetCond || pTo.isOnGround())) {
                    this.hoverTicks.add(playerName);
                    data.sfHoverTicks = 0;
                } else {
                    data.sfHoverTicks = -1;
                }
                if (checkNf) {
                    this.noFall.check(player, pFrom, pTo, previousSetBackY, data, cc, pData);
                }
            } else if (checkNf && cc.sfSetBackPolicyFallDamage) {
                if (!this.noFall.willDealFallDamage(player, from.getY(), previousSetBackY, data)) {
                    mightSkipNoFall = true;
                } else if (mightSkipNoFall && !pFrom.isOnGround() && !pFrom.isResetCond()) {
                    mightSkipNoFall = false;
                }
                if (!(mightSkipNoFall || pTo.isResetCond() && pFrom.isResetCond())) {
                    this.noFall.checkDamage(player, Math.min(from.getY(), to.getY()), data, pData);
                }
            }
        } else if (checkCf) {
            if (newTo == null) {
                newTo = this.creativeFly.check(player, pFrom, pTo, data, cc, pData, time, tick, useBlockChangeTracker);
                if (checkNf) {
                    this.noFall.check(player, pFrom, pTo, previousSetBackY, data, cc, pData);
                }
            }
            data.sfHoverTicks = -1;
        } else {
            data.clearFlyData();
        }
        if (pData.isCheckActive(CheckType.MOVING_MOREPACKETS, player) && (newTo == null || data.isMorePacketsSetBackOldest())) {
            Location mpNewTo = this.morePackets.check(player, pFrom, pTo, newTo == null, data, cc, pData);
            if (mpNewTo != null) {
                if (newTo != null && debug) {
                    this.debug(player, "Override set back by the older morepackets set back.");
                }
                newTo = mpNewTo;
            }
        } else {
            data.clearPlayerMorePacketsData();
        }
        if ((checkSf || checkCf) && jumpAmplifier != data.jumpAmplifier && (thisMove.touchedGround || !checkSf && (pFrom.isOnGround() || pTo.isOnGround()))) {
            data.jumpAmplifier = jumpAmplifier;
        }
        if (useBlockChangeTracker && data.blockChangeRef.firstSpanEntry != null) {
            if (debug) {
                this.debug(player, "BlockChangeReference: " + data.blockChangeRef.firstSpanEntry.tick + " .. " + data.blockChangeRef.lastSpanEntry.tick + " / " + tick);
            }
            data.blockChangeRef.updateFinal(pTo);
        }
        if (newTo == null) {
            if (data.hasTeleported()) {
                data.resetTeleported();
                if (debug) {
                    this.debug(player, "Ignore hook-induced set-back: actions not set to cancel.");
                }
            }
            if (verticalBounce != BounceType.NO_BOUNCE) {
                BounceHandler.processBounce(player, pFrom.getY(), pTo.getY(), verticalBounce, tick, this, data, cc, pData);
            }
            if (this.processingEvents.containsKey(playerName)) {
                data.playerMoves.finishCurrentMove();
                data.playerMoves.getCurrentMove().input = thisMove.input;
            } else {
                thisMove.invalidate();
            }
            ++data.timeSinceSetBack;
            return false;
        }
        if (data.hasTeleported()) {
            if (debug) {
                this.debug(player, "The set back has been overridden from (" + newTo + ") to: " + data.getTeleported());
            }
            newTo = data.getTeleported();
        }
        if (debug) {
            if (verticalBounce != BounceType.NO_BOUNCE) {
                this.debug(player, "Bounce effect not processed: " + (Object)((Object)verticalBounce));
            }
            if (data.verticalBounce != null) {
                this.debug(player, "Bounce effect not used: " + data.verticalBounce);
            }
        }
        this.prepareSetBack(player, event, newTo, data, cc, pData);
        return true;
    }

    private void prepareCreativeFlyCheck(Player player, Location from, Location to, PlayerMoveInfo moveInfo, PlayerMoveData thisMove, int multiMoveCount, int tick, MovingData data, MovingConfig cc, float walkSpeed) {
        data.adjustFlySpeed(player.getFlySpeed(), tick, cc.speedGrace);
        data.adjustWalkSpeed(walkSpeed, tick, cc.speedGrace);
        thisMove.modelFlying = cc.getModelFlying(player, (PlayerLocation)moveInfo.from, data, cc);
    }

    private boolean checkPastStateVerticalPush(Player player, PlayerLocation from, PlayerLocation to, PlayerMoveData thisMove, PlayerMoveData lastMove, int tick, boolean debug, MovingData data, MovingConfig cc) {
        UUID worldId = from.getWorld().getUID();
        double amount = -1.0;
        boolean addvel = false;
        BlockChangeTracker.BlockChangeEntry entryBelowY_POS = this.BlockChangeSearch(from, tick, BlockChangeTracker.Direction.Y_POS, debug, data, cc, worldId, true);
        if (entryBelowY_POS != null) {
            if (debug) {
                StringBuilder builder = new StringBuilder(150);
                builder.append("Direct block push at (");
                builder.append("x:" + entryBelowY_POS.x);
                builder.append(" y:" + entryBelowY_POS.y);
                builder.append(" z:" + entryBelowY_POS.z);
                builder.append(" direction:" + entryBelowY_POS.direction.name());
                builder.append(")");
                this.debug(player, builder.toString());
            }
            if (lastMove.valid && thisMove.yDistance >= 0.0) {
                if ((from.isOnGroundOrResetCond() || thisMove.touchedGroundWorkaround) && from.isOnGround(1.0)) {
                    amount = Math.min(thisMove.yDistance, 0.5625);
                } else if (lastMove.yDistance < -0.0834) {
                    amount = Math.min(thisMove.yDistance, 0.34);
                }
                if (thisMove.yDistance == 0.0) {
                    amount = 0.0;
                }
            }
            if (lastMove.toIsValid && amount < 0.0 && thisMove.yDistance < 0.0 && thisMove.yDistance > -1.515 && lastMove.yDistance >= 0.0) {
                amount = thisMove.yDistance;
                addvel = true;
            }
            if (entryBelowY_POS != null) {
                data.blockChangeRef.updateSpan(entryBelowY_POS);
            }
        }
        if (amount >= 0.0 || addvel) {
            SimpleEntry vel;
            data.removeLeadingQueuedVerticalVelocityByFlag(VelocityFlags.ORIGIN_BLOCK_MOVE);
            data.verticalBounce = vel = new SimpleEntry(tick, amount, VelocityFlags.ORIGIN_BLOCK_MOVE, 1);
            data.useVerticalBounce(player);
            data.useVerticalVelocity(thisMove.yDistance);
            if (debug) {
                this.debug(player, "checkPastStateVerticalPush: set velocity: " + vel);
            }
            return true;
        }
        return false;
    }

    private BlockChangeTracker.BlockChangeEntry BlockChangeSearch(PlayerLocation from, int tick, BlockChangeTracker.Direction direction, boolean debug, MovingData data, MovingConfig cc, UUID worldId, boolean searchBelow) {
        int iMinX = Location.locToBlock((double)from.getMinX());
        int iMaxX = Location.locToBlock((double)from.getMaxX());
        int iMinZ = Location.locToBlock((double)from.getMinZ());
        int iMaxZ = Location.locToBlock((double)from.getMaxZ());
        int belowY = from.getBlockY() - (searchBelow ? 1 : 0);
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = belowY; y <= belowY + 1; ++y) {
                    BlockChangeTracker.BlockChangeEntry entryBelowY_POS = this.blockChangeTracker.getBlockChangeEntry(data.blockChangeRef, tick, worldId, x, y, z, direction);
                    if (entryBelowY_POS == null) continue;
                    return entryBelowY_POS;
                }
            }
        }
        return null;
    }

    private boolean checkPastStateHorizontalPush(Player player, PlayerLocation from, PlayerLocation to, PlayerMoveData thisMove, PlayerMoveData lastMove, int tick, boolean debug, MovingData data, MovingConfig cc) {
        UUID worldId = from.getWorld().getUID();
        double xDistance = to.getX() - from.getX();
        double zDistance = to.getZ() - from.getZ();
        BlockChangeTracker.Direction dir = Math.abs(xDistance) > Math.abs(zDistance) ? (xDistance > 0.0 ? BlockChangeTracker.Direction.X_POS : BlockChangeTracker.Direction.X_NEG) : (zDistance > 0.0 ? BlockChangeTracker.Direction.Z_POS : BlockChangeTracker.Direction.Z_NEG);
        BlockChangeTracker.BlockChangeEntry entry = this.BlockChangeSearch(from, tick, dir, debug, data, cc, worldId, false);
        if (entry != null) {
            int count = MovingData.getHorVelValCount(0.6);
            data.addVerticalVelocity(new SimpleEntry(-0.35, 6));
            data.blockChangeRef.updateSpan(entry);
            if (debug) {
                StringBuilder builder = new StringBuilder(150);
                builder.append("Direct block push at (");
                builder.append("x:" + entry.x);
                builder.append(" y:" + entry.y);
                builder.append(" z:" + entry.z);
                builder.append(" direction:" + entry.direction.name());
                builder.append(")");
                this.debug(player, builder.toString());
                this.debug(player, "checkPastStateHorizontalPush: set velocity: 0.6");
            }
            return true;
        }
        return false;
    }

    private Location checkExtremeMove(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc) {
        PlayerMoveData thisMove = data.playerMoves.getCurrentMove();
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        double violation = 0.0;
        boolean allowVerticalVelocity = false;
        if (!(!(Math.abs(thisMove.yDistance) > 7.0) || lastMove.toIsValid && Math.abs(thisMove.yDistance) < Math.abs(lastMove.yDistance) && (thisMove.yDistance > 0.0 && lastMove.yDistance > 0.0 || thisMove.yDistance < 0.0 && lastMove.yDistance < 0.0))) {
            violation += thisMove.yDistance;
        }
        if (thisMove.hDistance > 15.0) {
            violation += thisMove.hDistance;
        }
        if (violation > 0.0) {
            double vL;
            ActionList actions;
            Check check;
            Improbable.check(player, (float)violation, System.currentTimeMillis(), "extreme.move", DataManager.getPlayerData(player));
            if (!data.hasSetBack()) {
                data.setSetBack(from);
            }
            violation *= 100.0;
            if (thisMove.flyCheck == CheckType.MOVING_SURVIVALFLY) {
                check = this.survivalFly;
                actions = cc.survivalFlyActions;
                data.survivalFlyVL += violation;
                vL = data.survivalFlyVL;
            } else {
                check = this.creativeFly;
                actions = cc.creativeFlyActions;
                data.creativeFlyVL += violation;
                vL = data.creativeFlyVL;
            }
            ViolationData vd = new ViolationData(check, player, vL, violation, actions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
                vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
                vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance(from, to)));
                vd.setParameter(ParameterName.TAGS, "EXTREME_MOVE");
            }
            if (check.executeActions(vd).willCancel()) {
                return MovingUtil.getApplicableSetBackLocation(player, to.getYaw(), to.getPitch(), from, data, cc);
            }
        }
        return null;
    }

    private void prepareSetBack(Player player, PlayerMoveEvent event, Location newTo, MovingData data, MovingConfig cc, IPlayerData pData) {
        if (LocUtil.needsYawCorrection(newTo.getYaw())) {
            newTo.setYaw(LocUtil.correctYaw(newTo.getYaw()));
        }
        if (LocUtil.needsPitchCorrection(newTo.getPitch())) {
            newTo.setPitch(LocUtil.correctPitch(newTo.getPitch()));
        }
        data.prepareSetBack(newTo);
        this.aux.resetPositionsAndMediumProperties(player, newTo, data, cc);
        PlayerSetBackMethod method = cc.playerSetBackMethod;
        if (method.shouldSetTo()) {
            event.setTo(newTo);
            if (pData.isDebugActive(this.checkType)) {
                this.debug(player, "Set back technique: SET_TO");
            }
        }
        if (method.shouldCancel()) {
            event.setCancelled(true);
            if (pData.isDebugActive(this.checkType)) {
                this.debug(player, "Set back technique: CANCEL (schedule:" + method.shouldSchedule() + " updateFrom:" + method.shouldUpdateFrom() + ")");
            }
        }
        if (pData.isDebugActive(this.checkType)) {
            this.debug(player, "Prepare set back to: " + newTo.getWorld().getName() + "/" + LocUtil.simpleFormatPosition(newTo) + " (" + method.getId() + ")");
        }
    }

    private void onCancelledMove(Player player, Location from, int tick, long now, MovingData mData, MovingConfig mCc, CombinedData data, IPlayerData pData) {
        boolean debug = pData.isDebugActive(this.checkType);
        if (mData.hasTeleported()) {
            Location ref = mData.getTeleported();
            PlayerSetBackMethod method = mCc.playerSetBackMethod;
            if (method.shouldUpdateFrom()) {
                LocUtil.set(from, ref);
            }
            if (method.shouldSchedule()) {
                IPlayerData pd = DataManager.getPlayerData(player);
                if (pd.isPlayerSetBackScheduled()) {
                    this.debug(player, "Teleport (set back) already scheduled to: " + ref);
                } else {
                    if (debug) {
                        this.debug(player, "Schedule a new teleport (isPlayerSetBackScheduled returned false, with teleported being set - set back) to: " + ref);
                    }
                    pd.requestPlayerSetBack();
                }
            }
        }
        Combined.resetYawRate(player, from.getYaw(), now, false, pData);
        this.aux.resetPositionsAndMediumProperties(player, from, mData, mCc);
        mData.resetTrace(player, from, tick, (IEntityAccessDimensions)this.mcAccess.getHandle(), mCc);
        pData.getGenericInstance(NetData.class).teleportQueue.onTeleportEvent(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
    }

    private void onMoveMonitorNotCancelled(Player player, Location from, Location to, long now, long tick, CombinedData data, MovingData mData, MovingConfig mCc, IPlayerData pData) {
        String toWorldName = to.getWorld().getName();
        boolean debug = pData.isDebugActive(this.checkType);
        Combined.feedYawRate(player, to.getYaw(), now, toWorldName, data, pData);
        if (player.isInsideVehicle()) {
            Location ref = player.getVehicle().getLocation(this.useLoc);
            this.aux.resetPositionsAndMediumProperties(player, ref, mData, mCc);
            this.useLoc.setWorld(null);
            mData.updateTrace(player, to, tick, (IEntityAccessDimensions)this.mcAccess.getHandle());
        } else if (!from.getWorld().getName().equals(toWorldName)) {
            this.aux.resetPositionsAndMediumProperties(player, to, mData, mCc);
            mData.resetTrace(player, to, tick, (IEntityAccessDimensions)this.mcAccess.getHandle(), mCc);
        } else {
            PlayerMoveData lastMove = mData.playerMoves.getFirstPastMove();
            if (!lastMove.toIsValid || !TrigUtil.isSamePos(to, lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ())) {
                this.aux.resetPositionsAndMediumProperties(player, to, mData, mCc);
            }
            mData.updateTrace(player, to, tick, (IEntityAccessDimensions)this.mcAccess.getHandle());
            if (mData.hasTeleported()) {
                if (mData.isTeleportedPosition(to)) {
                    if (debug) {
                        this.debug(player, "Event not cancelled, with teleported (set back) set, assume legacy behavior.");
                    }
                    return;
                }
                if (pData.isPlayerSetBackScheduled()) {
                    if (debug) {
                        this.debug(player, "Event not cancelled, despite a set back has been scheduled. Cancel set back.");
                    }
                    mData.resetTeleported();
                } else {
                    if (debug) {
                        this.debug(player, "Inconsistent state (move MONITOR): teleported has been set, but no set back is scheduled. Ignore set back.");
                    }
                    mData.resetTeleported();
                }
            }
        }
    }

    private boolean onPlayerTeleportMonitorHasTeleported(Player player, PlayerTeleportEvent event, Location to, MovingData data, MovingConfig cc, IPlayerData pData) {
        if (data.isTeleportedPosition(to)) {
            this.confirmSetBack(player, true, data, cc, pData, to);
            data.reducePlayerMorePacketsData(1.0f);
            if (pData.isDebugActive(this.checkType)) {
                this.debugTeleportMessage(player, event, "(set back)", to);
            }
            return true;
        }
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING) + " TP " + event.getCause() + " (set back was overridden): " + to);
        return false;
    }

    private void confirmSetBack(Player player, boolean fakeNews, MovingData data, MovingConfig cc, IPlayerData pData, Location fallbackTeleported) {
        Location teleported = data.getTeleported();
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        moveInfo.set(player, teleported != null ? teleported : fallbackTeleported, null, cc.yOnGround);
        if (cc.loadChunksOnTeleport) {
            MovingUtil.ensureChunksLoaded(player, teleported != null ? teleported : fallbackTeleported, "teleport", data, cc, pData);
        }
        data.onSetBack((PlayerLocation)moveInfo.from, teleported, cc, player);
        this.aux.returnPlayerMoveInfo(moveInfo);
        Combined.resetYawRate(player, teleported.getYaw(), System.currentTimeMillis(), true, pData);
        data.resetTeleported();
    }

    private void onPlayerTeleportMonitorCancelled(Player player, PlayerTeleportEvent event, Location to, MovingData data, IPlayerData pData) {
        if (data.isTeleported(to)) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.TRACE_FILE, CheckUtils.getLogMessagePrefix(player, CheckType.MOVING) + " TP " + event.getCause() + " (set back was prevented): " + to);
        } else if (pData.isDebugActive(this.checkType)) {
            this.debugTeleportMessage(player, event, to);
        }
        data.resetTeleported();
    }

    private void onPlayerTeleportMonitorNullTarget(Player player, PlayerTeleportEvent event, Location to, MovingData data, IPlayerData pData) {
        boolean debug = pData.isDebugActive(this.checkType);
        if (debug) {
            this.debugTeleportMessage(player, event, "No target location (to) set.");
        }
        if (data.hasTeleported()) {
            if (DataManager.getPlayerData(player).isPlayerSetBackScheduled()) {
                event.setCancelled(true);
                if (debug) {
                    this.debugTeleportMessage(player, event, "Cancel, due to a scheduled set back.");
                }
            } else {
                data.resetTeleported();
                if (debug) {
                    this.debugTeleportMessage(player, event, "Skip set back, not being scheduled.");
                }
            }
        }
    }

    private void debugTeleportMessage(Player player, PlayerTeleportEvent event, Object ... extra) {
        StringBuilder builder = new StringBuilder(128);
        builder.append("TP ");
        builder.append(event.getCause());
        if (event.isCancelled()) {
            builder.append(" (cancelled)");
        }
        if (extra != null && extra.length > 0) {
            for (Object obj : extra) {
                if (obj == null) continue;
                builder.append(' ');
                if (obj instanceof String) {
                    builder.append((String)obj);
                    continue;
                }
                builder.append(obj.toString());
            }
        }
        this.debug(player, builder.toString());
    }

    private void checkFallDamageEvent(Player player, EntityDamageEvent event) {
        double maxD;
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        if (player.isInsideVehicle()) {
            data.clearNoFallData();
            return;
        }
        MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
        PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
        double yOnGround = Math.max(cc.noFallyOnGround, cc.yOnGround);
        Location loc = player.getLocation(this.useFallLoc);
        moveInfo.set(player, loc, null, yOnGround);
        PlayerLocation pLoc = (PlayerLocation)moveInfo.from;
        pLoc.collectBlockFlags(yOnGround);
        if (event.isCancelled() || !MovingUtil.shouldCheckSurvivalFly(player, pLoc, (PlayerLocation)moveInfo.to, data, cc, pData) || !this.noFall.isEnabled(player, pData)) {
            data.clearNoFallData();
            this.useFallLoc.setWorld(null);
            this.aux.returnPlayerMoveInfo(moveInfo);
            return;
        }
        boolean debug = pData.isDebugActive(CheckType.MOVING_NOFALL);
        boolean allowReset = true;
        float fallDistance = player.getFallDistance();
        float yDiff = (float)(data.noFallMaxY - loc.getY());
        double damage = BridgeHealth.getRawDamage(event);
        if (debug) {
            this.debug(player, "Damage(FALL/PRE): " + damage + " / mc=" + player.getFallDistance() + " nf=" + data.noFallFallDistance + " yDiff=" + yDiff);
        }
        if (!data.noFallSkipAirCheck) {
            float dataDist = Math.max(yDiff, data.noFallFallDistance);
            double dataDamage = NoFall.getDamage(dataDist, player);
            if (damage > dataDamage + 0.5 || dataDamage <= 0.0) {
                PlayerMoveData firstPastMove = data.playerMoves.getFirstPastMove();
                if (pLoc.isOnGround() && pLoc.isInLava() && firstPastMove.toIsValid && firstPastMove.yDistance < 0.0) {
                    if (debug) {
                        this.debug(player, "NoFall/Damage: allow fall damage in lava (hotfix).");
                    }
                } else if (((PlayerLocation)moveInfo.from).isOnClimbable() && firstPastMove.isGliding) {
                    if (debug) {
                        this.debug(player, "Ignore fakefall on climbable on elytra move");
                    }
                } else if (this.noFallVL(player, "fakefall", data, cc)) {
                    player.setFallDistance(dataDist);
                    Improbable.check(player, player.getFallDistance(), System.currentTimeMillis(), "nofall.fakefall", pData);
                    if (dataDamage <= 0.0) {
                        event.setCancelled(true);
                        this.useFallLoc.setWorld(null);
                        this.aux.returnPlayerMoveInfo(moveInfo);
                        return;
                    }
                    if (debug) {
                        this.debug(player, "NoFall/Damage: override player fall distance and damage (" + fallDistance + " -> " + dataDist + ").");
                    }
                    fallDistance = dataDist;
                    BridgeHealth.setRawDamage(event, dataDamage);
                }
            }
            data.noFallFallDistance = (float)((double)data.noFallFallDistance + 1.0);
            if (!pLoc.isOnGround(1.0, 0.3, 0.1) && !pLoc.isResetCond() && !pLoc.isAboveLadder() && this.noFallVL(player, "fakeground", data, cc) && data.hasSetBack()) {
                allowReset = false;
                Improbable.check(player, 1.0f, System.currentTimeMillis(), "nofall.fakeground", pData);
            }
        }
        this.aux.returnPlayerMoveInfo(moveInfo);
        double d = data.jumpAmplifier > 0.0 ? NoFall.getDamage((float)NoFall.getApplicableFallHeight(player, loc.getY(), data), player) : (maxD = NoFall.getDamage(Math.max(yDiff, Math.max(data.noFallFallDistance, fallDistance)), player) + (allowReset ? 0.0 : this.attributeAccess.getHandle().getSafeFallDistance(player)));
        if (maxD > damage) {
            double featherFallingCorrection = NoFall.applyFeatherFalling(player, NoFall.applyBlockDamageModifier(player, data, maxD), ((MCAccess)this.mcAccess.getHandle()).dealFallDamageFiresAnEvent().decide());
            BridgeHealth.setRawDamage(event, featherFallingCorrection);
            if (debug) {
                this.debug(player, "Adjust fall damage to: " + (featherFallingCorrection != maxD ? featherFallingCorrection : maxD));
            }
        }
        if (allowReset) {
            data.clearNoFallData();
            if (debug) {
                this.debug(player, "Reset NoFall data on fall damage.");
            }
        } else {
            if (cc.noFallViolationReset) {
                data.clearNoFallData();
            }
            if (cc.sfHoverCheck && data.sfHoverTicks < 0) {
                data.sfHoverTicks = 0;
                this.hoverTicks.add(player.getName());
            }
        }
        this.useFallLoc.setWorld(null);
    }

    private boolean noFallVL(Player player, String tag, MovingData data, MovingConfig cc) {
        data.noFallVL += 1.0;
        ViolationData vd = new ViolationData(this.noFall, player, data.noFallVL, 1.0, cc.noFallActions);
        if (tag != null) {
            vd.setParameter(ParameterName.TAGS, tag);
        }
        return this.noFall.executeActions(vd).willCancel();
    }

    @Override
    public void playerJoins(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        this.dataOnJoin(player, player.getLocation(this.useJoinLoc), false, pData.getGenericInstance(MovingData.class), pData.getGenericInstance(MovingConfig.class), pData.isDebugActive(this.checkType));
        this.useJoinLoc.setWorld(null);
    }

    private void dataOnJoin(Player player, Location loc, boolean isRespawn, MovingData data, MovingConfig cc, boolean debug) {
        int loaded;
        String tag;
        int tick = TickTask.getTick();
        String string = tag = isRespawn ? "Respawn" : "Join";
        if (cc.loadChunksOnJoin && (loaded = MapUtil.ensureChunksLoaded(loc.getWorld(), loc.getX(), loc.getZ(), 3.0)) > 0 && debug) {
            StaticLog.logInfo("Player " + tag + ": Loaded " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " for player: " + player.getName());
        }
        if (!data.hasSetBack() || !data.hasSetBackWorldChanged(loc)) {
            data.clearFlyData();
            data.setSetBack(loc);
            data.joinOrRespawn = true;
        }
        data.clearVehicleData();
        data.clearAllMorePacketsData();
        data.removeAllVelocity();
        data.resetTrace(player, loc, tick, (IEntityAccessDimensions)this.mcAccess.getHandle(), cc);
        this.aux.resetPositionsAndMediumProperties(player, loc, data, cc);
        if (cc.enforceLocation) {
            this.playersEnforce.add(player.getName());
        }
        this.initHover(player, data, cc, data.playerMoves.getFirstPastMove().from.onGroundOrResetCond);
        if (player.isInsideVehicle()) {
            this.vehicleChecks.onPlayerVehicleEnter(player, player.getVehicle());
        }
        if (debug) {
            this.debug(player, tag + ": " + loc);
        }
    }

    private void initHover(Player player, MovingData data, MovingConfig cc, boolean isOnGroundOrResetCond) {
        if (!isOnGroundOrResetCond && cc.sfHoverCheck) {
            data.sfHoverTicks = 0;
            data.sfHoverLoginTicks = cc.sfHoverLoginTicks;
            this.hoverTicks.add(player.getName());
        } else {
            data.sfHoverLoginTicks = 0;
            data.sfHoverTicks = -1;
        }
    }

    @Override
    public void playerLeaves(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        MovingData data = pData.getGenericInstance(MovingData.class);
        Location loc = player.getLocation(this.useLeaveLoc);
        if (pData.isDebugActive(this.checkType)) {
            StaticLog.logInfo("Player " + player.getName() + " leaves at location: " + loc.toString());
        }
        if (!(player.isSleeping() || player.isDead() || BlockProperties.isPassable(loc) || Bridge1_13.hasIsSwimming())) {
            PlayerMoveData lastMove2;
            PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
            PlayerMoveData playerMoveData = lastMove2 = data.playerMoves.getNumberOfPastMoves() > 1 ? data.playerMoves.getSecondPastMove() : null;
            if (lastMove.valid) {
                double d;
                Location refLoc;
                Location location = refLoc = lastMove.toIsValid ? new Location(loc.getWorld(), lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ()) : new Location(loc.getWorld(), lastMove.from.getX(), lastMove.from.getY(), lastMove.from.getZ());
                if (TrigUtil.isSamePos(loc, refLoc) && !lastMove.toIsValid && lastMove2 != null) {
                    Location location2 = refLoc = lastMove2.toIsValid ? new Location(loc.getWorld(), lastMove2.to.getX(), lastMove2.to.getY(), lastMove2.to.getZ()) : new Location(loc.getWorld(), lastMove2.from.getX(), lastMove2.from.getY(), lastMove2.from.getZ());
                }
                if (!BlockProperties.isPassable(refLoc) || refLoc.distanceSquared(loc) > 1.25) {
                    double y = Math.ceil(loc.getY());
                    refLoc = loc.clone();
                    refLoc.setY(y);
                    if (!BlockProperties.isPassable(refLoc)) {
                        refLoc = loc;
                    }
                }
                if ((d = refLoc.distanceSquared(loc)) > 0.0 && (TrigUtil.manhattan(loc, refLoc) > 0 || BlockProperties.isPassable(refLoc)) && this.passable.isEnabled(player, pData)) {
                    StaticLog.logWarning("Potential exploit: Player " + player.getName() + " leaves, having moved into a block (not tracked by moving checks): " + player.getWorld().getName() + " / " + DebugUtil.formatMove(refLoc, loc));
                    if (d > 1.25) {
                        StaticLog.logWarning("SKIP set back for " + player.getName() + ", because distance is too high (risk of false positives): " + d);
                    } else {
                        StaticLog.logInfo("Set back player " + player.getName() + ": " + LocUtil.simpleFormat(refLoc));
                        data.prepareSetBack(refLoc);
                        if (!SchedulerHelper.teleportEntity((Entity)player, refLoc, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION)) {
                            StaticLog.logWarning("FAILED to set back player " + player.getName());
                        }
                    }
                }
            }
        }
        this.useLeaveLoc.setWorld(null);
        this.noFall.onLeave(player, data, pData);
        data.onPlayerLeave();
        if (SchedulerHelper.isTaskScheduled(data.vehicleSetBackTaskId)) {
            data.vehicleSetBackTaskId = null;
        }
        data.vehicleSetPassengerTaskId = null;
    }

    @Override
    public void onTick(int tick, long timeLast) {
        if (!this.playersEnforce.isEmpty()) {
            this.checkOnTickPlayersEnforce();
        }
        if (tick % this.hoverTicksStep == 0 && !this.hoverTicks.isEmpty()) {
            this.checkOnTickHover();
        }
        this.useTickLoc.setWorld(null);
    }

    private void checkOnTickHover() {
        ArrayList<String> rem = new ArrayList<String>(this.hoverTicks.size());
        PlayerMoveInfo info = this.aux.usePlayerMoveInfo();
        for (String playerName : this.hoverTicks) {
            Player player = DataManager.getPlayerExact(playerName);
            if (player == null || !player.isOnline()) {
                rem.add(playerName);
                continue;
            }
            IPlayerData pData = DataManager.getPlayerData(player);
            MovingData data = pData.getGenericInstance(MovingData.class);
            if (player.isDead() || player.isSleeping() || player.isInsideVehicle()) {
                data.sfHoverTicks = -1;
            }
            if (data.sfHoverTicks < 0) {
                data.sfHoverLoginTicks = 0;
                rem.add(playerName);
                continue;
            }
            if (data.sfHoverLoginTicks > 0) {
                --data.sfHoverLoginTicks;
                continue;
            }
            MovingConfig cc = pData.getGenericInstance(MovingConfig.class);
            if (!cc.sfHoverCheck) {
                rem.add(playerName);
                data.sfHoverTicks = -1;
                continue;
            }
            data.sfHoverTicks += this.hoverTicksStep;
            if (data.sfHoverTicks < cc.sfHoverTicks || !this.checkHover(player, data, cc, pData, info)) continue;
            rem.add(playerName);
        }
        this.hoverTicks.removeAll(rem);
        this.aux.returnPlayerMoveInfo(info);
    }

    private void checkOnTickPlayersEnforce() {
        ArrayList<String> rem = new ArrayList<String>(this.playersEnforce.size());
        for (String playerName : this.playersEnforce) {
            Player player = DataManager.getPlayerExact(playerName);
            if (player == null || !player.isOnline()) {
                rem.add(playerName);
                continue;
            }
            if (player.isDead() || player.isSleeping() || player.isInsideVehicle()) continue;
            MovingData data = DataManager.getGenericInstance(player, MovingData.class);
            Location newTo = this.enforceLocation(player, player.getLocation(this.useTickLoc), data);
            if (newTo == null) continue;
            data.prepareSetBack(newTo);
            SchedulerHelper.teleportEntity((Entity)player, newTo, BridgeMisc.TELEPORT_CAUSE_CORRECTION_OF_POSITION);
        }
        if (!rem.isEmpty()) {
            this.playersEnforce.removeAll(rem);
        }
    }

    private Location enforceLocation(Player player, Location loc, MovingData data) {
        PlayerMoveData lastMove = data.playerMoves.getFirstPastMove();
        if (lastMove.toIsValid && TrigUtil.distanceSquared(lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ(), loc.getX(), loc.getY(), loc.getZ()) > 0.00390625) {
            if (data.hasSetBack()) {
                return data.getSetBack(loc);
            }
            return new Location(player.getWorld(), lastMove.to.getX(), lastMove.to.getY(), lastMove.to.getZ(), loc.getYaw(), loc.getPitch());
        }
        return null;
    }

    private boolean checkHover(Player player, MovingData data, MovingConfig cc, IPlayerData pData, PlayerMoveInfo info) {
        boolean res;
        Location loc = player.getLocation(this.useTickLoc);
        info.set(player, loc, null, cc.yOnGround);
        int loaded = ((PlayerLocation)info.from).ensureChunksLoaded();
        if (loaded > 0 && pData.isDebugActive(this.checkType)) {
            StaticLog.logInfo("Hover check: Needed to load " + loaded + " chunk" + (loaded == 1 ? "" : "s") + " for the world " + loc.getWorld().getName() + " around " + loc.getBlockX() + "," + loc.getBlockZ() + " in order to check player: " + player.getName());
        }
        if (((PlayerLocation)info.from).isOnGroundOrResetCond() || ((PlayerLocation)info.from).isAboveLadder()) {
            res = true;
            data.sfHoverTicks = 0;
        } else if (data.sfHoverTicks > cc.sfHoverTicks) {
            PlayerMoveInfo moveInfo = this.aux.usePlayerMoveInfo();
            moveInfo.set(player, loc, null, cc.yOnGround);
            if (MovingUtil.shouldCheckSurvivalFly(player, (PlayerLocation)moveInfo.from, (PlayerLocation)moveInfo.to, data, cc, pData)) {
                this.handleHoverViolation(player, (PlayerLocation)moveInfo.from, cc, data, pData);
                res = false;
                data.sfHoverTicks = 0;
            } else {
                res = false;
                data.sfHoverTicks = 0;
            }
            this.aux.returnPlayerMoveInfo(moveInfo);
        } else {
            res = false;
        }
        info.cleanup();
        return res;
    }

    private void handleHoverViolation(Player player, PlayerLocation loc, MovingConfig cc, MovingData data, IPlayerData pData) {
        if (cc.sfHoverFallDamage && this.noFall.isEnabled(player, pData)) {
            this.noFall.checkDamage(player, loc.getY(), data, pData);
        }
        this.survivalFly.handleHoverViolation(player, loc, cc, data);
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.MOVING_SURVIVALFLY;
    }

    @Override
    public IData removeData(String playerName) {
        return null;
    }

    @Override
    public void removeAllData() {
        this.hoverTicks.clear();
        this.playersEnforce.clear();
        this.aux.clear();
    }

    @Override
    public void onReload() {
        this.aux.clear();
        this.hoverTicksStep = Math.max(1, ConfigManager.getConfigFile().getInt("checks.moving.survivalfly.hover.step"));
    }

    private void outputMoveDebug(Player player, PlayerLocation from, PlayerLocation to, double maxYOnGround, MCAccess mcAccess) {
        StringBuilder builder = new StringBuilder(250);
        Location loc = player.getLocation();
        builder.append(CheckUtils.getLogMessagePrefix(player, this.checkType));
        builder.append("MOVE in world (" + from.getWorld().getName() + ") ------>\n");
        DebugUtil.addMove(from, to, loc, builder);
        Vector v = player.getVelocity();
        if (v.lengthSquared() > 0.0) {
            builder.append("\n");
            builder.append("Bukkit velocity: " + StringUtil.fdec6.format(v.getX()) + ", " + StringUtil.fdec6.format(v.getY()) + ", " + StringUtil.fdec6.format(v.getZ()));
        }
        double jump = mcAccess.getJumpAmplifier(player);
        double speed = mcAccess.getFasterMovementAmplifier(player);
        double strider = BridgeEnchant.getDepthStriderLevel(player);
        double swiftSneak = BridgeEnchant.getSwiftSneakLevel(player);
        IPlayerData pData = DataManager.getPlayerData(player);
        if (BuildParameters.debugLevel > 0) {
            from.collectBlockFlags(maxYOnGround);
            if (from.getBlockFlags() != 0L) {
                builder.append("\nFrom flags: " + StringUtil.join(BlockFlags.getFlagNames(from.getBlockFlags()), " + "));
            }
            to.collectBlockFlags(maxYOnGround);
            if (to.getBlockFlags() != 0L) {
                builder.append("\nTo flags: " + StringUtil.join(BlockFlags.getFlagNames(to.getBlockFlags()), " + "));
            }
            if (!BlockProperties.isAir(from.getBlockType())) {
                DebugUtil.addBlockInfo(builder, from, "\nFrom");
            }
            if (!BlockProperties.isAir(from.getBlockTypeBelow())) {
                DebugUtil.addBlockBelowInfo(builder, from, "\nFrom");
            }
            if (!from.isOnGround() && from.isOnGround(0.5)) {
                builder.append(" (ground within 0.5)");
            }
            if (!BlockProperties.isAir(to.getBlockType())) {
                DebugUtil.addBlockInfo(builder, to, "\nTo");
            }
            if (!BlockProperties.isAir(to.getBlockTypeBelow())) {
                DebugUtil.addBlockBelowInfo(builder, to, "\nTo");
            }
            if (!to.isOnGround() && to.isOnGround(0.5)) {
                builder.append(" (ground within 0.5)");
            }
        }
        NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
        if (BuildParameters.debugLevel > 0) {
            builder.setLength(0);
            builder.append("\n(attribute speed= " + this.attributeAccess.getHandle().getMovementSpeed(player) + ")");
            builder.append("\n(attribute fly speed= " + player.getFlySpeed() + ")");
            if (player.isSprinting()) {
                builder.append("\n(Bukkit sprinting)");
            }
            if (pData.isSprinting()) {
                builder.append("\n(NCP sprinting)");
            }
            if (pData.isShiftKeyPressed()) {
                builder.append("\n(Shift key down)");
            }
            if (pData.isInCrouchingPose()) {
                builder.append("\n(NCP sneaking)");
            }
            if (BridgeMisc.isUsingItem(player)) {
                builder.append("\n(is using " + BridgeMisc.getItemInUse(player) + " item)");
            }
            if (!Double.isInfinite(speed)) {
                builder.append("\n(e_speed= " + (speed + 1.0) + ")");
            }
            double slow = PotionUtil.getPotionEffectAmplifier(player, BridgePotionEffect.SLOWNESS);
            if (!Double.isInfinite(Bridge1_13.getSlowfallingAmplifier((LivingEntity)player))) {
                builder.append("\n(e_slowfall= " + (Bridge1_13.getSlowfallingAmplifier((LivingEntity)player) + 1.0) + ")");
            }
            if (!Double.isInfinite(Bridge1_9.getLevitationAmplifier(player))) {
                builder.append("\n(e_levitation= " + (Bridge1_9.getLevitationAmplifier(player) + 1.0) + ")");
            }
            if (!Double.isInfinite(slow)) {
                builder.append("\n(e_slow= " + (slow + 1.0) + ")");
            }
            if (!Double.isInfinite(jump)) {
                builder.append("\n(e_jump= " + (jump + 1.0) + ")");
            }
            if (strider != 0.0) {
                builder.append("\n(e_depth_strider= " + strider + ")");
            }
            if (swiftSneak != 0.0) {
                builder.append("\n(swift sneak= " + swiftSneak + ")");
            }
            if (Bridge1_9.isGliding((LivingEntity)player)) {
                builder.append("\n(gliding, no elytra-wearing check)");
            }
            if (Bridge1_13.isRiptiding((LivingEntity)player)) {
                builder.append("\n(riptiding with Lvl: " + BridgeEnchant.getRiptideLevel(player) + ")");
            }
            if (player.getAllowFlight()) {
                builder.append("\n(allow flight)");
            }
            if (player.isFlying()) {
                builder.append("\n(flying)");
            }
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().debug(Streams.TRACE_FILE, builder.toString());
        }
    }
}

