/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.location.setback.DefaultSetBackStorage;
import fr.neatmonster.nocheatplus.checks.moving.location.tracking.LocationTrace;
import fr.neatmonster.nocheatplus.checks.moving.model.InputDirection;
import fr.neatmonster.nocheatplus.checks.moving.model.LiftOffEnvelope;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveConsistency;
import fr.neatmonster.nocheatplus.checks.moving.model.MoveTrace;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.checks.moving.model.VehicleMoveData;
import fr.neatmonster.nocheatplus.checks.moving.velocity.PairAxisVelocity;
import fr.neatmonster.nocheatplus.checks.moving.velocity.PairEntry;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleAxisVelocity;
import fr.neatmonster.nocheatplus.checks.moving.velocity.SimpleEntry;
import fr.neatmonster.nocheatplus.checks.workaround.WRPT;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.components.data.IDataOnReload;
import fr.neatmonster.nocheatplus.components.data.IDataOnRemoveSubCheckData;
import fr.neatmonster.nocheatplus.components.data.IDataOnWorldUnload;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessDimensions;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.location.IPositionWithLook;
import fr.neatmonster.nocheatplus.components.modifier.IAttributeAccess;
import fr.neatmonster.nocheatplus.components.registry.IGetGenericInstance;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.RichEntityLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.math.TrigUtil;
import fr.neatmonster.nocheatplus.workaround.IWorkaroundRegistry;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MovingData
extends ACheckData
implements IDataOnRemoveSubCheckData,
IDataOnReload,
IDataOnWorldUnload {
    private final IGenericInstanceHandle<IAttributeAccess> attributeAccess = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IAttributeAccess.class);
    public double creativeFlyVL = 0.0;
    public double morePacketsVL = 0.0;
    public double noFallVL = 0.0;
    public double survivalFlyVL = 0.0;
    public double vehicleMorePacketsVL = 0.0;
    public double vehicleEnvelopeVL = 0.0;
    public double passableVL = 0.0;
    public List<Location> lastCollidingEntitiesLocations = null;
    public boolean hasLeatherBoots = false;
    public double lastY = -64.0;
    public int jumpDelay;
    public double lastLevitationLevel;
    private int playerMoveCount = 0;
    private int setBackResetTime = 0;
    private int morePacketsSetBackResetTime = 0;
    public int speedTick = 0;
    public float walkSpeed = 0.0f;
    public float nextWalkSpeed = 0.0f;
    public float flySpeed = 0.0f;
    public double jumpAmplifier = 0.0;
    public long timeRiptiding = 0L;
    public long timeVehicletoss = 0L;
    public int boatIceVelocityTicks = 0;
    public long timeCamelDash = 0L;
    public final BlockChangeReference blockChangeRef = new BlockChangeReference();
    public float lastFrictionHorizontal = 0.6f;
    public float nextFrictionHorizontal = 0.0f;
    public float lastInertia = 0.0f;
    public float nextInertia = 0.0f;
    public double lastStuckInBlockHorizontal = 1.0;
    public double nextStuckInBlockHorizontal = 1.0;
    public float lastBlockSpeedMultiplier = 1.0f;
    public float nextBlockSpeedMultiplier = 1.0f;
    public double nextStuckInBlockVertical = 0.0;
    public double lastStuckInBlockVertical = 0.0;
    public double nextFrictionVertical = 0.0;
    public double lastFrictionVertical = 0.0;
    public double nextGravity = 0.0;
    public double lastGravity = 0.0;
    public final MoveTrace<PlayerMoveData> playerMoves = new MoveTrace<PlayerMoveData>(new Callable<PlayerMoveData>(){

        @Override
        public PlayerMoveData call() throws Exception {
            return new PlayerMoveData();
        }
    }, 6);
    public final MoveTrace<VehicleMoveData> vehicleMoves = new MoveTrace<VehicleMoveData>(new Callable<VehicleMoveData>(){

        @Override
        public VehicleMoveData call() throws Exception {
            return new VehicleMoveData();
        }
    }, 2);
    private static final double TOL_VVEL = 0.0625;
    private final SimpleAxisVelocity verVel = new SimpleAxisVelocity();
    private final PairAxisVelocity horVel = new PairAxisVelocity();
    public SimpleEntry verticalBounce = null;
    private final LocationTrace trace;
    private Location setBack = null;
    private Location teleported = null;
    public World fromMissedWorldChange = null;
    public int fireworksBoostDuration = 0;
    public int fireworksBoostTickNeedCheck = 0;
    public int fireworksBoostTickExpire = 0;
    public final ActionFrequency morePacketsFreq;
    public final ActionFrequency morePacketsBurstFreq;
    private Location morePacketsSetback = null;
    public float noFallFallDistance = 0.0f;
    public double noFallMaxY = 0.0;
    public boolean noFallSkipAirCheck = false;
    public Location noFallCurrentLocOnWindChargeHit = null;
    private static final LiftOffEnvelope defaultLiftOffEnvelope = LiftOffEnvelope.UNKNOWN;
    public int sfVLMoveCount = 0;
    public int sfJumpPhase = 0;
    @Deprecated
    private boolean sfDirty = false;
    public LiftOffEnvelope liftOffEnvelope = defaultLiftOffEnvelope;
    public int sfHoverTicks = -1;
    public int sfHoverLoginTicks = 0;
    public boolean sfVLInAir = false;
    public final IWorkaroundRegistry.WorkaroundSet ws;
    public boolean wasInBed = false;
    public static final int vehicleMorePacketsBufferDefault = 50;
    public int vehicleMorePacketsBuffer = 50;
    public long vehicleMorePacketsLastTime;
    public Object vehicleSetBackTaskId = null;
    public Object vehicleSetPassengerTaskId = null;
    public boolean joinOrRespawn = false;
    public int timeSinceSetBack = 0;
    public int lastSetBackHash = 0;
    public IPositionWithLook crossWorldFrom = null;
    public boolean lastMoveNoMove = false;
    public boolean wasInVehicle = false;
    public boolean vehicleLeave = false;
    public EntityType lastVehicleType = null;
    public boolean isVehicleSetBack = false;
    public MoveConsistency vehicleConsistency = MoveConsistency.INCONSISTENT;
    public final DefaultSetBackStorage vehicleSetBacks = new DefaultSetBackStorage();
    private final IPlayerData pData;

    public MovingData(MovingConfig config, IPlayerData pData) {
        this.pData = pData;
        this.morePacketsFreq = new ActionFrequency(config.morePacketsEPSBuckets, 500L);
        this.morePacketsBurstFreq = new ActionFrequency(12, 5000L);
        this.trace = new LocationTrace(config.traceMaxAge, config.traceMaxSize, NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(LocationTrace.TraceEntryPool.class));
        this.ws = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(WRPT.class).getWorkaroundSet("moving");
    }

    public void clearMostMovingCheckData() {
        this.clearFlyData();
        this.clearVehicleData();
        this.clearAllMorePacketsData();
    }

    public void clearVehicleData() {
        this.vehicleMoves.invalidate();
        this.vehicleSetBacks.invalidateAll();
    }

    public void clearFlyData() {
        this.playerMoves.invalidate();
        this.jumpDelay = 0;
        this.sfJumpPhase = 0;
        this.jumpAmplifier = 0.0;
        this.setBack = null;
        this.clearNoFallData();
        this.removeAllPlayerSpeedModifiers();
        this.clearWindChargeImpulse();
        this.sfHoverLoginTicks = -1;
        this.sfHoverTicks = -1;
        this.sfDirty = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.vehicleConsistency = MoveConsistency.INCONSISTENT;
        this.verticalBounce = null;
        this.blockChangeRef.valid = false;
        this.lastStuckInBlockHorizontal = 1.0;
        this.lastStuckInBlockVertical = 1.0;
        this.lastFrictionVertical = 1.0;
        this.lastBlockSpeedMultiplier = 1.0f;
        this.lastFrictionHorizontal = 1.0f;
        this.lastInertia = 0.0f;
    }

    public void onSetBack(PlayerLocation setBack, Location loc, MovingConfig cc, Player player) {
        this.morePacketsSetback = null;
        this.sfHoverTicks = -1;
        this.sfDirty = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.removeAllPlayerSpeedModifiers();
        this.vehicleConsistency = MoveConsistency.INCONSISTENT;
        this.verticalBounce = null;
        this.timeSinceSetBack = 0;
        this.lastStuckInBlockHorizontal = 1.0;
        this.lastStuckInBlockVertical = 1.0;
        this.lastFrictionVertical = 1.0;
        this.lastBlockSpeedMultiplier = 1.0f;
        this.lastFrictionHorizontal = 1.0f;
        this.lastInertia = 0.0f;
        this.lastSetBackHash = setBack == null ? 0 : setBack.hashCode();
        this.resetPlayerPositions(setBack);
        this.adjustLiftOffEnvelope(setBack);
        this.adjustMediumProperties(loc, cc, player, this.playerMoves.getCurrentMove());
        if (setBack == null) {
            this.setSetBack(setBack);
        }
    }

    public void prepareSetBack(Location loc) {
        this.playerMoves.invalidate();
        this.vehicleMoves.invalidate();
        this.sfJumpPhase = 0;
        this.verticalBounce = null;
        this.setTeleported(loc);
    }

    public void adjustMediumProperties(Location loc, MovingConfig cc, Player player, PlayerMoveData thisMove) {
        this.nextFrictionHorizontal = BlockProperties.getHorizontalFrictionFactor((LivingEntity)player, loc, cc.yOnGround, thisMove);
        this.nextStuckInBlockHorizontal = BlockProperties.getStuckInBlockHorizontalFactor((LivingEntity)player, loc, cc.yOnGround, thisMove);
        this.nextBlockSpeedMultiplier = MathUtil.lerp(this.attributeAccess.getHandle().getMovementEfficiency(player), BlockProperties.getBlockSpeedFactor((LivingEntity)player, loc, cc.yOnGround, thisMove), 1.0f);
        this.nextFrictionVertical = BlockProperties.getVerticalFrictionFactor((LivingEntity)player, loc, cc.yOnGround, thisMove);
        this.nextStuckInBlockVertical = BlockProperties.getStuckInBlockVerticalFactor((LivingEntity)player, loc, cc.yOnGround, thisMove);
    }

    public void resetHorizontalData() {
        PlayerMoveData thisMove = this.playerMoves.getCurrentMove();
        thisMove.xAllowedDistance = 0.0;
        thisMove.zAllowedDistance = 0.0;
        thisMove.hAllowedDistance = 0.0;
        thisMove.hasImpulse = AlmostBoolean.NO;
        thisMove.strafeImpulse = InputDirection.StrafeDirection.NONE;
        thisMove.forwardImpulse = InputDirection.ForwardDirection.NONE;
    }

    public void adjustLiftOffEnvelope(PlayerLocation loc) {
        loc.collectBlockFlags();
        this.liftOffEnvelope = loc.isInWeb() ? LiftOffEnvelope.LIMIT_WEBS : (loc.isInBerryBush() ? LiftOffEnvelope.LIMIT_SWEET_BERRY : (loc.isInPowderSnow() ? LiftOffEnvelope.LIMIT_POWDER_SNOW : (loc.isOnHoneyBlock() ? LiftOffEnvelope.LIMIT_HONEY_BLOCK : (loc.isOnGround() ? LiftOffEnvelope.NORMAL : LiftOffEnvelope.UNKNOWN))));
    }

    public void onPlayerLeave() {
        this.removeAllPlayerSpeedModifiers();
        this.trace.reset();
        this.playerMoves.invalidate();
        this.vehicleMoves.invalidate();
    }

    public void resetPlayerPositions(PlayerLocation loc) {
        this.resetPlayerPositions();
        if (loc != null) {
            PlayerMoveData lastMove = this.playerMoves.getFirstPastMove();
            lastMove.setWithExtraProperties(loc);
        }
    }

    private void resetPlayerPositions() {
        this.playerMoves.invalidate();
        this.sfDirty = false;
        this.liftOffEnvelope = defaultLiftOffEnvelope;
        this.verticalBounce = null;
        this.blockChangeRef.valid = false;
        this.lastStuckInBlockHorizontal = 1.0;
        this.lastStuckInBlockVertical = 1.0;
        this.lastFrictionVertical = 1.0;
        this.lastFrictionHorizontal = 0.6f;
        this.lastBlockSpeedMultiplier = 1.0f;
        this.lastInertia = 0.0f;
    }

    public void resetVehiclePositions(RichEntityLocation loc) {
        this.vehicleMoves.invalidate();
        if (loc != null) {
            VehicleMoveData lastMove = this.vehicleMoves.getFirstPastMove();
            lastMove.setWithExtraProperties(loc);
            Entity entity = loc.getEntity();
            lastMove.vehicleId = entity.getUniqueId();
            lastMove.vehicleType = entity.getType();
        }
    }

    public void clearAllMorePacketsData() {
        this.clearPlayerMorePacketsData();
        this.clearVehicleMorePacketsData();
    }

    public void clearPlayerMorePacketsData() {
        this.morePacketsSetback = null;
        long now = System.currentTimeMillis();
        this.morePacketsFreq.clear(now);
        this.morePacketsBurstFreq.clear(now);
    }

    public void reducePlayerMorePacketsData(float amount) {
        ActionFrequency.reduce(System.currentTimeMillis(), amount, this.morePacketsFreq, this.morePacketsBurstFreq);
    }

    public void clearVehicleMorePacketsData() {
        this.vehicleMorePacketsLastTime = 0L;
        this.vehicleMorePacketsBuffer = 50;
        this.vehicleSetBacks.getMidTermEntry().setValid(false);
    }

    public void clearNoFallData() {
        this.noFallFallDistance = 0.0f;
        this.noFallMaxY = BlockProperties.getMinWorldY();
        this.noFallSkipAirCheck = false;
    }

    public void clearWindChargeImpulse() {
        this.noFallCurrentLocOnWindChargeHit = null;
    }

    public void setSetBack(PlayerLocation loc) {
        if (this.setBack == null) {
            this.setBack = loc.getLocation();
        } else {
            LocUtil.set(this.setBack, loc);
        }
        this.setBackResetTime = this.playerMoveCount;
    }

    public void setSetBack(Location loc) {
        if (this.setBack == null) {
            this.setBack = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.setBack, loc);
        }
        this.setBackResetTime = this.playerMoveCount;
    }

    public Location getSetBack(Location ref) {
        return LocUtil.clone(this.setBack, ref);
    }

    public Location getSetBack(PlayerLocation ref) {
        return LocUtil.clone(this.setBack, ref);
    }

    public Location getSetBack(float yaw, float pitch) {
        return LocUtil.clone(this.setBack, yaw, pitch);
    }

    public boolean hasSetBack() {
        return this.setBack != null;
    }

    public boolean hasSetBackWorldChanged(Location loc) {
        if (this.setBack == null) {
            return true;
        }
        return this.setBack.getWorld().equals((Object)loc.getWorld());
    }

    public double getSetBackX() {
        return this.setBack.getX();
    }

    public double getSetBackY() {
        return this.hasSetBack() ? this.setBack.getY() : 0.0;
    }

    public double getSetBackZ() {
        return this.setBack.getZ();
    }

    public void setSetBackY(double y) {
        this.setBack.setY(y);
    }

    public boolean hasTeleported() {
        return this.teleported != null;
    }

    public final Location getTeleported() {
        return this.teleported == null ? this.teleported : LocUtil.clone(this.teleported);
    }

    public boolean isTeleported(Location loc) {
        return loc != null && this.teleported != null && this.teleported.equals((Object)loc);
    }

    public boolean isTeleportedPosition(Location loc) {
        return loc != null && this.teleported != null && TrigUtil.isSamePos(this.teleported, loc);
    }

    public boolean isTeleportedPosition(IGetPosition pos) {
        return pos != null && this.teleported != null && TrigUtil.isSamePos(pos, this.teleported);
    }

    public final void setTeleported(Location loc) {
        this.teleported = LocUtil.clone(loc);
    }

    public boolean hasMorePacketsSetBack() {
        return this.morePacketsSetback != null;
    }

    public boolean isMorePacketsSetBackOldest() {
        return this.morePacketsSetBackResetTime < this.setBackResetTime;
    }

    public void setMorePacketsSetBackFromSurvivalfly() {
        this.setMorePacketsSetBack(this.setBack);
    }

    public final void setMorePacketsSetBack(PlayerLocation loc) {
        if (this.morePacketsSetback == null) {
            this.morePacketsSetback = loc.getLocation();
        } else {
            LocUtil.set(this.morePacketsSetback, loc);
        }
        this.morePacketsSetBackResetTime = this.playerMoveCount;
    }

    public final void setMorePacketsSetBack(Location loc) {
        if (this.morePacketsSetback == null) {
            this.morePacketsSetback = LocUtil.clone(loc);
        } else {
            LocUtil.set(this.morePacketsSetback, loc);
        }
        this.morePacketsSetBackResetTime = this.playerMoveCount;
    }

    public Location getMorePacketsSetBack() {
        return LocUtil.clone(this.morePacketsSetback);
    }

    public final void resetTeleported() {
        this.teleported = null;
    }

    public final void resetSetBack() {
        this.setBack = null;
    }

    private void removeAllPlayerSpeedModifiers() {
        this.removeAllVelocity();
        this.fireworksBoostDuration = 0;
        this.fireworksBoostTickExpire = 0;
    }

    public void addVelocity(Player player, MovingConfig cc, double vx, double vy, double vz, long flags) {
        int tick = TickTask.getTick();
        this.removeInvalidVelocity(tick - cc.velocityActivationTicks);
        if (this.pData.isDebugActive(CheckType.MOVING)) {
            CheckUtils.debug(player, CheckType.MOVING, " New velocity: " + vx + ", " + vy + ", " + vz);
        }
        this.verVel.add(new SimpleEntry(tick, vy, flags, cc.velocityActivationCounter));
        if (vx != 0.0 || vz != 0.0) {
            this.horVel.add(new PairEntry(tick, vx, vz, cc.velocityActivationCounter));
        }
        this.sfDirty = true;
    }

    public void removeAllVelocity() {
        this.horVel.clear();
        this.verVel.clear();
        this.sfDirty = false;
    }

    public void addVelocity(Player player, MovingConfig cc, double vx, double vy, double vz) {
        this.addVelocity(player, cc, vx, vy, vz, 0L);
    }

    public void removeInvalidVelocity(int tick) {
        this.horVel.removeInvalid(tick);
        this.verVel.removeInvalid(tick);
    }

    public void velocityTick(int invalidateBeforeTick) {
        this.removeInvalidVelocity(invalidateBeforeTick);
        if (!this.sfDirty && this.horVel.hasQueued()) {
            this.sfDirty = true;
        }
    }

    public static int getHorVelValCount(double velocity) {
        return Math.max(30, 1 + (int)Math.round(velocity * 10.0));
    }

    public void addHorizontalVelocity(PairEntry vel) {
        this.horVel.add(vel);
    }

    public void clearAllHorVel() {
        this.horVel.clear();
    }

    public List<PairEntry> useHorizontalVelocity(double x, double z) {
        List<PairEntry> available = this.horVel.use(x, z, 0.001);
        if (!available.isEmpty()) {
            this.sfDirty = true;
        }
        return available;
    }

    public PairAxisVelocity getHorizontalVelocityTracker() {
        return this.horVel;
    }

    public void addHorizontalVelocity(StringBuilder builder) {
        if (this.horVel.hasQueued()) {
            builder.append("\n Horizontal velocity (queued):");
            this.horVel.addQueued(builder);
        }
    }

    public void prependVerticalVelocity(SimpleEntry entry) {
        this.verVel.addToFront(entry);
    }

    public List<SimpleEntry> peekVerticalVelocity(double amount, int minActCount, int maxActCount) {
        return this.verVel.peek(amount, minActCount, maxActCount, 1.0E-4);
    }

    public void addVerticalVelocity(SimpleEntry entry) {
        this.verVel.add(entry);
    }

    public boolean hasQueuedVerVel() {
        return this.verVel.hasQueued();
    }

    public List<SimpleEntry> useVerticalVelocity(double amount) {
        List<SimpleEntry> available = this.verVel.use(amount, 1.0E-4);
        if (available != null) {
            this.playerMoves.getCurrentMove().verVelUsed = available;
            this.sfDirty = true;
        }
        return available;
    }

    public List<SimpleEntry> getOrUseVerticalVelocity(double amount) {
        List<SimpleEntry> verVelUsed = this.playerMoves.getCurrentMove().verVelUsed;
        if (!verVelUsed.isEmpty()) {
            double sum = 0.0;
            for (SimpleEntry entry : verVelUsed) {
                sum += entry.value;
            }
            if (Math.abs(sum - amount) < 1.0E-4) {
                return verVelUsed;
            }
        }
        return this.useVerticalVelocity(amount);
    }

    public void removeLeadingQueuedVerticalVelocityByFlag(long flag) {
        this.verVel.removeLeadingQueuedVerticalVelocityByFlag(flag);
    }

    public SimpleAxisVelocity getVerticalVelocityTracker() {
        return this.verVel;
    }

    public void addVerticalVelocity(StringBuilder builder) {
        if (this.verVel.hasQueued()) {
            builder.append("\n Vertical velocity (queued):");
            this.verVel.addQueued(builder);
        }
    }

    public boolean isSetBack(Location loc) {
        if (loc == null || this.setBack == null) {
            return false;
        }
        if (!loc.getWorld().getName().equals(this.setBack.getWorld().getName())) {
            return false;
        }
        return loc.getX() == this.setBack.getX() && loc.getY() == this.setBack.getY() && loc.getZ() == this.setBack.getZ();
    }

    public void adjustWalkSpeed(float walkSpeed, int tick, int speedGrace) {
        this.walkSpeed = this.walkSpeed == 0.0f ? walkSpeed : this.nextWalkSpeed;
        this.nextWalkSpeed = walkSpeed;
    }

    public void adjustFlySpeed(float flySpeed, int tick, int speedGrace) {
        if (flySpeed > this.flySpeed) {
            this.flySpeed = flySpeed;
            this.speedTick = tick;
        } else if (flySpeed < this.flySpeed) {
            if (tick - this.speedTick > speedGrace) {
                this.flySpeed = flySpeed;
                this.speedTick = tick;
            }
        } else {
            this.speedTick = tick;
        }
    }

    public boolean hasTrace() {
        return this.trace != null;
    }

    public LocationTrace getTrace(Player player) {
        return this.trace;
    }

    private LocationTrace getTrace(int maxAge, int maxSize) {
        if (this.trace.getMaxSize() != maxSize || this.trace.getMaxAge() != (long)maxAge) {
            this.trace.adjustSettings(maxAge, maxSize, TickTask.getTick());
        }
        return this.trace;
    }

    public LocationTrace updateTrace(Player player, Location loc, long time, IEntityAccessDimensions iead) {
        LocationTrace trace = this.getTrace(player);
        if (iead == null) {
            trace.addEntry(time, loc.getX(), loc.getY(), loc.getZ(), 0.3, player.getEyeHeight());
        } else {
            trace.addEntry(time, loc.getX(), loc.getY(), loc.getZ(), iead.getWidth((Entity)player) / 2.0, Math.max(player.getEyeHeight(), iead.getHeight((Entity)player)));
        }
        return trace;
    }

    public void resetTrace(Player player, Location loc, long time, IEntityAccessDimensions iead, MovingConfig cc) {
        this.resetTrace(player, loc, time, cc.traceMaxAge, cc.traceMaxSize, iead);
    }

    public void resetTrace(Player player, Location loc, long time, int maxAge, int maxSize, IEntityAccessDimensions iead) {
        if (this.trace != null) {
            this.trace.reset();
        }
        this.getTrace(maxAge, maxSize).addEntry(time, loc.getX(), loc.getY(), loc.getZ(), iead.getWidth((Entity)player) / 2.0, Math.max(player.getEyeHeight(), iead.getHeight((Entity)player)));
    }

    public void useVerticalBounce(Player player) {
        player.setFallDistance(0.0f);
        this.noFallMaxY = BlockProperties.getMinWorldY();
        this.noFallFallDistance = 0.0f;
        this.noFallSkipAirCheck = true;
        this.prependVerticalVelocity(this.verticalBounce);
        this.verticalBounce = null;
    }

    public void handleTimeRanBackwards() {
        long time = System.currentTimeMillis();
        this.timeRiptiding = Math.min(this.timeRiptiding, time);
        this.vehicleMorePacketsLastTime = Math.min(this.vehicleMorePacketsLastTime, time);
        this.removeAllPlayerSpeedModifiers();
    }

    public int getPlayerMoveCount() {
        return this.playerMoveCount;
    }

    public void increasePlayerMoveCount() {
        ++this.playerMoveCount;
        if (this.playerMoveCount == Integer.MAX_VALUE) {
            this.playerMoveCount = 0;
            this.sfVLMoveCount = 0;
            this.morePacketsSetBackResetTime = 0;
            this.setBackResetTime = 0;
        }
    }

    public int getMorePacketsSetBackAge() {
        return this.playerMoveCount - this.morePacketsSetBackResetTime;
    }

    @Override
    public boolean dataOnRemoveSubCheckData(Collection<CheckType> checkTypes) {
        for (CheckType checkType : checkTypes) {
            switch (checkType) {
                case MOVING_SURVIVALFLY: {
                    this.survivalFlyVL = 0.0;
                    this.clearFlyData();
                    this.resetSetBack();
                    this.wasInBed = false;
                    break;
                }
                case MOVING_CREATIVEFLY: {
                    this.creativeFlyVL = 0.0;
                    this.clearFlyData();
                    this.resetSetBack();
                    break;
                }
                case MOVING_NOFALL: {
                    this.noFallVL = 0.0;
                    this.clearNoFallData();
                    break;
                }
                case MOVING_MOREPACKETS: {
                    this.morePacketsVL = 0.0;
                    this.clearPlayerMorePacketsData();
                    this.morePacketsSetback = null;
                    this.morePacketsSetBackResetTime = 0;
                    break;
                }
                case MOVING_PASSABLE: {
                    this.passableVL = 0.0;
                    break;
                }
                case MOVING_VEHICLE: {
                    this.vehicleEnvelopeVL = 0.0;
                    this.vehicleMorePacketsVL = 0.0;
                    this.clearVehicleData();
                    break;
                }
                case MOVING_VEHICLE_ENVELOPE: {
                    this.vehicleEnvelopeVL = 0.0;
                    this.vehicleMoves.invalidate();
                    this.vehicleSetBacks.invalidateAll();
                    break;
                }
                case MOVING_VEHICLE_MOREPACKETS: {
                    this.vehicleMorePacketsVL = 0.0;
                    this.clearVehicleMorePacketsData();
                    break;
                }
                case MOVING: {
                    this.clearMostMovingCheckData();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean dataOnWorldUnload(World world, IGetGenericInstance dataAccess) {
        String worldName = world.getName();
        if (this.teleported != null && worldName.equalsIgnoreCase(this.teleported.getWorld().getName())) {
            this.resetTeleported();
        }
        if (this.setBack != null && worldName.equalsIgnoreCase(this.setBack.getWorld().getName())) {
            this.clearFlyData();
        }
        if (this.morePacketsSetback != null && worldName.equalsIgnoreCase(this.morePacketsSetback.getWorld().getName())) {
            this.clearPlayerMorePacketsData();
            this.clearNoFallData();
        }
        this.vehicleSetBacks.resetByWorldName(worldName);
        return false;
    }

    @Override
    public boolean dataOnReload(IGetGenericInstance dataAccess) {
        MovingConfig cc = dataAccess.getGenericInstance(MovingConfig.class);
        this.trace.adjustSettings(cc.traceMaxAge, cc.traceMaxSize, TickTask.getTick());
        return false;
    }
}

