/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.ModelFlying;
import fr.neatmonster.nocheatplus.checks.moving.player.PlayerSetBackMethod;
import fr.neatmonster.nocheatplus.command.CommandUtil;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.Bugs;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import fr.neatmonster.nocheatplus.utilities.ds.prefixtree.SimpleCharPrefixTree;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class MovingConfig
extends ACheckConfig {
    public final boolean ignoreCreative;
    public final boolean ignoreAllowFlight;
    private final Map<GameMode, ModelFlying> flyingModelGameMode = new HashMap<GameMode, ModelFlying>();
    public final ActionList creativeFlyActions;
    public final float morePacketsEPSIdeal;
    public final float morePacketsEPSMax;
    public final int morePacketsEPSBuckets;
    public final float morePacketsBurstPackets;
    public final double morePacketsBurstDirect;
    public final double morePacketsBurstEPM;
    public final int morePacketsSetBackAge;
    public final ActionList morePacketsActions;
    public final boolean noFallDealDamage;
    public final boolean noFallSkipAllowFlight;
    public final boolean noFallViolationReset;
    public final boolean noFallTpReset;
    public final boolean noFallVehicleReset;
    public final boolean noFallAntiCriticals;
    public final ActionList noFallActions;
    public final ActionList passableActions;
    public final double passableHorizontalMargins;
    public final double passableVerticalMargins;
    public final boolean passableUntrackedTeleportCheck;
    public final boolean passableUntrackedCommandCheck;
    public final boolean passableUntrackedCommandTryTeleport;
    public final SimpleCharPrefixTree passableUntrackedCommandPrefixes = new SimpleCharPrefixTree();
    public final double sfStepHeight;
    public final boolean survivalFlyResetItem;
    public boolean survivalFlyStrictHorizontal;
    public final long survivalFlyVLFreezeCount;
    public final boolean survivalFlyVLFreezeInAir;
    public final boolean sfSetBackPolicyVoid;
    public final boolean sfSetBackPolicyFallDamage;
    public final ActionList survivalFlyActions;
    public final boolean sfHoverCheck;
    public final int sfHoverTicks;
    public final int sfHoverLoginTicks;
    public final boolean sfHoverFallDamage;
    public final double sfHoverViolation;
    public final int velocityActivationCounter;
    public final int velocityActivationTicks;
    public final double noFallyOnGround;
    public final double yOnGround;
    public final boolean ignoreStance;
    public final boolean tempKickIllegal;
    public final boolean loadChunksOnJoin;
    public final boolean loadChunksOnMove;
    public final boolean loadChunksOnTeleport;
    public final boolean loadChunksOnWorldChange;
    public final int speedGrace;
    public final boolean enforceLocation;
    public final boolean trackBlockMove;
    public final PlayerSetBackMethod playerSetBackMethod;
    public final boolean resetFwOnground;
    public final boolean elytraStrict;
    public final boolean vehicleEnforceLocation;
    public final boolean vehiclePreventDestroyOwn;
    public final boolean scheduleVehicleSetBacks;
    public final boolean schedulevehicleSetPassenger;
    public final Set<EntityType> ignoredVehicles = new HashSet<EntityType>();
    public final ActionList vehicleMorePacketsActions;
    public final HashMap<EntityType, Double> vehicleEnvelopeHorizontalSpeedCap = new HashMap();
    public final ActionList vehicleEnvelopeActions;
    public final int traceMaxAge;
    public final int traceMaxSize;
    public final String msgKickIllegalMove;
    public final String msgKickIllegalVehicleMove;

    public MovingConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        this.ignoreCreative = config.getBoolean("checks.moving.creativefly.ignore-creative");
        this.ignoreAllowFlight = config.getBoolean("checks.moving.creativefly.ignore-allow-flight");
        ModelFlying defaultModel = new ModelFlying("gamemode.creative", (ConfigurationSection)config, "checks.moving.creativefly.model.creative.", new ModelFlying().lock());
        for (GameMode gameMode : GameMode.values()) {
            this.flyingModelGameMode.put(gameMode, new ModelFlying("gamemode." + gameMode.name().toLowerCase(), (ConfigurationSection)config, "checks.moving.creativefly.model." + gameMode.name().toLowerCase() + ".", defaultModel).lock());
        }
        this.resetFwOnground = config.getBoolean("checks.moving.creativefly.model.elytra.reset-Fw-Onground");
        this.elytraStrict = config.getBoolean("checks.moving.creativefly.model.elytra.strict");
        this.creativeFlyActions = (ActionList)config.getOptimizedActionList("checks.moving.creativefly.actions", Permissions.MOVING_CREATIVEFLY);
        this.morePacketsEPSIdeal = config.getInt("checks.moving.morepackets.eps-ideal");
        this.morePacketsEPSMax = Math.max(this.morePacketsEPSIdeal, (float)config.getInt("checks.moving.morepackets.eps-max"));
        this.morePacketsEPSBuckets = 2 * Math.max(1, Math.min(60, config.getInt("checks.moving.morepackets.seconds")));
        this.morePacketsBurstPackets = config.getInt("checks.moving.morepackets.burst.epm-violation");
        this.morePacketsBurstDirect = config.getInt("checks.moving.morepackets.burst.direct-violation");
        this.morePacketsBurstEPM = config.getInt("checks.moving.morepackets.burst.epm-violation");
        this.morePacketsSetBackAge = config.getInt("checks.moving.morepackets.setbackage");
        this.morePacketsActions = (ActionList)config.getOptimizedActionList("checks.moving.morepackets.actions", Permissions.MOVING_MOREPACKETS);
        this.noFallDealDamage = config.getBoolean("checks.moving.nofall.deal-damage");
        this.noFallSkipAllowFlight = config.getBoolean("checks.moving.nofall.skip-allow-flight");
        this.noFallViolationReset = config.getBoolean("checks.moving.nofall.reset-on-violation");
        this.noFallTpReset = config.getBoolean("checks.moving.nofall.reset-on-teleport");
        this.noFallVehicleReset = config.getBoolean("checks.moving.nofall.reset-on-vehicle");
        this.noFallAntiCriticals = config.getBoolean("checks.moving.nofall.anti-criticals");
        this.noFallActions = (ActionList)config.getOptimizedActionList("checks.moving.nofall.actions", Permissions.MOVING_NOFALL);
        this.passableActions = (ActionList)config.getOptimizedActionList("checks.moving.passable.actions", Permissions.MOVING_PASSABLE);
        this.passableHorizontalMargins = config.getDouble("checks.moving.passable.horizontal-margin", 0.1, 1.0, 0.999999);
        this.passableVerticalMargins = config.getDouble("checks.moving.passable.vertical-margin", 0.1, 1.0, 0.999999);
        this.passableUntrackedTeleportCheck = config.getBoolean("checks.moving.passable.untracked.teleport.active");
        this.passableUntrackedCommandCheck = config.getBoolean("checks.moving.passable.untracked.command.active");
        this.passableUntrackedCommandTryTeleport = config.getBoolean("checks.moving.passable.untracked.command.try-teleport");
        CommandUtil.feedCommands(this.passableUntrackedCommandPrefixes, config, "checks.moving.passable.untracked.command.prefixes", true);
        this.survivalFlyResetItem = config.getBoolean("checks.moving.survivalfly.extended.reset-activeitem");
        this.survivalFlyStrictHorizontal = config.getBoolean("checks.moving.survivalfly.extended.strict-speed-prediction");
        this.sfSetBackPolicyFallDamage = config.getBoolean("checks.moving.survivalfly.setback-policy.falldamage");
        this.sfSetBackPolicyVoid = config.getBoolean("checks.moving.survivalfly.setback-policy.void-to-void");
        double sfStepHeight = config.getDouble("checks.moving.survivalfly.stepheight", Double.MAX_VALUE);
        if (sfStepHeight == Double.MAX_VALUE) {
            String ref = Bukkit.getVersion().toLowerCase().indexOf("spigot") != -1 ? "1.7.10" : "1.8";
            this.sfStepHeight = ServerVersion.select(ref, 0.5, 0.6, 0.6, 0.5);
        } else {
            this.sfStepHeight = sfStepHeight;
        }
        this.survivalFlyVLFreezeCount = config.getInt("checks.moving.survivalfly.leniency.freeze-count");
        this.survivalFlyVLFreezeInAir = config.getBoolean("checks.moving.survivalfly.leniency.freeze-inair");
        this.survivalFlyActions = (ActionList)config.getOptimizedActionList("checks.moving.survivalfly.actions", Permissions.MOVING_SURVIVALFLY);
        this.sfHoverCheck = config.getBoolean("checks.moving.survivalfly.hover.active");
        this.sfHoverTicks = config.getInt("checks.moving.survivalfly.hover.ticks");
        this.sfHoverLoginTicks = Math.max(0, config.getInt("checks.moving.survivalfly.hover.login-ticks"));
        this.sfHoverFallDamage = config.getBoolean("checks.moving.survivalfly.hover.fall-damage");
        this.sfHoverViolation = config.getDouble("checks.moving.survivalfly.hover.sf-violation");
        this.velocityActivationCounter = config.getInt("checks.moving.velocity.activation-counter");
        this.velocityActivationTicks = config.getInt("checks.moving.velocity.activation-ticks");
        this.yOnGround = config.getDouble("checks.moving.yonground", 1.0E-6, 0.01, 1.0E-5);
        this.noFallyOnGround = config.getDouble("checks.moving.nofall.yonground", 1.0E-6, 0.01, this.yOnGround);
        AlmostBoolean refIgnoreStance = config.getAlmostBoolean("checks.moving.ignore-stance", AlmostBoolean.MAYBE);
        this.ignoreStance = refIgnoreStance == AlmostBoolean.MAYBE ? ServerVersion.compareMinecraftVersion("1.8") >= 0 : refIgnoreStance.decide();
        this.tempKickIllegal = config.getBoolean("checks.moving.temp-kick-illegal");
        this.loadChunksOnJoin = config.getBoolean("checks.moving.loadchunks.join");
        this.loadChunksOnMove = config.getBoolean("checks.moving.loadchunks.move");
        this.loadChunksOnTeleport = config.getBoolean("checks.moving.loadchunks.teleport");
        this.loadChunksOnWorldChange = config.getBoolean("checks.moving.loadchunks.world-change");
        this.speedGrace = Math.max(0, (int)Math.round(config.getDouble("checks.moving.speed-grace") * 20.0));
        AlmostBoolean ref = config.getAlmostBoolean("checks.moving.enforce-location", AlmostBoolean.MAYBE);
        this.enforceLocation = ref == AlmostBoolean.MAYBE ? Bugs.shouldEnforceLocation() : ref.decide();
        this.trackBlockMove = config.getBoolean("compatibility.blocks.change-tracker.active") && config.getBoolean("compatibility.blocks.change-tracker.pistons");
        PlayerSetBackMethod playerSetBackMethod = PlayerSetBackMethod.fromString("extern.fromconfig", config.getString("checks.moving.setback.method"));
        this.playerSetBackMethod = playerSetBackMethod.doesThisMakeSense() ? playerSetBackMethod : (ServerVersion.compareMinecraftVersion("1.9") < 0 ? PlayerSetBackMethod.LEGACY : PlayerSetBackMethod.MODERN);
        this.traceMaxAge = config.getInt("checks.moving.trace.max-age", 30);
        this.traceMaxSize = config.getInt("checks.moving.trace.max-size", 30);
        ref = config.getAlmostBoolean("checks.moving.vehicle.enforce-location", AlmostBoolean.MAYBE);
        this.vehicleEnforceLocation = ref.decideOptimistically();
        this.vehiclePreventDestroyOwn = config.getBoolean("checks.moving.vehicle.prevent-destroy-own");
        this.scheduleVehicleSetBacks = config.getAlmostBoolean("checks.moving.vehicle.schedule-setbacks", AlmostBoolean.MAYBE).decide();
        this.vehicleMorePacketsActions = (ActionList)config.getOptimizedActionList("checks.moving.vehicle.morepackets.actions", Permissions.MOVING_MOREPACKETS);
        this.schedulevehicleSetPassenger = config.getAlmostBoolean("checks.moving.vehicle.schedule-set-passenger", AlmostBoolean.MAYBE).decideOptimistically();
        ref = config.getAlmostBoolean("checks.moving.vehicle.envelope.active", AlmostBoolean.MAYBE);
        if (ServerVersion.compareMinecraftVersion("1.9") < 0) {
            worldData.overrideCheckActivation(CheckType.MOVING_VEHICLE_ENVELOPE, AlmostBoolean.NO, OverrideType.PERMANENT, true);
        }
        config.readDoubleValuesForEntityTypes("checks.moving.vehicle.envelope.hdist-cap", this.vehicleEnvelopeHorizontalSpeedCap, 4.0, true);
        this.vehicleEnvelopeActions = (ActionList)config.getOptimizedActionList("checks.moving.vehicle.envelope.actions", Permissions.MOVING_VEHICLE_ENVELOPE);
        List<String> types = config.get("checks.moving.vehicle.ignored-vehicles") == null ? Arrays.asList("arrow", "spectral_arrow", "tipped_arrow") : config.getStringList("checks.moving.vehicle.ignored-vehicles");
        for (String stype : types) {
            try {
                EntityType type = EntityType.valueOf((String)stype.toUpperCase());
                if (type == null) continue;
                this.ignoredVehicles.add(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.msgKickIllegalMove = ColorUtil.replaceColors(config.getString("checks.moving.message.illegal-player-move"));
        this.msgKickIllegalVehicleMove = ColorUtil.replaceColors(config.getString("checks.moving.message.illegal-vehicle-move"));
    }

    public ModelFlying getModelFlying(Player player, PlayerLocation fromLocation, MovingData data, MovingConfig cc) {
        GameMode gameMode = player.getGameMode();
        ModelFlying modelGameMode = this.flyingModelGameMode.get(gameMode);
        long now = System.currentTimeMillis();
        switch (gameMode) {
            case SURVIVAL: 
            case ADVENTURE: 
            case CREATIVE: {
                break;
            }
            default: {
                return modelGameMode;
            }
        }
        if (player.isFlying() || !this.ignoreAllowFlight && player.getAllowFlight()) {
            return modelGameMode;
        }
        return modelGameMode;
    }
}

