/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.checks.moving.model.PlayerMoveData;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeBukkitAPI;
import fr.neatmonster.nocheatplus.compat.versions.ClientVersion;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.components.registry.feature.IDisableListener;
import fr.neatmonster.nocheatplus.hooks.ExemptionSettings;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.entity.InventoryUtil;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;

public class Open
extends Check
implements IDisableListener {
    private static Open instance = null;
    private UUID nestedPlayer = null;
    private final IHandle<ExemptionSettings> exeSet = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(ExemptionSettings.class);

    public static boolean checkClose(Player player) {
        return instance.check(player);
    }

    public Open() {
        super(CheckType.INVENTORY_OPEN);
        instance = this;
    }

    @Override
    public void onDisable() {
        instance = null;
        this.nestedPlayer = null;
    }

    public boolean check(Player player) {
        boolean isShulkerBox = BridgeBukkitAPI.getTopInventory(player).getType().toString().equals("SHULKER_BOX");
        if (this.exeSet.getHandle().isRegardedAsNpc((Entity)player) || !this.isEnabled(player) || !InventoryUtil.hasInventoryOpen(player) || isShulkerBox) {
            return false;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryConfig cc = pData.getGenericInstance(InventoryConfig.class);
        if (cc.openClose) {
            UUID id = player.getUniqueId();
            if (this.nestedPlayer == null || !id.equals(this.nestedPlayer)) {
                this.nestedPlayer = id;
                player.closeInventory();
                pData.getGenericInstance(InventoryData.class).inventoryOpenTime = 0L;
                pData.getGenericInstance(InventoryData.class).containerInteractTime = 0L;
                this.nestedPlayer = null;
                return true;
            }
        }
        return false;
    }

    public boolean checkOnMove(Player player, IPlayerData pData) {
        MovingData mData = pData.getGenericInstance(MovingData.class);
        InventoryConfig cc = pData.getGenericInstance(InventoryConfig.class);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        boolean creative = player.getGameMode() == GameMode.CREATIVE && (data.clickedSlotType == InventoryType.SlotType.QUICKBAR || cc.openDisableCreative);
        boolean isMerchant = BridgeBukkitAPI.getTopInventory(player).getType() == InventoryType.MERCHANT;
        PlayerMoveData thisMove = mData.playerMoves.getCurrentMove();
        if (!pData.isCheckActive(CheckType.MOVING_SURVIVALFLY, player) || mData.lastMoveNoMove || player.isInsideVehicle() || creative || isMerchant || !mData.getOrUseVerticalVelocity(thisMove.yDistance).isEmpty() || pData.getClientVersion().isAtLeast(ClientVersion.V_1_9) && CollisionUtil.isCollidingWithEntities(player, 0.5, 0.1, 0.5, true)) {
            return false;
        }
        if (thisMove.hasImpulse.decideOptimistically() || Bridge1_9.isGlidingWithElytra(player) && (thisMove.from.getYaw() != thisMove.to.getYaw() || thisMove.from.getPitch() != thisMove.to.getPitch())) {
            if ((double)cc.openImprobableWeight > 0.0) {
                Improbable.feed(player, cc.openImprobableWeight, System.currentTimeMillis());
            }
            return true;
        }
        return false;
    }
}

