/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.inventory.FastClick;
import fr.neatmonster.nocheatplus.checks.inventory.FastConsume;
import fr.neatmonster.nocheatplus.checks.inventory.Gutenberg;
import fr.neatmonster.nocheatplus.checks.inventory.InstantBow;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.checks.inventory.MoreInventory;
import fr.neatmonster.nocheatplus.checks.inventory.Open;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeBukkitAPI;
import fr.neatmonster.nocheatplus.compat.bukkit.BridgeHealth;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.entity.IEntityAccessVehicle;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.registry.setup.config.RegisterConfigWorld;
import fr.neatmonster.nocheatplus.components.registry.setup.data.RegisterDataPlayer;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.PlayerFactoryArgument;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.entity.InventoryUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.math.MathUtil;
import fr.neatmonster.nocheatplus.utilities.moving.MovingUtil;
import fr.neatmonster.nocheatplus.worlds.WorldFactoryArgument;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class InventoryListener
extends CheckListener
implements JoinLeaveListener {
    private final MoreInventory moreInv = this.addCheck(new MoreInventory());
    private final FastClick fastClick = this.addCheck(new FastClick());
    private final InstantBow instantBow = this.addCheck(new InstantBow());
    private final FastConsume fastConsume = this.addCheck(new FastConsume());
    private final Gutenberg gutenberg = this.addCheck(new Gutenberg());
    private final Open open = this.addCheck(new Open());
    private boolean keepCancel = false;
    private final boolean hasInventoryAction;
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("cancel.dead");
    private final IGenericInstanceHandle<IEntityAccessVehicle> handleVehicles = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(IEntityAccessVehicle.class);

    public InventoryListener() {
        super(CheckType.INVENTORY);
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        api.register(((RegisterDataPlayer)((RegisterConfigWorld)api.newRegistrationContext().registerConfigWorld(InventoryConfig.class).factory((IFactoryOne)new IFactoryOne<WorldFactoryArgument, InventoryConfig>(){

            @Override
            public InventoryConfig getNewInstance(WorldFactoryArgument arg) {
                return new InventoryConfig(arg.worldData);
            }
        })).registerConfigTypesPlayer().context().registerDataPlayer(InventoryData.class).factory((IFactoryOne)new IFactoryOne<PlayerFactoryArgument, InventoryData>(){

            @Override
            public InventoryData getNewInstance(PlayerFactoryArgument arg) {
                return new InventoryData();
            }
        })).addToGroups(CheckType.INVENTORY, true, new Class[]{IData.class, ICheckData.class}).context());
        this.hasInventoryAction = ReflectionUtil.getClass("org.bukkit.event.inventory.InventoryAction") != null;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityShootBow(EntityShootBowEvent event) {
        IPlayerData pData;
        Player player;
        if (event.getEntity() instanceof Player && this.instantBow.isEnabled(player = (Player)event.getEntity(), pData = DataManager.getPlayerData(player))) {
            long now = System.currentTimeMillis();
            Location loc = player.getLocation(this.useLoc);
            if (Combined.checkYawRate(player, loc.getYaw(), now, loc.getWorld().getName(), pData)) {
                event.setCancelled(true);
            }
            InventoryConfig cc = pData.getGenericInstance(InventoryConfig.class);
            if (this.instantBow.check(player, event.getForce(), now)) {
                event.setCancelled(true);
            } else if (cc.instantBowImprobableWeight > 0.0f) {
                if (cc.instantBowImprobableFeedOnly) {
                    Improbable.feed(player, cc.instantBowImprobableWeight, now);
                } else if (Improbable.check(player, cc.instantBowImprobableWeight, now, "inventory.instantbow", pData)) {
                    event.setCancelled(true);
                }
            }
            this.useLoc.setWorld(null);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        long now = System.currentTimeMillis();
        HumanEntity entity = event.getWhoClicked();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        int slot = event.getSlot();
        String inventoryAction = this.hasInventoryAction ? event.getAction().name() : null;
        InventoryConfig cc = pData.getGenericInstance(InventoryConfig.class);
        if (pData.isDebugActive(this.checkType)) {
            this.outputDebugInventoryClick(player, slot, event, inventoryAction);
        }
        if (data.inventoryOpenTime == 0L) {
            data.inventoryOpenTime = now;
            if (pData.isDebugActive(CheckType.INVENTORY)) {
                this.debug(player, "InventoryClickEvent: inventory wasn't explicitly open previously but an inventory click was sent; register time of the 1st click (assume inventory is open from this moment on)");
            }
        }
        if (event.isCancelled()) {
            return;
        }
        if (slot == -999 || slot < 0) {
            data.lastClickTime = now;
            return;
        }
        ItemStack cursor = event.getCursor();
        ItemStack clicked = event.getCurrentItem();
        boolean cancel = false;
        if (this.fastClick.isEnabled(player, pData) && (!event.getView().getType().equals((Object)InventoryType.CREATIVE) && player.getGameMode() != GameMode.CREATIVE || !cc.fastClickSpareCreative)) {
            boolean check = true;
            try {
                check = !cc.inventoryExemptions.contains(ChatColor.stripColor((String)event.getView().getTitle()));
            }
            catch (IllegalStateException e) {
                check = true;
            }
            if (check) {
                if (InventoryUtil.isContainerInventory(event.getInventory().getType()) && this.fastClick.checkContainerInteraction(player, data, cc)) {
                    cancel = true;
                    this.keepCancel = true;
                }
                if (!cancel && this.fastClick.check(player, now, event.getView(), slot, cursor, clicked, event.isShiftClick(), inventoryAction, data, cc, pData)) {
                    cancel = true;
                }
            }
        }
        data.lastClickTime = now;
        data.clickedSlotType = event.getSlotType();
        if (cancel || this.keepCancel) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEditingABook(PlayerEditBookEvent event) {
        BookMeta newMeta;
        int pages;
        Player player = event.getPlayer();
        if (!this.gutenberg.isEnabled(player)) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        if (this.gutenberg.check(player, data, pData, pages = (newMeta = event.getNewBookMeta()).getPageCount())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onConsumingFoodOrPotions(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        if (!this.fastConsume.isEnabled(player)) {
            return;
        }
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        long time = System.currentTimeMillis();
        if (this.fastConsume.check(player, event.getItem(), time, data, pData)) {
            event.setCancelled(true);
            DataManager.getPlayerData(player).requestUpdateInventory();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onClosingAnyInventory(InventoryCloseEvent event) {
        HumanEntity entity = event.getPlayer();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IPlayerData pData = DataManager.getPlayerData(player);
            InventoryData data = pData.getGenericInstance(InventoryData.class);
            data.inventoryOpenTime = 0L;
            data.containerInteractTime = 0L;
            if (pData.isDebugActive(CheckType.INVENTORY)) {
                this.debug(player, "InventoryCloseEvent: reset timing data.");
            }
        }
        this.keepCancel = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        CombinedData cData = pData.getGenericInstance(CombinedData.class);
        if (!(event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null || BridgeMisc.isUsingItem(player) || pData.isShiftKeyPressed() && event.isBlockInHand() || !BlockProperties.isContainer(event.getClickedBlock().getType()))) {
            data.containerInteractTime = System.currentTimeMillis();
            if (pData.isDebugActive(CheckType.INVENTORY)) {
                this.debug(player, "Interacted with a container: register the interaction time.");
            }
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        boolean resetAll = false;
        if (event.hasItem()) {
            ItemStack item = event.getItem();
            Material type = item.getType();
            if (type == Material.BOW) {
                long now = System.currentTimeMillis();
                data.instantBowInteract = data.instantBowInteract > 0L && now - data.instantBowInteract < 800L ? Math.min(System.currentTimeMillis(), data.instantBowInteract) : System.currentTimeMillis();
            } else if (InventoryUtil.isConsumable(type)) {
                long now = System.currentTimeMillis();
                data.fastConsumeFood = type;
                data.fastConsumeInteract = data.fastConsumeInteract > 0L && now - data.fastConsumeInteract < 800L ? Math.min(System.currentTimeMillis(), data.fastConsumeInteract) : System.currentTimeMillis();
                data.instantBowInteract = 0L;
            } else {
                resetAll = true;
            }
        } else {
            resetAll = true;
        }
        if (resetAll) {
            data.instantBowInteract = 0L;
            data.fastConsumeInteract = 0L;
            data.fastConsumeFood = null;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || !DataManager.getPlayerData(player).isCheckActive(CheckType.INVENTORY, player)) {
            return;
        }
        if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
            return;
        }
        if (MovingUtil.hasScheduledPlayerSetBack(player)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public final void onContainerOpen(InventoryOpenEvent event) {
        long now = System.currentTimeMillis();
        HumanEntity entity = event.getPlayer();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IPlayerData pData = DataManager.getPlayerData(player);
            InventoryData data = pData.getGenericInstance(InventoryData.class);
            if (MovingUtil.hasScheduledPlayerSetBack(player)) {
                event.setCancelled(true);
                data.inventoryOpenTime = 0L;
                if (pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
                    this.debug(player, "InventoryOpenEvent: attempted to open a container during set back processing; reset timing data and prevent opening.");
                }
            } else if (data.inventoryOpenTime == 0L) {
                data.inventoryOpenTime = now;
                if (pData.isDebugActive(CheckType.INVENTORY)) {
                    this.debug(player, "Fired an explicit InventoryOpenEvent; inventory is now open (no assumptions): register time.");
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        if (pData.isDebugActive(this.checkType) && data.fastConsumeFood != null) {
            this.debug(player, "PlayerItemHeldEvent, reset fastconsume.");
        }
        data.instantBowInteract = 0L;
        data.fastConsumeInteract = System.currentTimeMillis();
        data.fastConsumeFood = null;
        if (event.getPreviousSlot() != event.getNewSlot() && this.open.check(player) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(player, "Force-close inventory on changing slots.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        if (this.open.check(event.getPlayer()) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(player, "Force-close inventory on changing worlds.");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBreakingBlocks(BlockBreakEvent event) {
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        if (this.open.check(event.getPlayer()) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(player, "Force-close inventory on breaking blocks (cheat prevention).");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlacingBlocks(BlockPlaceEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (this.open.check(event.getPlayer()) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(event.getPlayer(), "Force-close inventory on placing blocks (cheat prevention).");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerPortal(PlayerPortalEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (this.open.check(event.getPlayer()) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(event.getPlayer(), "Force-close inventory on using a portal.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (this.open.check(event.getPlayer()) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(event.getPlayer(), "Force-close inventory on respawning.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IPlayerData pData = DataManager.getPlayerData(player);
            if (this.open.check(player) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
                this.debug(player, "Force-close inventory on death.");
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerSleep(PlayerBedEnterEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (this.open.check(event.getPlayer()) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(event.getPlayer(), "Force-close inventory on sleeping.");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerWake(PlayerBedLeaveEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (this.open.check(event.getPlayer()) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(event.getPlayer(), "Force-close inventory on waking up.");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityPortal(EntityPortalEnterEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            IPlayerData pData = DataManager.getPlayerData((Player)entity);
            if (this.open.check((Player)entity) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
                this.debug((Player)entity, "Force-close inventory on using a portal (entity).");
            }
        } else {
            for (Entity passenger : this.handleVehicles.getHandle().getEntityPassengers(entity)) {
                if (!(passenger instanceof Player)) continue;
                IPlayerData pData = DataManager.getPlayerData((Player)entity);
                if (!this.open.check((Player)passenger) || !pData.isDebugActive(CheckType.INVENTORY_OPEN)) continue;
                this.debug((Player)passenger, "Force-close inventory of passenger on using a portal, passenger: " + passenger.toString());
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        boolean PoYdiff = from.getPitch() != to.getPitch() || from.getYaw() != to.getYaw();
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (MovingUtil.hasScheduledPlayerSetBack(event.getPlayer())) {
            return;
        }
        CombinedData cData = pData.getGenericInstance(CombinedData.class);
        InventoryConfig cc = pData.getGenericInstance(InventoryConfig.class);
        Inventory inv = BridgeBukkitAPI.getTopInventory(event.getPlayer());
        if (this.moreInv.isEnabled(event.getPlayer(), pData) && this.moreInv.check(event.getPlayer(), cData, pData, inv.getType(), inv, PoYdiff)) {
            for (int i = 1; i <= 4; ++i) {
                ItemStack item = inv.getItem(i);
                if (item == null || BlockProperties.isAir(item.getType())) continue;
                event.getPlayer().closeInventory();
                if (!pData.isDebugActive(CheckType.INVENTORY_MOREINVENTORY)) break;
                this.debug(event.getPlayer(), "On PlayerMoveEvent: force-close inventory on MoreInv detection.");
                break;
            }
        }
        if (cc.openCancelOnMove && !pData.hasBypass(CheckType.INVENTORY_OPEN, event.getPlayer()) && InventoryUtil.hasInventoryOpen(event.getPlayer()) && this.open.checkOnMove(event.getPlayer(), pData)) {
            event.getPlayer().closeInventory();
            if (pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
                this.debug(event.getPlayer(), "Player is actively moving: force-close open inventory.");
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        IPlayerData pData = DataManager.getPlayerData(event.getPlayer());
        if (this.open.check(event.getPlayer()) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(event.getPlayer(), "Force-close inventory on teleporting.");
        }
    }

    @Override
    public void playerJoins(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        data.inventoryOpenTime = 0L;
        if (pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(player, "Reset inventory timings data on join.");
        }
    }

    @Override
    public void playerLeaves(Player player) {
        IPlayerData pData = DataManager.getPlayerData(player);
        if (this.open.check(player) && pData.isDebugActive(CheckType.INVENTORY_OPEN)) {
            this.debug(player, "Force-close inventory on leaving the server.");
        }
    }

    private void outputDebugInventoryClick(Player player, int slot, InventoryClickEvent event, String action) {
        StringBuilder builder = new StringBuilder(512);
        InventoryData data = DataManager.getPlayerData(player).getGenericInstance(InventoryData.class);
        builder.append("Inventory click: slot: " + slot);
        builder.append(" , Inventory has been opened for: " + MathUtil.toSeconds(System.currentTimeMillis() - data.inventoryOpenTime) + " secs");
        builder.append(" , Time between inventory click and last interaction time: " + MathUtil.toSeconds(data.lastClickTime - data.containerInteractTime) + " secs");
        builder.append(" , Viewers: ");
        for (HumanEntity entity : event.getViewers()) {
            builder.append(entity.getName());
            builder.append("(");
            builder.append(entity.getClass().getName());
            builder.append(")");
        }
        builder.append(" , View: ");
        InventoryView view = event.getView();
        builder.append(view.getClass().getName());
        this.addInventory(view.getBottomInventory(), view, " , Bottom: ", builder);
        this.addInventory(view.getBottomInventory(), view, " , Top: ", builder);
        if (action != null) {
            builder.append(" , Action: ");
            builder.append(action);
        }
        builder.append(" , Event: ");
        builder.append(event.getClass().getName());
        this.debug(player, builder.toString());
    }

    private void addInventory(Inventory inventory, InventoryView view, String prefix, StringBuilder builder) {
        builder.append(prefix);
        if (inventory == null) {
            builder.append("(none)");
        } else {
            String name = view.getTitle();
            builder.append(name);
            builder.append("/");
            builder.append(inventory.getClass().getName());
        }
    }
}

