/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

public class InventoryConfig
extends ACheckConfig {
    public final boolean fastClickSpareCreative;
    public final float fastClickShortTermLimit;
    public final float fastClickNormalLimit;
    public final int chestOpenLimit;
    public final Set<String> inventoryExemptions = new HashSet<String>();
    public final float fastClickImprobableWeight;
    public final ActionList fastClickActions;
    public final long fastConsumeDuration;
    public final boolean fastConsumeWhitelist;
    public final Set<Material> fastConsumeItems = new HashSet<Material>();
    public final ActionList fastConsumeActions;
    public final int gutenbergPageLimit;
    public final ActionList gutenbergActions;
    public final boolean instantBowStrict;
    public final long instantBowDelay;
    public final boolean instantBowImprobableFeedOnly;
    public final float instantBowImprobableWeight;
    public final ActionList instantBowActions;
    public final boolean openClose;
    public final boolean openCancelOnMove;
    public final float openImprobableWeight;
    public final boolean openDisableCreative;
    public final boolean hotFixFallingBlockEndPortalActive;

    public InventoryConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile data = worldData.getRawConfiguration();
        this.fastClickSpareCreative = data.getBoolean("checks.inventory.fastclick.spare-creative");
        this.fastClickShortTermLimit = (float)data.getDouble("checks.inventory.fastclick.limit.short-term");
        this.fastClickNormalLimit = (float)data.getDouble("checks.inventory.fastclick.limit.normal");
        this.chestOpenLimit = data.getInt("checks.inventory.fastclick.min-interaction-duration");
        data.readStringlFromList("checks.inventory.fastclick.exclude", this.inventoryExemptions);
        this.fastClickImprobableWeight = (float)data.getDouble("checks.inventory.fastclick.improbable.weight");
        this.fastClickActions = (ActionList)data.getOptimizedActionList("checks.inventory.fastclick.actions", Permissions.INVENTORY_FASTCLICK);
        if (ServerVersion.compareMinecraftVersion("1.9") >= 0) {
            NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().overrideCheckActivation(CheckType.INVENTORY_FASTCONSUME, AlmostBoolean.NO, OverrideType.PERMANENT, true);
            NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().overrideCheckActivation(CheckType.INVENTORY_INSTANTBOW, AlmostBoolean.NO, OverrideType.PERMANENT, true);
        }
        this.fastConsumeDuration = (long)(1000.0 * data.getDouble("checks.inventory.fastconsume.duration"));
        this.fastConsumeWhitelist = data.getBoolean("checks.inventory.fastconsume.whitelist");
        data.readMaterialFromList("checks.inventory.fastconsume.items", this.fastConsumeItems);
        this.fastConsumeActions = (ActionList)data.getOptimizedActionList("checks.inventory.fastconsume.actions", Permissions.INVENTORY_FASTCONSUME);
        this.gutenbergPageLimit = data.getInt("checks.inventory.gutenberg.page-limit");
        this.gutenbergActions = (ActionList)data.getOptimizedActionList("checks.inventory.gutenberg.actions", Permissions.INVENTORY_GUTENBERG);
        this.instantBowStrict = data.getBoolean("checks.inventory.instantbow.strict");
        this.instantBowDelay = data.getInt("checks.inventory.instantbow.delay");
        this.instantBowImprobableFeedOnly = data.getBoolean("checks.inventory.instantbow.improbable.feed-only");
        this.instantBowImprobableWeight = (float)data.getDouble("checks.inventory.instantbow.improbable.weight");
        this.instantBowActions = (ActionList)data.getOptimizedActionList("checks.inventory.instantbow.actions", Permissions.INVENTORY_INSTANTBOW);
        this.openClose = data.getBoolean("checks.inventory.open.close");
        this.openCancelOnMove = data.getBoolean("checks.inventory.open.close-on-move");
        this.openDisableCreative = data.getBoolean("checks.inventory.open.disable-creative");
        this.openImprobableWeight = (float)data.getDouble("checks.inventory.open.improbable-weight");
        this.hotFixFallingBlockEndPortalActive = data.getBoolean("checks.inventory.hotfix.duplication.falling-block-endportal");
    }
}

