/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.entity.InventoryUtil;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FastConsume
extends Check {
    public FastConsume() {
        super(CheckType.INVENTORY_FASTCONSUME);
    }

    public boolean check(Player player, ItemStack stack, long time, InventoryData data, IPlayerData pData) {
        Material mat;
        long ref;
        if (stack == null) {
            return false;
        }
        long l = ref = data.fastConsumeInteract == 0L ? 0L : Math.max(data.fastConsumeInteract, data.lastClickTime);
        if (time < ref) {
            data.fastConsumeInteract = data.lastClickTime = time;
            return false;
        }
        InventoryConfig cc = pData.getGenericInstance(InventoryConfig.class);
        Material material = mat = stack == null ? null : stack.getType();
        if (mat != null && (cc.fastConsumeWhitelist ? !cc.fastConsumeItems.contains(mat) : cc.fastConsumeItems.contains(mat))) {
            return false;
        }
        long timeSpent = ref == 0L ? 0L : time - ref;
        long expectedDuration = cc.fastConsumeDuration;
        boolean cancel = false;
        if (timeSpent < expectedDuration) {
            float lag = TickTask.getLag(expectedDuration, true);
            if ((float)timeSpent * lag < (float)expectedDuration) {
                double difference = (double)((float)expectedDuration - (float)timeSpent * lag) / 100.0;
                data.fastConsumeVL += difference;
                ViolationData vd = new ViolationData(this, player, data.fastConsumeVL, difference, cc.fastConsumeActions);
                vd.setParameter(ParameterName.FOOD, "" + mat);
                if (data.fastConsumeFood != mat) {
                    vd.setParameter(ParameterName.TAGS, "inconsistent(" + data.fastConsumeFood + ")");
                } else {
                    vd.setParameter(ParameterName.TAGS, "");
                }
                if (this.executeActions(vd).willCancel()) {
                    cancel = true;
                }
            }
        } else {
            data.fastConsumeVL *= 0.6;
        }
        if (cancel) {
            ItemStack actualStack = InventoryUtil.getFirstConsumableItemInHand(player);
            data.fastConsumeFood = actualStack == null ? null : actualStack.getType();
        } else {
            if (pData.isDebugActive(this.type)) {
                this.debug(player, "PlayerItemConsumeEvent, reset fastconsume: " + data.fastConsumeFood);
            }
            data.fastConsumeFood = null;
        }
        data.fastConsumeInteract = time;
        return cancel;
    }
}

