/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.entity.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class FastClick
extends Check {
    final List<String> tags = new ArrayList<String>();

    public FastClick() {
        super(CheckType.INVENTORY_FASTCLICK);
    }

    public boolean check(Player player, long now, InventoryView view, int slot, ItemStack cursor, ItemStack clicked, boolean isShiftClick, String inventoryAction, InventoryData data, InventoryConfig cc, IPlayerData pData) {
        double violation;
        int cursorAmount;
        Material cursorMat;
        Material clickedMat = clicked == null ? Material.AIR : clicked.getType();
        boolean cancel = false;
        this.tags.clear();
        if (cursor != null) {
            cursorMat = cursor.getType();
            cursorAmount = Math.max(1, cursor.getAmount());
        } else {
            cursorMat = null;
            cursorAmount = 0;
        }
        float amount = inventoryAction != null ? this.getAmountWithAction(view, slot, clicked, clickedMat, cursorMat, cursorAmount, isShiftClick, inventoryAction, data, cc) : (cursor != null ? this.detectTweaks1_5(view, slot, clicked, clickedMat, cursorMat, cursorAmount, isShiftClick, data, cc) : 1.0f);
        if (isShiftClick && inventoryAction.equals("MOVE_TO_OTHER_INVENTORY") && cursorMat != null && cursorMat != Material.AIR && clickedMat != Material.AIR) {
            return false;
        }
        data.fastClickFreq.add(now, amount);
        float shortTerm = data.fastClickFreq.bucketScore(0);
        if (shortTerm > cc.fastClickShortTermLimit) {
            shortTerm /= TickTask.getLag(data.fastClickFreq.bucketDuration(), true);
        }
        shortTerm -= cc.fastClickShortTermLimit;
        float normal = data.fastClickFreq.score(1.0f);
        if (normal > cc.fastClickNormalLimit) {
            normal /= TickTask.getLag(data.fastClickFreq.bucketDuration() * (long)data.fastClickFreq.numberOfBuckets(), true);
        }
        if ((violation = (double)Math.max(shortTerm, normal -= cc.fastClickNormalLimit)) > 0.0) {
            this.tags.add("clickspeed");
            data.fastClickVL += violation;
            ViolationData vd = new ViolationData(this, player, data.fastClickVL, violation, cc.fastClickActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            cancel = this.executeActions(vd).willCancel();
        } else {
            data.fastClickVL *= 0.99;
        }
        if (pData.isDebugActive(this.type) && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
            player.sendMessage("FastClick: " + data.fastClickFreq.bucketScore(0) + " | " + data.fastClickFreq.score(1.0f) + " | cursor=" + cursor + " | clicked=" + clicked + " | action=" + inventoryAction);
        }
        data.fastClickLastClicked = clickedMat;
        data.fastClickLastSlot = slot;
        data.fastClickLastCursor = cursorMat;
        data.fastClickLastCursorAmount = cursorAmount;
        if (cc.fastClickImprobableWeight > 0.0f) {
            Improbable.feed(player, cc.fastClickImprobableWeight * amount, now);
        }
        return cancel;
    }

    public boolean checkContainerInteraction(Player player, InventoryData data, InventoryConfig cc) {
        boolean cancel = false;
        this.tags.clear();
        if (InventoryUtil.isContainerInteractionRecent(player, cc.chestOpenLimit)) {
            this.tags.add("interact_time");
            long duration = Math.max(data.lastClickTime - data.containerInteractTime, 20L);
            double violation = (double)((long)cc.chestOpenLimit / duration) * 100.0;
            data.fastClickVL += violation;
            ViolationData vd = new ViolationData(this, player, data.fastClickVL, violation, cc.fastClickActions);
            if (vd.needsParameters()) {
                vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
            }
            cancel = this.executeActions(vd).willCancel();
        }
        return cancel;
    }

    private float detectTweaks1_5(InventoryView view, int slot, ItemStack clicked, Material clickedMat, Material cursorMat, int cursorAmount, boolean isShiftClick, InventoryData data, InventoryConfig cc) {
        if (cursorMat != data.fastClickLastCursor && (!isShiftClick || clickedMat == Material.AIR || clickedMat != data.fastClickLastClicked) || cursorMat == Material.AIR || cursorAmount != data.fastClickLastCursorAmount) {
            return 1.0f;
        }
        if (clickedMat == Material.AIR || clickedMat == cursorMat || isShiftClick && clickedMat == data.fastClickLastClicked) {
            return Math.min(cc.fastClickNormalLimit, cc.fastClickShortTermLimit) / (float)(isShiftClick && clickedMat != Material.AIR ? 1.0 + (double)Math.max(cursorAmount, InventoryUtil.getStackCount(view, clicked)) : (double)cursorAmount) * 0.75f;
        }
        return 1.0f;
    }

    private float getAmountWithAction(InventoryView view, int slot, ItemStack clicked, Material clickedMat, Material cursorMat, int cursorAmount, boolean isShiftClick, String inventoryAction, InventoryData data, InventoryConfig cc) {
        if (inventoryAction.equals("DROP_ONE_SLOT") && slot == data.fastClickLastSlot && clickedMat == data.fastClickLastClicked && view.getType() == InventoryType.CRAFTING) {
            return 0.6f;
        }
        if (inventoryAction.equals("COLLECT_TO_CURSOR")) {
            int stackCount = InventoryUtil.getStackCount(view, clicked);
            return stackCount <= 0 ? 1.0f : Math.min(cc.fastClickNormalLimit, cc.fastClickShortTermLimit) / (float)stackCount * 0.75f;
        }
        if (inventoryAction.equals("MOVE_TO_OTHER_INVENTORY") && cursorMat != Material.AIR) {
            return this.detectTweaks1_5(view, slot, clicked, clickedMat, cursorMat, cursorAmount, isShiftClick, data, cc);
        }
        return 1.0f;
    }
}

