/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.generic.block;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueLookBlockChecker;
import fr.neatmonster.nocheatplus.compat.Bridge1_13;
import fr.neatmonster.nocheatplus.components.config.ICheckConfig;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.ray.CollideRayVsAABB;
import fr.neatmonster.nocheatplus.utilities.collision.tracing.ray.ICollideRayVsAABB;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class AbstractBlockDirectionCheck<D extends ICheckData, C extends ICheckConfig>
extends Check {
    private final ICollideRayVsAABB boulder = new CollideRayVsAABB();
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final BoulderChecker checker = new BoulderChecker();

    public AbstractBlockDirectionCheck(CheckType checkType) {
        super(checkType);
    }

    protected abstract double addVL(Player var1, double var2, D var4, C var5);

    protected abstract ActionList getActions(C var1);

    protected abstract void cooldown(Player var1, D var2, C var3);

    public boolean check(Player player, Location loc, double eyeHeight, Block block, BlockFace face, FlyingQueueHandle flyingHandle, D data, C cc, IPlayerData pData) {
        boolean cancel = false;
        double x = loc.getX();
        double y = loc.getY() + eyeHeight;
        double z = loc.getZ();
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        double distance = this.checker.checkFlyingQueue(x, y, z, loc.getYaw(), loc.getPitch(), blockX, blockY, blockZ, flyingHandle) ? Double.MAX_VALUE : this.checker.getMinDistance();
        if (face != null && !AbstractBlockDirectionCheck.isInteractable(loc, Location.locToBlock((double)y), block, face)) {
            distance = 1.0;
        }
        if (distance != Double.MAX_VALUE) {
            distance = Math.sqrt(distance);
            if (pData.isDebugActive(this.type)) {
                this.outputDebugFail(player, this.boulder, distance);
            }
            double vl = this.addVL(player, distance, data, cc);
            cancel = this.executeActions(player, vl, distance, this.getActions(cc)).willCancel();
        } else {
            this.cooldown(player, data, cc);
        }
        return cancel;
    }

    private double checkBoulder(double x, double y, double z, float yaw, float pitch, int blockX, int blockY, int blockZ) {
        this.useLoc.setYaw(yaw);
        this.useLoc.setPitch(pitch);
        Vector dir = this.useLoc.getDirection();
        double dirX = dir.getX();
        double dirY = dir.getY();
        double dirZ = dir.getZ();
        this.boulder.setFindNearestPointIfNotCollide(true).setRay(x, y, z, dirX, dirY, dirZ).setAABB(blockX, blockY, blockZ, Bridge1_13.hasIsSwimming() ? 0.9 : 0.1).loop();
        if (this.boulder.collides()) {
            return Double.MAX_VALUE;
        }
        return this.boulder.getClosestDistanceSquared();
    }

    private void outputDebugFail(Player player, ICollideRayVsAABB boulder, double distance) {
        this.debug(player, "Failed: collides: " + boulder.collides() + " , dist: " + distance + " , pos: " + LocUtil.simpleFormat(boulder));
    }

    private static boolean isInteractable(Location loc, int locY, Block block, BlockFace face) {
        int locX = loc.getBlockX();
        int locZ = loc.getBlockZ();
        int blockX = block.getX();
        int blockZ = block.getZ();
        int blockY = block.getY();
        if (locX == blockX && locZ == blockZ && locY == blockY) {
            return true;
        }
        long flags = BlockFlags.getBlockFlags(block.getType());
        boolean FULL_BOUNDS = (flags & BlockFlags.F_HEIGHT100) != 0L && (flags & BlockFlags.F_XZ100) != 0L;
        List<BlockFace> interactableFaces = AbstractBlockDirectionCheck.getInteractableFaces(locX - blockX, locZ - blockZ, locY - blockY, FULL_BOUNDS);
        if (!interactableFaces.contains(face)) {
            return false;
        }
        return !AbstractBlockDirectionCheck.isDirectionBlocked(block, interactableFaces, face, FULL_BOUNDS);
    }

    private static List<BlockFace> getInteractableFaces(int xdiff, int zdiff, int ydiff, boolean fullBounds) {
        ArrayList<BlockFace> faces = new ArrayList<BlockFace>(6);
        if (!fullBounds) {
            if (xdiff == 0) {
                faces.add(BlockFace.EAST);
                faces.add(BlockFace.WEST);
            }
            if (zdiff == 0) {
                faces.add(BlockFace.SOUTH);
                faces.add(BlockFace.NORTH);
            }
        }
        if (ydiff == 0) {
            faces.add(BlockFace.UP);
            faces.add(BlockFace.DOWN);
        } else {
            faces.add(ydiff > 0 ? BlockFace.UP : BlockFace.DOWN);
        }
        if (xdiff != 0) {
            faces.add(xdiff > 0 ? BlockFace.EAST : BlockFace.WEST);
        }
        if (zdiff != 0) {
            faces.add(zdiff > 0 ? BlockFace.SOUTH : BlockFace.NORTH);
        }
        return faces;
    }

    private static boolean isDirectionBlocked(Block block, List<BlockFace> interactableFaces, BlockFace tface, boolean hasFullBounds) {
        if (hasFullBounds) {
            long blockRelativeFlags = BlockFlags.getBlockFlags(block.getRelative(tface).getType());
            return (blockRelativeFlags & BlockFlags.F_IGN_PASSABLE) == 0L && (blockRelativeFlags & BlockFlags.F_HEIGHT100) != 0L && (blockRelativeFlags & BlockFlags.F_XZ100) != 0L;
        }
        for (BlockFace face : interactableFaces) {
            boolean relativeFullBounds;
            long blockRelativeFlags = BlockFlags.getBlockFlags(block.getRelative(face).getType());
            boolean bl = relativeFullBounds = (blockRelativeFlags & BlockFlags.F_HEIGHT100) != 0L && (blockRelativeFlags & BlockFlags.F_XZ100) != 0L;
            if (relativeFullBounds && (blockRelativeFlags & BlockFlags.F_IGN_PASSABLE) != 0L) continue;
            return false;
        }
        return true;
    }

    private final class BoulderChecker
    extends FlyingQueueLookBlockChecker {
        private double minDistance;

        private BoulderChecker() {
        }

        @Override
        protected boolean check(double x, double y, double z, float yaw, float pitch, int blockX, int blockY, int blockZ) {
            double distance = AbstractBlockDirectionCheck.this.checkBoulder(x, y, z, yaw, pitch, blockX, blockY, blockZ);
            if (distance == Double.MAX_VALUE) {
                return true;
            }
            this.minDistance = Math.min(this.minDistance, distance);
            return false;
        }

        @Override
        public boolean checkFlyingQueue(double x, double y, double z, float oldYaw, float oldPitch, int blockX, int blockY, int blockZ, FlyingQueueHandle flyingHandle) {
            this.minDistance = Double.MAX_VALUE;
            return super.checkFlyingQueue(x, y, z, oldYaw, oldPitch, blockX, blockY, blockZ, flyingHandle);
        }

        public double getMinDistance() {
            return this.minDistance;
        }
    }
}

